/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateConverter
implements ObjectConverter {
    public static final ConverterContext DATETIME_CONTEXT = new ConverterContext("DateTime");
    public static final ConverterContext TIME_CONTEXT = new ConverterContext("Time");
    public static final ConverterContext DATE_CONTEXT = new ConverterContext("Date");
    private DateFormat _shortFormat = SimpleDateFormat.getDateInstance(3);
    private DateFormat _mediumFormat = SimpleDateFormat.getDateInstance(2);
    private DateFormat _longFormat = SimpleDateFormat.getDateInstance(1);
    private DateFormat _defaultFormat = SimpleDateFormat.getDateInstance(2);
    private DateFormat _shortDatetimeFormat = SimpleDateFormat.getDateTimeInstance(3, 3);
    private DateFormat _mediumDatetimeFormat = SimpleDateFormat.getDateTimeInstance(2, 2);
    private DateFormat _longDatetimeFormat = SimpleDateFormat.getDateTimeInstance(1, 1);
    private DateFormat _defaultDatetimeFormat = SimpleDateFormat.getDateTimeInstance(2, 2);
    private DateFormat _shortTimeFormat = SimpleDateFormat.getTimeInstance(3);
    private DateFormat _mediumTimeFormat = SimpleDateFormat.getTimeInstance(2);
    private DateFormat _longTimeFormat = SimpleDateFormat.getTimeInstance(1);
    private DateFormat _defaultTimeFormat = SimpleDateFormat.getTimeInstance(2);

    public synchronized String toString(Object object, ConverterContext context) {
        TimeZone timeZone;
        if (object == null) {
            return "";
        }
        if (object instanceof Calendar) {
            timeZone = ((Calendar)object).getTimeZone();
            object = ((Calendar)object).getTime();
        } else if (object instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)object);
            timeZone = cal.getTimeZone();
        } else {
            timeZone = TimeZone.getDefault();
        }
        if (object instanceof Date || object instanceof Number) {
            if (context != null && context.getUserObject() instanceof DateFormat) {
                return ((DateFormat)context.getUserObject()).format(object);
            }
            if (DATETIME_CONTEXT.equals(context)) {
                this._defaultDatetimeFormat.setTimeZone(timeZone);
                return this._defaultDatetimeFormat.format(object);
            }
            if (TIME_CONTEXT.equals(context)) {
                this._defaultTimeFormat.setTimeZone(timeZone);
                return this._defaultTimeFormat.format(object);
            }
            this._defaultFormat.setTimeZone(timeZone);
            return this._defaultFormat.format(object);
        }
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public boolean supportToString(Object object, ConverterContext context) {
        return true;
    }

    public synchronized Object fromString(String string, ConverterContext context) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        try {
            Object userObject;
            Object object = userObject = context != null ? context.getUserObject() : null;
            if (userObject instanceof DateFormat) {
                return ((DateFormat)userObject).parse(string);
            }
            if (DATETIME_CONTEXT.equals(context)) {
                return this._defaultDatetimeFormat.parse(string);
            }
            if (TIME_CONTEXT.equals(context)) {
                return this._defaultTimeFormat.parse(string);
            }
            return this._defaultFormat.parse(string);
        }
        catch (ParseException e1) {
            String[] formatStrings;
            if (DATETIME_CONTEXT.equals(context)) {
                try {
                    return this._shortDatetimeFormat.parse(string);
                }
                catch (ParseException e2) {
                    try {
                        return this._mediumDatetimeFormat.parse(string);
                    }
                    catch (ParseException e3) {
                        try {
                            return this._longDatetimeFormat.parse(string);
                        }
                        catch (ParseException e4) {
                        }
                    }
                }
            } else {
                if (TIME_CONTEXT.equals(context)) {
                    try {
                        return this._shortTimeFormat.parse(string);
                    }
                    catch (ParseException e2) {
                        try {
                            return this._mediumTimeFormat.parse(string);
                        }
                        catch (ParseException e3) {
                            try {
                                return this._longTimeFormat.parse(string);
                            }
                            catch (ParseException e4) {
                                return string;
                            }
                        }
                    }
                }
                try {
                    return this._shortFormat.parse(string);
                }
                catch (ParseException e2) {
                    try {
                        return this._mediumFormat.parse(string);
                    }
                    catch (ParseException e3) {
                        try {
                            return this._longFormat.parse(string);
                        }
                        catch (ParseException e4) {
                            // empty catch block
                        }
                    }
                }
            }
            for (String formatString : formatStrings = new String[]{"yyyy-mm-dd", "yy-mm-dd", "yyyymmdd", "yymmdd", "dd-MMM-yy", "dd-MMM-yyyy"}) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(formatString);
                    return sdf.parse(string);
                }
                catch (ParseException ex) {
                }
            }
            return string;
        }
    }

    public boolean supportFromString(String string, ConverterContext context) {
        return true;
    }

    public DateFormat getDefaultFormat() {
        return this._defaultFormat;
    }

    public void setDefaultFormat(DateFormat defaultFormat) {
        this._defaultFormat = defaultFormat;
    }

    public DateFormat getDefaultTimeFormat() {
        return this._defaultTimeFormat;
    }

    public void setDefaultTimeFormat(DateFormat defaultTimeFormat) {
        this._defaultTimeFormat = defaultTimeFormat;
    }

    public DateFormat getDefaultDatetimeFormat() {
        return this._defaultDatetimeFormat;
    }

    public void setDefaultDatetimeFormat(DateFormat defaultDatetimeFormat) {
        this._defaultDatetimeFormat = defaultDatetimeFormat;
    }
}

