=begin
= sample of WebUnit( test_digit.rb )
  Copyright(C) 2001 yuichi TAKAHASHI
  $Id: test_digit.rb,v 1.1.1.1 2003/01/21 11:50:40 yuichi Exp $
=end

require 'webunit/webunit'
require 'digit'

class TestDigit < RUNIT::TestCase

  def test_value
    assert_equals( -1, Digit::new( '-1' ).value )    
    assert_equals( 0, Digit::new( '0' ).value )
    assert_equals( 1, Digit::new( '1' ).value )
    assert_equals( 16, Digit::new( '0x10' ).value )
  end

  def test_to_s
    assert_equals( '012', Digit::new( '10' ).to_s( 8 ) )
    assert_equals( '0', Digit::new( '0' ).to_s( 8 ) )
    assert_equals( '16', Digit::new( '0x10' ).to_s( 10 ) )
    assert_equals( '0xA', Digit::new( '10' ).to_s( 16 ) )
  end

end
