/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.impl.cache.CacheUtil;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.impl.search.IndexPatternOccurrenceImpl;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.searches.IndexPatternSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class IndexPatternSearcher
extends QueryExecutorBase<IndexPatternOccurrence, IndexPatternSearch.SearchParameters> {
    private static final String WHITESPACE = " \t";
    private static final TokenSet COMMENT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.LINE_COMMENT, CustomHighlighterTokenType.MULTI_LINE_COMMENT});

    public IndexPatternSearcher() {
        super(true);
    }

    public void processQuery(@NotNull IndexPatternSearch.SearchParameters queryParameters, @NotNull Processor<? super IndexPatternOccurrence> consumer) {
        int count;
        if (queryParameters == null) {
            IndexPatternSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            IndexPatternSearcher.$$$reportNull$$$0(1);
        }
        PsiFile file2 = queryParameters.getFile();
        VirtualFile virtualFile = file2.getVirtualFile();
        if (file2 instanceof PsiBinaryFile || file2 instanceof PsiCompiledElement || virtualFile == null) {
            return;
        }
        TodoCacheManager cacheManager = TodoCacheManager.SERVICE.getInstance(file2.getProject());
        IndexPatternProvider patternProvider = queryParameters.getPatternProvider();
        int n = count = patternProvider != null ? cacheManager.getTodoCount(virtualFile, patternProvider) : cacheManager.getTodoCount(virtualFile, queryParameters.getPattern());
        if (count != 0) {
            IndexPatternSearcher.executeImpl(queryParameters, consumer);
        }
    }

    protected static void executeImpl(IndexPatternSearch.SearchParameters queryParameters, Processor<? super IndexPatternOccurrence> consumer) {
        IndexPattern[] indexPatternArray;
        IndexPatternProvider patternProvider = queryParameters.getPatternProvider();
        PsiFile file2 = queryParameters.getFile();
        CharSequence chars = file2.getViewProvider().getContents();
        boolean multiLine = queryParameters.isMultiLine();
        List<CommentRange> commentRanges = IndexPatternSearcher.findCommentTokenRanges(file2, chars, queryParameters.getRange(), multiLine);
        TIntArrayList occurrences = new TIntArrayList(1);
        if (patternProvider != null) {
            indexPatternArray = patternProvider.getIndexPatterns();
        } else {
            IndexPattern[] indexPatternArray2 = new IndexPattern[1];
            indexPatternArray = indexPatternArray2;
            indexPatternArray2[0] = queryParameters.getPattern();
        }
        IndexPattern[] patterns = indexPatternArray;
        for (int i = 0; i < commentRanges.size(); ++i) {
            occurrences.resetQuick();
            for (int j = patterns.length - 1; j >= 0; --j) {
                if (IndexPatternSearcher.collectPatternMatches(patterns, patterns[j], chars, commentRanges, i, file2, queryParameters.getRange(), consumer, occurrences, multiLine)) continue;
                return;
            }
        }
    }

    private static List<CommentRange> findCommentTokenRanges(PsiFile file2, CharSequence chars, TextRange range2, boolean multiLine) {
        if (file2 instanceof PsiPlainTextFile) {
            FileType fType = file2.getFileType();
            if (fType instanceof CustomSyntaxTableFileType) {
                Lexer lexer = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fType, (Project)file2.getProject(), (VirtualFile)file2.getVirtualFile()).getHighlightingLexer();
                return IndexPatternSearcher.findComments(lexer, chars, range2, COMMENT_TOKENS, null, multiLine);
            }
            return Collections.singletonList(new CommentRange(0, file2.getTextLength()));
        }
        ArrayList<CommentRange> commentRanges = new ArrayList<CommentRange>();
        FileViewProvider viewProvider = file2.getViewProvider();
        Set relevantLanguages = viewProvider.getLanguages();
        for (Language lang : relevantLanguages) {
            ParserDefinition parserDefinition;
            SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)lang, (Project)file2.getProject(), (VirtualFile)file2.getVirtualFile());
            Lexer lexer = syntaxHighlighter.getHighlightingLexer();
            TokenSet commentTokens = null;
            IndexPatternBuilder builderForFile = null;
            for (IndexPatternBuilder builder2 : IndexPatternBuilder.EP_NAME.getExtensionList()) {
                Lexer lexerFromBuilder = builder2.getIndexingLexer(file2);
                if (lexerFromBuilder == null) continue;
                lexer = lexerFromBuilder;
                commentTokens = builder2.getCommentTokenSet(file2);
                builderForFile = builder2;
            }
            if (builderForFile == null && (parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)) != null) {
                commentTokens = parserDefinition.getCommentTokens();
            }
            if (commentTokens == null) continue;
            List<CommentRange> langRanges = IndexPatternSearcher.findComments(lexer, chars, range2, commentTokens, builderForFile, multiLine);
            IndexPatternSearcher.mergeCommentLists(commentRanges, langRanges);
        }
        return commentRanges;
    }

    private static void mergeCommentLists(List<CommentRange> target2, List<CommentRange> source) {
        List merged = target2.isEmpty() ? source : ContainerUtil.mergeSortedLists(target2, source, (Comparator)CommentRange.BY_START_OFFSET_THEN_BY_END_OFFSET, (boolean)true);
        target2.clear();
        target2.addAll(merged);
    }

    private static List<CommentRange> findComments(Lexer lexer, CharSequence chars, TextRange range2, TokenSet commentTokens, IndexPatternBuilder builderForFile, boolean multiLine) {
        IElementType tokenType;
        ArrayList<CommentRange> commentRanges = new ArrayList<CommentRange>();
        int lastEndOffset = -1;
        lexer.start(chars);
        while ((tokenType = lexer.getTokenType()) != null) {
            if (range2 != null) {
                if (lexer.getTokenEnd() > range2.getStartOffset()) {
                    if (lexer.getTokenStart() >= range2.getEndOffset() && (!multiLine || lastEndOffset < 0 || !IndexPatternSearcher.containsOneLineBreak(chars, lastEndOffset, lexer.getTokenStart()))) break;
                }
            } else {
                boolean isComment;
                boolean bl = isComment = commentTokens.contains(tokenType) || CacheUtil.isInComments(tokenType);
                if (isComment) {
                    int end;
                    int startDelta = builderForFile != null ? builderForFile.getCommentStartDelta(lexer.getTokenType(), lexer.getTokenSequence()) : 0;
                    int endDelta = builderForFile != null ? builderForFile.getCommentEndDelta(lexer.getTokenType()) : 0;
                    int start2 = lexer.getTokenStart() + startDelta;
                    if (start2 < (end = lexer.getTokenEnd() - endDelta) && end <= chars.length()) {
                        commentRanges.add(new CommentRange(start2, end, builderForFile == null ? "" : builderForFile.getCharsAllowedInContinuationPrefix(tokenType)));
                    }
                    lastEndOffset = end;
                }
            }
            lexer.advance();
        }
        return commentRanges;
    }

    private static boolean containsOneLineBreak(CharSequence text, int startOffset, int endOffset) {
        boolean hasLineBreak = false;
        for (int i = startOffset; i < endOffset; ++i) {
            if (text.charAt(i) != '\n') continue;
            if (hasLineBreak) {
                return false;
            }
            hasLineBreak = true;
        }
        return hasLineBreak;
    }

    private static boolean collectPatternMatches(IndexPattern[] allIndexPatterns, IndexPattern indexPattern, CharSequence chars, List<CommentRange> commentRanges, int commentNum, PsiFile file2, TextRange range2, Processor<? super IndexPatternOccurrence> consumer, TIntArrayList matches, boolean multiLine) {
        CommentRange commentRange = commentRanges.get(commentNum);
        int commentStart = commentRange.startOffset;
        int commentEnd = commentRange.endOffset;
        Pattern pattern = indexPattern.getPattern();
        if (pattern != null) {
            boolean found;
            ProgressManager.checkCanceled();
            CharSequenceSubSequence input = new CharSequenceSubSequence(chars, commentStart, commentEnd);
            Matcher matcher = pattern.matcher((CharSequence)input);
            while (found = matcher.find()) {
                int end;
                int start2 = matcher.start() + commentStart;
                if (start2 != (end = matcher.end() + commentStart) && (range2 == null || range2.getStartOffset() <= start2 && end <= range2.getEndOffset()) && matches.indexOf(start2) == -1) {
                    List<TextRange> additionalRanges;
                    List<TextRange> list2 = additionalRanges = multiLine ? IndexPatternSearcher.findContinuation(start2, chars, allIndexPatterns, commentRanges, commentNum) : Collections.emptyList();
                    if (range2 != null && !additionalRanges.isEmpty() && ((TextRange)additionalRanges.get(additionalRanges.size() - 1)).getEndOffset() > range2.getEndOffset()) continue;
                    matches.add(start2);
                    IndexPatternOccurrenceImpl occurrence = new IndexPatternOccurrenceImpl(file2, start2, end, indexPattern, additionalRanges);
                    if (!consumer.process((Object)occurrence)) {
                        return false;
                    }
                }
                ProgressManager.checkCanceled();
            }
        }
        return true;
    }

    private static List<TextRange> findContinuation(int mainRangeStartOffset, CharSequence text, IndexPattern[] allIndexPatterns, List<CommentRange> commentRanges, int commentNum) {
        int refOffset;
        int continuationStartOffset;
        int lineStartOffset = CharArrayUtil.shiftBackwardUntil((CharSequence)text, (int)(mainRangeStartOffset - 1), (String)"\n") + 1;
        int lineEndOffset = CharArrayUtil.shiftForwardUntil((CharSequence)text, (int)mainRangeStartOffset, (String)"\n");
        int offsetInLine = mainRangeStartOffset - lineStartOffset;
        ArrayList result2 = new ArrayList();
        block0: while (lineEndOffset < text.length() && (continuationStartOffset = CharArrayUtil.shiftForward((CharSequence)text, (int)(refOffset = (lineStartOffset = lineEndOffset + 1) + offsetInLine), (int)(lineEndOffset = CharArrayUtil.shiftForwardUntil((CharSequence)text, (int)lineStartOffset, (String)"\n")), (String)WHITESPACE)) != refOffset && continuationStartOffset < lineEndOffset && (continuationStartOffset < commentRanges.get(commentNum).endOffset || ++commentNum < commentRanges.size() && continuationStartOffset >= commentRanges.get(commentNum).startOffset && continuationStartOffset < commentRanges.get(commentNum).endOffset)) {
            CommentRange commentRange = commentRanges.get(commentNum);
            int commentStartOffset = Math.max(lineStartOffset, commentRange.startOffset);
            int continuationEndOffset = Math.min(lineEndOffset, commentRange.endOffset);
            if (refOffset < commentStartOffset || CharArrayUtil.shiftBackward((CharSequence)text, (int)commentStartOffset, (int)(refOffset - 1), (String)(WHITESPACE + commentRange.allowedContinuationPrefixChars)) + 1 != commentStartOffset) break;
            CharSequence commentText = text.subSequence(commentStartOffset, continuationEndOffset);
            for (IndexPattern pattern : allIndexPatterns) {
                Pattern p = pattern.getPattern();
                if (p != null && p.matcher(commentText).find()) break block0;
            }
            result2.add(new TextRange(continuationStartOffset, continuationEndOffset));
        }
        return result2.isEmpty() ? Collections.emptyList() : result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/search/IndexPatternSearcher";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CommentRange {
        private static final Comparator<CommentRange> BY_START_OFFSET_THEN_BY_END_OFFSET = Comparator.comparingInt(o -> o.startOffset).thenComparingInt(o -> o.endOffset);
        private final int startOffset;
        private final int endOffset;
        private final String allowedContinuationPrefixChars;

        private CommentRange(int startOffset, int endOffset) {
            this(startOffset, endOffset, "");
        }

        private CommentRange(int startOffset, int endOffset, String chars) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.allowedContinuationPrefixChars = chars;
        }
    }
}

