/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.extensions.ExtractorScripts;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.run.actions.GridAction;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseExtractorAction
extends AlignedIconWithTextAction.Group
implements GridAction,
DumbAware {
    public static final String CSV_FORMAT_SETTINGS_ACTION = "Console.TableResult.Copy.Csv.Settings";

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ChooseExtractorAction.$$$reportNull$$$0(0);
        }
        Project project = ChooseExtractorAction.getEventProject((AnActionEvent)e);
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        boolean enabled = project != null && dataGrid != null;
        e.getPresentation().setEnabledAndVisible(enabled);
        if (enabled) {
            ChooseExtractorAction.updateText(ChooseExtractorAction.getCurrentExtractorName(project), e.getPresentation(), "");
        }
    }

    @NotNull
    private static String getCurrentExtractorName(@Nullable Project project) {
        String string = DataExtractorProperties.getCurrentExtractorFactory(project).getName();
        if (string == null) {
            ChooseExtractorAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static void updateText(@NotNull String name, @NotNull Presentation presentation, @NotNull String prefix) {
        if (name == null) {
            ChooseExtractorAction.$$$reportNull$$$0(2);
        }
        if (presentation == null) {
            ChooseExtractorAction.$$$reportNull$$$0(3);
        }
        if (prefix == null) {
            ChooseExtractorAction.$$$reportNull$$$0(4);
        }
        String adjusted = prefix.isEmpty() ? FileUtil.getNameWithoutExtension((String)FileUtil.getNameWithoutExtension((String)name)) : name;
        String newText = prefix + StringUtil.escapeMnemonics((String)StringUtil.firstLast((String)adjusted, (int)12));
        presentation.setText(newText);
        JComponent c2 = (JComponent)presentation.getClientProperty(COMPONENT_KEY);
        if (c2 != null) {
            c2.setToolTipText(name);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ChooseExtractorAction.$$$reportNull$$$0(5);
        }
        if ((project = ChooseExtractorAction.getEventProject((AnActionEvent)e)) == null) {
            return;
        }
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        final Presentation presentation = e.getPresentation();
        JComponent button = (JComponent)presentation.getClientProperty(COMPONENT_KEY);
        if (dataGrid == null) {
            return;
        }
        ChooserGroup actionGroup = new ChooserGroup(){

            @Override
            protected void extractorSelected(@NotNull Project project, @NotNull DataExtractorFactory factory) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (factory == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.extractorSelected(project, factory);
                ChooseExtractorAction.updateText(factory.getName(), presentation, "");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "factory";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/run/actions/ChooseExtractorAction$1";
                objectArray[2] = "extractorSelected";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)actionGroup, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
        if (button != null) {
            popup.showUnderneathOf((Component)button);
        } else {
            popup.showInBestPositionFor(e.getDataContext());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ChooseExtractorAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ChooseExtractorAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentExtractorName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ChooserGroup
    extends ActionGroup
    implements DumbAware {
        public void update(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                ChooserGroup.$$$reportNull$$$0(0);
            }
            if ((project = ChooserGroup.getEventProject((AnActionEvent)e)) == null) {
                return;
            }
            ChooseExtractorAction.updateText(ChooseExtractorAction.getCurrentExtractorName(project), e.getPresentation(), this.getTemplatePresentation().getText() + ": ");
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            final Project project = ChooserGroup.getEventProject((AnActionEvent)e);
            if (project == null) {
                if (EMPTY_ARRAY == null) {
                    ChooserGroup.$$$reportNull$$$0(1);
                }
                return EMPTY_ARRAY;
            }
            AnAction[] anActionArray = ChooserGroup.getActions((Function<DataExtractorFactory, ? extends AnAction>)new Function<DataExtractorFactory, AnAction>(){
                private final String mySelectedName;
                private boolean mySelectionIsSet;
                {
                    this.mySelectedName = ChooseExtractorAction.getCurrentExtractorName(project);
                }

                public AnAction fun(DataExtractorFactory factory) {
                    String name = factory.getName();
                    boolean selected = !this.mySelectionIsSet && name.equals(this.mySelectedName);
                    this.mySelectionIsSet |= selected;
                    return new SelectExtractorFactoryAction(factory, selected);
                }
            });
            if (anActionArray == null) {
                ChooserGroup.$$$reportNull$$$0(2);
            }
            return anActionArray;
        }

        protected void extractorSelected(@NotNull Project project, @NotNull DataExtractorFactory factory) {
            if (project == null) {
                ChooserGroup.$$$reportNull$$$0(3);
            }
            if (factory == null) {
                ChooserGroup.$$$reportNull$$$0(4);
            }
            DataExtractorProperties.setCurrentExtractorFactory(project, factory);
        }

        @NotNull
        public static AnAction[] getActions(@NotNull Function<DataExtractorFactory, ? extends AnAction> wrapExtractorToAction) {
            if (wrapExtractorToAction == null) {
                ChooserGroup.$$$reportNull$$$0(5);
            }
            ArrayList actions = ContainerUtil.newArrayList();
            actions.addAll(ContainerUtil.mapNotNull(DataExtractorFactories.getLegacy(), wrapExtractorToAction));
            actions.add(Separator.getInstance());
            actions.addAll(ContainerUtil.mapNotNull(DataExtractorFactories.getCsvFormats(), wrapExtractorToAction));
            actions.add(Separator.getInstance());
            actions.addAll(ContainerUtil.mapNotNull(DataExtractorFactories.getScripts(), wrapExtractorToAction));
            actions.add(Separator.getInstance());
            actions.add(DataExtractorProperties.getSkipComputedColumnsAction());
            actions.add(DataExtractorProperties.getSkipGeneratedColumnsAction());
            actions.add(DataExtractorProperties.getAddCreateTableAction());
            actions.add(DataExtractorProperties.getOverwriteExistingFilesAction());
            actions.add(DataExtractorProperties.getSingleFileAction());
            actions.add(Separator.getInstance());
            actions.add(ActionManager.getInstance().getAction(ChooseExtractorAction.CSV_FORMAT_SETTINGS_ACTION));
            actions.add(new GoToScriptsDirectoryAction());
            AnAction[] anActionArray = actions.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                ChooserGroup.$$$reportNull$$$0(6);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseExtractorAction$ChooserGroup";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrapExtractorToAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseExtractorAction$ChooserGroup";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "extractorSelected";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getActions";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class GoToScriptsDirectoryAction
        extends DumbAwareAction {
            GoToScriptsDirectoryAction() {
                super("Go to Scripts Directory");
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    GoToScriptsDirectoryAction.$$$reportNull$$$0(0);
                }
                Project project = e.getProject();
                e.getPresentation().setEnabledAndVisible(project != null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    GoToScriptsDirectoryAction.$$$reportNull$$$0(1);
                }
                Project project = e.getProject();
                File scriptsDir = ExtractorScripts.getScriptsDirectory();
                if (project == null || scriptsDir == null) {
                    return;
                }
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(scriptsDir);
                if (virtualFile == null) {
                    return;
                }
                PsiNavigationSupport.getInstance().createNavigatable(project, virtualFile, -1).navigate(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/run/actions/ChooseExtractorAction$ChooserGroup$GoToScriptsDirectoryAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class SelectExtractorFactoryAction
        extends ToggleAction
        implements DumbAware {
            private final DataExtractorFactory myExtractorFactory;
            private final boolean mySelected;

            private SelectExtractorFactoryAction(DataExtractorFactory factory, boolean selected) {
                if (ChooserGroup.this == null) {
                    SelectExtractorFactoryAction.$$$reportNull$$$0(0);
                }
                if (factory == null) {
                    SelectExtractorFactoryAction.$$$reportNull$$$0(1);
                }
                super(factory.getName());
                this.myExtractorFactory = factory;
                this.mySelected = selected;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    SelectExtractorFactoryAction.$$$reportNull$$$0(2);
                }
                return this.mySelected;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                Project project;
                if (e == null) {
                    SelectExtractorFactoryAction.$$$reportNull$$$0(3);
                }
                if ((project = e.getProject()) != null) {
                    ChooserGroup.this.extractorSelected(project, this.myExtractorFactory);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument %s for @NotNull parameter of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "0";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "factory";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/run/actions/ChooseExtractorAction$ChooserGroup$SelectExtractorFactoryAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format(string, objectArray));
            }
        }
    }
}

