/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.DateFormatUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.annotate.HgAnnotationLine;

public class HgAnnotateCommand {
    private static final Logger LOG = Logger.getInstance(HgAnnotateCommand.class);
    private static final Pattern LINE_PATTERN = Pattern.compile("\\s*(.+)\\s+([0-9]+)\\s+([0-9a-fA-F]+)\\s+([a-zA-Z]{3}\\s+[a-zA-Z]{3}\\s+[0-9]{2}\\s+.*[0-9]{4}.+):\\s*([0-9]+):\\s(.*)");
    private static final int USER_GROUP = 1;
    private static final int REVISION_GROUP = 2;
    private static final int CHANGESET_GROUP = 3;
    private static final int DATE_GROUP = 4;
    private static final int LINE_NUMBER_GROUP = 5;
    private static final int CONTENT_GROUP = 6;
    private final Project myProject;

    public HgAnnotateCommand(Project project) {
        this.myProject = project;
    }

    public List<HgAnnotationLine> execute(@NotNull HgFile hgFile, @Nullable HgRevisionNumber revision) {
        if (hgFile == null) {
            HgAnnotateCommand.$$$reportNull$$$0(0);
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-cvnudl");
        HgVcs vcs = HgVcs.getInstance(this.myProject);
        if (vcs != null && vcs.getProjectSettings().isWhitespacesIgnoredInAnnotations() && vcs.getVersion().isIgnoreWhitespaceDiffInAnnotationsSupported()) {
            arguments.add("-w");
        }
        if (revision != null) {
            arguments.add("-r");
            arguments.add(revision.getChangeset());
        }
        arguments.add(hgFile.getRelativePath());
        HgCommandResult result = new HgCommandExecutor(this.myProject).executeInCurrentThread(hgFile.getRepo(), "annotate", arguments);
        if (result == null) {
            return Collections.emptyList();
        }
        List<String> outputLines = result.getOutputLines();
        return HgAnnotateCommand.parse(outputLines);
    }

    private static List<HgAnnotationLine> parse(List<String> outputLines) {
        ArrayList<HgAnnotationLine> annotations = new ArrayList<HgAnnotationLine>(outputLines.size());
        for (String line : outputLines) {
            Matcher matcher = LINE_PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            String user = matcher.group(1).trim();
            HgRevisionNumber rev = HgRevisionNumber.getInstance(matcher.group(2), matcher.group(3));
            String dateGroup = matcher.group(4).trim();
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.US);
            String date = "";
            try {
                date = DateFormatUtil.formatPrettyDate((Date)dateFormat.parse(dateGroup));
            }
            catch (ParseException e) {
                LOG.error("Couldn't parse annotation date ", (Throwable)e);
            }
            Integer lineNumber = Integer.valueOf(matcher.group(5));
            String content = matcher.group(6);
            HgAnnotationLine annotationLine = new HgAnnotationLine(user, rev, date, lineNumber, content);
            annotations.add(annotationLine);
        }
        return annotations;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hgFile", "org/zmlx/hg4idea/command/HgAnnotateCommand", "execute"));
    }
}

