/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.validation.JSEmptyTypeChecker;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettingsTracker;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceAnnotatorCheckerProvider
extends TypeScriptAnnotatorCheckerProvider {
    public static final Key<CachedValue<Boolean>> USE_SERVICE_INFO = Key.create((String)"use.service.info");
    private final Project myProject;
    @Nullable
    private final TypeScriptCompilerSettings mySettings;
    private final TypeScriptCompilerSettingsTracker myTracker;
    private TypeScriptConfigService myConfigService;

    public TypeScriptLanguageServiceAnnotatorCheckerProvider(@NotNull Project project, @Nullable TypeScriptCompilerSettings settings, @NotNull TypeScriptCompilerSettingsTracker tracker, @NotNull TypeScriptConfigService configService) {
        if (project == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(0);
        }
        if (tracker == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(1);
        }
        if (configService == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.mySettings = settings;
        this.myTracker = tracker;
        this.myConfigService = configService;
    }

    @Override
    protected boolean isAvailable(@NotNull PsiElement context) {
        PsiFile file2;
        if (context == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(3);
        }
        return Boolean.TRUE == CachedValuesManager.getCachedValue((PsiElement)(file2 = context.getContainingFile().getOriginalFile()), USE_SERVICE_INFO, () -> CachedValueProvider.Result.create((Object)this.isAvailableImpl((PsiElement)file2), (Object[])new Object[]{this.myTracker, this.myConfigService.getTracker(), VirtualFileManager.getInstance()}));
    }

    private boolean isAvailableImpl(@NotNull PsiElement context) {
        if (context == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(4);
        }
        if (this.mySettings == null || ApplicationManager.getApplication().isUnitTestMode() && !TypeScriptLanguageServiceUtil.USE_SERVICE) {
            return false;
        }
        PsiFile file2 = context.getContainingFile();
        if (!(file2 instanceof JSFile)) {
            return false;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            return false;
        }
        JSLanguageServiceBase service = this.getService(virtualFile);
        return TypeScriptLanguageServiceAnnotatorCheckerProvider.checkServiceIsAvailable(this.myProject, service, this.mySettings);
    }

    public static boolean checkServiceIsAvailable(@NotNull Project project, @Nullable JSLanguageServiceBase service, @NotNull TypeScriptCompilerSettings settings) {
        if (project == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(6);
        }
        if (!TypeScriptLanguageServiceUtil.isServiceEnabled(project)) {
            return false;
        }
        if (service == null || !service.checkCanUseService()) {
            return false;
        }
        service.initialize();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return TypeScriptLanguageServiceUtil.USE_SERVICE;
        }
        return settings.useServiceForProjectsWithoutConfig() || TypeScriptConfigService.Provider.hasConfigs(project);
    }

    private JSLanguageServiceBase getService(VirtualFile virtualFile) {
        return TypeScriptCompilerService.getServiceForFile(this.myProject, virtualFile);
    }

    @Override
    @NotNull
    public JSTypeChecker getTypeChecker(@NotNull JSProblemReporter<?> reporter) {
        if (reporter == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(7);
        }
        JSEmptyTypeChecker jSEmptyTypeChecker = JSEmptyTypeChecker.getInstance();
        if (jSEmptyTypeChecker == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(8);
        }
        return jSEmptyTypeChecker;
    }

    @Override
    public boolean skipErrors() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configService";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceAnnotatorCheckerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceAnnotatorCheckerProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkServiceIsAvailable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTypeChecker";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

