/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.settings;

import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ConverterProvider;
import com.intellij.conversion.ProjectConverter;
import com.intellij.conversion.RunManagerSettings;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javascript.debugger.execution.JavascriptDebugConfigurationType;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class JavaScriptDebugConfigurationConverterProvider
extends ConverterProvider {
    protected JavaScriptDebugConfigurationConverterProvider() {
        super("js-debug-configuration-converter");
    }

    @NotNull
    public String getConversionDescription() {
        if ("JavaScript Remote and Local run configuration will be converted into unified JavaScript run configuration" == null) {
            JavaScriptDebugConfigurationConverterProvider.$$$reportNull$$$0(0);
        }
        return "JavaScript Remote and Local run configuration will be converted into unified JavaScript run configuration";
    }

    @NotNull
    public ProjectConverter createConverter(@NotNull ConversionContext context) {
        if (context == null) {
            JavaScriptDebugConfigurationConverterProvider.$$$reportNull$$$0(1);
        }
        ProjectConverter projectConverter = new ProjectConverter(){

            public ConversionProcessor<RunManagerSettings> createRunConfigurationsConverter() {
                return new ConversionProcessor<RunManagerSettings>(){

                    public boolean isConversionNeeded(RunManagerSettings settings) {
                        for (Element element : settings.getRunConfigurations()) {
                            if (!JavaScriptDebugConfigurationConverterProvider.isJsRemoteRunConfiguration(element)) continue;
                            return true;
                        }
                        return false;
                    }

                    public void process(RunManagerSettings settings) {
                        for (Element element : settings.getRunConfigurations()) {
                            if (!JavaScriptDebugConfigurationConverterProvider.isJsRemoteRunConfiguration(element)) continue;
                            JavaScriptDebugConfigurationConverterProvider.convert(element);
                        }
                    }
                };
            }
        };
        if (projectConverter == null) {
            JavaScriptDebugConfigurationConverterProvider.$$$reportNull$$$0(2);
        }
        return projectConverter;
    }

    public static boolean isJsRemoteRunConfiguration(Element element) {
        return "JavascriptDebugSession".equalsIgnoreCase(element.getAttributeValue("type")) && !"true".equals(element.getAttributeValue("default"));
    }

    public static void convert(Element element) {
        Element settings;
        element.setAttribute("type", JavascriptDebugConfigurationType.getTypeInstance().getId());
        element.removeAttribute("factoryName");
        Element localSettings = element.getChild("JSDebuggerConfigurationSettings");
        Element remoteSettings = localSettings == null ? element.getChild("JSRemoteDebuggerConfigurationSettings") : null;
        Element element2 = settings = localSettings == null ? remoteSettings : localSettings;
        if (settings != null) {
            String engineId = null;
            String uri = null;
            Object[] objects = settings.getChildren().toArray();
            settings.removeContent();
            for (Object o : objects) {
                Element tag = (Element)o;
                if ("option".equals(tag.getName())) {
                    String optionName = tag.getAttributeValue("name");
                    String optionValue = StringUtil.nullize((String)tag.getAttributeValue("value"));
                    if ("fileUrl".equals(optionName)) {
                        uri = optionValue;
                        continue;
                    }
                    if (!"engineId".equals(optionName) || "embedded".equals(optionValue) || "chrome".equals(optionValue)) continue;
                    engineId = "firefox".equals(optionValue) ? WebBrowserManager.PREDEFINED_FIREFOX_ID.toString() : optionValue;
                    continue;
                }
                if (remoteSettings == null || !"mapping".equals(tag.getName())) continue;
                element.addContent(tag);
            }
            element.removeChild("JSDebuggerConfigurationSettings");
            element.removeChild("JSRemoteDebuggerConfigurationSettings");
            if (!StringUtil.isEmpty(engineId)) {
                element.setAttribute("engineId", engineId);
            }
            if (!StringUtil.isEmptyOrSpaces(uri)) {
                element.setAttribute("uri", uri.trim());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/debugger/settings/JavaScriptDebugConfigurationConverterProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConversionDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/debugger/settings/JavaScriptDebugConfigurationConverterProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConverter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createConverter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

