/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.associations;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.containers.hash.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.plugins.ruby.associations.AssociatedItem;
import org.jetbrains.plugins.ruby.associations.Association;
import org.jetbrains.plugins.ruby.associations.AssociationFactory;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.ruby.RubyPsiManager;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public class AssociationsParser
implements Disposable {
    private final Module b;
    private PsiTreeChangeListener a;
    private Map<AssociatedItem, Set<Association>> c;

    public static AssociationsParser getInstance(Module module) {
        return (AssociationsParser)ModuleServiceManager.getService((Module)module, AssociationsParser.class);
    }

    public AssociationsParser(Module module) {
        this.b = module;
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(this.b);
        if (standardRailsPaths == null) {
            return;
        }
        String string = standardRailsPaths.getModelsRootURL();
        VirtualFile virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(string);
        if (virtualFile == null) {
            return;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.b.getProject());
        PsiDirectory psiDirectory = psiManager.findDirectory(virtualFile);
        RubyPsiManager.getInstance(this.b.getProject()).addChangeWatcher((PsiElement)psiDirectory, psiElement -> {
            this.c = null;
        });
    }

    public synchronized Set<Association> getAllAssociations(AssociatedItem model) {
        return this.b(model);
    }

    public synchronized Set<Association> getAllAssociations(RClass rClass) {
        AssociationFactory[] associationFactoryArray;
        HashSet<Association> hashSet = new HashSet<Association>();
        for (AssociationFactory associationFactory : associationFactoryArray = (AssociationFactory[])AssociationFactory.EP_NAME.getExtensions()) {
            AssociatedItem associatedItem = associationFactory.createAssociatedItem(rClass);
            if (associatedItem == null) continue;
            hashSet.addAll(this.getAllAssociations(associatedItem));
        }
        return hashSet;
    }

    private Set<Association> b(AssociatedItem associatedItem) {
        if (this.c == null) {
            this.c = new HashMap();
        }
        this.a(associatedItem);
        return this.c.get(associatedItem);
    }

    private void a(AssociatedItem associatedItem) {
        HashSet<Association> hashSet = new HashSet<Association>();
        List<RContainer> list2 = RubyFQNUtil.getFQNBasedPartialDeclarations((RContainer)associatedItem.getRClass(), true, null);
        for (RContainer rContainer : list2) {
            if (!(rContainer instanceof RClass)) continue;
            AssociationsParser.a(associatedItem, hashSet);
        }
        this.c.put(associatedItem, hashSet);
    }

    private static void a(AssociatedItem associatedItem, Set<Association> set) {
        List<Association> list2 = associatedItem.getAssociations();
        set.addAll(list2);
    }

    public void dispose() {
        if (this.a != null) {
            PsiManager.getInstance((Project)this.b.getProject()).removePsiTreeChangeListener(this.a);
            this.a = null;
        }
    }
}

