/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.VMPipe;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.spi.SelectorProvider;

class PipeImpl
extends Pipe {
    private SinkChannelImpl sink;
    private SourceChannelImpl source;

    public Pipe.SinkChannel sink() {
        return this.sink;
    }

    public Pipe.SourceChannel source() {
        return this.source;
    }

    public PipeImpl(SelectorProvider provider) throws IOException {
        VMPipe.init(this, provider);
    }

    public static final class SinkChannelImpl
    extends Pipe.SinkChannel {
        private int native_fd;

        protected final void implCloseSelectableChannel() throws IOException {
            throw new Error("Not implemented");
        }

        protected final void implConfigureBlocking(boolean blocking) throws IOException {
            throw new Error("Not implemented");
        }

        public final int write(ByteBuffer dst) throws IOException {
            throw new Error("Not implemented");
        }

        public final long write(ByteBuffer[] srcs) throws IOException {
            return this.write(srcs, 0, srcs.length);
        }

        public final synchronized long write(ByteBuffer[] srcs, int offset, int len) throws IOException {
            if (offset < 0 || offset > srcs.length || len < 0 || len > srcs.length - offset) {
                throw new IndexOutOfBoundsException();
            }
            long bytesWritten = 0L;
            int index = 0;
            while (index < len) {
                bytesWritten += (long)this.write(srcs[offset + index]);
                ++index;
            }
            return bytesWritten;
        }

        public final int getNativeFD() {
            return this.native_fd;
        }

        public SinkChannelImpl(SelectorProvider selectorProvider, int native_fd) {
            super(selectorProvider);
            this.native_fd = native_fd;
        }
    }

    public static final class SourceChannelImpl
    extends Pipe.SourceChannel {
        private int native_fd;

        protected final void implCloseSelectableChannel() throws IOException {
            throw new Error("Not implemented");
        }

        protected final void implConfigureBlocking(boolean blocking) throws IOException {
            throw new Error("Not implemented");
        }

        public final int read(ByteBuffer src) throws IOException {
            throw new Error("Not implemented");
        }

        public final long read(ByteBuffer[] srcs) throws IOException {
            return this.read(srcs, 0, srcs.length);
        }

        public final synchronized long read(ByteBuffer[] srcs, int offset, int len) throws IOException {
            if (offset < 0 || offset > srcs.length || len < 0 || len > srcs.length - offset) {
                throw new IndexOutOfBoundsException();
            }
            long bytesRead = 0L;
            int index = 0;
            while (index < len) {
                bytesRead += (long)this.read(srcs[offset + index]);
                ++index;
            }
            return bytesRead;
        }

        public final int getNativeFD() {
            return this.native_fd;
        }

        public SourceChannelImpl(SelectorProvider selectorProvider, int native_fd) {
            super(selectorProvider);
            this.native_fd = native_fd;
        }
    }
}

