/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.dgc;

import gnu.java.rmi.server.UnicastServerRef;
import java.rmi.RemoteException;
import java.rmi.dgc.DGC;
import java.rmi.dgc.Lease;
import java.rmi.dgc.VMID;
import java.rmi.server.ObjID;
import java.rmi.server.RMISocketFactory;
import java.util.Hashtable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DGCImpl
extends UnicastServerRef
implements DGC {
    private static final long LEASE_VALUE = 600000L;
    private Hashtable leaseCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Lease dirty(ObjID[] ids, long sequenceNum, Lease lease) throws RemoteException {
        VMID vmid = lease.getVMID();
        if (vmid == null) {
            vmid = new VMID();
        }
        long leaseValue = 600000L;
        lease = new Lease(vmid, leaseValue);
        Hashtable hashtable = this.leaseCache;
        synchronized (hashtable) {
            block5: {
                LeaseRecord lr;
                block4: {
                    lr = (LeaseRecord)this.leaseCache.get(vmid);
                    if (lr == null) break block4;
                    lr.reset(leaseValue);
                    break block5;
                }
                lr = new LeaseRecord(vmid, leaseValue);
                this.leaseCache.put(vmid, lr);
            }
            return lease;
        }
    }

    public void clean(ObjID[] ids, long sequenceNum, VMID vmid, boolean strong) throws RemoteException {
    }

    private final /* synthetic */ void this() {
        this.leaseCache = new Hashtable();
    }

    public DGCImpl() throws RemoteException {
        super(new ObjID(2), 0, RMISocketFactory.getSocketFactory());
        this.this();
    }

    private static class LeaseRecord {
        private VMID vmid;
        private long expireTime;

        void reset(long leaseValue) {
            long l = System.currentTimeMillis();
            this.expireTime = l + leaseValue;
        }

        boolean isExpired() {
            long l = System.currentTimeMillis();
            return l > this.expireTime;
        }

        LeaseRecord(VMID vmid, long leaseValue) {
            this.vmid = vmid;
            this.reset(leaseValue);
        }
    }
}

