/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dct;

import edu.emory.mathcs.jtransforms.dct.DoubleDCT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DoubleDCT_3D {
    private int n1;
    private int n2;
    private int n3;
    private int sliceStride;
    private int rowStride;
    private int[] ip;
    private double[] w;
    private double[] t;
    private DoubleDCT_1D dctn1;
    private DoubleDCT_1D dctn2;
    private DoubleDCT_1D dctn3;
    private int oldNthread;
    private int nt;

    public DoubleDCT_3D(int n, int n2, int n3) {
        if (!(ConcurrencyUtils.isPowerOf2(n) && ConcurrencyUtils.isPowerOf2(n2) && ConcurrencyUtils.isPowerOf2(n3))) {
            throw new IllegalArgumentException("n1, n2 and n3 must be power of two numbers");
        }
        if (n <= 1 || n2 <= 1 || n3 <= 1) {
            throw new IllegalArgumentException("n1, n2 and n3 must be greater than 1");
        }
        this.n1 = n;
        this.n2 = n2;
        this.n3 = n3;
        this.sliceStride = n2 * n3;
        this.rowStride = n3;
        this.ip = new int[2 + (int)Math.ceil(Math.sqrt(Math.max(Math.max(n / 2, n2 / 2), n3 / 2)))];
        this.w = new double[(int)Math.ceil(Math.max(Math.max((double)n * 1.5, (double)n2 * 1.5), (double)n3 * 1.5))];
        this.dctn1 = new DoubleDCT_1D(n, this.ip, this.w);
        this.dctn2 = new DoubleDCT_1D(n2, this.ip, this.w);
        this.dctn3 = new DoubleDCT_1D(n3, this.ip, this.w);
        this.oldNthread = ConcurrencyUtils.getNumberOfProcessors();
        this.nt = n;
        if (this.nt < n2) {
            this.nt = n2;
        }
        this.nt *= 4;
        if (this.oldNthread > 1) {
            this.nt *= this.oldNthread;
        }
        if (n3 == 2) {
            this.nt >>= 1;
        }
        this.t = new double[this.nt];
    }

    public void forward(double[] dArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 < this.n3) {
            n4 = this.n3;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (n4 > (n2 = this.ip[1])) {
            n2 = n4;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = this.n1;
            if (this.nt < this.n2) {
                this.nt = this.n2;
            }
            this.nt *= 4;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.n3 == 2) {
                this.nt >>= 1;
            }
            this.t = new double[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.ddxt3da_subth(-1, dArray, bl);
            this.ddxt3db_subth(-1, dArray, bl);
        } else {
            this.ddxt3da_sub(-1, dArray, bl);
            this.ddxt3db_sub(-1, dArray, bl);
        }
    }

    public void forward(double[][][] dArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 < this.n3) {
            n4 = this.n3;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (n4 > (n2 = this.ip[1])) {
            n2 = n4;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = this.n1;
            if (this.nt < this.n2) {
                this.nt = this.n2;
            }
            this.nt *= 4;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.n3 == 2) {
                this.nt >>= 1;
            }
            this.t = new double[this.nt];
            this.oldNthread = n;
        }
        if (ConcurrencyUtils.getNumberOfProcessors() > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.ddxt3da_subth(-1, dArray, bl);
            this.ddxt3db_subth(-1, dArray, bl);
        } else {
            this.ddxt3da_sub(-1, dArray, bl);
            this.ddxt3db_sub(-1, dArray, bl);
        }
    }

    public void inverse(double[] dArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 < this.n3) {
            n4 = this.n3;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (n4 > (n2 = this.ip[1])) {
            n2 = n4;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = this.n1;
            if (this.nt < this.n2) {
                this.nt = this.n2;
            }
            this.nt *= 4;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.n3 == 2) {
                this.nt >>= 1;
            }
            this.t = new double[this.nt];
            this.oldNthread = n;
        }
        if (ConcurrencyUtils.getNumberOfProcessors() > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.ddxt3da_subth(1, dArray, bl);
            this.ddxt3db_subth(1, dArray, bl);
        } else {
            this.ddxt3da_sub(1, dArray, bl);
            this.ddxt3db_sub(1, dArray, bl);
        }
    }

    public void inverse(double[][][] dArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 < this.n3) {
            n4 = this.n3;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (n4 > (n2 = this.ip[1])) {
            n2 = n4;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = this.n1;
            if (this.nt < this.n2) {
                this.nt = this.n2;
            }
            this.nt *= 4;
            if (n > 1) {
                this.nt *= n;
            }
            if (this.n3 == 2) {
                this.nt >>= 1;
            }
            this.t = new double[this.nt];
            this.oldNthread = n;
        }
        if (ConcurrencyUtils.getNumberOfProcessors() > 1 && this.n1 * this.n2 * this.n3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.ddxt3da_subth(1, dArray, bl);
            this.ddxt3db_subth(1, dArray, bl);
        } else {
            this.ddxt3da_sub(1, dArray, bl);
            this.ddxt3db_sub(1, dArray, bl);
        }
    }

    private void ddxt3da_sub(int n, double[] dArray, boolean bl) {
        if (n == -1) {
            for (int i = 0; i < this.n1; ++i) {
                int n2;
                int n3;
                int n4 = i * this.sliceStride;
                for (n3 = 0; n3 < this.n2; ++n3) {
                    this.dctn3.forward(dArray, n4 + n3 * this.rowStride, bl);
                }
                if (this.n3 > 2) {
                    for (int j = 0; j < this.n3; j += 4) {
                        int n5;
                        for (n3 = 0; n3 < this.n2; ++n3) {
                            n2 = n4 + n3 * this.rowStride + j;
                            n5 = this.n2 + n3;
                            this.t[n3] = dArray[n2];
                            this.t[n5] = dArray[n2 + 1];
                            this.t[n5 + this.n2] = dArray[n2 + 2];
                            this.t[n5 + 2 * this.n2] = dArray[n2 + 3];
                        }
                        this.dctn2.forward(this.t, 0, bl);
                        this.dctn2.forward(this.t, this.n2, bl);
                        this.dctn2.forward(this.t, 2 * this.n2, bl);
                        this.dctn2.forward(this.t, 3 * this.n2, bl);
                        for (n3 = 0; n3 < this.n2; ++n3) {
                            n2 = n4 + n3 * this.rowStride + j;
                            n5 = this.n2 + n3;
                            dArray[n2] = this.t[n3];
                            dArray[n2 + 1] = this.t[n5];
                            dArray[n2 + 2] = this.t[n5 + this.n2];
                            dArray[n2 + 3] = this.t[n5 + 2 * this.n2];
                        }
                    }
                    continue;
                }
                if (this.n3 != 2) continue;
                for (n3 = 0; n3 < this.n2; ++n3) {
                    n2 = n4 + n3 * this.rowStride;
                    this.t[n3] = dArray[n2];
                    this.t[this.n2 + n3] = dArray[n2 + 1];
                }
                this.dctn2.forward(this.t, 0, bl);
                this.dctn2.forward(this.t, this.n2, bl);
                for (n3 = 0; n3 < this.n2; ++n3) {
                    n2 = n4 + n3 * this.rowStride;
                    dArray[n2] = this.t[n3];
                    dArray[n2 + 1] = this.t[this.n2 + n3];
                }
            }
        } else {
            for (int i = 0; i < this.n1; ++i) {
                int n6;
                int n7;
                int n8 = i * this.sliceStride;
                for (n7 = 0; n7 < this.n2; ++n7) {
                    this.dctn3.inverse(dArray, n8 + n7 * this.rowStride, bl);
                }
                if (this.n3 > 2) {
                    for (int j = 0; j < this.n3; j += 4) {
                        int n9;
                        for (n7 = 0; n7 < this.n2; ++n7) {
                            n6 = n8 + n7 * this.rowStride + j;
                            n9 = this.n2 + n7;
                            this.t[n7] = dArray[n6];
                            this.t[n9] = dArray[n6 + 1];
                            this.t[n9 + this.n2] = dArray[n6 + 2];
                            this.t[n9 + 2 * this.n2] = dArray[n6 + 3];
                        }
                        this.dctn2.inverse(this.t, 0, bl);
                        this.dctn2.inverse(this.t, this.n2, bl);
                        this.dctn2.inverse(this.t, 2 * this.n2, bl);
                        this.dctn2.inverse(this.t, 3 * this.n2, bl);
                        for (n7 = 0; n7 < this.n2; ++n7) {
                            n6 = n8 + n7 * this.rowStride + j;
                            n9 = this.n2 + n7;
                            dArray[n6] = this.t[n7];
                            dArray[n6 + 1] = this.t[n9];
                            dArray[n6 + 2] = this.t[n9 + this.n2];
                            dArray[n6 + 3] = this.t[n9 + 2 * this.n2];
                        }
                    }
                    continue;
                }
                if (this.n3 != 2) continue;
                for (n7 = 0; n7 < this.n2; ++n7) {
                    n6 = n8 + n7 * this.rowStride;
                    this.t[n7] = dArray[n6];
                    this.t[this.n2 + n7] = dArray[n6 + 1];
                }
                this.dctn2.inverse(this.t, 0, bl);
                this.dctn2.inverse(this.t, this.n2, bl);
                for (n7 = 0; n7 < this.n2; ++n7) {
                    n6 = n8 + n7 * this.rowStride;
                    dArray[n6] = this.t[n7];
                    dArray[n6 + 1] = this.t[this.n2 + n7];
                }
            }
        }
    }

    private void ddxt3da_sub(int n, double[][][] dArray, boolean bl) {
        if (n == -1) {
            for (int i = 0; i < this.n1; ++i) {
                int n2;
                for (n2 = 0; n2 < this.n2; ++n2) {
                    this.dctn3.forward(dArray[i][n2], bl);
                }
                if (this.n3 > 2) {
                    for (int j = 0; j < this.n3; j += 4) {
                        int n3;
                        for (n2 = 0; n2 < this.n2; ++n2) {
                            n3 = this.n2 + n2;
                            this.t[n2] = dArray[i][n2][j];
                            this.t[n3] = dArray[i][n2][j + 1];
                            this.t[n3 + this.n2] = dArray[i][n2][j + 2];
                            this.t[n3 + 2 * this.n2] = dArray[i][n2][j + 3];
                        }
                        this.dctn2.forward(this.t, 0, bl);
                        this.dctn2.forward(this.t, this.n2, bl);
                        this.dctn2.forward(this.t, 2 * this.n2, bl);
                        this.dctn2.forward(this.t, 3 * this.n2, bl);
                        for (n2 = 0; n2 < this.n2; ++n2) {
                            n3 = this.n2 + n2;
                            dArray[i][n2][j] = this.t[n2];
                            dArray[i][n2][j + 1] = this.t[n3];
                            dArray[i][n2][j + 2] = this.t[n3 + this.n2];
                            dArray[i][n2][j + 3] = this.t[n3 + 2 * this.n2];
                        }
                    }
                    continue;
                }
                if (this.n3 != 2) continue;
                for (n2 = 0; n2 < this.n2; ++n2) {
                    this.t[n2] = dArray[i][n2][0];
                    this.t[this.n2 + n2] = dArray[i][n2][1];
                }
                this.dctn2.forward(this.t, 0, bl);
                this.dctn2.forward(this.t, this.n2, bl);
                for (n2 = 0; n2 < this.n2; ++n2) {
                    dArray[i][n2][0] = this.t[n2];
                    dArray[i][n2][1] = this.t[this.n2 + n2];
                }
            }
        } else {
            for (int i = 0; i < this.n1; ++i) {
                int n4;
                for (n4 = 0; n4 < this.n2; ++n4) {
                    this.dctn3.inverse(dArray[i][n4], bl);
                }
                if (this.n3 > 2) {
                    for (int j = 0; j < this.n3; j += 4) {
                        int n5;
                        for (n4 = 0; n4 < this.n2; ++n4) {
                            n5 = this.n2 + n4;
                            this.t[n4] = dArray[i][n4][j];
                            this.t[n5] = dArray[i][n4][j + 1];
                            this.t[n5 + this.n2] = dArray[i][n4][j + 2];
                            this.t[n5 + 2 * this.n2] = dArray[i][n4][j + 3];
                        }
                        this.dctn2.inverse(this.t, 0, bl);
                        this.dctn2.inverse(this.t, this.n2, bl);
                        this.dctn2.inverse(this.t, 2 * this.n2, bl);
                        this.dctn2.inverse(this.t, 3 * this.n2, bl);
                        for (n4 = 0; n4 < this.n2; ++n4) {
                            n5 = this.n2 + n4;
                            dArray[i][n4][j] = this.t[n4];
                            dArray[i][n4][j + 1] = this.t[n5];
                            dArray[i][n4][j + 2] = this.t[n5 + this.n2];
                            dArray[i][n4][j + 3] = this.t[n5 + 2 * this.n2];
                        }
                    }
                    continue;
                }
                if (this.n3 != 2) continue;
                for (n4 = 0; n4 < this.n2; ++n4) {
                    this.t[n4] = dArray[i][n4][0];
                    this.t[this.n2 + n4] = dArray[i][n4][1];
                }
                this.dctn2.inverse(this.t, 0, bl);
                this.dctn2.inverse(this.t, this.n2, bl);
                for (n4 = 0; n4 < this.n2; ++n4) {
                    dArray[i][n4][0] = this.t[n4];
                    dArray[i][n4][1] = this.t[this.n2 + n4];
                }
            }
        }
    }

    private void ddxt3db_sub(int n, double[] dArray, boolean bl) {
        block19: {
            block17: {
                block18: {
                    if (n != -1) break block17;
                    if (this.n3 <= 2) break block18;
                    for (int i = 0; i < this.n2; ++i) {
                        int n2 = i * this.rowStride;
                        for (int j = 0; j < this.n3; j += 4) {
                            int n3;
                            int n4;
                            int n5;
                            for (n5 = 0; n5 < this.n1; ++n5) {
                                n4 = n5 * this.sliceStride + n2 + j;
                                n3 = this.n1 + n5;
                                this.t[n5] = dArray[n4];
                                this.t[n3] = dArray[n4 + 1];
                                this.t[n3 + this.n1] = dArray[n4 + 2];
                                this.t[n3 + 2 * this.n1] = dArray[n4 + 3];
                            }
                            this.dctn1.forward(this.t, 0, bl);
                            this.dctn1.forward(this.t, this.n1, bl);
                            this.dctn1.forward(this.t, 2 * this.n1, bl);
                            this.dctn1.forward(this.t, 3 * this.n1, bl);
                            for (n5 = 0; n5 < this.n1; ++n5) {
                                n4 = n5 * this.sliceStride + n2 + j;
                                n3 = this.n1 + n5;
                                dArray[n4] = this.t[n5];
                                dArray[n4 + 1] = this.t[n3];
                                dArray[n4 + 2] = this.t[n3 + this.n1];
                                dArray[n4 + 3] = this.t[n3 + 2 * this.n1];
                            }
                        }
                    }
                    break block19;
                }
                if (this.n3 != 2) break block19;
                for (int i = 0; i < this.n2; ++i) {
                    int n6;
                    int n7;
                    int n8 = i * this.rowStride;
                    for (n7 = 0; n7 < this.n1; ++n7) {
                        n6 = n7 * this.sliceStride + n8;
                        this.t[n7] = dArray[n6];
                        this.t[this.n1 + n7] = dArray[n6 + 1];
                    }
                    this.dctn1.forward(this.t, 0, bl);
                    this.dctn1.forward(this.t, this.n1, bl);
                    for (n7 = 0; n7 < this.n1; ++n7) {
                        n6 = n7 * this.sliceStride + n8;
                        dArray[n6] = this.t[n7];
                        dArray[n6 + 1] = this.t[this.n1 + n7];
                    }
                }
                break block19;
            }
            if (this.n3 > 2) {
                for (int i = 0; i < this.n2; ++i) {
                    int n9 = i * this.rowStride;
                    for (int j = 0; j < this.n3; j += 4) {
                        int n10;
                        int n11;
                        int n12;
                        for (n12 = 0; n12 < this.n1; ++n12) {
                            n11 = n12 * this.sliceStride + n9 + j;
                            n10 = this.n1 + n12;
                            this.t[n12] = dArray[n11];
                            this.t[n10] = dArray[n11 + 1];
                            this.t[n10 + this.n1] = dArray[n11 + 2];
                            this.t[n10 + 2 * this.n1] = dArray[n11 + 3];
                        }
                        this.dctn1.inverse(this.t, 0, bl);
                        this.dctn1.inverse(this.t, this.n1, bl);
                        this.dctn1.inverse(this.t, 2 * this.n1, bl);
                        this.dctn1.inverse(this.t, 3 * this.n1, bl);
                        for (n12 = 0; n12 < this.n1; ++n12) {
                            n11 = n12 * this.sliceStride + n9 + j;
                            n10 = this.n1 + n12;
                            dArray[n11] = this.t[n12];
                            dArray[n11 + 1] = this.t[n10];
                            dArray[n11 + 2] = this.t[n10 + this.n1];
                            dArray[n11 + 3] = this.t[n10 + 2 * this.n1];
                        }
                    }
                }
            } else if (this.n3 == 2) {
                for (int i = 0; i < this.n2; ++i) {
                    int n13;
                    int n14;
                    int n15 = i * this.rowStride;
                    for (n14 = 0; n14 < this.n1; ++n14) {
                        n13 = n14 * this.sliceStride + n15;
                        this.t[n14] = dArray[n13];
                        this.t[this.n1 + n14] = dArray[n13 + 1];
                    }
                    this.dctn1.inverse(this.t, 0, bl);
                    this.dctn1.inverse(this.t, this.n1, bl);
                    for (n14 = 0; n14 < this.n1; ++n14) {
                        n13 = n14 * this.sliceStride + n15;
                        dArray[n13] = this.t[n14];
                        dArray[n13 + 1] = this.t[this.n1 + n14];
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int n, double[][][] dArray, boolean bl) {
        block19: {
            block17: {
                block18: {
                    if (n != -1) break block17;
                    if (this.n3 <= 2) break block18;
                    for (int i = 0; i < this.n2; ++i) {
                        for (int j = 0; j < this.n3; j += 4) {
                            int n2;
                            int n3;
                            for (n3 = 0; n3 < this.n1; ++n3) {
                                n2 = this.n1 + n3;
                                this.t[n3] = dArray[n3][i][j];
                                this.t[n2] = dArray[n3][i][j + 1];
                                this.t[n2 + this.n1] = dArray[n3][i][j + 2];
                                this.t[n2 + 2 * this.n1] = dArray[n3][i][j + 3];
                            }
                            this.dctn1.forward(this.t, 0, bl);
                            this.dctn1.forward(this.t, this.n1, bl);
                            this.dctn1.forward(this.t, 2 * this.n1, bl);
                            this.dctn1.forward(this.t, 3 * this.n1, bl);
                            for (n3 = 0; n3 < this.n1; ++n3) {
                                n2 = this.n1 + n3;
                                dArray[n3][i][j] = this.t[n3];
                                dArray[n3][i][j + 1] = this.t[n2];
                                dArray[n3][i][j + 2] = this.t[n2 + this.n1];
                                dArray[n3][i][j + 3] = this.t[n2 + 2 * this.n1];
                            }
                        }
                    }
                    break block19;
                }
                if (this.n3 != 2) break block19;
                for (int i = 0; i < this.n2; ++i) {
                    int n4;
                    for (n4 = 0; n4 < this.n1; ++n4) {
                        this.t[n4] = dArray[n4][i][0];
                        this.t[this.n1 + n4] = dArray[n4][i][1];
                    }
                    this.dctn1.forward(this.t, 0, bl);
                    this.dctn1.forward(this.t, this.n1, bl);
                    for (n4 = 0; n4 < this.n1; ++n4) {
                        dArray[n4][i][0] = this.t[n4];
                        dArray[n4][i][1] = this.t[this.n1 + n4];
                    }
                }
                break block19;
            }
            if (this.n3 > 2) {
                for (int i = 0; i < this.n2; ++i) {
                    for (int j = 0; j < this.n3; j += 4) {
                        int n5;
                        int n6;
                        for (n6 = 0; n6 < this.n1; ++n6) {
                            n5 = this.n1 + n6;
                            this.t[n6] = dArray[n6][i][j];
                            this.t[n5] = dArray[n6][i][j + 1];
                            this.t[n5 + this.n1] = dArray[n6][i][j + 2];
                            this.t[n5 + 2 * this.n1] = dArray[n6][i][j + 3];
                        }
                        this.dctn1.inverse(this.t, 0, bl);
                        this.dctn1.inverse(this.t, this.n1, bl);
                        this.dctn1.inverse(this.t, 2 * this.n1, bl);
                        this.dctn1.inverse(this.t, 3 * this.n1, bl);
                        for (n6 = 0; n6 < this.n1; ++n6) {
                            n5 = this.n1 + n6;
                            dArray[n6][i][j] = this.t[n6];
                            dArray[n6][i][j + 1] = this.t[n5];
                            dArray[n6][i][j + 2] = this.t[n5 + this.n1];
                            dArray[n6][i][j + 3] = this.t[n5 + 2 * this.n1];
                        }
                    }
                }
            } else if (this.n3 == 2) {
                for (int i = 0; i < this.n2; ++i) {
                    int n7;
                    for (n7 = 0; n7 < this.n1; ++n7) {
                        this.t[n7] = dArray[n7][i][0];
                        this.t[this.n1 + n7] = dArray[n7][i][1];
                    }
                    this.dctn1.inverse(this.t, 0, bl);
                    this.dctn1.inverse(this.t, this.n1, bl);
                    for (n7 = 0; n7 < this.n1; ++n7) {
                        dArray[n7][i][0] = this.t[n7];
                        dArray[n7][i][1] = this.t[this.n1 + n7];
                    }
                }
            }
        }
    }

    private void ddxt3da_subth(final int n, final double[] dArray, final boolean bl) {
        int n2;
        int n3 = ConcurrencyUtils.getNumberOfProcessors();
        if (n3 > this.n1) {
            n3 = this.n1;
        }
        int n4 = 4 * this.n2;
        if (this.n3 == 2) {
            n4 >>= 1;
        }
        final int n5 = n3;
        Future[] futureArray = new Future[n3];
        for (int i = 0; i < n3; ++i) {
            n2 = i;
            final int n6 = n4 * i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    if (n == -1) {
                        for (int i = n2; i < DoubleDCT_3D.this.n1; i += n5) {
                            int n10;
                            int n22;
                            int n3 = i * DoubleDCT_3D.this.sliceStride;
                            for (n22 = 0; n22 < DoubleDCT_3D.this.n2; ++n22) {
                                DoubleDCT_3D.this.dctn3.forward(dArray, n3 + n22 * DoubleDCT_3D.this.rowStride, bl);
                            }
                            if (DoubleDCT_3D.this.n3 > 2) {
                                for (n22 = 0; n22 < DoubleDCT_3D.this.n3; n22 += 4) {
                                    int n4;
                                    int n52;
                                    for (n52 = 0; n52 < DoubleDCT_3D.this.n2; ++n52) {
                                        n10 = n3 + n52 * DoubleDCT_3D.this.rowStride + n22;
                                        n4 = n6 + DoubleDCT_3D.this.n2 + n52;
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + n52] = dArray[n10];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n4] = dArray[n10 + 1];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n4 + ((DoubleDCT_3D)DoubleDCT_3D.this).n2] = dArray[n10 + 2];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n4 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).n2] = dArray[n10 + 3];
                                    }
                                    DoubleDCT_3D.this.dctn2.forward(DoubleDCT_3D.this.t, n6, bl);
                                    DoubleDCT_3D.this.dctn2.forward(DoubleDCT_3D.this.t, n6 + DoubleDCT_3D.this.n2, bl);
                                    DoubleDCT_3D.this.dctn2.forward(DoubleDCT_3D.this.t, n6 + 2 * DoubleDCT_3D.this.n2, bl);
                                    DoubleDCT_3D.this.dctn2.forward(DoubleDCT_3D.this.t, n6 + 3 * DoubleDCT_3D.this.n2, bl);
                                    for (n52 = 0; n52 < DoubleDCT_3D.this.n2; ++n52) {
                                        n10 = n3 + n52 * DoubleDCT_3D.this.rowStride + n22;
                                        n4 = n6 + DoubleDCT_3D.this.n2 + n52;
                                        dArray[n10] = DoubleDCT_3D.this.t[n6 + n52];
                                        dArray[n10 + 1] = DoubleDCT_3D.this.t[n4];
                                        dArray[n10 + 2] = DoubleDCT_3D.this.t[n4 + DoubleDCT_3D.this.n2];
                                        dArray[n10 + 3] = DoubleDCT_3D.this.t[n4 + 2 * DoubleDCT_3D.this.n2];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDCT_3D.this.n3 != 2) continue;
                            for (n22 = 0; n22 < DoubleDCT_3D.this.n2; ++n22) {
                                n10 = n3 + n22 * DoubleDCT_3D.this.rowStride;
                                ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + n22] = dArray[n10];
                                ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + ((DoubleDCT_3D)DoubleDCT_3D.this).n2 + n22] = dArray[n10 + 1];
                            }
                            DoubleDCT_3D.this.dctn2.forward(DoubleDCT_3D.this.t, n6, bl);
                            DoubleDCT_3D.this.dctn2.forward(DoubleDCT_3D.this.t, n6 + DoubleDCT_3D.this.n2, bl);
                            for (n22 = 0; n22 < DoubleDCT_3D.this.n2; ++n22) {
                                n10 = n3 + n22 * DoubleDCT_3D.this.rowStride;
                                dArray[n10] = DoubleDCT_3D.this.t[n6 + n22];
                                dArray[n10 + 1] = DoubleDCT_3D.this.t[n6 + DoubleDCT_3D.this.n2 + n22];
                            }
                        }
                    } else {
                        for (int i = n2; i < DoubleDCT_3D.this.n1; i += n5) {
                            int n11;
                            int n62;
                            int n7 = i * DoubleDCT_3D.this.sliceStride;
                            for (n62 = 0; n62 < DoubleDCT_3D.this.n2; ++n62) {
                                DoubleDCT_3D.this.dctn3.inverse(dArray, n7 + n62 * DoubleDCT_3D.this.rowStride, bl);
                            }
                            if (DoubleDCT_3D.this.n3 > 2) {
                                for (n62 = 0; n62 < DoubleDCT_3D.this.n3; n62 += 4) {
                                    int n8;
                                    int n9;
                                    for (n9 = 0; n9 < DoubleDCT_3D.this.n2; ++n9) {
                                        n11 = n7 + n9 * DoubleDCT_3D.this.rowStride + n62;
                                        n8 = n6 + DoubleDCT_3D.this.n2 + n9;
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + n9] = dArray[n11];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n8] = dArray[n11 + 1];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n8 + ((DoubleDCT_3D)DoubleDCT_3D.this).n2] = dArray[n11 + 2];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n8 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).n2] = dArray[n11 + 3];
                                    }
                                    DoubleDCT_3D.this.dctn2.inverse(DoubleDCT_3D.this.t, n6, bl);
                                    DoubleDCT_3D.this.dctn2.inverse(DoubleDCT_3D.this.t, n6 + DoubleDCT_3D.this.n2, bl);
                                    DoubleDCT_3D.this.dctn2.inverse(DoubleDCT_3D.this.t, n6 + 2 * DoubleDCT_3D.this.n2, bl);
                                    DoubleDCT_3D.this.dctn2.inverse(DoubleDCT_3D.this.t, n6 + 3 * DoubleDCT_3D.this.n2, bl);
                                    for (n9 = 0; n9 < DoubleDCT_3D.this.n2; ++n9) {
                                        n11 = n7 + n9 * DoubleDCT_3D.this.rowStride + n62;
                                        n8 = n6 + DoubleDCT_3D.this.n2 + n9;
                                        dArray[n11] = DoubleDCT_3D.this.t[n6 + n9];
                                        dArray[n11 + 1] = DoubleDCT_3D.this.t[n8];
                                        dArray[n11 + 2] = DoubleDCT_3D.this.t[n8 + DoubleDCT_3D.this.n2];
                                        dArray[n11 + 3] = DoubleDCT_3D.this.t[n8 + 2 * DoubleDCT_3D.this.n2];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDCT_3D.this.n3 != 2) continue;
                            for (n62 = 0; n62 < DoubleDCT_3D.this.n2; ++n62) {
                                n11 = n7 + n62 * DoubleDCT_3D.this.rowStride;
                                ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + n62] = dArray[n11];
                                ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + ((DoubleDCT_3D)DoubleDCT_3D.this).n2 + n62] = dArray[n11 + 1];
                            }
                            DoubleDCT_3D.this.dctn2.inverse(DoubleDCT_3D.this.t, n6, bl);
                            DoubleDCT_3D.this.dctn2.inverse(DoubleDCT_3D.this.t, n6 + DoubleDCT_3D.this.n2, bl);
                            for (n62 = 0; n62 < DoubleDCT_3D.this.n2; ++n62) {
                                n11 = n7 + n62 * DoubleDCT_3D.this.rowStride;
                                dArray[n11] = DoubleDCT_3D.this.t[n6 + n62];
                                dArray[n11 + 1] = DoubleDCT_3D.this.t[n6 + DoubleDCT_3D.this.n2 + n62];
                            }
                        }
                    }
                }
            });
        }
        try {
            for (n2 = 0; n2 < n3; ++n2) {
                futureArray[n2].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void ddxt3da_subth(final int n, final double[][][] dArray, final boolean bl) {
        int n2;
        int n3 = ConcurrencyUtils.getNumberOfProcessors();
        final int n4 = n3 > this.n1 ? this.n1 : n3;
        int n5 = 4 * this.n2;
        if (this.n3 == 2) {
            n5 >>= 1;
        }
        Future[] futureArray = new Future[n4];
        for (int i = 0; i < n4; ++i) {
            n2 = i;
            final int n6 = n5 * i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    if (n == -1) {
                        for (int i = n2; i < DoubleDCT_3D.this.n1; i += n4) {
                            int n7;
                            for (n7 = 0; n7 < DoubleDCT_3D.this.n2; ++n7) {
                                DoubleDCT_3D.this.dctn3.forward(dArray[i][n7], bl);
                            }
                            if (DoubleDCT_3D.this.n3 > 2) {
                                for (n7 = 0; n7 < DoubleDCT_3D.this.n3; n7 += 4) {
                                    int n22;
                                    int n3;
                                    for (n3 = 0; n3 < DoubleDCT_3D.this.n2; ++n3) {
                                        n22 = n6 + DoubleDCT_3D.this.n2 + n3;
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + n3] = dArray[i][n3][n7];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n22] = dArray[i][n3][n7 + 1];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n22 + ((DoubleDCT_3D)DoubleDCT_3D.this).n2] = dArray[i][n3][n7 + 2];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n22 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).n2] = dArray[i][n3][n7 + 3];
                                    }
                                    DoubleDCT_3D.this.dctn2.forward(DoubleDCT_3D.this.t, n6, bl);
                                    DoubleDCT_3D.this.dctn2.forward(DoubleDCT_3D.this.t, n6 + DoubleDCT_3D.this.n2, bl);
                                    DoubleDCT_3D.this.dctn2.forward(DoubleDCT_3D.this.t, n6 + 2 * DoubleDCT_3D.this.n2, bl);
                                    DoubleDCT_3D.this.dctn2.forward(DoubleDCT_3D.this.t, n6 + 3 * DoubleDCT_3D.this.n2, bl);
                                    for (n3 = 0; n3 < DoubleDCT_3D.this.n2; ++n3) {
                                        n22 = n6 + DoubleDCT_3D.this.n2 + n3;
                                        dArray[i][n3][n7] = DoubleDCT_3D.this.t[n6 + n3];
                                        dArray[i][n3][n7 + 1] = DoubleDCT_3D.this.t[n22];
                                        dArray[i][n3][n7 + 2] = DoubleDCT_3D.this.t[n22 + DoubleDCT_3D.this.n2];
                                        dArray[i][n3][n7 + 3] = DoubleDCT_3D.this.t[n22 + 2 * DoubleDCT_3D.this.n2];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDCT_3D.this.n3 != 2) continue;
                            for (n7 = 0; n7 < DoubleDCT_3D.this.n2; ++n7) {
                                ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + n7] = dArray[i][n7][0];
                                ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + ((DoubleDCT_3D)DoubleDCT_3D.this).n2 + n7] = dArray[i][n7][1];
                            }
                            DoubleDCT_3D.this.dctn2.forward(DoubleDCT_3D.this.t, n6, bl);
                            DoubleDCT_3D.this.dctn2.forward(DoubleDCT_3D.this.t, n6 + DoubleDCT_3D.this.n2, bl);
                            for (n7 = 0; n7 < DoubleDCT_3D.this.n2; ++n7) {
                                dArray[i][n7][0] = DoubleDCT_3D.this.t[n6 + n7];
                                dArray[i][n7][1] = DoubleDCT_3D.this.t[n6 + DoubleDCT_3D.this.n2 + n7];
                            }
                        }
                    } else {
                        for (int i = n2; i < DoubleDCT_3D.this.n1; i += n4) {
                            int n8;
                            for (n8 = 0; n8 < DoubleDCT_3D.this.n2; ++n8) {
                                DoubleDCT_3D.this.dctn3.inverse(dArray[i][n8], bl);
                            }
                            if (DoubleDCT_3D.this.n3 > 2) {
                                for (n8 = 0; n8 < DoubleDCT_3D.this.n3; n8 += 4) {
                                    int n42;
                                    int n5;
                                    for (n5 = 0; n5 < DoubleDCT_3D.this.n2; ++n5) {
                                        n42 = n6 + DoubleDCT_3D.this.n2 + n5;
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + n5] = dArray[i][n5][n8];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n42] = dArray[i][n5][n8 + 1];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n42 + ((DoubleDCT_3D)DoubleDCT_3D.this).n2] = dArray[i][n5][n8 + 2];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n42 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).n2] = dArray[i][n5][n8 + 3];
                                    }
                                    DoubleDCT_3D.this.dctn2.inverse(DoubleDCT_3D.this.t, n6, bl);
                                    DoubleDCT_3D.this.dctn2.inverse(DoubleDCT_3D.this.t, n6 + DoubleDCT_3D.this.n2, bl);
                                    DoubleDCT_3D.this.dctn2.inverse(DoubleDCT_3D.this.t, n6 + 2 * DoubleDCT_3D.this.n2, bl);
                                    DoubleDCT_3D.this.dctn2.inverse(DoubleDCT_3D.this.t, n6 + 3 * DoubleDCT_3D.this.n2, bl);
                                    for (n5 = 0; n5 < DoubleDCT_3D.this.n2; ++n5) {
                                        n42 = n6 + DoubleDCT_3D.this.n2 + n5;
                                        dArray[i][n5][n8] = DoubleDCT_3D.this.t[n6 + n5];
                                        dArray[i][n5][n8 + 1] = DoubleDCT_3D.this.t[n42];
                                        dArray[i][n5][n8 + 2] = DoubleDCT_3D.this.t[n42 + DoubleDCT_3D.this.n2];
                                        dArray[i][n5][n8 + 3] = DoubleDCT_3D.this.t[n42 + 2 * DoubleDCT_3D.this.n2];
                                    }
                                }
                                continue;
                            }
                            if (DoubleDCT_3D.this.n3 != 2) continue;
                            for (n8 = 0; n8 < DoubleDCT_3D.this.n2; ++n8) {
                                ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + n8] = dArray[i][n8][0];
                                ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + ((DoubleDCT_3D)DoubleDCT_3D.this).n2 + n8] = dArray[i][n8][1];
                            }
                            DoubleDCT_3D.this.dctn2.inverse(DoubleDCT_3D.this.t, n6, bl);
                            DoubleDCT_3D.this.dctn2.inverse(DoubleDCT_3D.this.t, n6 + DoubleDCT_3D.this.n2, bl);
                            for (n8 = 0; n8 < DoubleDCT_3D.this.n2; ++n8) {
                                dArray[i][n8][0] = DoubleDCT_3D.this.t[n6 + n8];
                                dArray[i][n8][1] = DoubleDCT_3D.this.t[n6 + DoubleDCT_3D.this.n2 + n8];
                            }
                        }
                    }
                }
            });
        }
        try {
            for (n2 = 0; n2 < n4; ++n2) {
                futureArray[n2].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void ddxt3db_subth(final int n, final double[] dArray, final boolean bl) {
        int n2;
        int n3 = ConcurrencyUtils.getNumberOfProcessors();
        if (n3 > this.n2) {
            n3 = this.n2;
        }
        int n4 = 4 * this.n1;
        if (this.n3 == 2) {
            n4 >>= 1;
        }
        Future[] futureArray = new Future[n3];
        final int n5 = n3;
        for (int i = 0; i < n3; ++i) {
            n2 = i;
            final int n6 = n4 * i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    block19: {
                        block17: {
                            block18: {
                                if (n != -1) break block17;
                                if (DoubleDCT_3D.this.n3 <= 2) break block18;
                                for (int i = n2; i < DoubleDCT_3D.this.n2; i += n5) {
                                    int n12 = i * DoubleDCT_3D.this.rowStride;
                                    for (int j = 0; j < DoubleDCT_3D.this.n3; j += 4) {
                                        int n22;
                                        int n3;
                                        int n4;
                                        for (n4 = 0; n4 < DoubleDCT_3D.this.n1; ++n4) {
                                            n3 = n4 * DoubleDCT_3D.this.sliceStride + n12 + j;
                                            n22 = n6 + DoubleDCT_3D.this.n1 + n4;
                                            ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + n4] = dArray[n3];
                                            ((DoubleDCT_3D)DoubleDCT_3D.this).t[n22] = dArray[n3 + 1];
                                            ((DoubleDCT_3D)DoubleDCT_3D.this).t[n22 + ((DoubleDCT_3D)DoubleDCT_3D.this).n1] = dArray[n3 + 2];
                                            ((DoubleDCT_3D)DoubleDCT_3D.this).t[n22 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).n1] = dArray[n3 + 3];
                                        }
                                        DoubleDCT_3D.this.dctn1.forward(DoubleDCT_3D.this.t, n6, bl);
                                        DoubleDCT_3D.this.dctn1.forward(DoubleDCT_3D.this.t, n6 + DoubleDCT_3D.this.n1, bl);
                                        DoubleDCT_3D.this.dctn1.forward(DoubleDCT_3D.this.t, n6 + 2 * DoubleDCT_3D.this.n1, bl);
                                        DoubleDCT_3D.this.dctn1.forward(DoubleDCT_3D.this.t, n6 + 3 * DoubleDCT_3D.this.n1, bl);
                                        for (n4 = 0; n4 < DoubleDCT_3D.this.n1; ++n4) {
                                            n3 = n4 * DoubleDCT_3D.this.sliceStride + n12 + j;
                                            n22 = n6 + DoubleDCT_3D.this.n1 + n4;
                                            dArray[n3] = DoubleDCT_3D.this.t[n6 + n4];
                                            dArray[n3 + 1] = DoubleDCT_3D.this.t[n22];
                                            dArray[n3 + 2] = DoubleDCT_3D.this.t[n22 + DoubleDCT_3D.this.n1];
                                            dArray[n3 + 3] = DoubleDCT_3D.this.t[n22 + 2 * DoubleDCT_3D.this.n1];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDCT_3D.this.n3 != 2) break block19;
                            for (int i = n2; i < DoubleDCT_3D.this.n2; i += n5) {
                                int n13;
                                int n52;
                                int n62 = i * DoubleDCT_3D.this.rowStride;
                                for (n52 = 0; n52 < DoubleDCT_3D.this.n1; ++n52) {
                                    n13 = n52 * DoubleDCT_3D.this.sliceStride + n62;
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + n52] = dArray[n13];
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + ((DoubleDCT_3D)DoubleDCT_3D.this).n1 + n52] = dArray[n13 + 1];
                                }
                                DoubleDCT_3D.this.dctn1.forward(DoubleDCT_3D.this.t, n6, bl);
                                DoubleDCT_3D.this.dctn1.forward(DoubleDCT_3D.this.t, n6 + DoubleDCT_3D.this.n1, bl);
                                for (n52 = 0; n52 < DoubleDCT_3D.this.n1; ++n52) {
                                    n13 = n52 * DoubleDCT_3D.this.sliceStride + n62;
                                    dArray[n13] = DoubleDCT_3D.this.t[n6 + n52];
                                    dArray[n13 + 1] = DoubleDCT_3D.this.t[n6 + DoubleDCT_3D.this.n1 + n52];
                                }
                            }
                            break block19;
                        }
                        if (DoubleDCT_3D.this.n3 > 2) {
                            for (int i = n2; i < DoubleDCT_3D.this.n2; i += n5) {
                                int n14 = i * DoubleDCT_3D.this.rowStride;
                                for (int j = 0; j < DoubleDCT_3D.this.n3; j += 4) {
                                    int n7;
                                    int n8;
                                    int n9;
                                    for (n9 = 0; n9 < DoubleDCT_3D.this.n1; ++n9) {
                                        n8 = n9 * DoubleDCT_3D.this.sliceStride + n14 + j;
                                        n7 = n6 + DoubleDCT_3D.this.n1 + n9;
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + n9] = dArray[n8];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n7] = dArray[n8 + 1];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n7 + ((DoubleDCT_3D)DoubleDCT_3D.this).n1] = dArray[n8 + 2];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n7 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).n1] = dArray[n8 + 3];
                                    }
                                    DoubleDCT_3D.this.dctn1.inverse(DoubleDCT_3D.this.t, n6, bl);
                                    DoubleDCT_3D.this.dctn1.inverse(DoubleDCT_3D.this.t, n6 + DoubleDCT_3D.this.n1, bl);
                                    DoubleDCT_3D.this.dctn1.inverse(DoubleDCT_3D.this.t, n6 + 2 * DoubleDCT_3D.this.n1, bl);
                                    DoubleDCT_3D.this.dctn1.inverse(DoubleDCT_3D.this.t, n6 + 3 * DoubleDCT_3D.this.n1, bl);
                                    for (n9 = 0; n9 < DoubleDCT_3D.this.n1; ++n9) {
                                        n8 = n9 * DoubleDCT_3D.this.sliceStride + n14 + j;
                                        n7 = n6 + DoubleDCT_3D.this.n1 + n9;
                                        dArray[n8] = DoubleDCT_3D.this.t[n6 + n9];
                                        dArray[n8 + 1] = DoubleDCT_3D.this.t[n7];
                                        dArray[n8 + 2] = DoubleDCT_3D.this.t[n7 + DoubleDCT_3D.this.n1];
                                        dArray[n8 + 3] = DoubleDCT_3D.this.t[n7 + 2 * DoubleDCT_3D.this.n1];
                                    }
                                }
                            }
                        } else if (DoubleDCT_3D.this.n3 == 2) {
                            for (int i = n2; i < DoubleDCT_3D.this.n2; i += n5) {
                                int n15;
                                int n10;
                                int n11 = i * DoubleDCT_3D.this.rowStride;
                                for (n10 = 0; n10 < DoubleDCT_3D.this.n1; ++n10) {
                                    n15 = n10 * DoubleDCT_3D.this.sliceStride + n11;
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + n10] = dArray[n15];
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + ((DoubleDCT_3D)DoubleDCT_3D.this).n1 + n10] = dArray[n15 + 1];
                                }
                                DoubleDCT_3D.this.dctn1.inverse(DoubleDCT_3D.this.t, n6, bl);
                                DoubleDCT_3D.this.dctn1.inverse(DoubleDCT_3D.this.t, n6 + DoubleDCT_3D.this.n1, bl);
                                for (n10 = 0; n10 < DoubleDCT_3D.this.n1; ++n10) {
                                    n15 = n10 * DoubleDCT_3D.this.sliceStride + n11;
                                    dArray[n15] = DoubleDCT_3D.this.t[n6 + n10];
                                    dArray[n15 + 1] = DoubleDCT_3D.this.t[n6 + DoubleDCT_3D.this.n1 + n10];
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            for (n2 = 0; n2 < n3; ++n2) {
                futureArray[n2].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void ddxt3db_subth(final int n, final double[][][] dArray, final boolean bl) {
        int n2;
        int n3 = ConcurrencyUtils.getNumberOfProcessors();
        final int n4 = n3 > this.n2 ? this.n2 : n3;
        int n5 = 4 * this.n1;
        if (this.n3 == 2) {
            n5 >>= 1;
        }
        Future[] futureArray = new Future[n4];
        for (int i = 0; i < n4; ++i) {
            n2 = i;
            final int n6 = n5 * i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    block19: {
                        block17: {
                            block18: {
                                if (n != -1) break block17;
                                if (DoubleDCT_3D.this.n3 <= 2) break block18;
                                for (int i = n2; i < DoubleDCT_3D.this.n2; i += n4) {
                                    for (int j = 0; j < DoubleDCT_3D.this.n3; j += 4) {
                                        int n5;
                                        int n22;
                                        for (n22 = 0; n22 < DoubleDCT_3D.this.n1; ++n22) {
                                            n5 = n6 + DoubleDCT_3D.this.n1 + n22;
                                            ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + n22] = dArray[n22][i][j];
                                            ((DoubleDCT_3D)DoubleDCT_3D.this).t[n5] = dArray[n22][i][j + 1];
                                            ((DoubleDCT_3D)DoubleDCT_3D.this).t[n5 + ((DoubleDCT_3D)DoubleDCT_3D.this).n1] = dArray[n22][i][j + 2];
                                            ((DoubleDCT_3D)DoubleDCT_3D.this).t[n5 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).n1] = dArray[n22][i][j + 3];
                                        }
                                        DoubleDCT_3D.this.dctn1.forward(DoubleDCT_3D.this.t, n6, bl);
                                        DoubleDCT_3D.this.dctn1.forward(DoubleDCT_3D.this.t, n6 + DoubleDCT_3D.this.n1, bl);
                                        DoubleDCT_3D.this.dctn1.forward(DoubleDCT_3D.this.t, n6 + 2 * DoubleDCT_3D.this.n1, bl);
                                        DoubleDCT_3D.this.dctn1.forward(DoubleDCT_3D.this.t, n6 + 3 * DoubleDCT_3D.this.n1, bl);
                                        for (n22 = 0; n22 < DoubleDCT_3D.this.n1; ++n22) {
                                            n5 = n6 + DoubleDCT_3D.this.n1 + n22;
                                            dArray[n22][i][j] = DoubleDCT_3D.this.t[n6 + n22];
                                            dArray[n22][i][j + 1] = DoubleDCT_3D.this.t[n5];
                                            dArray[n22][i][j + 2] = DoubleDCT_3D.this.t[n5 + DoubleDCT_3D.this.n1];
                                            dArray[n22][i][j + 3] = DoubleDCT_3D.this.t[n5 + 2 * DoubleDCT_3D.this.n1];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (DoubleDCT_3D.this.n3 != 2) break block19;
                            for (int i = n2; i < DoubleDCT_3D.this.n2; i += n4) {
                                int n7;
                                for (n7 = 0; n7 < DoubleDCT_3D.this.n1; ++n7) {
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + n7] = dArray[n7][i][0];
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + ((DoubleDCT_3D)DoubleDCT_3D.this).n1 + n7] = dArray[n7][i][1];
                                }
                                DoubleDCT_3D.this.dctn1.forward(DoubleDCT_3D.this.t, n6, bl);
                                DoubleDCT_3D.this.dctn1.forward(DoubleDCT_3D.this.t, n6 + DoubleDCT_3D.this.n1, bl);
                                for (n7 = 0; n7 < DoubleDCT_3D.this.n1; ++n7) {
                                    dArray[n7][i][0] = DoubleDCT_3D.this.t[n6 + n7];
                                    dArray[n7][i][1] = DoubleDCT_3D.this.t[n6 + DoubleDCT_3D.this.n1 + n7];
                                }
                            }
                            break block19;
                        }
                        if (DoubleDCT_3D.this.n3 > 2) {
                            for (int i = n2; i < DoubleDCT_3D.this.n2; i += n4) {
                                for (int j = 0; j < DoubleDCT_3D.this.n3; j += 4) {
                                    int n8;
                                    int n3;
                                    for (n3 = 0; n3 < DoubleDCT_3D.this.n1; ++n3) {
                                        n8 = n6 + DoubleDCT_3D.this.n1 + n3;
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + n3] = dArray[n3][i][j];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n8] = dArray[n3][i][j + 1];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n8 + ((DoubleDCT_3D)DoubleDCT_3D.this).n1] = dArray[n3][i][j + 2];
                                        ((DoubleDCT_3D)DoubleDCT_3D.this).t[n8 + 2 * ((DoubleDCT_3D)DoubleDCT_3D.this).n1] = dArray[n3][i][j + 3];
                                    }
                                    DoubleDCT_3D.this.dctn1.inverse(DoubleDCT_3D.this.t, n6, bl);
                                    DoubleDCT_3D.this.dctn1.inverse(DoubleDCT_3D.this.t, n6 + DoubleDCT_3D.this.n1, bl);
                                    DoubleDCT_3D.this.dctn1.inverse(DoubleDCT_3D.this.t, n6 + 2 * DoubleDCT_3D.this.n1, bl);
                                    DoubleDCT_3D.this.dctn1.inverse(DoubleDCT_3D.this.t, n6 + 3 * DoubleDCT_3D.this.n1, bl);
                                    for (n3 = 0; n3 < DoubleDCT_3D.this.n1; ++n3) {
                                        n8 = n6 + DoubleDCT_3D.this.n1 + n3;
                                        dArray[n3][i][j] = DoubleDCT_3D.this.t[n6 + n3];
                                        dArray[n3][i][j + 1] = DoubleDCT_3D.this.t[n8];
                                        dArray[n3][i][j + 2] = DoubleDCT_3D.this.t[n8 + DoubleDCT_3D.this.n1];
                                        dArray[n3][i][j + 3] = DoubleDCT_3D.this.t[n8 + 2 * DoubleDCT_3D.this.n1];
                                    }
                                }
                            }
                        } else if (DoubleDCT_3D.this.n3 == 2) {
                            for (int i = n2; i < DoubleDCT_3D.this.n2; i += n4) {
                                int n9;
                                for (n9 = 0; n9 < DoubleDCT_3D.this.n1; ++n9) {
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + n9] = dArray[n9][i][0];
                                    ((DoubleDCT_3D)DoubleDCT_3D.this).t[n6 + ((DoubleDCT_3D)DoubleDCT_3D.this).n1 + n9] = dArray[n9][i][1];
                                }
                                DoubleDCT_3D.this.dctn1.inverse(DoubleDCT_3D.this.t, n6, bl);
                                DoubleDCT_3D.this.dctn1.inverse(DoubleDCT_3D.this.t, n6 + DoubleDCT_3D.this.n1, bl);
                                for (n9 = 0; n9 < DoubleDCT_3D.this.n1; ++n9) {
                                    dArray[n9][i][0] = DoubleDCT_3D.this.t[n6 + n9];
                                    dArray[n9][i][1] = DoubleDCT_3D.this.t[n6 + DoubleDCT_3D.this.n1 + n9];
                                }
                            }
                        }
                    }
                }
            });
        }
        try {
            for (n2 = 0; n2 < n4; ++n2) {
                futureArray[n2].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void makewt(int n) {
        this.ip[0] = n;
        this.ip[1] = 1;
        if (n > 2) {
            int n2;
            int n3 = n >> 1;
            double d = Math.atan(1.0) / (double)n3;
            double d2 = Math.cos(d * (double)n3);
            this.w[0] = 1.0;
            this.w[1] = d2;
            if (n3 == 4) {
                this.w[2] = Math.cos(d * 2.0);
                this.w[3] = Math.sin(d * 2.0);
            } else if (n3 > 4) {
                this.makeipt(n);
                this.w[2] = 0.5 / Math.cos(d * 2.0);
                this.w[3] = 0.5 / Math.cos(d * 6.0);
                for (n2 = 4; n2 < n3; n2 += 4) {
                    this.w[n2] = Math.cos(d * (double)n2);
                    this.w[n2 + 1] = Math.sin(d * (double)n2);
                    this.w[n2 + 2] = Math.cos(3.0 * d * (double)n2);
                    this.w[n2 + 3] = -Math.sin(3.0 * d * (double)n2);
                }
            }
            int n4 = 0;
            while (n3 > 2) {
                double d3;
                double d4;
                int n5 = n4 + n3;
                this.w[n5] = 1.0;
                this.w[n5 + 1] = d2;
                if ((n3 >>= 1) == 4) {
                    d4 = this.w[n4 + 4];
                    d3 = this.w[n4 + 5];
                    this.w[n5 + 2] = d4;
                    this.w[n5 + 3] = d3;
                } else if (n3 > 4) {
                    d4 = this.w[n4 + 4];
                    double d5 = this.w[n4 + 6];
                    this.w[n5 + 2] = 0.5 / d4;
                    this.w[n5 + 3] = 0.5 / d5;
                    for (n2 = 4; n2 < n3; n2 += 4) {
                        int n6 = n4 + 2 * n2;
                        int n7 = n5 + n2;
                        d4 = this.w[n6];
                        d3 = this.w[n6 + 1];
                        d5 = this.w[n6 + 2];
                        double d6 = this.w[n6 + 3];
                        this.w[n7] = d4;
                        this.w[n7 + 1] = d3;
                        this.w[n7 + 2] = d5;
                        this.w[n7 + 3] = d6;
                    }
                }
                n4 = n5;
            }
        }
    }

    private void makeipt(int n) {
        this.ip[2] = 0;
        this.ip[3] = 16;
        int n2 = 2;
        for (int i = n; i > 32; i >>= 2) {
            int n3 = n2 << 1;
            int n4 = n3 << 3;
            for (int j = n2; j < n3; ++j) {
                int n5;
                this.ip[n2 + j] = n5 = this.ip[j] << 2;
                this.ip[n3 + j] = n5 + n4;
            }
            n2 = n3;
        }
    }

    private void makect(int n, double[] dArray, int n2) {
        this.ip[1] = n;
        if (n > 1) {
            int n3 = n >> 1;
            double d = Math.atan(1.0) / (double)n3;
            dArray[n2] = Math.cos(d * (double)n3);
            dArray[n2 + n3] = 0.5 * dArray[n2];
            for (int i = 1; i < n3; ++i) {
                dArray[n2 + i] = 0.5 * Math.cos(d * (double)i);
                dArray[n2 + n - i] = 0.5 * Math.sin(d * (double)i);
            }
        }
    }
}

