/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_3D;
import edu.emory.mathcs.utils.IOUtils;

public class AccuracyCheckDoubleFFT {
    private AccuracyCheckDoubleFFT() {
    }

    public static void checkAccuracyComplexFFT_1D(int n, int n2) {
        System.out.println("Checking accuracy of 1D complex FFT...");
        for (int i = 0; i < n2; ++i) {
            int n3 = n + i;
            int n4 = (int)Math.pow(2.0, n3);
            DoubleFFT_1D doubleFFT_1D = new DoubleFFT_1D(n4);
            double d = 0.0;
            double[] dArray = new double[2 * n4];
            IOUtils.fillMatrix_1D(2 * n4, dArray);
            double[] dArray2 = new double[2 * n4];
            IOUtils.fillMatrix_1D(2 * n4, dArray2);
            doubleFFT_1D.complexForward(dArray);
            doubleFFT_1D.complexInverse(dArray, true);
            for (int j = 0; j < 2 * n4; ++j) {
                double d2 = Math.abs(dArray2[j] - dArray[j]);
                d = Math.max(d, d2);
            }
            if (d > 1.0E-10) {
                System.err.println("\tsize = 2^" + n3 + ";\terror = " + d);
            } else {
                System.out.println("\tsize = 2^" + n3 + ";\terror = " + d);
            }
            dArray = null;
            dArray2 = null;
            doubleFFT_1D = null;
            System.gc();
        }
    }

    public static void checkAccuracyComplexFFT_2D(int n, int n2) {
        double d;
        int n3;
        Object object;
        Object object2;
        double d2;
        DoubleFFT_2D doubleFFT_2D;
        int n4;
        int n5;
        int n6;
        System.out.println("Checking accuracy of 2D complex FFT (double[] input)...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            doubleFFT_2D = new DoubleFFT_2D(n4, n4);
            d2 = 0.0;
            object2 = new double[2 * n4 * n4];
            IOUtils.fillMatrix_2D(n4, 2 * n4, object2);
            object = new double[2 * n4 * n4];
            IOUtils.fillMatrix_2D(n4, 2 * n4, object);
            doubleFFT_2D.complexForward((double[])object2);
            doubleFFT_2D.complexInverse((double[])object2, true);
            for (n3 = 0; n3 < 2 * n4 * n4; ++n3) {
                d = Math.abs(object[n3] - object2[n3]);
                d2 = Math.max(d2, d);
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n5 + " x 2^" + n5 + ";\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n5 + " x 2^" + n5 + ";\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D complex FFT (double[][] input)...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            doubleFFT_2D = new DoubleFFT_2D(n4, n4);
            d2 = 0.0;
            object2 = new double[n4][2 * n4];
            IOUtils.fillMatrix_2D(n4, 2 * n4, (double[][])object2);
            object = new double[n4][2 * n4];
            IOUtils.fillMatrix_2D(n4, 2 * n4, (double[][])object);
            doubleFFT_2D.complexForward((double[][])object2);
            doubleFFT_2D.complexInverse((double[][])object2, true);
            for (n3 = 0; n3 < n4; ++n3) {
                for (int i = 0; i < 2 * n4; ++i) {
                    d = Math.abs((double)(object[n3][i] - object2[n3][i]));
                    d2 = Math.max(d2, d);
                }
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n5 + " x 2^" + n5 + ";\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n5 + " x 2^" + n5 + ";\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleFFT_2D = null;
            System.gc();
        }
    }

    public static void checkAccuracyComplexFFT_3D(int n, int n2) {
        double d;
        int n3;
        Object object;
        Object object2;
        double d2;
        DoubleFFT_3D doubleFFT_3D;
        int n4;
        int n5;
        int n6;
        System.out.println("Checking accuracy of 3D complex FFT (double[] input)...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            doubleFFT_3D = new DoubleFFT_3D(n4, n4, n4);
            d2 = 0.0;
            object2 = new double[2 * n4 * n4 * n4];
            IOUtils.fillMatrix_3D(n4, n4, 2 * n4, object2);
            object = new double[2 * n4 * n4 * n4];
            IOUtils.fillMatrix_3D(n4, n4, 2 * n4, object);
            doubleFFT_3D.complexForward((double[])object2);
            doubleFFT_3D.complexInverse((double[])object2, true);
            for (n3 = 0; n3 < 2 * n4 * n4 * n4; ++n3) {
                d = Math.abs(object[n3] - object2[n3]);
                d2 = Math.max(d2, d);
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n5 + " x 2^" + n5 + " x 2^" + n5 + ";\t\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n5 + " x 2^" + n5 + " x 2^" + n5 + ";\t\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D complex FFT (double[][][] input)...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            doubleFFT_3D = new DoubleFFT_3D(n4, n4, n4);
            d2 = 0.0;
            object2 = new double[n4][n4][2 * n4];
            IOUtils.fillMatrix_3D(n4, n4, 2 * n4, (double[][][])object2);
            object = new double[n4][n4][2 * n4];
            IOUtils.fillMatrix_3D(n4, n4, 2 * n4, (double[][][])object);
            doubleFFT_3D.complexForward((double[][][])object2);
            doubleFFT_3D.complexInverse((double[][][])object2, true);
            for (n3 = 0; n3 < n4; ++n3) {
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < 2 * n4; ++j) {
                        d = Math.abs((double)(object[n3][i][j] - object2[n3][i][j]));
                        d2 = Math.max(d2, d);
                    }
                }
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n5 + " x 2^" + n5 + " x 2^" + n5 + ";\t\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n5 + " x 2^" + n5 + " x 2^" + n5 + ";\t\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleFFT_3D = null;
            System.gc();
        }
    }

    public static void checkAccuracyRealFFT_1D(int n, int n2) {
        double d;
        int n3;
        double[] dArray;
        double[] dArray2;
        double d2;
        DoubleFFT_1D doubleFFT_1D;
        int n4;
        int n5;
        int n6;
        System.out.println("Checking accuracy of 1D real FFT...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            doubleFFT_1D = new DoubleFFT_1D(n4);
            d2 = 0.0;
            dArray2 = new double[n4];
            IOUtils.fillMatrix_1D(n4, dArray2);
            dArray = new double[n4];
            IOUtils.fillMatrix_1D(n4, dArray);
            doubleFFT_1D.realForward(dArray);
            doubleFFT_1D.realInverse(dArray, true);
            for (n3 = 0; n3 < n4; ++n3) {
                d = Math.abs(dArray[n3] - dArray2[n3]);
                d2 = Math.max(d2, d);
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n5 + ";\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n5 + ";\terror = " + d2);
            }
            dArray2 = null;
            dArray = null;
            doubleFFT_1D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of on 1D real forward full FFT...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            doubleFFT_1D = new DoubleFFT_1D(n4);
            d2 = 0.0;
            dArray2 = new double[2 * n4];
            IOUtils.fillMatrix_1D(n4, dArray2);
            dArray = new double[2 * n4];
            IOUtils.fillMatrix_1D(n4, dArray);
            doubleFFT_1D.realForwardFull(dArray);
            doubleFFT_1D.complexInverse(dArray, true);
            for (n3 = 0; n3 < n4; ++n3) {
                d = Math.abs(dArray[2 * n3] - dArray2[n3]);
                d2 = Math.max(d2, d);
                d = Math.abs(dArray[2 * n3 + 1]);
                d2 = Math.max(d2, d);
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n5 + ";\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n5 + ";\terror = " + d2);
            }
            dArray2 = null;
            dArray = null;
            doubleFFT_1D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 1D real inverse full FFT...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            doubleFFT_1D = new DoubleFFT_1D(n4);
            d2 = 0.0;
            dArray2 = new double[2 * n4];
            IOUtils.fillMatrix_1D(n4, dArray2);
            dArray = new double[2 * n4];
            IOUtils.fillMatrix_1D(n4, dArray);
            doubleFFT_1D.realInverseFull(dArray, true);
            doubleFFT_1D.complexForward(dArray);
            for (n3 = 0; n3 < n4; ++n3) {
                d = Math.abs(dArray[2 * n3] - dArray2[n3]);
                d2 = Math.max(d2, d);
                d = Math.abs(dArray[2 * n3 + 1]);
                d2 = Math.max(d2, d);
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n5 + ";\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n5 + ";\terror = " + d2);
            }
            dArray2 = null;
            dArray = null;
            doubleFFT_1D = null;
            System.gc();
        }
    }

    public static void checkAccuracyRealFFT_2D(int n, int n2) {
        int n3;
        double d;
        int n4;
        Object object;
        Object object2;
        double d2;
        DoubleFFT_2D doubleFFT_2D;
        int n5;
        int n6;
        int n7;
        System.out.println("Checking accuracy of 2D real FFT (double[] input)...");
        for (n7 = 0; n7 < n2; ++n7) {
            n6 = n + n7;
            n5 = (int)Math.pow(2.0, n6);
            doubleFFT_2D = new DoubleFFT_2D(n5, n5);
            d2 = 0.0;
            object2 = new double[n5 * n5];
            IOUtils.fillMatrix_2D(n5, n5, object2);
            object = new double[n5 * n5];
            IOUtils.fillMatrix_2D(n5, n5, object);
            doubleFFT_2D.realForward((double[])object);
            doubleFFT_2D.realInverse((double[])object, true);
            for (n4 = 0; n4 < n5 * n5; ++n4) {
                d = Math.abs(object[n4] - object2[n4]);
                d2 = Math.max(d2, d);
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D real FFT (double[][] input)...");
        for (n7 = 0; n7 < n2; ++n7) {
            n6 = n + n7;
            n5 = (int)Math.pow(2.0, n6);
            doubleFFT_2D = new DoubleFFT_2D(n5, n5);
            d2 = 0.0;
            object2 = new double[n5][n5];
            IOUtils.fillMatrix_2D(n5, n5, (double[][])object2);
            object = new double[n5][n5];
            IOUtils.fillMatrix_2D(n5, n5, (double[][])object);
            doubleFFT_2D.realForward((double[][])object);
            doubleFFT_2D.realInverse((double[][])object, true);
            for (n4 = 0; n4 < n5; ++n4) {
                for (n3 = 0; n3 < n5; ++n3) {
                    d = Math.abs((double)(object[n4][n3] - object2[n4][n3]));
                    d2 = Math.max(d2, d);
                }
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D real forward full FFT (double[] input)...");
        for (n7 = 0; n7 < n2; ++n7) {
            n6 = n + n7;
            n5 = (int)Math.pow(2.0, n6);
            doubleFFT_2D = new DoubleFFT_2D(n5, n5);
            d2 = 0.0;
            object2 = new double[2 * n5 * n5];
            IOUtils.fillMatrix_2D(n5, n5, object2);
            object = new double[2 * n5 * n5];
            IOUtils.fillMatrix_2D(n5, n5, object);
            doubleFFT_2D.realForwardFull((double[])object);
            doubleFFT_2D.complexInverse((double[])object, true);
            for (n4 = 0; n4 < n5 * n5; ++n4) {
                d = Math.abs(object[2 * n4] - object2[n4]);
                d2 = Math.max(d2, d);
                d = Math.abs(object[2 * n4 + 1]);
                d2 = Math.max(d2, d);
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D real forward full FFT (double[][] input)...");
        for (n7 = 0; n7 < n2; ++n7) {
            n6 = n + n7;
            n5 = (int)Math.pow(2.0, n6);
            doubleFFT_2D = new DoubleFFT_2D(n5, n5);
            d2 = 0.0;
            object2 = new double[n5][n5];
            IOUtils.fillMatrix_2D(n5, n5, (double[][])object2);
            object = new double[n5][2 * n5];
            IOUtils.fillMatrix_2D(n5, n5, (double[][])object);
            doubleFFT_2D.realForwardFull((double[][])object);
            doubleFFT_2D.complexInverse((double[][])object, true);
            for (n4 = 0; n4 < n5; ++n4) {
                for (n3 = 0; n3 < n5; ++n3) {
                    d = Math.abs((double)(object[n4][2 * n3] - object2[n4][n3]));
                    d2 = Math.max(d2, d);
                    d = Math.abs((double)object[n4][2 * n3 + 1]);
                    d2 = Math.max(d2, d);
                }
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D real inverse full FFT (double[] input)...");
        for (n7 = 0; n7 < n2; ++n7) {
            n6 = n + n7;
            n5 = (int)Math.pow(2.0, n6);
            doubleFFT_2D = new DoubleFFT_2D(n5, n5);
            d2 = 0.0;
            object2 = new double[2 * n5 * n5];
            IOUtils.fillMatrix_2D(n5, n5, object2);
            object = new double[2 * n5 * n5];
            IOUtils.fillMatrix_2D(n5, n5, object);
            doubleFFT_2D.realInverseFull((double[])object, true);
            doubleFFT_2D.complexForward((double[])object);
            for (n4 = 0; n4 < n5 * n5; ++n4) {
                d = Math.abs(object[2 * n4] - object2[n4]);
                d2 = Math.max(d2, d);
                d = Math.abs(object[2 * n4 + 1]);
                d2 = Math.max(d2, d);
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleFFT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D real inverse full FFT (double[][] input)...");
        for (n7 = 0; n7 < n2; ++n7) {
            n6 = n + n7;
            n5 = (int)Math.pow(2.0, n6);
            doubleFFT_2D = new DoubleFFT_2D(n5, n5);
            d2 = 0.0;
            object2 = new double[n5][n5];
            IOUtils.fillMatrix_2D(n5, n5, (double[][])object2);
            object = new double[n5][2 * n5];
            IOUtils.fillMatrix_2D(n5, n5, (double[][])object);
            doubleFFT_2D.realInverseFull((double[][])object, true);
            doubleFFT_2D.complexForward((double[][])object);
            for (n4 = 0; n4 < n5; ++n4) {
                for (n3 = 0; n3 < n5; ++n3) {
                    d = Math.abs((double)(object[n4][2 * n3] - object2[n4][n3]));
                    d2 = Math.max(d2, d);
                    d = Math.abs((double)object[n4][2 * n3 + 1]);
                    d2 = Math.max(d2, d);
                }
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n6 + " x 2^" + n6 + ";\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleFFT_2D = null;
            System.gc();
        }
    }

    public static void checkAccuracyRealFFT_3D(int n, int n2) {
        int n3;
        int n4;
        double d;
        int n5;
        Object object;
        Object object2;
        double d2;
        DoubleFFT_3D doubleFFT_3D;
        int n6;
        int n7;
        int n8;
        System.out.println("Checking accuracy of 3D real FFT (double[] input)...");
        for (n8 = 0; n8 < n2; ++n8) {
            n7 = n + n8;
            n6 = (int)Math.pow(2.0, n7);
            doubleFFT_3D = new DoubleFFT_3D(n6, n6, n6);
            d2 = 0.0;
            object2 = new double[n6 * n6 * n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, object2);
            object = new double[n6 * n6 * n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, object);
            doubleFFT_3D.realForward((double[])object);
            doubleFFT_3D.realInverse((double[])object, true);
            for (n5 = 0; n5 < n6 * n6 * n6; ++n5) {
                d = Math.abs(object[n5] - object2[n5]);
                d2 = Math.max(d2, d);
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D real FFT (double[][][] input)...");
        for (n8 = 0; n8 < n2; ++n8) {
            n7 = n + n8;
            n6 = (int)Math.pow(2.0, n7);
            doubleFFT_3D = new DoubleFFT_3D(n6, n6, n6);
            d2 = 0.0;
            object2 = new double[n6][n6][n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, (double[][][])object2);
            object = new double[n6][n6][n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, (double[][][])object);
            doubleFFT_3D.realForward((double[][][])object);
            doubleFFT_3D.realInverse((double[][][])object, true);
            for (n5 = 0; n5 < n6; ++n5) {
                for (n4 = 0; n4 < n6; ++n4) {
                    for (n3 = 0; n3 < n6; ++n3) {
                        d = Math.abs((double)(object[n5][n4][n3] - object2[n5][n4][n3]));
                        d2 = Math.max(d2, d);
                    }
                }
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D real forward full FFT (double[] input)...");
        for (n8 = 0; n8 < n2; ++n8) {
            n7 = n + n8;
            n6 = (int)Math.pow(2.0, n7);
            doubleFFT_3D = new DoubleFFT_3D(n6, n6, n6);
            d2 = 0.0;
            object2 = new double[2 * n6 * n6 * n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, object2);
            object = new double[2 * n6 * n6 * n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, object);
            doubleFFT_3D.realForwardFull((double[])object);
            doubleFFT_3D.complexInverse((double[])object, true);
            for (n5 = 0; n5 < n6 * n6 * n6; ++n5) {
                d = Math.abs(object[2 * n5] - object2[n5]);
                d2 = Math.max(d2, d);
                d = Math.abs(object[2 * n5 + 1]);
                d2 = Math.max(d2, d);
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D real forward full FFT (double[][][] input)...");
        for (n8 = 0; n8 < n2; ++n8) {
            n7 = n + n8;
            n6 = (int)Math.pow(2.0, n7);
            doubleFFT_3D = new DoubleFFT_3D(n6, n6, n6);
            d2 = 0.0;
            object2 = new double[n6][n6][2 * n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, (double[][][])object2);
            object = new double[n6][n6][2 * n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, (double[][][])object);
            doubleFFT_3D.realForwardFull((double[][][])object);
            doubleFFT_3D.complexInverse((double[][][])object, true);
            for (n5 = 0; n5 < n6; ++n5) {
                for (n4 = 0; n4 < n6; ++n4) {
                    for (n3 = 0; n3 < n6; ++n3) {
                        d = Math.abs((double)(object[n5][n4][2 * n3] - object2[n5][n4][n3]));
                        d2 = Math.max(d2, d);
                        d = Math.abs((double)object[n5][n4][2 * n3 + 1]);
                        d2 = Math.max(d2, d);
                    }
                }
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D real inverse full FFT (double[] input)...");
        for (n8 = 0; n8 < n2; ++n8) {
            n7 = n + n8;
            n6 = (int)Math.pow(2.0, n7);
            doubleFFT_3D = new DoubleFFT_3D(n6, n6, n6);
            d2 = 0.0;
            object2 = new double[2 * n6 * n6 * n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, object2);
            object = new double[2 * n6 * n6 * n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, object);
            doubleFFT_3D.realInverseFull((double[])object, true);
            doubleFFT_3D.complexForward((double[])object);
            for (n5 = 0; n5 < n6 * n6 * n6; ++n5) {
                d = Math.abs(object[2 * n5] - object2[n5]);
                d2 = Math.max(d2, d);
                d = Math.abs(object[2 * n5 + 1]);
                d2 = Math.max(d2, d);
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleFFT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D real inverse full FFT (double[][][] input)...");
        for (n8 = 0; n8 < n2; ++n8) {
            n7 = n + n8;
            n6 = (int)Math.pow(2.0, n7);
            doubleFFT_3D = new DoubleFFT_3D(n6, n6, n6);
            d2 = 0.0;
            object2 = new double[n6][n6][2 * n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, (double[][][])object2);
            object = new double[n6][n6][2 * n6];
            IOUtils.fillMatrix_3D(n6, n6, n6, (double[][][])object);
            doubleFFT_3D.realInverseFull((double[][][])object, true);
            doubleFFT_3D.complexForward((double[][][])object);
            for (n5 = 0; n5 < n6; ++n5) {
                for (n4 = 0; n4 < n6; ++n4) {
                    for (n3 = 0; n3 < n6; ++n3) {
                        d = Math.abs((double)(object[n5][n4][2 * n3] - object2[n5][n4][n3]));
                        d2 = Math.max(d2, d);
                        d = Math.abs((double)object[n5][n4][2 * n3 + 1]);
                        d2 = Math.max(d2, d);
                    }
                }
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n7 + " x 2^" + n7 + " x 2^" + n7 + ";\t\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleFFT_3D = null;
            System.gc();
        }
    }

    public static void main(String[] stringArray) {
        AccuracyCheckDoubleFFT.checkAccuracyComplexFFT_1D(0, 21);
        AccuracyCheckDoubleFFT.checkAccuracyRealFFT_1D(0, 21);
        AccuracyCheckDoubleFFT.checkAccuracyComplexFFT_2D(1, 11);
        AccuracyCheckDoubleFFT.checkAccuracyRealFFT_2D(1, 11);
        AccuracyCheckDoubleFFT.checkAccuracyComplexFFT_3D(1, 7);
        AccuracyCheckDoubleFFT.checkAccuracyRealFFT_3D(1, 7);
        System.exit(0);
    }
}

