#
# SPL - The SPL Programming Language
# Copyright (C) 2004, 2005  Clifford Wolf <clifford@clifford.at>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ac-spl.m4: The SPL autoconf (aclocal) module
#

AC_DEFUN([SPL_CHECK],
[
	AC_ARG_WITH(spl, AS_HELP_STRING([--with-spl=DIR], [prefix of the SPL installation]), spl_prefix="$withval", spl_prefix="")

	AC_MSG_CHECKING(for spl-config)

	spl_config_bin="spl-config"
	if test "x$spl_prefix" != "x"; then
		spl_config_bin="$spl_prefix/bin/$spl_config_bin"
	fi 

	if $spl_config_bin --cflags > /dev/null 2> /dev/null
	then
		AC_MSG_RESULT(yes)

		AC_MSG_CHECKING(for spl cflags)
		SPL_CFLAGS="$( $spl_config_bin --cflags )"
		AC_MSG_RESULT($SPL_CFLAGS)

		AC_MSG_CHECKING(for spl ldflags)
		SPL_LDFLAGS="$( $spl_config_bin --ldflags )"
		AC_MSG_RESULT($SPL_LDFLAGS)

		AC_MSG_CHECKING(for spl ldlibs)
		SPL_LDLIBS="$( $spl_config_bin --ldlibs )"
		AC_MSG_RESULT($SPL_LDLIBS)

		ifelse([$1], , :, [$1])
	else
		AC_MSG_RESULT([no (can not execute $spl_config_bin)])
		SPL_CFLAGS=""; SPL_LDFLAGS=""; SPL_LDLIBS=""
		ifelse([$2], , :, [$2])
	fi

	AC_SUBST(SPL_CFLAGS)
	AC_SUBST(SPL_LDFLAGS)
	AC_SUBST(SPL_LDLIBS)
])

