/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.shapes;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import net.sourceforge.napkinlaf.shapes.AbstractDrawnGenerator;
import net.sourceforge.napkinlaf.util.RandomValue;

public class DrawnScribbleGenerator
extends AbstractDrawnGenerator {
    private final RandomValue position;
    private final RandomValue side;
    private final float[] point;
    private final float minShow;
    private int shown;
    private double range;
    private double swingRange;
    private float midRange;
    private GeneralPath shape;
    private int orientation;
    private boolean done;
    private double max;
    private static final float PER_STROKE = 1.8f;
    private static final double HEIGHT_ADJUST = 0.85;

    DrawnScribbleGenerator(float minShow) {
        this.minShow = minShow;
        this.position = new RandomValue(0.0, 0.4);
        this.side = new RandomValue(0.0, 0.4);
        this.point = new float[2];
    }

    public Shape generate(AffineTransform matrix) {
        boolean first;
        boolean bl = first = this.shape == null;
        if (first) {
            this.shape = new GeneralPath();
            this.done = false;
            this.position.setMid(0.0);
            this.setSideRange();
            if (this.orientation == 0) {
                this.convert(matrix, 0.0f, (float)this.side.getMid());
            } else {
                this.convert(matrix, (float)this.side.getMid(), 0.0f);
            }
            this.shape.moveTo(this.convertedX(), this.convertedY());
        }
        if ((float)this.shown > this.minShow && !this.done) {
            if (first) {
                this.line(matrix);
            }
            double pos = this.position.get();
            while (pos <= (double)this.shown) {
                this.position.setMid(pos + (double)1.8f);
                this.line(matrix);
                pos = this.position.get();
            }
            if (this.position.getMid() + (double)1.8f >= this.max) {
                this.position.setMid(this.max);
                this.line(matrix);
                this.line(matrix);
                this.done = true;
            }
        }
        return this.shape;
    }

    private void line(AffineTransform matrix) {
        double y;
        double x;
        this.setSideRange();
        if (this.orientation == 0) {
            x = this.position.generate();
            y = this.side.generate();
        } else {
            y = this.position.generate();
            x = this.side.generate();
        }
        this.convert(matrix, (float)x, (float)y);
        this.shape.lineTo(this.convertedX(), this.convertedY());
    }

    private void setSideRange() {
        this.side.setMid(this.side.getMid() < (double)this.midRange ? (double)this.midRange + this.swingRange : (double)this.midRange - this.swingRange);
    }

    private void convert(AffineTransform matrix, float x, float y) {
        this.point[0] = x;
        this.point[1] = y;
        matrix.transform(this.point, 0, this.point, 0, 1);
    }

    private float convertedX() {
        return this.point[0];
    }

    private float convertedY() {
        return this.point[1];
    }

    public void setShown(int shown) {
        if (shown < this.shown) {
            this.shape = null;
        }
        this.shown = shown;
    }

    public void setRange(double range) {
        if (this.range != range) {
            this.range = range;
            this.midRange = (float)(this.range / 2.0);
            this.swingRange = range * 0.85 / 2.0;
            this.shape = null;
        }
    }

    public void setOrientation(int orientation) {
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.shape = null;
        }
    }

    public void setMax(double max) {
        if (this.max != max) {
            this.max = max;
            this.shape = null;
        }
    }
}

