/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.app;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.fife.ui.SplashScreen;
import org.fife.ui.app.AbstractGUIApplication;
import org.fife.ui.app.GUIApplicationPreferences;
import org.fife.ui.app.GUIPlugin;
import org.fife.ui.app.Plugin;
import org.fife.ui.app.PluginLoader;
import org.fife.ui.app.StatusBarPlugin;
import org.fife.ui.dockablewindows.DockableWindow;
import org.fife.ui.dockablewindows.DockableWindowPanel;

public abstract class AbstractPluggableGUIApplication
extends AbstractGUIApplication {
    private List pluginList;
    private PluginLoader pluginLoader;

    public AbstractPluggableGUIApplication(String jarFile) {
        super(jarFile);
    }

    public AbstractPluggableGUIApplication(String title, String jarFile) {
        super(title, jarFile);
    }

    public AbstractPluggableGUIApplication(String title, String jarFile, GUIApplicationPreferences prefs) {
        super(title, jarFile, prefs);
    }

    public final void addPlugin(Plugin plugin) {
        if (this.pluginList == null) {
            this.pluginList = new ArrayList(1);
        }
        this.pluginList.add(plugin);
        if (plugin instanceof GUIPlugin) {
            GUIPlugin gp = (GUIPlugin)plugin;
            ((MainContentPanel)this.mainContentPanel).addPlugin(gp);
        } else if (plugin instanceof StatusBarPlugin) {
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.weightx = 0.0;
            this.getStatusBar().addStatusBarComponent((StatusBarPlugin)plugin, 0, c);
        }
        plugin.install(this);
        this.handleInstallPlugin(plugin);
    }

    JPanel createMainContentPanel(JPanel actualContentPane) {
        MainContentPanel mcp = new MainContentPanel();
        mcp.setContentPanel(actualContentPane);
        return mcp;
    }

    public Plugin[] getPlugins() {
        int count = this.pluginList == null ? 0 : this.pluginList.size();
        Plugin[] plugins = new Plugin[count];
        if (count > 0) {
            plugins = this.pluginList.toArray(plugins);
        }
        return plugins;
    }

    public int getSplitPaneDividerLocation(int splitPane) {
        int dividerLocation = 0;
        switch (splitPane) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                dividerLocation = ((MainContentPanel)this.mainContentPanel).getDividerLocation(splitPane);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad splitPane value");
            }
        }
        return dividerLocation;
    }

    protected void handleInstallPlugin(Plugin plugin) {
    }

    public boolean isPluginLoadingComplete() {
        return this.pluginLoader != null && this.pluginLoader.isPluginLoadingComplete();
    }

    private void loadPlugins() {
        new Thread(){

            public void run() {
                try {
                    AbstractPluggableGUIApplication.this.pluginLoader = new PluginLoader(AbstractPluggableGUIApplication.this);
                    AbstractPluggableGUIApplication.this.pluginLoader.loadPlugins();
                }
                catch (IOException ioe) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            AbstractPluggableGUIApplication.this.displayException(ioe);
                        }
                    });
                }
            }
        }.start();
    }

    protected void preDisplayInit(GUIApplicationPreferences prefs, SplashScreen splashScreen) {
        this.loadPlugins();
    }

    public boolean removePlugin(Plugin plugin) {
        this.pluginList.remove(plugin);
        if (plugin instanceof GUIPlugin) {
            GUIPlugin gp = (GUIPlugin)plugin;
            return ((MainContentPanel)this.mainContentPanel).removePlugin(gp);
        }
        throw new IllegalArgumentException("Only GUIPlugins are currently supported");
    }

    public void setContentPane(Container contentPane) {
        if (contentPane != null && !contentPane.equals(this.actualContentPane)) {
            MainContentPanel mcp = (MainContentPanel)this.mainContentPanel;
            if (this.actualContentPane != null) {
                mcp.removeContentPanel(this.actualContentPane);
            }
            mcp.setContentPanel(contentPane);
        }
    }

    public void setSplitPaneDividerLocation(int splitPane, int pos) {
        MainContentPanel mcp = (MainContentPanel)this.mainContentPanel;
        mcp.setDividerLocation(splitPane, pos);
    }

    private static final class MainContentPanel
    extends DockableWindowPanel {
        private MainContentPanel() {
        }

        public boolean addPlugin(GUIPlugin plugin) {
            boolean success = true;
            Iterator i = plugin.dockableWindowIterator();
            while (i.hasNext()) {
                DockableWindow wind = (DockableWindow)i.next();
                if (this.addDockableWindow(wind)) continue;
                success = false;
            }
            return success;
        }

        public boolean removePlugin(GUIPlugin plugin) {
            boolean success = true;
            Iterator i = plugin.dockableWindowIterator();
            while (i.hasNext()) {
                DockableWindow wind = (DockableWindow)i.next();
                if (this.removeDockableWindow(wind)) continue;
                success = false;
            }
            return success;
        }
    }
}

