/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.fife.ui.rtextfilechooser.FileChooserViewRendererFactory;
import org.fife.ui.rtextfilechooser.FileChooserViewTransferHandler;
import org.fife.ui.rtextfilechooser.MouseListener;
import org.fife.ui.rtextfilechooser.RTextFileChooser;
import org.fife.ui.rtextfilechooser.RTextFileChooserView;
import org.fife.ui.rtextfilechooser.SelectionListener;

class ListView
extends JList
implements RTextFileChooserView {
    private RTextFileChooser chooser;
    private MouseListener mouseListener;
    private SelectionListener selectionListener;

    public ListView(RTextFileChooser chooser) {
        super(new DefaultListModel());
        this.chooser = chooser;
        ListCellRenderer cellRenderer = FileChooserViewRendererFactory.createListViewRenderer(chooser);
        this.setCellRenderer(cellRenderer);
        this.setLayoutOrientation(1);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ListView.this.setVisibleRowCount(-1);
            }
        });
        this.setTransferHandler(new FileChooserViewTransferHandler(this));
        this.setDragEnabled(true);
        this.addKeyListener(new ViewKeyListener());
        this.mouseListener = new MouseListener(chooser);
        this.addMouseListener(this.mouseListener);
        this.selectionListener = new SelectionListener(chooser);
        this.addListSelectionListener(this.selectionListener);
        this.fixInputMap();
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.applyComponentOrientation(orientation);
    }

    public void clearDisplayedFiles() {
        this.setModel(new DefaultListModel());
    }

    public void ensureFileIsVisible(File file) {
        DefaultListModel model = (DefaultListModel)this.getModel();
        int index = model.indexOf(file);
        if (index != -1) {
            this.ensureIndexIsVisible(index);
        }
    }

    private void fixInputMap() {
        InputMap im = this.getInputMap();
        im.put(KeyStroke.getKeyStroke("shift DELETE"), "none");
    }

    public Color getDefaultFileColor() {
        return this.getForeground();
    }

    public int getDisplayedFileCount() {
        return this.getModel().getSize();
    }

    public File getFileAtPoint(Point p) {
        int row = this.locationToIndex(p);
        return (File)this.getModel().getElementAt(row);
    }

    public File getSelectedFile() {
        return (File)this.getSelectedValue();
    }

    public File[] getSelectedFiles() {
        Object[] objArray = this.getSelectedValues();
        int length = objArray.length;
        File[] fileArray = new File[length];
        System.arraycopy(objArray, 0, fileArray, 0, length);
        return fileArray;
    }

    public String getToolTipText(MouseEvent e) {
        String tip = null;
        Point p = e.getPoint();
        int index = this.locationToIndex(p);
        if (index == -1) {
            return null;
        }
        Rectangle bounds = this.getCellBounds(index, index);
        if (bounds.contains(p)) {
            File file = (File)this.getModel().getElementAt(index);
            if (file == null || file.isDirectory()) {
                return null;
            }
            tip = this.chooser.getToolTipFor(file);
        }
        return tip;
    }

    public void removeAllListeners() {
        this.removeMouseListener(this.mouseListener);
        this.removeListSelectionListener(this.selectionListener);
    }

    public void selectFileAtPoint(Point p) {
        int row = this.locationToIndex(p);
        Rectangle bounds = this.getCellBounds(row, row);
        if (bounds.contains(p)) {
            this.setSelectedIndex(row);
            this.ensureIndexIsVisible(row);
        } else {
            this.clearSelection();
        }
    }

    public void setDisplayedFiles(Vector files) {
        DefaultListModel model = new DefaultListModel();
        for (int i = 0; i < files.size(); ++i) {
            model.addElement(files.get(i));
        }
        this.setModel(model);
    }

    public void setMultiSelectionEnabled(boolean enabled) {
        this.getSelectionModel().setSelectionMode(enabled ? 2 : 0);
    }

    public void setSelectedFiles(File[] files) {
        int num = files.length;
        if (num > 0) {
            ListModel model = this.getModel();
            int modelSize = model.getSize();
            block0: for (int i = 0; i < num; ++i) {
                File parentFile;
                File f1 = files[i];
                if (!f1.exists() || !(parentFile = f1.getParentFile()).equals(this.chooser.currentDirectory)) continue;
                for (int j = 0; j < modelSize; ++j) {
                    File f2 = (File)model.getElementAt(j);
                    if (!f1.equals(f2)) continue;
                    this.addSelectionInterval(j, j);
                    continue block0;
                }
            }
        }
    }

    private class ViewKeyListener
    extends KeyAdapter {
        private String typed;
        private long lastTime;

        private ViewKeyListener() {
        }

        private int getNextMatch(String text, int fromCell) {
            String fileName;
            Object value;
            int row;
            text = text.toUpperCase();
            ListModel model = ListView.this.getModel();
            for (row = fromCell; row < model.getSize(); ++row) {
                value = model.getElementAt(row);
                fileName = value instanceof File ? ((File)value).getName() : value.toString();
                if (!(fileName = fileName.toUpperCase()).startsWith(text)) continue;
                return row;
            }
            for (row = 0; row < fromCell; ++row) {
                value = model.getElementAt(row);
                fileName = value instanceof File ? ((File)value).getName() : value.toString();
                if (!(fileName = fileName.toUpperCase()).startsWith(text)) continue;
                return row;
            }
            return -1;
        }

        public void keyTyped(KeyEvent e) {
            int matchCell;
            if (ListView.this.getModel().getSize() == 0) {
                return;
            }
            long time = e.getWhen();
            this.typed = time < this.lastTime + 1000L ? (this.typed == null ? String.valueOf(e.getKeyChar()) : this.typed + e.getKeyChar()) : String.valueOf(e.getKeyChar());
            this.lastTime = time;
            int startCell = ListView.this.getLeadSelectionIndex();
            if (startCell == -1) {
                startCell = 0;
            }
            if ((matchCell = this.getNextMatch(this.typed, startCell)) != -1) {
                ListView.this.setSelectedIndex(matchCell);
                ListView.this.ensureFileIsVisible(ListView.this.getSelectedFile());
            }
        }
    }
}

