/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import org.fife.ui.FSATextField;
import org.fife.ui.MenuButton;
import org.fife.ui.RScrollPane;
import org.fife.ui.ResizableFrameContentPane;
import org.fife.ui.UIUtil;
import org.fife.ui.breadcrumbbar.BreadcrumbBar;
import org.fife.ui.rtextfilechooser.Actions;
import org.fife.ui.rtextfilechooser.DetailsView;
import org.fife.ui.rtextfilechooser.FileChooserIconManager;
import org.fife.ui.rtextfilechooser.FileChooserPreferences;
import org.fife.ui.rtextfilechooser.FileDisplayNames;
import org.fife.ui.rtextfilechooser.FileSelector;
import org.fife.ui.rtextfilechooser.FileTypeInfo;
import org.fife.ui.rtextfilechooser.IconsView;
import org.fife.ui.rtextfilechooser.ListView;
import org.fife.ui.rtextfilechooser.RTextFileChooserView;
import org.fife.ui.rtextfilechooser.RootManager;
import org.fife.ui.rtextfilechooser.Utilities;
import org.fife.ui.rtextfilechooser.WildcardFileFilter;
import org.fife.ui.rtextfilechooser.filters.AcceptAllFileFilter;

public class RTextFileChooser
extends ResizableFrameContentPane
implements ActionListener,
PropertyChangeListener,
FileSelector {
    public static final int LIST_MODE = 0;
    public static final int DETAILS_MODE = 1;
    public static final int ICONS_MODE = 3;
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    public static final int ERROR_OPTION = -1;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    public static final int STYLE_BOLD = 0;
    public static final int STYLE_ITALIC = 1;
    public static final int STYLE_UNDERLINE = 2;
    static final boolean IGNORE_CASE = Utilities.isCaseSensitiveFileSystem();
    private FileSystemView fileSystemView;
    private ItemListener itemListener;
    private AcceptAllFileFilter acceptAllFilter;
    private BreadcrumbBar lookInBreadcrumbBar;
    private FSATextField fileNameTextField;
    private JComboBox filterCombo;
    private JComboBox encodingCombo;
    private TextFieldListener textFieldListener;
    private JButton upOneLevelButton;
    private JButton newFolderButton;
    private MenuButton viewButton;
    private MenuButton favoritesButton;
    private JButton acceptButton;
    private JButton cancelButton;
    protected RTextFileChooserView view;
    private RScrollPane viewScrollPane;
    private JPopupMenu popupMenu;
    private WildcardFileFilter globFilter;
    private Icon upFolderIcon;
    private Icon newFolderIcon;
    private Icon detailsViewIcon;
    private Icon listViewIcon;
    private Icon iconsViewIcon;
    private Icon favoritesIcon;
    private FileChooserIconManager iconManager;
    private String customTitle;
    private String saveButtonText;
    private String saveDialogTitleText;
    private String saveButtonToolTipText;
    private int saveButtonMnemonic;
    private String openButtonText;
    private String openDialogTitleText;
    private String openButtonToolTipText;
    private int openButtonMnemonic;
    private String newFolderPrompt;
    private String errorNewDirPrompt;
    String errorDialogTitle;
    private String directoryText;
    private String fileText;
    private String nameString;
    private String sizeString;
    private String typeString;
    private String statusString;
    private String lastModifiedString;
    private String openString;
    private String noFavoritesDefinedString;
    private String favoriteDNERemoveString;
    private Actions.SystemOpenAction systemEditAction;
    private Actions.SystemOpenAction systemViewAction;
    private Actions.CopyAction copyAction;
    private Actions.DeleteAction deleteAction;
    private Actions.DeleteAction hardDeleteAction;
    private Actions.PasteAction pasteAction;
    private Actions.RefreshAction refreshAction;
    private Actions.RenameAction renameAction;
    private Actions.UpOneLevelAction upOneLevelAction;
    private Actions.PropertiesAction propertiesAction;
    private int mode = -1;
    private boolean multiSelectionEnabled = false;
    private int fileSelectionMode = 0;
    private boolean fileSystemAware;
    private boolean autoCompleteFileNames;
    private String encoding;
    private FileFilter filterToSelect;
    private FileTypeInfo tempInfo;
    private HashMap customColors;
    private boolean showHiddenFiles;
    private Color hiddenFileColor;
    private boolean styleOpenFiles;
    private int openFilesStyle;
    File currentDirectory;
    private File[] selectedFiles;
    private Dimension lastSize;
    private int lastType;
    private Vector fileFilters = new Vector(5, 1);
    private FileFilter currentFileFilter;
    private boolean isChangingDirectories;
    private File[] filesToSelect;
    private File[] openedFiles;
    private JDialog dialog;
    private boolean guiInitialized;
    private boolean showEncodingCombo;
    private List favoriteList;
    private int retVal;
    private static final File DEFAULT_START_DIRECTORY = new File(System.getProperty("user.dir"));
    private static final String FAVORITES_ENCODING = "UTF-8";
    private static final boolean IS_JAVA_6_PLUS;
    static final ResourceBundle msg;

    public RTextFileChooser() {
        this(DEFAULT_START_DIRECTORY);
    }

    public RTextFileChooser(boolean showEncodingCombo) {
        this(showEncodingCombo, DEFAULT_START_DIRECTORY);
    }

    public RTextFileChooser(String startDirectory) {
        this(new File(startDirectory));
    }

    public RTextFileChooser(File startDirectory) {
        this(true, startDirectory);
    }

    public RTextFileChooser(boolean showEncodingCombo, File startDirectory) {
        this.showEncodingCombo = showEncodingCombo;
        this.fileSystemView = FileSystemView.getFileSystemView();
        this.iconManager = new FileChooserIconManager();
        this.itemListener = new RTextFileChooserItemListener();
        if (startDirectory == null || !startDirectory.isDirectory()) {
            startDirectory = DEFAULT_START_DIRECTORY;
        }
        this.currentDirectory = startDirectory;
        FileChooserPreferences prefs = FileChooserPreferences.load();
        this.tempInfo = new FileTypeInfo(null, null);
        this.customColors = prefs.customColors;
        this.setShowHiddenFiles(prefs.showHiddenFiles);
        this.setHiddenFileColor(prefs.hiddenFileColor);
        this.setFileSystemAware(prefs.fileSystemAware);
        this.setAutoCompleteFileNames(prefs.autoCompleteFileNames);
        this.setStyleOpenFiles(prefs.styleOpenFiles);
        this.setOpenFilesStyle(prefs.openFilesStyle);
        this.mode = prefs.viewMode;
        this.guiInitialized = false;
    }

    public boolean addToFavorites(String dir) {
        if (dir == null) {
            throw new NullPointerException("dir cannot be null");
        }
        if (this.favoriteList == null) {
            this.favoriteList = new ArrayList(1);
        }
        if (!this.favoriteList.contains(dir)) {
            this.favoriteList.add(dir);
            return true;
        }
        return false;
    }

    protected synchronized void initializeGUIComponents() {
        if (this.guiInitialized) {
            return;
        }
        ComponentOrientation o = ComponentOrientation.getOrientation(this.getLocale());
        boolean ltr = o.isLeftToRight();
        this.createActions();
        this.getIcons();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Box topPanel = new Box(2);
        topPanel.setOpaque(true);
        JLabel lookInLabel = new JLabel(this.getString("LookInLabel"));
        int horizStrutSize = 4;
        Border empty3Border = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        this.lookInBreadcrumbBar = new BreadcrumbBar();
        this.populateLookInComboBox();
        this.lookInBreadcrumbBar.addPropertyChangeListener("breadcrumbbar.location", this);
        this.upOneLevelButton = new JButton(this.upOneLevelAction);
        this.upOneLevelButton.setText(null);
        this.upOneLevelButton.setIcon(this.upFolderIcon);
        this.upOneLevelButton.setToolTipText(this.getString("UpOneLevelTTT"));
        this.upOneLevelButton.setBorder(empty3Border);
        this.newFolderButton = new JButton(this.newFolderIcon);
        this.newFolderButton.setToolTipText(this.getString("NewFolderTTT"));
        this.newFolderButton.setActionCommand("CreateNewDirectory");
        this.newFolderButton.addActionListener(this);
        this.newFolderButton.setBorder(empty3Border);
        this.viewButton = new MenuButton(this.listViewIcon);
        this.viewButton.setBorder(empty3Border);
        JRadioButtonMenuItem rbItem = new JRadioButtonMenuItem(this.getString("ListViewTTT"), this.listViewIcon, this.mode == 0);
        rbItem.setActionCommand("ListButton");
        rbItem.addActionListener(this);
        this.viewButton.addMenuItem(rbItem);
        ButtonGroup bg = new ButtonGroup();
        bg.add(rbItem);
        rbItem = new JRadioButtonMenuItem(this.getString("DetailsViewTTT"), this.detailsViewIcon, this.mode == 1);
        rbItem.setActionCommand("DetailsButton");
        rbItem.addActionListener(this);
        this.viewButton.addMenuItem(rbItem);
        bg.add(rbItem);
        rbItem = new JRadioButtonMenuItem(this.getString("IconsViewTTT"), this.iconsViewIcon, this.mode == 3);
        rbItem.setActionCommand("IconsButton");
        rbItem.addActionListener(this);
        this.viewButton.addMenuItem(rbItem);
        bg.add(rbItem);
        this.favoritesButton = new MenuButton(this.favoritesIcon);
        this.favoritesButton.setToolTipText(this.getString("FavoritesTTT"));
        this.favoritesButton.setBorder(empty3Border);
        this.favoritesButton.addSeparator();
        JMenuItem item = new JMenuItem(new Actions.AddToFavoritesAction(this));
        this.favoritesButton.addMenuItem(item);
        this.favoritesButton.addPopupMenuListener(new FavoritesPopupListener());
        topPanel.add(lookInLabel);
        topPanel.add(this.lookInBreadcrumbBar);
        topPanel.add(Box.createHorizontalStrut(horizStrutSize));
        topPanel.add(this.upOneLevelButton);
        topPanel.add(Box.createHorizontalStrut(horizStrutSize));
        topPanel.add(this.newFolderButton);
        topPanel.add(Box.createHorizontalStrut(horizStrutSize));
        topPanel.add(this.viewButton);
        topPanel.add(Box.createHorizontalStrut(horizStrutSize));
        topPanel.add(this.favoritesButton);
        this.add((Component)topPanel, "North");
        this.textFieldListener = new TextFieldListener();
        this.installDetailsViewStrings();
        this.setViewModeImpl(this.mode);
        Box centerPanel = Box.createVerticalBox();
        centerPanel.add(Box.createVerticalStrut(5));
        centerPanel.add(this.viewScrollPane);
        centerPanel.add(Box.createVerticalStrut(5));
        this.add(centerPanel);
        JPanel bottomPanel = new JPanel(new SpringLayout());
        JLabel fileNameLabel = new JLabel(this.getString("FileNameLabel"));
        JLabel filterLabel = new JLabel(this.getString("FilterLabel"));
        JLabel encodingLabel = new JLabel(this.getString("EncodingLabel"));
        this.fileNameTextField = new FSATextField(false, this.currentDirectory);
        this.fileNameTextField.setFileSystemAware(this.getFileSystemAware());
        this.fileNameTextField.setAutoCompleteFileName(this.getAutoCompleteFileNames());
        this.fileNameTextField.addFocusListener(this.textFieldListener);
        this.fileNameTextField.getDocument().addDocumentListener(this.textFieldListener);
        fileNameLabel.setLabelFor(this.fileNameTextField);
        this.filterCombo = new JComboBox();
        this.filterCombo.setMaximumRowCount(12);
        filterLabel.setLabelFor(this.filterCombo);
        this.filterCombo.addItemListener(this.itemListener);
        int bottomPanelRowCount = 2;
        if (this.showEncodingCombo) {
            this.encodingCombo = new JComboBox();
            UIUtil.fixComboOrientation(this.encodingCombo);
            this.encodingCombo.setMaximumRowCount(12);
            encodingLabel.setLabelFor(this.encodingCombo);
            ++bottomPanelRowCount;
        }
        if (ltr) {
            bottomPanel.add(fileNameLabel);
            bottomPanel.add(this.fileNameTextField);
            bottomPanel.add(filterLabel);
            bottomPanel.add(this.filterCombo);
            if (this.showEncodingCombo) {
                bottomPanel.add(encodingLabel);
                bottomPanel.add(this.encodingCombo);
            }
        } else {
            bottomPanel.add(this.fileNameTextField);
            bottomPanel.add(fileNameLabel);
            bottomPanel.add(this.filterCombo);
            bottomPanel.add(filterLabel);
            if (this.showEncodingCombo) {
                bottomPanel.add(this.encodingCombo);
                bottomPanel.add(encodingLabel);
            }
        }
        JPanel temp = new JPanel(new GridLayout(2, 1, 0, 5));
        this.acceptButton = new JButton();
        this.acceptButton.setActionCommand("AcceptButtonPressed");
        this.acceptButton.addActionListener(this);
        UIUtil.ensureButtonWidth(this.acceptButton, 80);
        temp.add(this.acceptButton);
        String cancelText = UIManager.getString("FileChooser.cancelButtonText");
        int cancelMnemonic = RTextFileChooser.getMnemonic("FileChooser.cancelButtonMnemonic");
        String cancelToolTip = UIManager.getString("FileChooser.cancelButtonToolTipText");
        this.cancelButton = new JButton(cancelText);
        this.cancelButton.setMnemonic(cancelMnemonic);
        this.cancelButton.setToolTipText(cancelToolTip);
        this.cancelButton.setActionCommand("CancelButtonPressed");
        this.cancelButton.addActionListener(this);
        UIUtil.ensureButtonWidth(this.cancelButton, 80);
        temp.add(this.cancelButton);
        JPanel bottomButtonPanel = new JPanel(new BorderLayout());
        bottomButtonPanel.add((Component)temp, "North");
        temp = new JPanel(new BorderLayout());
        temp.add(bottomPanel);
        temp.add((Component)bottomButtonPanel, "After");
        this.add((Component)temp, "South");
        int initX = ltr ? 0 : 5;
        UIUtil.makeSpringCompactGrid(bottomPanel, bottomPanelRowCount, 2, initX, 0, 6, 6);
        if (this.acceptAllFilter == null) {
            this.acceptAllFilter = new AcceptAllFileFilter();
        }
        this.addChoosableFileFilter(this.acceptAllFilter);
        this.populateFilterComboBox();
        this.installStrings();
        this.applyComponentOrientation(o);
        this.guiInitialized = true;
        this.refreshEncodingComboBox();
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("AcceptButtonPressed".equals(actionCommand)) {
            this.approveSelection();
        } else if ("CancelButtonPressed".equals(actionCommand)) {
            this.cancelSelection();
        } else if ("CreateNewDirectory".equals(actionCommand)) {
            String newDirName = JOptionPane.showInputDialog(this, (Object)this.newFolderPrompt);
            if (newDirName != null) {
                boolean result = new File(this.currentDirectory, newDirName).mkdir();
                if (!result) {
                    JOptionPane.showMessageDialog(this, this.errorNewDirPrompt, this.errorDialogTitle, 0);
                } else {
                    this.refreshView();
                    this.fileNameTextField.setText(newDirName);
                }
            }
            this.fileNameTextField.requestFocusInWindow();
        } else if ("PopupOpen".equals(actionCommand)) {
            this.actionPerformed(new ActionEvent(this.view, 1001, "AcceptButtonPressed"));
        } else if ("ListButton".equals(actionCommand)) {
            this.setViewMode(0);
            this.viewButton.setIcon(this.listViewIcon);
        } else if ("DetailsButton".equals(actionCommand)) {
            this.setViewMode(1);
            this.viewButton.setIcon(this.detailsViewIcon);
        } else if ("IconsButton".equals(actionCommand)) {
            this.setViewMode(3);
            this.viewButton.setIcon(this.iconsViewIcon);
        } else if ("SetDir".equals(actionCommand)) {
            JMenuItem item = (JMenuItem)e.getSource();
            String dirName = item.getText();
            File dir = new File(dirName);
            if (!dir.isDirectory()) {
                String text = MessageFormat.format(this.favoriteDNERemoveString, dirName);
                int rc = JOptionPane.showConfirmDialog(this, text, this.errorDialogTitle, 0);
                if (rc == 0) {
                    this.favoriteList.remove(dirName);
                }
            } else {
                this.setCurrentDirectory(dir);
            }
            this.fileNameTextField.requestFocusInWindow();
        }
    }

    public void addChoosableFileFilter(FileFilter filter) {
        this.setFileFilterImpl(filter, false);
    }

    String addOpenFileStyleHtml(String addTo) {
        if (this.getStyleOpenFiles()) {
            switch (this.getOpenFilesStyle()) {
                default: 
            }
            addTo = "<html><u>" + addTo + "</u></html>";
        }
        return addTo;
    }

    private void adjustSizeIfNecessary() {
        Dimension size = this.dialog.getSize();
        Dimension oldSize = new Dimension(size);
        if (size.width > 800) {
            size.width = 800;
        } else if (size.width < 300) {
            size.width = 300;
        }
        if (size.height > 800) {
            size.height = 800;
        } else if (size.height < 300) {
            size.height = 300;
        }
        if (size.width != oldSize.width || size.height != oldSize.height) {
            this.dialog.setSize(size);
        }
    }

    public void approveSelection() {
        this.selectedFiles = this.getFilesFromFileNameTextField();
        if (this.selectedFiles == null) {
            return;
        }
        this.ensureAbsoluteFilePaths(this.selectedFiles);
        if (this.fileSelectionMode == 0) {
            if (RTextFileChooser.containsFilesAndDirectories(this.selectedFiles)) {
                File[] temp = new File[]{this.selectedFiles[0]};
                if (temp[0].isDirectory()) {
                    temp[0] = this.getCanonicalFileFor(temp[0]);
                    this.setCurrentDirectory(temp[0]);
                    return;
                }
                this.selectedFiles = temp;
            } else if (RTextFileChooser.containsOnlyDirectories(this.selectedFiles)) {
                this.selectedFiles[0] = this.getCanonicalFileFor(this.selectedFiles[0]);
                this.setCurrentDirectory(this.selectedFiles[0]);
                return;
            }
        }
        if (this.approveSelectionImpl()) {
            this.iconManager.clearIconCache();
            this.retVal = 0;
            this.dialog.setVisible(false);
        }
    }

    protected boolean approveSelectionImpl() {
        return true;
    }

    public void cancelSelection() {
        this.iconManager.clearIconCache();
        this.selectedFiles = null;
        this.retVal = 1;
        this.dialog.setVisible(false);
    }

    public void clearExtensionColorMap() {
        this.customColors.clear();
    }

    public void clearFavorites() {
        if (this.favoriteList != null) {
            this.favoriteList.clear();
        }
    }

    private static final boolean containsFilesAndDirectories(Object[] files) {
        int num = files.length;
        boolean containsFile = false;
        boolean containsDirectory = false;
        for (int i = 0; i < num; ++i) {
            if (((File)files[i]).isDirectory()) {
                containsDirectory = true;
            } else if (((File)files[i]).isFile()) {
                containsFile = true;
            }
            if (!containsDirectory || !containsFile) continue;
            return true;
        }
        return false;
    }

    private static final boolean containsOnlyDirectories(Object[] files) {
        int num = files.length;
        for (int i = 0; i < num; ++i) {
            if (((File)files[i]).isDirectory()) continue;
            return false;
        }
        return true;
    }

    private void createActions() {
        FileSelector selector = new FileSelector(){

            public File getSelectedFile() {
                return RTextFileChooser.this.getView().getSelectedFile();
            }

            public File[] getSelectedFiles() {
                return RTextFileChooser.this.getView().getSelectedFiles();
            }
        };
        this.systemEditAction = new Actions.SystemOpenAction(selector, "edit");
        this.systemViewAction = new Actions.SystemOpenAction(selector, "open");
        this.renameAction = new Actions.RenameAction(this);
        this.copyAction = new Actions.CopyAction((FileSelector)this);
        this.deleteAction = new Actions.DeleteAction(this, false);
        this.hardDeleteAction = new Actions.DeleteAction(this, true);
        this.pasteAction = new Actions.PasteAction(this);
        this.refreshAction = new Actions.RefreshAction(this);
        this.upOneLevelAction = new Actions.UpOneLevelAction(this);
        this.propertiesAction = new Actions.PropertiesAction((FileSelector)this);
    }

    protected JDialog createDialog(Window parent) throws HeadlessException {
        boolean supportsWindowDecorations;
        Window wind = parent != null ? parent : JOptionPane.getRootFrame();
        JDialog dialog = wind instanceof Frame ? new JDialog((Frame)wind, true) : new JDialog((Dialog)((JDialog)wind), true);
        dialog.setContentPane(this);
        JRootPane rootPane = dialog.getRootPane();
        rootPane.setDefaultButton(this.acceptButton);
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            dialog.getRootPane().setWindowDecorationStyle(6);
        }
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                RTextFileChooser.this.cancelSelection();
            }
        });
        this.installActions(dialog);
        ComponentOrientation o = this.getComponentOrientation();
        dialog.applyComponentOrientation(o);
        return dialog;
    }

    private void createPopupMenu() {
        this.popupMenu = new JPopupMenu(){

            public void show(Component c, int x, int y) {
                int count = RTextFileChooser.this.view.getSelectedFiles().length;
                boolean filesSelected = count > 0;
                ((JMenuItem)this.getComponent(0)).setEnabled(filesSelected);
                ((JMenuItem)this.getComponent(1)).setEnabled(IS_JAVA_6_PLUS && filesSelected);
                ((JMenuItem)this.getComponent(2)).setEnabled(filesSelected);
                ((JMenuItem)this.getComponent(4)).setEnabled(filesSelected);
                ((JMenuItem)this.getComponent(5)).setEnabled(filesSelected);
                ((JMenuItem)this.getComponent(6)).setEnabled(filesSelected);
                JMenuItem upOneLevel = (JMenuItem)this.getComponent(8);
                upOneLevel.setEnabled(RTextFileChooser.this.upOneLevelButton.isEnabled());
                ((JMenuItem)this.getComponent(12)).setEnabled(filesSelected);
                super.show(c, x, y);
            }
        };
        JMenuItem menuItem = new JMenuItem(this.openString);
        menuItem.setActionCommand("PopupOpen");
        menuItem.addActionListener(this);
        this.popupMenu.add(menuItem);
        JMenu subMenu = new JMenu(msg.getString("PopupMenu.OpenIn"));
        this.popupMenu.add(subMenu);
        subMenu.add(new JMenuItem(this.systemEditAction));
        subMenu.add(new JMenuItem(this.systemViewAction));
        this.popupMenu.add(new JMenuItem(this.renameAction));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.copyAction));
        this.popupMenu.add(new JMenuItem(this.pasteAction));
        this.popupMenu.add(new JMenuItem(this.deleteAction));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.upOneLevelAction));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.refreshAction));
        this.popupMenu.addSeparator();
        this.popupMenu.add(new JMenuItem(this.propertiesAction));
        ComponentOrientation o = this.getComponentOrientation();
        this.popupMenu.applyComponentOrientation(o);
    }

    synchronized void displayPopupMenu(JComponent view, int x, int y) {
        if (this.popupMenu == null) {
            this.createPopupMenu();
        }
        this.popupMenu.show(view, x, y);
    }

    private void ensureAbsoluteFilePaths(File[] files) {
        int num = files.length;
        for (int i = 0; i < num; ++i) {
            if (files[i].isAbsolute()) continue;
            files[i] = new File(this.currentDirectory, files[i].getPath());
        }
    }

    private void ensureCurrentDirectoryExists() {
        if (!this.currentDirectory.isDirectory()) {
            this.currentDirectory = new File(System.getProperty("user.dir"));
        }
    }

    void focusFileNameField(boolean clear) {
        if (clear) {
            this.fileNameTextField.setText(null);
        }
        this.fileNameTextField.requestFocusInWindow();
    }

    public boolean getAutoCompleteFileNames() {
        return this.autoCompleteFileNames;
    }

    private final File getCanonicalFileFor(File dir) {
        if (!dir.isAbsolute()) {
            dir = new File(this.currentDirectory, dir.getPath());
        }
        return dir;
    }

    public FileFilter[] getChoosableFileFilters() {
        Object[] filterArray = new FileFilter[this.fileFilters.size()];
        this.fileFilters.copyInto(filterArray);
        return filterArray;
    }

    public Color getColorForExtension(String extension) {
        return (Color)this.customColors.get(IGNORE_CASE ? extension.toLowerCase() : extension);
    }

    public final File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public HashMap getCustomColorsMap() {
        return this.customColors;
    }

    public String getCustomTitle() {
        return this.customTitle;
    }

    public static final String getDefaultEncoding() {
        String encoding = System.getProperty("file.encoding");
        if (encoding == null) {
            try {
                File f = File.createTempFile("rtext", null);
                FileWriter w = new FileWriter(f);
                encoding = w.getEncoding();
                w.close();
                f.delete();
            }
            catch (IOException ioe) {
                encoding = "US-ASCII";
            }
        }
        return encoding;
    }

    public Color getDefaultFileColor() {
        return this.view != null ? this.view.getDefaultFileColor() : new JLabel().getForeground();
    }

    public String getDescription(File file) {
        String desc = this.fileSystemView.getSystemTypeDescription(file);
        if (desc == null) {
            desc = file.isDirectory() ? this.directoryText : this.fileText;
        }
        return desc;
    }

    public int getDialogType() {
        return this.lastType;
    }

    public String getEncoding() {
        if (this.encoding == null) {
            this.encoding = RTextFileChooser.getDefaultEncoding();
        }
        return this.encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getEncodingOf(File file) throws IOException {
        int n;
        byte[] bom = new byte[4];
        FileInputStream in = new FileInputStream(file);
        try {
            n = in.read(bom, 0, bom.length);
        }
        finally {
            in.close();
        }
        String encoding = null;
        encoding = bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1 ? "UTF-32BE" : (n == 4 && bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0 ? "UTF-32LE" : (bom[0] == -17 && bom[1] == -69 && bom[2] == -65 ? FAVORITES_ENCODING : (bom[0] == -2 && bom[1] == -1 ? "UTF-16BE" : (bom[0] == -1 && bom[1] == -2 ? "UTF-16LE" : RTextFileChooser.getDefaultEncoding()))));
        return encoding;
    }

    public String[] getFavorites() {
        if (this.favoriteList == null) {
            return new String[0];
        }
        String[] array = new String[this.favoriteList.size()];
        array = this.favoriteList.toArray(array);
        return array;
    }

    public FileFilter getFileFilter() {
        return this.currentFileFilter;
    }

    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    private File[] getFilesFromFileNameTextField() {
        File[] files = null;
        String text = this.fileNameTextField.getText();
        if (text == null) {
            return null;
        }
        if ((text = text.trim()).length() == 0) {
            return null;
        }
        if (text.charAt(0) != '\"') {
            files = new File[]{this.fileSystemView.createFileObject(text)};
            if (!files[0].isAbsolute()) {
                files[0] = this.fileSystemView.getChild(this.currentDirectory, text);
            }
            if (!files[0].exists() && RTextFileChooser.isGlobPattern(text)) {
                if (this.globFilter == null) {
                    this.globFilter = new WildcardFileFilter();
                }
                try {
                    this.globFilter.setPattern(text);
                    this.refreshView(true);
                    this.fileNameTextField.setFileSystemAware(false);
                    this.fileNameTextField.setText(null);
                    this.fileNameTextField.setFileSystemAware(true);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Invalid pattern: " + text + "\n" + e, this.errorDialogTitle, 0);
                }
                return null;
            }
        } else {
            int i;
            ArrayList<String> fileNames = new ArrayList<String>();
            while ((i = text.indexOf(34, 1)) != -1) {
                fileNames.add(text.substring(1, i));
                text = text.substring(i);
                i = text.indexOf(34, 1);
                if (i == -1) {
                    if (text.length() > 1) {
                        return null;
                    }
                    text = "";
                    break;
                }
                text = text.substring(i);
            }
            if (text.length() > 1) {
                fileNames.add(text.substring(1));
            }
            int numFileNames = fileNames.size();
            files = new File[numFileNames];
            for (i = 0; i < numFileNames; ++i) {
                files[i] = new File((String)fileNames.get(i));
            }
        }
        return files;
    }

    public boolean getFileSystemAware() {
        return this.fileSystemAware;
    }

    public FileSystemView getFileSystemView() {
        return this.fileSystemView;
    }

    public FileTypeInfo getFileTypeInfoFor(File file) {
        if (file.isDirectory()) {
            this.tempInfo.labelTextColor = this.getDefaultFileColor();
        } else {
            String fileName = file.getName();
            String extension = Utilities.getExtension(fileName);
            if (extension != null && extension.length() > 0) {
                Color color = this.getColorForExtension(extension);
                if (color == null) {
                    color = this.getDefaultFileColor();
                }
                this.tempInfo.labelTextColor = color;
            } else {
                this.tempInfo.labelTextColor = this.getDefaultFileColor();
            }
        }
        this.tempInfo.icon = this.iconManager.getIcon(file);
        return this.tempInfo;
    }

    public Color getHiddenFileColor() {
        return this.hiddenFileColor;
    }

    public void getIcons() {
        this.newFolderIcon = UIManager.getIcon("FileChooser.newFolderIcon");
        this.upFolderIcon = UIManager.getIcon("FileChooser.upFolderIcon");
        this.detailsViewIcon = UIManager.getIcon("FileChooser.detailsViewIcon");
        this.listViewIcon = UIManager.getIcon("FileChooser.listViewIcon");
        ClassLoader cl = this.getClass().getClassLoader();
        String path = "org/fife/ui/rtextfilechooser/images/";
        if (this.newFolderIcon == null) {
            this.newFolderIcon = new ImageIcon(cl.getResource(path + "createnewdirectory.gif"));
        }
        if (this.upFolderIcon == null) {
            this.upFolderIcon = new ImageIcon(cl.getResource(path + "uponelevel.gif"));
        }
        if (this.detailsViewIcon == null) {
            this.detailsViewIcon = new ImageIcon(cl.getResource(path + "detailsview.gif"));
        }
        if (this.listViewIcon == null) {
            this.listViewIcon = new ImageIcon(cl.getResource(path + "listview.gif"));
        }
        this.iconsViewIcon = new ImageIcon(cl.getResource(path + "listview.gif"));
        if (this.favoritesIcon == null) {
            this.favoritesIcon = new ImageIcon(cl.getResource(path + "book.png"));
        }
    }

    private static final int getMnemonic(String key) {
        Object value = UIManager.get(key);
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public String getName(File f) {
        return FileDisplayNames.get().getName(f);
    }

    public int getOpenFilesStyle() {
        return this.openFilesStyle;
    }

    public File getSelectedFile() {
        return this.selectedFiles[0];
    }

    public File[] getSelectedFiles() {
        return (File[])this.selectedFiles.clone();
    }

    public boolean getShowHiddenFiles() {
        return this.showHiddenFiles;
    }

    public String getString(String key) {
        return msg.getString(key);
    }

    public boolean getStyleOpenFiles() {
        return this.styleOpenFiles;
    }

    String getToolTipFor(File file) {
        return "<html><body>&nbsp;" + this.nameString + file.getName() + "<br>&nbsp;" + this.lastModifiedString + Utilities.getLastModifiedString(file.lastModified()) + "<br>&nbsp;" + this.sizeString + Utilities.getFileSizeStringFor(file) + "</body></html>";
    }

    RTextFileChooserView getView() {
        return this.view;
    }

    public int getViewMode() {
        return this.mode;
    }

    private void installActions(JDialog dialog) {
        JRootPane rootPane = dialog.getRootPane();
        InputMap inputMap = rootPane.getInputMap(2);
        ActionMap actionMap = rootPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "OnEsc");
        actionMap.put("OnEsc", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                RTextFileChooser.this.cancelButton.doClick(0);
            }
        });
        KeyStroke ks = (KeyStroke)this.renameAction.getValue("AcceleratorKey");
        inputMap.put(ks, "OnRename");
        actionMap.put("OnRename", this.renameAction);
        ks = (KeyStroke)this.deleteAction.getValue("AcceleratorKey");
        inputMap.put(ks, "OnDelete");
        actionMap.put("OnDelete", this.deleteAction);
        ks = (KeyStroke)this.hardDeleteAction.getValue("AcceleratorKey");
        inputMap.put(ks, "OnHardDelete");
        actionMap.put("OnHardDelete", this.hardDeleteAction);
        ks = (KeyStroke)this.pasteAction.getValue("AcceleratorKey");
        inputMap.put(ks, "OnPaste");
        actionMap.put("OnPaste", this.pasteAction);
        if (System.getProperty("os.name").toLowerCase().indexOf("os x") == 1) {
            ks = (KeyStroke)this.upOneLevelAction.getValue("AcceleratorKey");
            inputMap.put(ks, "OnBackspace");
            actionMap.put("OnBackspace", this.upOneLevelAction);
        }
        ks = (KeyStroke)this.refreshAction.getValue("AcceleratorKey");
        inputMap.put(ks, "OnRefresh");
        actionMap.put("OnRefresh", this.refreshAction);
        ks = (KeyStroke)this.propertiesAction.getValue("AcceleratorKey");
        inputMap.put(ks, "OnProperties");
        actionMap.put("OnProperties", this.propertiesAction);
    }

    private void installDetailsViewStrings() {
        this.nameString = this.getString("Name");
        this.sizeString = this.getString("Size");
        this.typeString = this.getString("Type");
        this.statusString = this.getString("Status");
        this.lastModifiedString = this.getString("LastModified");
    }

    private void installStrings() {
        this.saveButtonText = UIManager.getString("FileChooser.saveButtonText");
        this.openButtonText = UIManager.getString("FileChooser.openButtonText");
        this.saveDialogTitleText = UIManager.getString("FileChooser.saveDialogTitleText");
        this.openDialogTitleText = UIManager.getString("FileChooser.openDialogTitleText");
        this.saveButtonMnemonic = RTextFileChooser.getMnemonic("FileChooser.saveButtonMnemonic");
        this.openButtonMnemonic = RTextFileChooser.getMnemonic("FileChooser.openButtonMnemonic");
        this.saveButtonToolTipText = UIManager.getString("FileChooser.saveButtonToolTipText");
        this.openButtonToolTipText = UIManager.getString("FileChooser.openButtonToolTipText");
        if (this.encodingCombo != null) {
            SortedMap<String, Charset> availcs = Charset.availableCharsets();
            Set keys = availcs.keySet();
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                this.encodingCombo.addItem(i.next());
            }
            this.encodingCombo.addItemListener(this.itemListener);
        }
        this.newFolderPrompt = this.getString("NewFolderPrompt");
        this.errorNewDirPrompt = this.getString("ErrorNewDirPrompt");
        this.errorDialogTitle = this.getString("Error");
        this.directoryText = this.getString("Directory");
        this.fileText = this.getString("File");
        this.openString = this.getString("PopupMenu.Open");
        this.noFavoritesDefinedString = this.getString("NoFavoritesDefined");
        this.favoriteDNERemoveString = this.getString("FavoriteDoesNotExistRemoveIt");
    }

    private static boolean isGlobPattern(String filename) {
        return File.separatorChar == '\\' && filename.indexOf(42) >= 0 || File.separatorChar == '/' && (filename.indexOf(42) >= 0 || filename.indexOf(63) >= 0 || filename.indexOf(91) >= 0);
    }

    public final boolean isMultiSelectionEnabled() {
        return this.multiSelectionEnabled;
    }

    public boolean isOpenedFile(File file) {
        int num = this.openedFiles != null ? this.openedFiles.length : 0;
        for (int i = 0; i < num; ++i) {
            if (!file.equals(this.openedFiles[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadFavorites(File file) throws IOException {
        int count = 0;
        String line = null;
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), FAVORITES_ENCODING));
        try {
            while ((line = r.readLine()) != null) {
                if (line.length() <= 0 || line.startsWith("#")) continue;
                this.addToFavorites(line);
                ++count;
            }
        }
        finally {
            r.close();
        }
        return count;
    }

    private void populateFilterComboBox() {
        this.filterCombo.removeAllItems();
        int max = this.fileFilters.size();
        for (int i = 0; i < max; ++i) {
            this.filterCombo.addItem(this.fileFilters.get(i));
        }
    }

    private void populateLookInComboBox() {
        this.lookInBreadcrumbBar.setShownLocation(this.currentDirectory);
    }

    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if ("breadcrumbbar.location".equals(name)) {
            this.setCurrentDirectory(this.lookInBreadcrumbBar.getShownLocation());
        }
    }

    protected void refreshEncodingComboBox() {
        if (!this.guiInitialized || this.encodingCombo == null) {
            return;
        }
        if (this.encoding == null) {
            this.encoding = RTextFileChooser.getDefaultEncoding();
        }
        Charset cs1 = Charset.forName(this.encoding);
        int count = this.encodingCombo.getItemCount();
        for (int i = 0; i < count; ++i) {
            String item = (String)this.encodingCombo.getItemAt(i);
            Charset cs2 = Charset.forName(item);
            if (!cs1.equals(cs2)) continue;
            this.encodingCombo.setSelectedIndex(i);
            return;
        }
        String defaultEncoding = RTextFileChooser.getDefaultEncoding();
        cs1 = Charset.forName(defaultEncoding);
        for (int i = 0; i < count; ++i) {
            String item = (String)this.encodingCombo.getItemAt(i);
            Charset cs2 = Charset.forName(item);
            if (!cs1.equals(cs2)) continue;
            this.encodingCombo.setSelectedIndex(i);
            return;
        }
    }

    final void refreshView() {
        this.refreshView(false);
    }

    private final void refreshView(boolean useGlobFilter) {
        if (!this.guiInitialized) {
            return;
        }
        this.ensureCurrentDirectoryExists();
        File[] files = this.fileSystemView.getFiles(this.currentDirectory, !this.showHiddenFiles);
        if (files != null) {
            FileFilter filter;
            int num = files.length;
            Vector<File> dirList = new Vector<File>();
            Vector<File> fileList = new Vector<File>();
            FileFilter fileFilter = filter = useGlobFilter ? this.globFilter : this.currentFileFilter;
            if (this.fileSelectionMode == 1) {
                for (int i = 0; i < num; ++i) {
                    if (!files[i].isDirectory()) continue;
                    dirList.add(files[i]);
                }
            } else {
                for (int i = 0; i < num; ++i) {
                    if (files[i].isDirectory()) {
                        dirList.add(files[i]);
                        continue;
                    }
                    if (!filter.accept(files[i])) continue;
                    fileList.add(files[i]);
                }
            }
            if (this.mode != 1) {
                Collections.sort(fileList);
                Collections.sort(dirList);
            }
            if (this.fileSelectionMode != 1) {
                dirList.addAll(fileList);
            }
            this.view.setDisplayedFiles(dirList);
        } else {
            this.view.clearDisplayedFiles();
        }
        JViewport viewport = this.viewScrollPane.getViewport();
        if (this.viewScrollPane.getComponentOrientation().isLeftToRight()) {
            viewport.setViewPosition(new Point(0, 0));
        } else {
            Dimension size = viewport.getViewSize();
            viewport.setViewPosition(new Point(size.width, 0));
        }
        this.view.clearSelection();
    }

    public boolean removeChoosableFileFilter(FileFilter f) {
        if (this.fileFilters.contains(f)) {
            if (this.getFileFilter() == f) {
                this.setFileFilter(null);
            }
            this.fileFilters.removeElement(f);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFavorites(File file) throws IOException {
        PrintWriter w = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), FAVORITES_ENCODING)));
        try {
            if (this.favoriteList != null) {
                for (String favorite : this.favoriteList) {
                    w.println(favorite);
                }
            }
        }
        finally {
            w.close();
        }
    }

    public void savePreferences() {
        FileChooserPreferences.save(this);
    }

    public void setAutoCompleteFileNames(boolean auto) {
        this.autoCompleteFileNames = auto;
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setAutoCompleteFileName(auto);
        }
    }

    public void setColorForExtension(String extension, Color color) {
        if (IGNORE_CASE) {
            extension = extension.toLowerCase();
        }
        this.customColors.put(extension, color);
    }

    public void setCurrentDirectory(File dir) {
        block7: {
            this.isChangingDirectories = true;
            if (this.guiInitialized) {
                this.setCursor(Cursor.getPredefinedCursor(3));
            }
            if (dir.isDirectory() || RootManager.getInstance().isRoot(dir)) {
                try {
                    this.currentDirectory = new File(dir.getCanonicalPath());
                }
                catch (Exception e) {
                    if (RootManager.getInstance().isRoot(dir)) {
                        this.currentDirectory = new File(dir.getAbsolutePath());
                        break block7;
                    }
                    this.currentDirectory = new File(System.getProperty("user.dir"));
                }
            } else {
                this.currentDirectory = new File(System.getProperty("user.dir"));
            }
        }
        this.selectedFiles = null;
        if (this.guiInitialized) {
            this.refreshView();
            File parentFile = this.currentDirectory.getParentFile();
            this.upOneLevelAction.setEnabled(parentFile != null && parentFile.isDirectory() && parentFile.canRead());
            this.populateLookInComboBox();
            this.fileNameTextField.setText(null);
            this.fileNameTextField.requestFocusInWindow();
            this.acceptButton.setEnabled(false);
            this.fileNameTextField.setCurrentDirectory(this.currentDirectory);
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.isChangingDirectories = false;
    }

    public void setCurrentDirectory(String dir) {
        this.setCurrentDirectory(new File(dir));
    }

    public void setCustomTitle(String title) {
        this.customTitle = title;
    }

    public void setEncoding(String encoding) {
        if (encoding == null) {
            encoding = RTextFileChooser.getDefaultEncoding();
        }
        if (!encoding.equals(this.encoding)) {
            this.encoding = encoding;
            this.refreshEncodingComboBox();
        }
    }

    public void setFileFilter(FileFilter filter) {
        this.setFileFilterImpl(filter, true);
    }

    protected void setFileFilterImpl(FileFilter filter, boolean cacheIfGUINotRealized) {
        if (filter == null) {
            if (this.acceptAllFilter == null) {
                this.acceptAllFilter = new AcceptAllFileFilter();
            }
            filter = this.acceptAllFilter;
        }
        if (filter != null && !this.fileFilters.contains(filter)) {
            int size = this.fileFilters.size();
            if (size == 0) {
                this.fileFilters.add(filter);
            } else {
                this.fileFilters.insertElementAt(filter, size);
            }
            if (this.guiInitialized) {
                this.populateFilterComboBox();
            }
        }
        if (!this.guiInitialized) {
            if (cacheIfGUINotRealized) {
                this.filterToSelect = filter;
            }
            return;
        }
        this.filterCombo.setSelectedItem(filter);
        if (filter != null) {
            if (this.isMultiSelectionEnabled() && this.selectedFiles != null && this.selectedFiles.length > 0) {
                Vector<File> fList = new Vector<File>();
                boolean failed = false;
                int num = this.selectedFiles.length;
                for (int i = 0; i < num; ++i) {
                    if (filter.accept(this.selectedFiles[i])) {
                        fList.add(this.selectedFiles[i]);
                        continue;
                    }
                    failed = true;
                }
                if (failed) {
                    this.setSelectedFiles(fList.size() == 0 ? null : fList.toArray(new File[fList.size()]));
                }
            } else if (this.selectedFiles != null && this.selectedFiles.length > 0 && this.selectedFiles[0] != null && !filter.accept(this.selectedFiles[0])) {
                this.setSelectedFile(null);
            }
        }
    }

    public void setFileSelectionMode(int mode) {
        if (this.fileSelectionMode == mode) {
            return;
        }
        if (mode != 0 && mode != 1 && mode != 2) {
            mode = 0;
        }
        this.fileSelectionMode = mode;
        this.refreshView();
    }

    public void setFileSystemAware(boolean aware) {
        this.fileSystemAware = aware;
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setFileSystemAware(aware);
        }
    }

    public void setHiddenFileColor(Color color) {
        if (color == null) {
            throw new NullPointerException("Hidden file color cannot be null");
        }
        this.hiddenFileColor = color;
    }

    public void setInfoForExtension(String extension, Color c) {
        String ext = IGNORE_CASE ? extension.toLowerCase() : extension;
        this.customColors.put(ext, c);
    }

    public void setMultiSelectionEnabled(boolean enabled) {
        this.multiSelectionEnabled = enabled;
        if (this.guiInitialized) {
            this.view.setMultiSelectionEnabled(enabled);
        }
    }

    public void setOpenedFiles(File[] files) {
        this.openedFiles = files;
        this.refreshView();
    }

    public void setOpenFilesStyle(int style) {
        if (style != 0 && style != 1 && style != 2) {
            style = 2;
        }
        this.openFilesStyle = style;
    }

    public void setSelectedFile(File file) {
        if (file == null) {
            this.selectedFiles = new File[0];
        } else {
            this.selectedFiles = new File[1];
            this.selectedFiles[0] = file;
        }
        this.setSelectedFiles(this.selectedFiles);
    }

    public void setSelectedFiles(Vector files) {
        int size = files.size();
        File[] fileArray = new File[size];
        fileArray = files.toArray(fileArray);
        this.setSelectedFiles(fileArray);
    }

    public void setSelectedFiles(File[] files) {
        if (this.isChangingDirectories) {
            return;
        }
        this.filesToSelect = (File[])files.clone();
        this.selectedFiles = this.filesToSelect;
    }

    public void setShowHiddenFiles(boolean show) {
        if (show != this.showHiddenFiles) {
            this.showHiddenFiles = show;
            this.refreshView();
        }
    }

    public void setStyleOpenFiles(boolean style) {
        if (style != this.styleOpenFiles) {
            this.styleOpenFiles = style;
            this.refreshView();
        }
    }

    public void setViewMode(int mode) {
        if (this.mode != mode) {
            this.setViewModeImpl(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setViewModeImpl(int mode) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.view != null) {
            this.view.removeAllListeners();
        }
        try {
            this.mode = mode;
            int horizontalScrollBarPolicy = 32;
            int verticalScrollBarPolicy = 22;
            switch (mode) {
                default: {
                    this.view = new ListView(this);
                    verticalScrollBarPolicy = 21;
                    break;
                }
                case 1: {
                    this.view = new DetailsView(this, this.nameString, this.sizeString, this.typeString, this.statusString, this.lastModifiedString);
                    horizontalScrollBarPolicy = 30;
                    break;
                }
                case 3: {
                    this.view = new IconsView(this);
                    horizontalScrollBarPolicy = 30;
                }
            }
            if (this.viewScrollPane == null) {
                this.viewScrollPane = new RScrollPane((JComponent)((Object)this.view));
                ComponentOrientation o = ComponentOrientation.getOrientation(this.getLocale());
                this.viewScrollPane.applyComponentOrientation(o);
            } else {
                this.viewScrollPane.setViewportView((JComponent)((Object)this.view));
            }
            this.viewScrollPane.setHorizontalScrollBarPolicy(horizontalScrollBarPolicy);
            this.viewScrollPane.setVerticalScrollBarPolicy(verticalScrollBarPolicy);
            this.view.setMultiSelectionEnabled(this.multiSelectionEnabled);
            if (this.dialog != null && this.dialog.isVisible()) {
                this.refreshView();
            }
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (this.fileNameTextField != null) {
            this.fileNameTextField.requestFocusInWindow();
        }
    }

    protected int showDialogImpl(Window parent, int dialogType) {
        this.initializeGUIComponents();
        this.ensureCurrentDirectoryExists();
        if (this.filterToSelect != null) {
            this.setFileFilter(this.filterToSelect);
            this.filterToSelect = null;
        }
        if (this.filesToSelect != null) {
            int num = this.filesToSelect.length;
            if (num > 0) {
                File file = this.filesToSelect[0];
                if (file.isAbsolute() && !this.fileSystemView.isParent(this.currentDirectory, file)) {
                    this.setCurrentDirectory(file.getParentFile());
                }
                this.view.setSelectedFiles(this.filesToSelect);
            }
            this.filesToSelect = null;
        } else {
            this.setCurrentDirectory(this.currentDirectory);
        }
        File oldCurrentDirectory = this.currentDirectory;
        this.dialog = this.createDialog(parent);
        if (dialogType == 1) {
            this.dialog.setTitle(this.customTitle != null ? this.customTitle : this.saveDialogTitleText);
            this.acceptButton.setText(this.saveButtonText);
            this.acceptButton.setMnemonic(this.saveButtonMnemonic);
            this.acceptButton.setToolTipText(this.saveButtonToolTipText);
            this.lastType = dialogType;
        } else {
            this.dialog.setTitle(this.customTitle != null ? this.customTitle : this.openDialogTitleText);
            this.acceptButton.setText(this.openButtonText);
            this.acceptButton.setMnemonic(this.openButtonMnemonic);
            this.acceptButton.setToolTipText(this.openButtonToolTipText);
            this.lastType = 0;
        }
        this.dialog.pack();
        if (this.lastSize != null) {
            this.dialog.setSize(this.lastSize);
        } else {
            this.adjustSizeIfNecessary();
        }
        this.dialog.setLocationRelativeTo(parent);
        this.lookInBreadcrumbBar.setMode(0);
        this.fileNameTextField.requestFocusInWindow();
        try {
            this.dialog.setVisible(true);
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this, "Exception occurred in RTextFileChooser:\n" + t + "\nPlease report this at http://sourceforge.net/projects/rtext,\n" + "\nalso noting the number of files that were in the directory you were\n" + "\nin/changing to.", this.errorDialogTitle, 0);
            this.retVal = -1;
        }
        this.lastSize = this.dialog.getSize();
        this.dialog.dispose();
        this.dialog = null;
        if (this.retVal != 0) {
            this.setCurrentDirectory(oldCurrentDirectory);
        }
        return this.retVal;
    }

    public int showOpenDialog(Window parent) {
        return this.showDialogImpl(parent, 0);
    }

    public int showSaveDialog(Window parent) {
        return this.showDialogImpl(parent, 1);
    }

    void synchronizeTextFieldWithView() {
        if (this.isChangingDirectories) {
            return;
        }
        this.isChangingDirectories = true;
        File[] files = this.view.getSelectedFiles();
        int numSelected = files.length;
        this.fileNameTextField.setFileSystemAware(false);
        if (numSelected == 1) {
            this.fileNameTextField.setText(files[0].getName());
        } else if (numSelected > 1) {
            String temp = "";
            for (int i = 0; i < numSelected; ++i) {
                temp = temp + "\"" + files[i].getName() + "\" ";
            }
            if (!this.fileNameTextField.hasFocus()) {
                this.fileNameTextField.setText(temp);
            }
        }
        this.fileNameTextField.setFileSystemAware(true);
        this.isChangingDirectories = false;
    }

    void updateSelectedEncoding() {
        File[] files = this.view.getSelectedFiles();
        if (files != null) {
            if (files.length == 1 && files[0].isFile()) {
                try {
                    this.setEncoding(RTextFileChooser.getEncodingOf(files[0]));
                }
                catch (IOException e) {
                    this.setEncoding(RTextFileChooser.getDefaultEncoding());
                    return;
                }
            } else {
                this.setEncoding(RTextFileChooser.getDefaultEncoding());
            }
        }
    }

    public void updateUI() {
        if (!this.guiInitialized) {
            return;
        }
        super.updateUI();
        if (this.popupMenu != null) {
            SwingUtilities.updateComponentTreeUI(this.popupMenu);
        }
        Border empty3Border = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        this.upOneLevelButton.setBorder(empty3Border);
        this.newFolderButton.setBorder(empty3Border);
        this.viewButton.setBorder(empty3Border);
        this.favoritesButton.setBorder(empty3Border);
        if (this.mode == 1) {
            this.view.removeAllListeners();
            this.mode = 0;
            this.setViewMode(1);
        }
    }

    static {
        msg = ResourceBundle.getBundle("org.fife.ui.rtextfilechooser.FileChooser");
        String ver = System.getProperty("java.specification.version");
        IS_JAVA_6_PLUS = !ver.startsWith("1.4") && !ver.startsWith("1.5");
    }

    private class TextFieldListener
    extends FocusAdapter
    implements DocumentListener {
        private TextFieldListener() {
        }

        public void changedUpdate(DocumentEvent e) {
        }

        private void handleDocumentChange(DocumentEvent e) {
            if (!RTextFileChooser.this.isChangingDirectories) {
                RTextFileChooser.this.view.clearSelection();
            }
            int charCount = RTextFileChooser.this.fileNameTextField.getDocument().getLength();
            RTextFileChooser.this.acceptButton.setEnabled(charCount > 0);
        }

        public void insertUpdate(DocumentEvent e) {
            this.handleDocumentChange(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.handleDocumentChange(e);
        }

        public void focusGained(FocusEvent e) {
            RTextFileChooser.this.fileNameTextField.selectAll();
        }
    }

    private class RTextFileChooserItemListener
    implements ItemListener {
        private RTextFileChooserItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (RTextFileChooser.this.isChangingDirectories) {
                return;
            }
            RTextFileChooser.this.isChangingDirectories = true;
            Object source = e.getSource();
            if (source == RTextFileChooser.this.filterCombo && e.getStateChange() == 1) {
                RTextFileChooser.this.currentFileFilter = (FileFilter)e.getItem();
                RTextFileChooser.this.refreshView();
            } else if (source == RTextFileChooser.this.encodingCombo && e.getStateChange() == 1) {
                RTextFileChooser.this.setEncoding((String)e.getItem());
            }
            RTextFileChooser.this.isChangingDirectories = false;
        }
    }

    private class FavoritesPopupListener
    implements PopupMenuListener {
        private FavoritesPopupListener() {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            for (int count = RTextFileChooser.this.favoritesButton.getItemCount(); count > 2; --count) {
                Component old = RTextFileChooser.this.favoritesButton.removeItem(0);
                if (!(old instanceof JMenuItem)) continue;
                JMenuItem oldItem = (JMenuItem)old;
                oldItem.removeActionListener(RTextFileChooser.this);
            }
            if (RTextFileChooser.this.favoriteList != null && !RTextFileChooser.this.favoriteList.isEmpty()) {
                for (String dir : RTextFileChooser.this.favoriteList) {
                    JMenuItem item = new JMenuItem(dir);
                    item.setActionCommand("SetDir");
                    item.addActionListener(RTextFileChooser.this);
                    RTextFileChooser.this.favoritesButton.insertMenuItem(item, RTextFileChooser.this.favoritesButton.getItemCount() - 2);
                }
            } else {
                JMenuItem item = new JMenuItem(RTextFileChooser.this.noFavoritesDefinedString);
                item.setEnabled(false);
                RTextFileChooser.this.favoritesButton.insertMenuItem(item, 0);
            }
            ComponentOrientation o = ComponentOrientation.getOrientation(RTextFileChooser.this.getLocale());
            RTextFileChooser.this.favoritesButton.applyComponentOrientation(o);
        }
    }
}

