/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpanderFactory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;

public class SchemaExpander
implements INodeExpander {
    INodeExpanderFactory _inodeFactory = null;
    DatabaseObjectType _dbObjType = null;

    public SchemaExpander(INodeExpanderFactory inodeExpFactory, DatabaseObjectType dbObjType) {
        this._inodeFactory = inodeExpFactory;
        this._dbObjType = dbObjType;
    }

    @Override
    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        IDatabaseObjectInfo parentDbinfo = parentNode.getDatabaseObjectInfo();
        SQLDatabaseMetaData md = session.getSQLConnection().getSQLMetaData();
        String catalogName = parentDbinfo.getCatalogName();
        String schemaName = parentDbinfo.getSimpleName();
        DatabaseObjectInfo seqInfo = new DatabaseObjectInfo(catalogName, schemaName, this._inodeFactory.getParentLabelForType(this._dbObjType), this._dbObjType, md);
        ObjectTreeNode node = new ObjectTreeNode(session, seqInfo);
        node.addExpander(this._inodeFactory.createExpander(this._dbObjType));
        childNodes.add(node);
        return childNodes;
    }
}

