/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.graphite;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTabbedPaneUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class GraphiteTabbedPaneUI
extends BaseTabbedPaneUI {
    private Color[] sepColors = null;

    public static ComponentUI createUI(JComponent c) {
        return new GraphiteTabbedPaneUI();
    }

    protected void installComponents() {
        this.simpleButtonBorder = true;
        super.installComponents();
    }

    protected Color getLoBorderColor(int tabIndex) {
        if ((tabIndex == this.tabPane.getSelectedIndex() || tabIndex == this.rolloverIndex) && this.tabPane.getBackgroundAt(tabIndex) instanceof ColorUIResource) {
            return AbstractLookAndFeel.getControlColorDark();
        }
        return AbstractLookAndFeel.getControlShadow();
    }

    protected Color[] getContentBorderColors(int tabPlacement) {
        if (this.sepColors == null) {
            this.sepColors = new Color[5];
            this.sepColors[0] = this.getLoBorderColor(0);
            this.sepColors[1] = AbstractLookAndFeel.getControlColorDark();
            this.sepColors[2] = ColorHelper.darker(AbstractLookAndFeel.getControlColorDark(), 4.0);
            this.sepColors[3] = ColorHelper.darker(AbstractLookAndFeel.getControlColorDark(), 8.0);
            this.sepColors[4] = ColorHelper.darker(AbstractLookAndFeel.getControlColorDark(), 12.0);
        }
        return this.sepColors;
    }

    protected Font getTabFont(boolean isSelected) {
        if (isSelected) {
            return super.getTabFont(isSelected).deriveFont(1);
        }
        return super.getTabFont(isSelected);
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Color backColor = this.tabPane.getBackgroundAt(tabIndex);
        if (!(backColor instanceof UIResource)) {
            super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
            return;
        }
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            Graphics2D g2D = (Graphics2D)g;
            Object savedRenderingHint = null;
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
            }
            v.paint(g, textRect);
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
            }
        } else {
            int mnemIndex = -1;
            if (JTattooUtilities.getJavaVersion() >= 1.4) {
                mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            }
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                if (isSelected) {
                    if (ColorHelper.getGrayValue(AbstractLookAndFeel.getControlColorDark()) > 128) {
                        g.setColor(this.tabPane.getForegroundAt(tabIndex));
                    } else {
                        ColorUIResource titleColor = AbstractLookAndFeel.getWindowTitleForegroundColor();
                        if (ColorHelper.getGrayValue(titleColor) > 164) {
                            g.setColor(Color.black);
                        } else {
                            g.setColor(Color.white);
                        }
                        JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x + 1, textRect.y + 1 + metrics.getAscent());
                        g.setColor(titleColor);
                    }
                } else if (tabIndex == this.rolloverIndex) {
                    g.setColor(AbstractLookAndFeel.getTheme().getRolloverForegroundColor());
                } else {
                    g.setColor(this.tabPane.getForegroundAt(tabIndex));
                }
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            } else {
                g.setColor(Color.white);
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x + 1, textRect.y + metrics.getAscent() + 1);
                g.setColor(AbstractLookAndFeel.getDisabledForegroundColor());
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            }
        }
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        if (this.tabPane.isRequestFocusEnabled() && this.tabPane.hasFocus() && isSelected && tabIndex >= 0 && textRect.width > 8) {
            g.setColor(AbstractLookAndFeel.getTheme().getFocusColor());
            BasicGraphicsUtils.drawDashedRect(g, textRect.x - 4, textRect.y, textRect.width + 8, textRect.height);
            BasicGraphicsUtils.drawDashedRect(g, textRect.x - 3, textRect.y + 1, textRect.width + 6, textRect.height - 2);
        }
    }
}

