/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mail;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import org.springframework.mail.MailMessage;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SimpleMailMessage
implements MailMessage,
Serializable {
    private String from;
    private String replyTo;
    private String[] to;
    private String[] cc;
    private String[] bcc;
    private Date sentDate;
    private String subject;
    private String text;

    public SimpleMailMessage() {
    }

    public SimpleMailMessage(SimpleMailMessage original) {
        Assert.notNull((Object)original, (String)"The 'original' message argument cannot be null");
        this.from = original.getFrom();
        this.replyTo = original.getReplyTo();
        if (original.getTo() != null) {
            this.to = SimpleMailMessage.copy(original.getTo());
        }
        if (original.getCc() != null) {
            this.cc = SimpleMailMessage.copy(original.getCc());
        }
        if (original.getBcc() != null) {
            this.bcc = SimpleMailMessage.copy(original.getBcc());
        }
        this.sentDate = original.getSentDate();
        this.subject = original.getSubject();
        this.text = original.getText();
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setTo(String to) {
        this.to = new String[]{to};
    }

    public void setTo(String[] to) {
        this.to = to;
    }

    public String[] getTo() {
        return this.to;
    }

    public void setCc(String cc) {
        this.cc = new String[]{cc};
    }

    public void setCc(String[] cc) {
        this.cc = cc;
    }

    public String[] getCc() {
        return this.cc;
    }

    public void setBcc(String bcc) {
        this.bcc = new String[]{bcc};
    }

    public void setBcc(String[] bcc) {
        this.bcc = bcc;
    }

    public String[] getBcc() {
        return this.bcc;
    }

    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate;
    }

    public Date getSentDate() {
        return this.sentDate;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void copyTo(MailMessage target) {
        Assert.notNull((Object)target, (String)"The 'target' message argument cannot be null");
        if (this.getFrom() != null) {
            target.setFrom(this.getFrom());
        }
        if (this.getReplyTo() != null) {
            target.setReplyTo(this.getReplyTo());
        }
        if (this.getTo() != null) {
            target.setTo(this.getTo());
        }
        if (this.getCc() != null) {
            target.setCc(this.getCc());
        }
        if (this.getBcc() != null) {
            target.setBcc(this.getBcc());
        }
        if (this.getSentDate() != null) {
            target.setSentDate(this.getSentDate());
        }
        if (this.getSubject() != null) {
            target.setSubject(this.getSubject());
        }
        if (this.getText() != null) {
            target.setText(this.getText());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SimpleMailMessage: ");
        sb.append("from=").append(this.from).append("; ");
        sb.append("replyTo=").append(this.replyTo).append("; ");
        sb.append("to=").append(StringUtils.arrayToCommaDelimitedString((Object[])this.to)).append("; ");
        sb.append("cc=").append(StringUtils.arrayToCommaDelimitedString((Object[])this.cc)).append("; ");
        sb.append("bcc=").append(StringUtils.arrayToCommaDelimitedString((Object[])this.bcc)).append("; ");
        sb.append("sentDate=").append(this.sentDate).append("; ");
        sb.append("subject=").append(this.subject).append("; ");
        sb.append("text=").append(this.text);
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleMailMessage)) {
            return false;
        }
        SimpleMailMessage otherMessage = (SimpleMailMessage)other;
        return ObjectUtils.nullSafeEquals((Object)this.from, (Object)otherMessage.from) && ObjectUtils.nullSafeEquals((Object)this.replyTo, (Object)otherMessage.replyTo) && Arrays.equals(this.to, otherMessage.to) && Arrays.equals(this.cc, otherMessage.cc) && Arrays.equals(this.bcc, otherMessage.bcc) && ObjectUtils.nullSafeEquals((Object)this.sentDate, (Object)otherMessage.sentDate) && ObjectUtils.nullSafeEquals((Object)this.subject, (Object)otherMessage.subject) && ObjectUtils.nullSafeEquals((Object)this.text, (Object)otherMessage.text);
    }

    public int hashCode() {
        int i;
        int hashCode = this.from == null ? 0 : this.from.hashCode();
        hashCode = 29 * hashCode + (this.replyTo == null ? 0 : this.replyTo.hashCode());
        for (i = 0; this.to != null && i < this.to.length; ++i) {
            hashCode = 29 * hashCode + (this.to == null ? 0 : this.to[i].hashCode());
        }
        for (i = 0; this.cc != null && i < this.cc.length; ++i) {
            hashCode = 29 * hashCode + (this.cc == null ? 0 : this.cc[i].hashCode());
        }
        for (i = 0; this.bcc != null && i < this.bcc.length; ++i) {
            hashCode = 29 * hashCode + (this.bcc == null ? 0 : this.bcc[i].hashCode());
        }
        hashCode = 29 * hashCode + (this.sentDate == null ? 0 : this.sentDate.hashCode());
        hashCode = 29 * hashCode + (this.subject == null ? 0 : this.subject.hashCode());
        hashCode = 29 * hashCode + (this.text == null ? 0 : this.text.hashCode());
        return hashCode;
    }

    private static String[] copy(String[] state) {
        String[] copy = new String[state.length];
        System.arraycopy(state, 0, copy, 0, state.length);
        return copy;
    }
}

