package TDS::Tdf::Parser;

sub ReplaceEntity ($\$)
{
    my ($self, $line) = @_;

    $_ = $$line;

    s/\$/\\$$/g;
    s/_/\\_/g;
    s/~/\\~\\quad/g;
    s/([<>])/\$$1\$/g;
    s/\&/\\&/g;

    die;
    $$line = $_;
}
    

package TDS::Tdf::Command::HD;

$Template = "";
$EndTemplate = "}\n";

sub AsHTML($$)
{
    my ($self, $params) = @_;
    
    my $num = $self->attr->[1];

    $Template = "";
    if ($num == 1){
	$Template = "\\chapter"
    } elsif ($num == 2){
	$Template = "\\section";
    } elsif ($num == 3){
	$Template = "\\subsection";
    } elsif ($num == 4){
	$Template = "\\subsubsection";
    } else {
	die "HD $num";
    }
    $Template .= "{%content";
    $self->SUPER::AsHTML($params);
}

################################################################

package TDS::Tdf::Command::LINK;

$Template = '%content';
$EndTemplate = "\footnote{%{1}}";

package TDS::Tdf::Command::MAILTO;

$Template = '%content';
$EndTemplate = "\footnote{%{1}}";

package TDS::Tdf::Command::BR;

$Template = "\n\\\\";
$EndTemplate = "";

################################################################
package TDS::Tdf::Command::P;

$Template = "\n\n";
$EndTemplate = "\n\n";

package TDS::Tdf::Command::SPAN;

$Template = "%content";
$EndTemplate = "";

package TDS::Tdf::Command::DL;

$Template = "\\begin{description}\n";
$EndTemplate = "\\end{description}\n";

package TDS::Tdf::Command::DT;

$Template = "\\item [%content";
$EndTemplate = ":\\quad\n]";

package TDS::Tdf::Command::DD;

$Template = "%1 %content";
$EndTemplate = "";

package TDS::Tdf::Command::UL;

$Template = "\\begin{itemize}\n";
$EndTemplate = "\\end{itemize}\n";

package TDS::Tdf::Command::LI;

$Template = "\\item %1 %content\n";
$EndTemplate = "";

package TDS::Tdf::Command::CITE;

$Template = "";
$EndTemplate = "";

package TDS::Tdf::Command::CODE;

$Template = "\\begin{verbatim}";
$EndTemplate = "\\end{verbatim}";


package TDS::Tdf::Command::PRE;

$Template = "\\begin{verbatim}";
$EndTemplate = "\\end{verbatim}";



1;
