package TDS::Renderer;
# $Id: Renderer.pm,v 1.79 2001/02/06 05:02:09 tom Exp $
################################################################

=head1 NAME

TDS::Renderer - rendering class

=head1 SYNOPSIS

 use TDS::Renderer;
 use TDS::Status;
 use TDS::Collection;

 $col = new TDS::Collection;
 $r = new TDS::Renderer;
 $r->Read;
 print $r->AsHTML($col);


=head1 DESCRIPTION

derived from TDS::Skelton.html.
read skelton.html, expand macros, return html.

=cut

################################################################

use strict qw(vars);
use vars qw(@ISA $SkeltonFilename
	    $LAST_MODIFIED $LAST_MODIFIED_GMT
	    $RECENT $REFRESH $NEXT_MONTH $PREV_MONTH $THIS_MONTH
	    $NEXT_DAY $PREV_DAY $THIS_DAY
	    $FIRST_PART $MIDDLE_PART $LAST_PART
	    $CATEGORY $SUBMIT_JUMP $SUMMARY $TITLE_SUMMARY $POWER
	    $SEARCH_SUBMIT $SEARCH_RESULT $SEARCH_SELECT_SORT $SEARCH_SELECT_OBJECT $SEARCH_CHECKBOX_TITLEONLY $SEARCH_CHECKBOX_IGNORECASE
	    $SEARCH_CHECKBOX_UNUSE_SIGNATURE_METHOD
	    $AUTHOR_MANAGEMENT $TDF_EDITOR $URL_LIST $DICTIONARY
	    $LOG_ANALYSE_ANCHOR
	    $COMMENT_SUBMIT $COMMENT_SHOW_ALL_SUBMIT $COMMENT_COOKIE_OK);


use JConv;
use DateTime::Format;
use CGI::CookieTool;
use CGI::QueryString;
use CGI::Tools;
use Template;

use TDS;
use TDS::System;
use TDS::Mode;
use TDS::Skelton;

use TDS::DirInfo;

@ISA = qw(TDS::Skelton);


=head1 STATIC VARIABLES

ƥץ졼ȡ

 $LAST_MODIFIED      ǿ
 $RECENT             Ȥ
 $REFRESH            
 $NEXT_MONTH         
 $PREV_MONTH         
 $THIS_MONTH         
 $NEXT_DAY           
 $PREV_DAY           
 $THIS_DAY           
 $SUBMIT_JUMP        ץ֥ߥåȥ٥
 $SUMMARY            
 $TITLE_SUMMARY      ȥ
 $SEARCH_SUBMIT      ֥ߥåȥ٥
 $SEARCH_RESULT      ɽ
 $SEARCH_SELECT_SORT ¤ӽʿŤ
 $SEARCH_SELECT_OBJECT о
 $SEARCH_CHECKBOX_TITLEONLY   ȥΤ߸
 $SEARCH_CHECKBOX_IGNORECASE  ignorecase
 $SEARCH_CHECKBOX_UNUSE_SIGNATURE_METHOD
 $AUTHOR_MANAGEMENT  Դ
 $TDF_EDITOR         TdfEditor 
 $URL_LIST           URL ꥹȤ
 $DICTIONARY         
 $LOG_ANALYSE_ANCHOR Ϥ
 $COMMENT_SUBMIT     ȥ֥ߥåȥ٥
 $COMMENT_SHOW_ALL_SUBMIT Ȥ٤ɽ֥ߥåȥ٥
 $COMMENT_COOKIE_OK  ̾򥯥åǿ碌뤫   

ե̾

 $SkeltonFile             ե̾

=cut

# ٥ƥץ졼
# ޥ̾Ʊ
$LAST_MODIFIED = "%a, %d %b %Y %H:%M:%S %Z" unless defined $LAST_MODIFIED;
$LAST_MODIFIED_GMT = "%a, %d %b %Y %H:%M:%S %Z" unless defined $LAST_MODIFIED_GMT;
$RECENT = "[ǿ]" unless defined $RECENT;
$REFRESH = "[]" unless defined $REFRESH;
$NEXT_MONTH = "&gt;&gt;" unless defined $NEXT_MONTH;
$PREV_MONTH = "&lt;&lt;" unless defined $PREV_MONTH;
$THIS_MONTH = "==" unless defined $THIS_MONTH;
$NEXT_DAY = "&gt;" unless defined $NEXT_DAY;
$PREV_DAY = "&lt;" unless defined $PREV_DAY;
$THIS_DAY = "=" unless defined $THIS_DAY;
$FIRST_PART = "[]" unless defined $FIRST_PART;
$MIDDLE_PART = "[]" unless defined $MIDDLE_PART;
$LAST_PART = "[]" unless defined $LAST_PART;
$SUBMIT_JUMP = "" unless defined $SUBMIT_JUMP;
$SUMMARY = "[]" unless defined $SUMMARY;
$POWER = "[ѥ]" unless defined $POWER;
$TITLE_SUMMARY = "[ȥ]" unless defined $TITLE_SUMMARY;
$CATEGORY = 'ALL' unless defined $CATEGORY;
$SEARCH_SUBMIT =  "" unless defined $SEARCH_SUBMIT;
$SEARCH_RESULT = "<p>%diary  %num ˥ޥåޤ</p>" unless defined $SEARCH_RESULT;
$SEARCH_SELECT_SORT =  ",Ť" unless defined $SEARCH_SELECT_SORT;
$SEARCH_SELECT_OBJECT = "ꤷ,Ƕᣳ,Ƕǯ,٤" unless defined $SEARCH_SELECT_OBJECT;
$SEARCH_CHECKBOX_TITLEONLY = "ȥΤ" unless defined $SEARCH_CHECKBOX_TITLEONLY;
$SEARCH_CHECKBOX_IGNORECASE = "羮ʸ̵" unless defined $SEARCH_CHECKBOX_IGNORECASE;
$SEARCH_CHECKBOX_UNUSE_SIGNATURE_METHOD = "ͥˡԻ" unless defined $SEARCH_CHECKBOX_UNUSE_SIGNATURE_METHOD;
$AUTHOR_MANAGEMENT =  "[Դ]" unless defined $AUTHOR_MANAGEMENT;
$TDF_EDITOR = "[Խ]" unless defined $TDF_EDITOR;
$URL_LIST = "[URL ꥹ]" unless defined $URL_LIST;
$DICTIONARY = "[]" unless defined $DICTIONARY;
$LOG_ANALYSE_ANCHOR =  "[]" unless defined $LOG_ANALYSE_ANCHOR;
$COMMENT_SUBMIT = "" unless defined $COMMENT_SUBMIT;
$COMMENT_SHOW_ALL_SUBMIT = "Τɽ" unless defined $COMMENT_SHOW_ALL_SUBMIT;
$COMMENT_COOKIE_OK = "̾Ͽ" unless defined $COMMENT_COOKIE_OK;

$SkeltonFilename = "skelton.html";

attributes qw(status);

################################################################

=head1 MEMBER FUNCTIONS

=cut

sub initialize($)
{
    my $self = shift;

    $self->status($TDS::Status);
    $self->SUPER::initialize;
}

=head2 $r->AsHTML($col);

 $col 򸵤˥ޥŸ HTML ֤
$col ɬϤʤФʤʤ

=cut


sub AsHTML($$)
{
    my ($self, $col) = @_;

    # $col ɬϤʤФʤʤ
    die "BUG: Renderer::AsHTML: \$col must be set." unless $col;
    print "<br>html start " .  (time() - $TDS::Status->start_time->time)
	if $TDS::Status->debug;

    ################
    # 
    for (keys %{$self->config}){
	require TDS::Tdf::Command;
	my $conf_name = $_;
	if (/(.*)_template$/){        # ƥץ졼
	    my ($cmd_name, $is_end) = /^(.*)_(end_)?template/;
	    $cmd_name = uc($cmd_name);
	    IllegalConfig("no such command: $cmd_name")
		unless $TDS::Tdf::Command::IsCommand{$cmd_name};
	    my $var = sprintf("TDS::Tdf::Command::%s::%sTemplate",
			      $cmd_name, ($is_end)?'End':'');
	    $$var = $self->config->{$conf_name};
	} elsif (/^date_format$/){    # 
	    $TDS::Tdf::Command::DIARY::DateFormat =
		$self->config->{'date_format'};
	} elsif (/^(.*)_mark$/){      # ޡ
	    my $conf = $_;
	    my %hash = ('new'=>'NEW',
			'topic'=>'NEW', # ߴΤ
			'sub'=>'SUB');
	    my $cmd_name = uc($hash{$1});
	    unless ($cmd_name){
		IllegalConfig("no such mark: ${cmd_name}_mark");
	    }
	    my $var = "TDS::Tdf::Command::${cmd_name}::Mark";
	    $$var = $self->config->{$conf};
	} elsif (/^(.*)_explain$/){   # ʸ
	    require TDS::Explain;
	    my $conf = $_;
	    my %hash = ('recent'=>'Recent',
			'month'=>'Month',
			'day'=>'Day',
			'part'=>'Part',
			'each_part'=>'EachPart',
			'search'=>'Search');
	    my $name = $hash{$1};
	    unless ($name){
		IllegalConfig("no such explain: $name");
	    }
	    my $var = "TDS::Explain::${name}";
	    $$var = $self->config->{$conf};
	}
    }
    require TDS::Explain;
    my $explain = new TDS::Explain;    # ǻȤ
    
    ### 絡ǽ ###
    # 
    my $params = {is_author=>$TDS::Status->is_author};
    my $content_html = $col->AsHTML($params);

    $self->SetMacro("(DIARY_)?CONTENT", sub {
	return $content_html;
    });
    # ȥ
    $self->SetMacro("TITLE", $params->{title} || TDS::IdentInfo->Get('title'));
    
    # 
    $self->SetMacro("NUMBER_OF_DIARY", @{$col->diarys}+0);
    # 
    $self->SetMacro("LAST_MODIFIED(_GMT)?", sub {
	my ($self, $cmd, $var) = @_;
	$var ||= $$cmd;
	my $tz = ($1) ? 'GMT' : $TDS::System::TZ;
	my $lm = (TDS::Mode::IsDynamic()) ? $TDS::Status->lmo->GetLastModified :
	    time();
	time2str($var, $lm, $tz);
    });
    
    # explain
    $self->SetMacro("EXPLAIN", $explain->AsString($TDS::Status));
		     
    # info
    $self->SetMacro("INFORMATION", sub {
	require TDS::Information;
	my $self = shift;
#	return unless $TDS::Status->mode eq 'RECENT';
	my $info = new TDS::Information;
	$info->Read;
	return $info->AsPlain;
    });

    # captured antenna
    $self->SetMacro("CAPTURED_ANTENNA", sub {
	require TDS::CapturedAntenna;
	my $datafile = GetDataDir() . "/captured_antenna.dat";
	unless (-f $datafile){
	    #return "no data: $datafile";
	    return undef;
	} else {
	    my $ca = new TDS::CapturedAntenna;
	    $ca->Read;
	    return $ca->AsHTML;
	}
    });

    # mode
    $self->SetMacro("MODE", sub {

	my $self = shift;
	my $str = TDS::Mode::GetMode();
	$str .= "(modperl)"
	    if CGI::Tools::IsModPerl();
	$str .= "<!-- BEGIN @@@ AUTHOR @@@ -->,author<!-- END @@@ AUTHOR @@@ -->"
	    if $TDS::Status->is_author;
	$str .= ",site"
	    if $TDS::System::TDS_Root;
	$str .= ",style:$TDS::Style::Name"
	    if $TDS::Style::Name;
	require TDS::Cache::Base;
	$str .= ",cache:" . ((TDS::Cache::Base->PermittedCaching) ? 'on' : 'off');
	$str .= ",robot" if $TDS::Status->is_robot;
	$str .= ",debug"
	    if $TDS::Status->debug;
	return "[$str]";
    });
    # Ķѿ
    my $skelton = $self->skelton;      # ޤǻȤ
    $skelton =~ s/<!--#echo var="(.*)" *-->/$ENV{$1}/g;

    ################
    # 󥿡
    if (TDS::Mode::IsDynamic()){
	$self->SetMacro("COUNTER_?(ALL|TODAY)?", sub {
	    require TDS::AccessLog;
	    return undef unless $TDS::AccessLog::EnableAccessLog;
	    require TDS::AccessLog::Counter;

	    my ($self, $cmd, $var) = @_;
	    my $counter = new TDS::AccessLog::Counter;
	    if ($1){
		if ($1 eq 'ALL'){
		    $var = $counter->All;
		} elsif ($1 eq 'TODAY'){
		    $var = $counter->Today;
		} else {
		    die "Illegal Command: $cmd";
		}
		return "<!-- BEGIN @@@ $cmd @@@ -->$var<!-- END @@@ $cmd @@@ -->";		
	    } else {
		$var ||= $TDS::AccessLog::Counter::Template;
		$var = "<!-- BEGIN @@@ $cmd @@@ -->$var<!-- END @@@ $cmd @@@ -->";
		Expand($var, {'all'=>$counter->All,
			      'today'=>$counter->Today,
			      'times'=>$TDS::Status->id->GetTimes
			      });
	    }
	});
	$self->SetMacro("COOKIE_TIMES", sub {
	    my ($self, $cmd, $var) = @_;
	    return "<!-- BEGIN @@@ $cmd @@@ -->" . $TDS::Status->id->GetTimes .
		"<!-- END @@@ $cmd @@@ -->";
	});
    } else {                                            # static
	$self->SetMacro("COUNTER_?(ALL|TODAY)?", sub {
	    my ($self, $cmd, $var) = @_;
	    require TDS::AccessLog;
	    return undef unless $TDS::AccessLog::EnableAccessLog;
	    if ($1){
		return "<strong>$cmd: depreceted in static mode</strong>";
	    }
	    return qq(<!--\#exec cgi="counter.cgi"-->);
	});
	require TDS::Cookie;
	if ($TDS::Cookie::EnableCookie){
	    $skelton =~ s@(</head>)@<!--#exec cgi="set-cookie.cgi" -->$1@i;
	}
	$self->SetMacro("COOKIE_TIMES", sub {
	    my ($self, $cmd, $var) = @_;
	    return "<strong>$cmd: deprecated in static mode.</strong>";
	});
    }
    ################
    # PIM : ǿǤλΤɽ
    if ($TDS::Status->mode eq 'RECENT' &&
	!$TDS::Status->title_mode){
	$skelton =~ s/<!--#begin +cmd="?PIM"? *-->//;
	$skelton =~ s/<!--#end +cmd="?PIM"? *-->//;
    } else {
	$skelton =~ s/<!--#begin +cmd="?PIM"? *-->.*<!--#end +cmd="?PIM"? *-->//s;
    }
    # TODO
    $self->SetMacro("TODO", sub {
	require TDS::PIM::Todo;
	my $todo = new TDS::PIM::Todo;
	return $todo->AsHTML;
    });
    
    # Schedule
    $self->SetMacro("SCHEDULE", sub {
	require TDS::PIM::Schedule;
	my $sch = new TDS::PIM::Schedule;
	return $sch->AsHTML;
    });
    # CGI ͭʤȤΤ
    if ($TDS::System::CanUseCGI &&
	!$TDS::Status->title_mode){    # ȥλɽʤ
	# SEARCH
	$skelton =~ s/<!--#begin +cmd="?SEARCH"? *-->/<form action="search.cgi" method="get"><div>/;
	$skelton =~ s/<!--#end +cmd="?SEARCH"? *-->/<\/div><\/form>/;
    } else {
	$skelton =~ s/<!--#begin +cmd="?SEARCH"? *-->.*<!--#end +cmd="?SEARCH"? *-->//s;
    }
    # COMMENT
    if ($TDS::System::CanUseCGI &&
	!$TDS::Status->title_mode){
	$skelton =~ s/<!--#begin +cmd="?COMMENT"? *-->/<form action="comment.cgi" method="post">/;	
	$skelton =~ s/<!--#end +cmd="?COMMENT"? *-->/<\/form>/;	
    } else {
	$skelton =~ s/<!--#begin +cmd="?COMMENT"? *-->.*<!--#end +cmd="?COMMENT"? *-->//s;
    }
    $self->skelton($skelton);    # ޤ

    ################
    # 
    $self->SetMacro("RECENT", sub {
	my ($self, $cmd, $var) = @_;
	$var ||= $RECENT;
	my $href = (TDS::Mode::IsStatic()) ? 
	    "./$TDS::Static::RecentHtml" : "./TsDiary.cgi";
	return qq(<a href="$href">$var</a>);
    });
    $self->SetMacro("REFRESH", sub {
	return unless $TDS::System::CanUseCGI;
	my ($self, $cmd, $var) = @_;
	$var ||= $REFRESH;
	return qq(<a href="TsDiary.cgi?refresh=1">$var</a>);
    });
    $self->SetMacro("(FIRST|MIDDLE|LAST)_PART", sub {
	my ($self, $cmd, $var) = @_;
	require TDS::Navigator::Partly;
	my $nav = new TDS::Navigator::Partly(year=>$TDS::Status->year,
					     month=>$TDS::Status->month);
	$var ||= "$$cmd";
	if ($1 eq "FIRST"){
	    return $nav->AsFirst($var);
	} elsif ($1 eq "MIDDLE"){
	    return $nav->AsMiddle($var);
	} elsif ($1 eq "LAST"){
	    return $nav->AsLast($var);
	}
    });
	
    $self->SetMacro("(NEXT|PREV|THIS)_MONTH", sub {
	my ($self, $cmd, $var) = @_;
	require TDS::Navigator::Monthly;
	my $nav = new TDS::Navigator::Monthly(year=>$TDS::Status->year,
					      month=>$TDS::Status->month);
	$var ||= "$$cmd";
	if ($1 eq "NEXT"){
	    return $nav->AsNext($var);
	} elsif ($1 eq "THIS"){
	    return $nav->AsThis($var);
	} elsif ($1 eq "PREV"){
	    return $nav->AsPrev($var);
	}
    });
    $self->SetMacro("(NEXT|PREV|THIS)_DAY", sub {
	my ($self, $cmd, $var) = @_;
	require TDS::Navigator::Daily;
	my $nav = new TDS::Navigator::Daily(year=>$TDS::Status->year,
					    month=>$TDS::Status->month,
					    day=>$TDS::Status->day_part);
	$var ||= "$$cmd";
	if ($1 eq "NEXT"){
	    return $nav->AsNext($var);
	} elsif ($1 eq "THIS"){
	    return $nav->AsThis($var);
	} elsif ($1 eq "PREV"){
	    return $nav->AsPrev($var);
	}
    });
    $self->SetMacro("PREV_FEW_DAYS", sub {
	my ($self, $cmd, $var) = @_;
	require TDS::Navigator::FewDays;
	my $nav = new TDS::Navigator::FewDays(year=>$TDS::Status->year,
					      month=>$TDS::Status->month,
					      day=>$TDS::Status->day_part);
	$var ||= "$$cmd";
	return $nav->AsPrev($var, $col->last_day);
    });
    
    # ǯܻ
    $self->SetMacro("OTHER_MONTH_FORM", "<strong>deprecated: use SELECT_YEAR/MONTH/PART/CATEGORY,SUBMIT_JUMP</strong>");
    $self->SetMacro("CATEGORY", "<strong>Macro Name Changed: CATEGORY -> SELECT_CATEGORY</strong>");
    $self->SetMacro("YMD_JUMP", sub {
	my ($self, $cmd, $var) = @_;
	my $ymd = sprintf("%04d%02d%02d",
			  $TDS::Status->year,
			  $TDS::Status->month,
			  $TDS::Status->day_part);
	return qq(<form action="title.cgi" method="get">
		  <input type="text" name="keywords" value="$ymd">
		  <input type="submit" value="GO">
		  </form>);
    });

    $self->SetMacro("SELECT_(YEAR_MONTH|JUN|PART|CATEGORY)", sub {
	my ($self, $cmd, $var) = @_;
	
	return undef
	    unless $TDS::System::CanUseCGI;
	my @html;

	if ($1 eq 'YEAR_MONTH'){
	    push(@html, '<select name="year_month">');

	    for ($col->GetMonthDirs){
		my ($year, $month) = @$_;
		my $ym = sprintf("%04d/%02d", $year, $month);
		if ($TDS::Status->year == $year &&
		    $TDS::Status->month == $month){
		    push(@html, qq(<option value="$ym" selected>$ym</option>));
		} else {
		    push(@html, qq(<option value="$ym">$ym</option>));
		}
	    }
	    if (0){
		for (reverse($TDS::Status->start_year..$TDS::Status->year)){
		    my $year = $_;
		    for (reverse(1..12)){
			my $month = $_;
			my $ym = sprintf("%04d/%02d", $year, $month);
			if ($TDS::Status->year == $year &&
			    $TDS::Status->month == $month){
			    push(@html, qq(<option value="$ym" selected>$ym</option>));
			} else {
			    push(@html, qq(<option value="$ym">$ym</option>));
			}
		    }
		}
	    }
	} elsif ($1 eq 'JUN' || $1 eq 'PART'){
	    my @values = split(',', $explain->each_part);
	    push(@html, '<select name="part">');
	    my $start = ($TDS::Collection::AllowAllMonthly) ? 0 : 1;
	    my @table = ('', 'a', 'b', 'c');
	    for ($start..3){
		if (param('part') eq $table[$_]){
		    push(@html, qq(<option value="$table[$_]" selected>$values[$_]</option>));
		} else {
		    push(@html, qq(<option value="$table[$_]">$values[$_]</option>));
		}
	    }
	} elsif ($1 eq 'CATEGORY'){
#	    $var ||= "$$cmd";
	    $var = "ALL";
	    push(@html, $TDS::Status->category->AsHTML_Array($var));
	}
	push(@html, "</select>");
	return join("\n", @html);
    });
    # ֥ߥåȥ
    $self->SetMacro("SUBMIT_JUMP", sub {
	my ($self, $cmd, $var) = @_;
	return undef
	    unless $TDS::System::CanUseCGI;

	$var ||= "$$cmd";
	return qq(<input type="submit" value="$var">);
    });
    
    # 
    $self->SetMacro("SUMMARY", sub {
	my ($self, $cmd, $var) = @_;
	$var ||= "$$cmd";
	my $href = (TDS::Mode::IsStatic()) ?
	    "summary.html" : "summary.cgi";
	return qq(<a href="$href">$var</a>);
    });
    # ȥ
    $self->SetMacro("TITLE_SUMMARY", sub {
	my ($self, $cmd, $var) = @_;
	$var ||= "$$cmd";
	unless (TDS::Mode::IsStatic()){
	    my $query = $ENV{'QUERY_STRING'};
	    if ($query){
		$query = "?$query";
	    }
	    return qq(<a href="title.cgi$query">$var</a>);
	} else {
	    undef;
	}
    });
    # ѥ
    $self->SetMacro("POWER", sub {
	my ($self, $cmd, $var) = @_;
	unless ($TDS::System::CanUseCGI){
	    return undef;
	}
	$var ||= "$$cmd";
	my $query;
	if ($TDS::Status->GetMode() !~ /RECENT/){
	    $query = "?" . param('keywords');
	}
	return qq(<a href="power.cgi$query">$var</a>);
    });
    # 
    $self->SetMacro("CALENDAR", sub {
	my ($self, $cmd, $var) = @_;
	return undef if $TDS::Status->title_mode;
	
	require TDS::Calendar;
	my $calendar = new TDS::Calendar; #::Table;
	$calendar->AsHTML($TDS::Status->year, $TDS::Status->month, $col);
    });
    ################
    # 
    $self->SetMacro("SEARCH_([A-Z_]*)", sub {
	my ($self, $cmd, $var) = @_;
	$var ||= "$$cmd";

	require TDS::Search;
	
	return undef                # CGI should be enabled
	    unless ($TDS::System::CanUseCGI);
	
	if ($1 eq 'INPUT_KEYWORD'){
	    my $keyword = $TDS::Status->keyword->escaped || "";
	    return qq(<input type="text" name="keyword" value="$keyword" $var>);
	} elsif ($1 eq 'SUBMIT'){
	    return qq(<input type="submit" value="$var">);
	} elsif ($1 eq 'RESULT'){
	    return undef unless param('keyword');
	    return Expand($var, $params->{match});
	} elsif ($1 eq 'SELECT_SORT'){
	    my @list = split(",", $var);
	    my @html = (qq(<select name="search_sort">));
	    for ('last', 'old'){
		my $tmp = shift(@list);
		my $selected = (param('search_sort') eq $_) ? 'selected': '';
		push(@html, qq(<option value="$_" $selected>$tmp</option>));
	    }
	    push(@html, "</select>");
	    return join("\n", @html);
	} elsif ($1 eq 'SELECT_OBJECT'){
	    my @list = split(",", $var);
	    my @html = (qq(<select name="search_object">));

	    my $type;
	    for $type ('this', 'recent', 'year', 'all'){
		my $tmp = shift(@list);
		if ($type eq 'all'){
		    if(&TDS::Mode::GetMode() eq 'dynamic' &&
		       !$TDS::Status->is_author &&
		       !$TDS::Search::AllowAllSearch){
			next;
		    }
		}
		my $selected = (param('search_object') eq $type) ? 'selected': '';
		push(@html, qq(<option value="$type" $selected>$tmp</option>));
	    }
	    push(@html, "</select>");
	    return join("\n", @html);
	} elsif ($1 eq 'CHECKBOX_TITLEONLY'){
	    my $checked = (param('search_titleonly')) ? 'checked' : '';
	    return qq(<input type="checkbox" name="search_titleonly" $checked>$var);
	} elsif ($1 eq 'CHECKBOX_IGNORECASE'){
	    if ($TDS::Search::UseSignatureMethod){
		# ͥˡȤ ignorecase Ǥʤ
		return undef;
	    } else {
		my $checked = (param('search_ignorecase')) ? 'checked' : '';
		return qq(<input type="checkbox" name="search_ignorecase" $checked>$var);
	    }
	} elsif ($1 eq 'CHECKBOX_UNUSE_SIGNATURE_METHOD'){
	    my $checked = (param('search_unuse_signature_method')) ? 'checked' : '';
	    if ($TDS::Search::UseSignatureMethod){
		return qq(<input type="checkbox" name="search_unuse_signature_method" $checked>$var);
	    } else {
		return undef;
	    }
	}

    });
    ################
    # ղõǽ
    # ܼ
    $self->SetMacro("TOC|TABLE_OF_CONTENTS", sub {
	my ($self, $cmd, $var) = @_;

	return $params->{_toc}->AsHTML
	    if ref $params->{_toc};
    });
	
    # URL ꥹɽ
    $self->SetMacro("URL_LIST", sub {
	my ($self, $cmd, $var) = @_;
	$var ||= "$$cmd";
	return sprintf(qq(<a href="%s">$var</a>),
		       (TDS::Mode::IsStatic()) ?
		       "url.html" : "url.cgi");
    });
    # 
    $self->SetMacro("DICTIONARY", sub {
	my ($self, $cmd, $var) = @_;
	$var ||= "$$cmd";
	return sprintf(qq(<a href="%s">$var</a>),
		       (TDS::Mode::IsStatic()) ?
		       "dictionary.html" : "dictionary.cgi");
    });
    # Դ
    $self->SetMacro("AUTHOR_MANAGEMENT", sub {
	return undef unless $TDS::System::CanUseCGI;
	
	my ($self, $cmd, $var) = @_;
	$var ||= "$$cmd";
	return qq(<a href="admin/">$var</a>);
    });
    # TdfEditor
    $self->SetMacro("TDF_EDITOR", sub {
	return undef unless $TDS::System::CanUseCGI;
	
	my ($self, $cmd, $var) = @_;
	$var ||= "$$cmd";
	return qq(<a href="admin/tdf_editor.cgi">$var</a>);
    });

    # 
    $self->SetMacro("LOG_ANALYSE(_ANCHOR)?", sub {
	return undef unless $TDS::AccessLog::EnableAccessLog;
	
	my ($self, $cmd, $var) = @_;
	$var ||= "$$cmd";

	return sprintf(qq(<a href="admin/log.cgi?year=%04d&amp;month=%02d">$var</a>),
		       $TDS::Status->year, $TDS::Status->month);
    });
    # ǽ
    $self->SetMacro("COMMENT_([A-Z_]+)", sub {
	require TDS::Comment;
	my ($self, $cmd, $var) = @_;
	if ($1 eq "INPUT_NAME"){
	    unless ($TDS::Status->request_uri){    # html
		return qq(<input type="text" name="name" value="<!--\#exec cgi='comment_name.cgi' -->" $var>);
	    } else {
		my $name = GetCookie('name');
		return qq(<!-- BEGIN @@@ $cmd @@@ --><input type="text" name="name" value="$name" $var><!-- END @@@ $cmd @@@ -->);
	    }
	} elsif ($1 eq "INPUT_CONTENT"){
	    return qq(<input type="text" name="comment" value="$TDS::Comment::DefaultComment" $var>);
	} elsif ($1 eq "SUBMIT"){
	    $var ||= "$$cmd";
	    return qq(<input type="submit" name="add" value="$var">);
	} elsif ($1 eq "SHOW_ALL_SUBMIT"){
	    $var ||= "$$cmd";
	    return qq(<input type="submit" name="show_all" value="$var">);
	} elsif ($1 eq "SHOW"){
	    $var ||= 5;
	    if ($TDS::Status->request_uri){   # CGI
		my $cmt = new TDS::Comment;
#		return "<!-- BEGIN @@@ $cmd @@@ -->" . $cmt->AsHTML .
#		    "<!-- END @@@ $cmd @@@ -->";
		return $cmt->AsHTML;
	    } elsif (!$TDS::System::CanUseSSI){
		# SSI is required in static mode
		warn qq(<!--\#macro cmd="COMMENT_SHOW" --> : must be able to use SSI);
	    } else {                           # output to file
		return qq(<!--\#exec cgi="comment_show.cgi" -->);
	    }
	} elsif ($1 eq "COOKIE_OK"){
	    $var ||= "$$cmd";
	    return qq(<input type="checkbox" name="cookie_ok" checked>$var\n);
	}
	    
    });
    ################################################################
    return join("", $self->SUPER::AsHTML);
}

################################################################
sub IllegalConfig($)
{
    my $msg = shift;

    die "<h2>illegal configuration in skelton.html</h2><p>$msg</p>";
}
1;
