# NOTE: Derived from web_diary_dir/lib/TDS/Collection.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package TDS::Collection;

#line 285 "web_diary_dir/lib/TDS/Collection.pm (autosplit into web_diary_dir/lib/auto/TDS/Collection/pickup_files.al)"
################################################################


sub pickup_files($$$$$)
{
    my ($self, $year, $month, $min_day, $max_day) = @_;

    $month = sprintf("%02d", $month);

    #print STDERR caller;
    my $dir = GetDiaryDir() . "/$year/$month";
    opendir(DIR, $dir) || return ();
    my @files;
    for (sort readdir(DIR)){
#    for (($rvs)? reverse sort readdir(DIR) : sort readdir(DIR)){
	my $file = $_;
	my $d;
	next unless $file =~ /^(\d\d)\.tdf$/;    # must be DD.tdf
	$d = $1;
	next unless ($d >= 1 && $d <= DaysMonth($year, $month)); # valid date
	next if -z "$dir/$file";                    # must be not empty
	#print "$file, ";
	my $flg;
	if ($min_day == 0){    # monthly
	    $flg = 1;
	} else {               # day or partly
	    $flg = ($d >= $min_day && $d <= $max_day);
	}
	if ($flg){
	    my $lm = (stat("$dir/$file"))[9];
	    if ($self->last_modified < $lm){
		$self->last_modified($lm);
	    }
	    push(@files, ["$dir/$file", $year, $month, $d, $lm]);
	}
    }
    closedir(DIR);

    return @files;
}

# end of TDS::Collection::pickup_files
1;
