/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd;

import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.output.xsd.basic.AbstractAttributeUseVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.Annotated;
import com.thaiopensource.relaxng.output.xsd.basic.Attribute;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroup;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroupDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroupRef;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUse;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUseChoice;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexType;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeComplexContent;
import com.thaiopensource.relaxng.output.xsd.basic.Element;
import com.thaiopensource.relaxng.output.xsd.basic.Facet;
import com.thaiopensource.relaxng.output.xsd.basic.GroupRef;
import com.thaiopensource.relaxng.output.xsd.basic.Occurs;
import com.thaiopensource.relaxng.output.xsd.basic.OptionalAttribute;
import com.thaiopensource.relaxng.output.xsd.basic.Particle;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleAll;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleChoice;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleRepeat;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleSequence;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.Schema;
import com.thaiopensource.relaxng.output.xsd.basic.SchemaTransformer;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleType;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeRestriction;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeUnion;
import com.thaiopensource.relaxng.output.xsd.basic.SingleAttributeUse;
import com.thaiopensource.relaxng.output.xsd.basic.Wildcard;
import com.thaiopensource.relaxng.output.xsd.basic.WildcardAttribute;
import com.thaiopensource.relaxng.output.xsd.basic.WildcardElement;
import com.thaiopensource.util.Equal;
import com.thaiopensource.xml.util.Name;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

class Transformer
extends SchemaTransformer {
    private final AttributeMapper attributeMapper = new AttributeMapper();
    private final Set<String> transformedAttributeGroups = new HashSet<String>();
    private final ErrorReporter er;
    private boolean preserveAllGroup = false;

    Transformer(Schema schema, ErrorReporter errorReporter) {
        super(schema);
        this.er = errorReporter;
    }

    @Override
    public SimpleType visitUnion(SimpleTypeUnion simpleTypeUnion) {
        List<SimpleType> list = this.transformSimpleTypeList(simpleTypeUnion.getChildren());
        SimpleType simpleType = Transformer.combineEnumeration(simpleTypeUnion, list);
        if (simpleType != null) {
            return simpleType;
        }
        return new SimpleTypeUnion(simpleTypeUnion.getLocation(), simpleTypeUnion.getAnnotation(), list);
    }

    private static SimpleType combineEnumeration(SimpleTypeUnion simpleTypeUnion, List<SimpleType> list) {
        if (list.size() < 2) {
            return null;
        }
        SimpleType simpleType = list.get(0);
        if (!(simpleType instanceof SimpleTypeRestriction)) {
            return null;
        }
        String string = ((SimpleTypeRestriction)simpleType).getName();
        Vector<Facet> vector = new Vector<Facet>();
        for (SimpleType simpleType2 : list) {
            if (!(simpleType2 instanceof SimpleTypeRestriction)) {
                return null;
            }
            SimpleTypeRestriction simpleTypeRestriction = (SimpleTypeRestriction)simpleType2;
            if (!simpleTypeRestriction.getName().equals(string)) {
                return null;
            }
            if (simpleTypeRestriction.getFacets().isEmpty()) {
                return null;
            }
            for (Facet facet : simpleTypeRestriction.getFacets()) {
                if (!facet.getName().equals("enumeration")) {
                    return null;
                }
                vector.add(facet);
            }
        }
        return new SimpleTypeRestriction(simpleTypeUnion.getLocation(), simpleTypeUnion.getAnnotation(), string, vector);
    }

    @Override
    public Particle visitAll(ParticleAll particleAll) {
        if (this.preserveAllGroup) {
            this.preserveAllGroup = false;
            return super.visitAll(particleAll);
        }
        return new ParticleRepeat(particleAll.getLocation(), particleAll.getAnnotation(), new ParticleChoice(particleAll.getLocation(), null, new AllBodyTransformer(this.getSchema()).transformParticleList(this.transformParticleList(particleAll.getChildren()))), Occurs.ZERO_OR_MORE);
    }

    @Override
    public AttributeUse visitAttributeGroup(AttributeGroup attributeGroup) {
        Object object;
        List<AttributeUse> list = this.transformAttributeUseList(attributeGroup.getChildren());
        Object object2 = null;
        boolean[] blArray = new boolean[list.size()];
        boolean bl = false;
        int n = -1;
        for (int i = 0; i < blArray.length; ++i) {
            Wildcard wildcard = this.attributeMapper.getAttributeWildcard(list.get(i));
            if (wildcard == null) continue;
            if (object2 == null) {
                object2 = wildcard;
                n = i;
                continue;
            }
            bl = true;
            object = Wildcard.union((Wildcard)object2, wildcard);
            if (((Wildcard)object).equals(object2)) {
                blArray[i] = true;
                continue;
            }
            if (((Wildcard)object).equals(wildcard)) {
                if (n >= 0) {
                    blArray[n] = true;
                }
                n = i;
                object2 = wildcard;
                continue;
            }
            blArray[i] = true;
            if (n >= 0) {
                blArray[n] = true;
            }
            object2 = object;
            n = -1;
        }
        if (!bl) {
            if (list == attributeGroup.getChildren()) {
                return attributeGroup;
            }
            return new AttributeGroup(attributeGroup.getLocation(), attributeGroup.getAnnotation(), list);
        }
        Vector<AttributeUse> vector = new Vector<AttributeUse>();
        for (int i = 0; i < blArray.length; ++i) {
            object = list.get(i);
            if (blArray[i]) {
                object = ((AttributeUse)object).accept(new AttributeTransformer(null, null, false));
            }
            vector.add((AttributeUse)object);
        }
        if (n == -1) {
            vector.add(new WildcardAttribute(attributeGroup.getLocation(), null, (Wildcard)object2));
        }
        return new AttributeGroup(attributeGroup.getLocation(), attributeGroup.getAnnotation(), vector);
    }

    @Override
    public AttributeUse visitAttributeUseChoice(AttributeUseChoice attributeUseChoice) {
        Object object;
        Object object2;
        List<AttributeUse> list = this.transformAttributeUseList(attributeUseChoice.getChildren());
        Map[] mapArray = new Map[list.size()];
        int n = -1;
        Object object3 = null;
        for (int i = 0; i < mapArray.length; ++i) {
            mapArray[i] = this.attributeMapper.getAttributeMap(list.get(i));
            object2 = this.attributeMapper.getAttributeWildcard(list.get(i));
            if (object2 == null) continue;
            if (object3 == null) {
                object3 = object2;
                n = i;
                continue;
            }
            Wildcard wildcard = Wildcard.union((Wildcard)object3, (Wildcard)object2);
            if (wildcard.equals(object3)) continue;
            n = wildcard.equals(object2) ? i : -1;
            object3 = wildcard;
        }
        HashSet<Name> hashSet = new HashSet<Name>();
        object2 = new HashSet(mapArray[0].keySet());
        for (int i = 1; i < mapArray.length; ++i) {
            object2.addAll(mapArray[i].keySet());
        }
        Set[] setArray = new Set[list.size()];
        for (int i = 0; i < setArray.length; ++i) {
            setArray[i] = new HashSet();
        }
        Vector<AttributeUse> vector = new Vector<AttributeUse>();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = (Name)iterator.next();
            if (object3 != null && ((Wildcard)object3).contains((Name)object)) continue;
            SingleAttributeUse[] singleAttributeUseArray = new SingleAttributeUse[mapArray.length];
            int n2 = -1;
            boolean bl = true;
            for (int i = 0; i < mapArray.length; ++i) {
                singleAttributeUseArray[i] = (SingleAttributeUse)mapArray[i].get(object);
                if (singleAttributeUseArray[i] != null) {
                    if (n2 >= 0) {
                        n2 = -2;
                    } else if (n2 == -1) {
                        n2 = i;
                    }
                    if (!singleAttributeUseArray[i].isOptional()) continue;
                    bl = false;
                    continue;
                }
                bl = false;
            }
            if (bl) {
                hashSet.add((Name)object);
            }
            if (n2 < 0) {
                n2 = Transformer.chooseUseIndex(singleAttributeUseArray);
            }
            if (n2 >= 0) {
                setArray[n2].add(object);
                continue;
            }
            Vector<SimpleType> vector2 = new Vector<SimpleType>();
            for (int i = 0; i < singleAttributeUseArray.length; ++i) {
                if (singleAttributeUseArray[i] == null || singleAttributeUseArray[i].getType() == null) continue;
                vector2.add(singleAttributeUseArray[i].getType());
            }
            Attribute attribute = new Attribute(attributeUseChoice.getLocation(), null, (Name)object, new SimpleTypeUnion(attributeUseChoice.getLocation(), null, vector2).accept(this));
            if (bl) {
                vector.add(attribute);
                continue;
            }
            vector.add(new OptionalAttribute(attributeUseChoice.getLocation(), null, attribute, null));
        }
        for (int i = 0; i < setArray.length; ++i) {
            object = list.get(i).accept(new AttributeTransformer(setArray[i], hashSet, i == n));
            if (((Annotated)object).equals(AttributeGroup.EMPTY)) continue;
            vector.add((AttributeUse)object);
        }
        if (object3 != null && n == -1) {
            vector.add(new WildcardAttribute(attributeUseChoice.getLocation(), null, (Wildcard)object3));
        }
        return new AttributeGroup(attributeUseChoice.getLocation(), attributeUseChoice.getAnnotation(), vector);
    }

    private static int chooseUseIndex(SingleAttributeUse[] singleAttributeUseArray) {
        int n;
        for (n = 0; n < singleAttributeUseArray.length; ++n) {
            if (singleAttributeUseArray[n] == null || singleAttributeUseArray[n].getType() != null || singleAttributeUseArray[n].getDefaultValue() != null) continue;
            return n;
        }
        n = -1;
        for (int i = 0; i < singleAttributeUseArray.length; ++i) {
            if (singleAttributeUseArray[i] == null) continue;
            if (n == -1) {
                n = i;
                continue;
            }
            if (Equal.equal(singleAttributeUseArray[i].getType(), singleAttributeUseArray[n].getType()) && Equal.equal(singleAttributeUseArray[i].getDefaultValue(), singleAttributeUseArray[n].getDefaultValue())) continue;
            return -1;
        }
        return n;
    }

    @Override
    public void visitAttributeGroup(AttributeGroupDefinition attributeGroupDefinition) {
        attributeGroupDefinition.setAttributeUses(this.getTransformedAttributeGroup(attributeGroupDefinition.getName()));
    }

    private AttributeUse getTransformedAttributeGroup(String string) {
        AttributeGroupDefinition attributeGroupDefinition = this.getSchema().getAttributeGroup(string);
        if (!this.transformedAttributeGroups.contains(string)) {
            attributeGroupDefinition.setAttributeUses(attributeGroupDefinition.getAttributeUses().accept(this));
            this.transformedAttributeGroups.add(string);
        }
        return attributeGroupDefinition.getAttributeUses();
    }

    @Override
    public Particle visitElement(Element element) {
        if (Transformer.containsLegalAllGroup(element)) {
            this.preserveAllGroup = true;
        }
        return super.visitElement(element);
    }

    private static boolean containsLegalAllGroup(Element element) {
        ComplexType complexType = element.getComplexType();
        if (!(complexType instanceof ComplexTypeComplexContent)) {
            return false;
        }
        Particle particle = ((ComplexTypeComplexContent)complexType).getParticle();
        if (!(particle instanceof ParticleAll)) {
            return false;
        }
        String string = element.getName().getNamespaceUri();
        for (Particle particle2 : ((ParticleAll)particle).getChildren()) {
            if (particle2 instanceof ParticleRepeat) {
                Occurs occurs = ((ParticleRepeat)particle2).getOccurs();
                if (occurs.getMin() > 1 || occurs.getMax() > 1) {
                    return false;
                }
                particle2 = ((ParticleRepeat)particle2).getChild();
            }
            if (!(particle2 instanceof Element)) {
                return false;
            }
            if (((Element)particle2).getName().getNamespaceUri().equals(string)) continue;
            return false;
        }
        return true;
    }

    class AttributeMapper
    extends AbstractAttributeUseVisitor<AttributeInfo> {
        private final Map<AttributeUse, AttributeInfo> cache = new HashMap<AttributeUse, AttributeInfo>();

        AttributeMapper() {
        }

        Map<Name, SingleAttributeUse> getAttributeMap(AttributeUse attributeUse) {
            return this.getAttributeInfo((AttributeUse)attributeUse).map;
        }

        Wildcard getAttributeWildcard(AttributeUse attributeUse) {
            return this.getAttributeInfo((AttributeUse)attributeUse).wildcard;
        }

        private AttributeInfo getAttributeInfo(AttributeUse attributeUse) {
            AttributeInfo attributeInfo = this.cache.get(attributeUse);
            if (attributeInfo == null) {
                attributeInfo = attributeUse.accept(this);
                this.cache.put(attributeUse, attributeInfo);
            }
            return attributeInfo;
        }

        @Override
        public AttributeInfo visitAttribute(Attribute attribute) {
            HashMap<Name, SingleAttributeUse> hashMap = new HashMap<Name, SingleAttributeUse>();
            hashMap.put(attribute.getName(), attribute);
            return new AttributeInfo(hashMap, null);
        }

        @Override
        public AttributeInfo visitAttributeGroup(AttributeGroup attributeGroup) {
            HashMap<Name, SingleAttributeUse> hashMap = new HashMap<Name, SingleAttributeUse>();
            Wildcard wildcard = null;
            for (AttributeUse attributeUse : attributeGroup.getChildren()) {
                AttributeInfo attributeInfo = this.getAttributeInfo(attributeUse);
                if (attributeInfo.wildcard != null) {
                    wildcard = attributeInfo.wildcard;
                }
                hashMap.putAll(attributeInfo.map);
            }
            return new AttributeInfo(hashMap, wildcard);
        }

        @Override
        public AttributeInfo visitOptionalAttribute(OptionalAttribute optionalAttribute) {
            HashMap<Name, SingleAttributeUse> hashMap = new HashMap<Name, SingleAttributeUse>();
            hashMap.put(optionalAttribute.getAttribute().getName(), optionalAttribute);
            return new AttributeInfo(hashMap, null);
        }

        @Override
        public AttributeInfo visitAttributeGroupRef(AttributeGroupRef attributeGroupRef) {
            return this.getAttributeInfo(Transformer.this.getTransformedAttributeGroup(attributeGroupRef.getName()));
        }

        @Override
        public AttributeInfo visitWildcardAttribute(WildcardAttribute wildcardAttribute) {
            return new AttributeInfo(AttributeInfo.EMPTY_MAP, wildcardAttribute.getWildcard());
        }
    }

    class AllBodyTransformer
    extends SchemaTransformer {
        public AllBodyTransformer(Schema schema) {
            super(schema);
        }

        @Override
        public Particle visitGroupRef(GroupRef groupRef) {
            if (new SequenceDetector().visitGroupRef(groupRef) == Boolean.FALSE) {
                return groupRef;
            }
            return this.getSchema().getGroup(groupRef.getName()).getParticle().accept(this);
        }

        @Override
        public Particle visitSequence(ParticleSequence particleSequence) {
            return new ParticleChoice(particleSequence.getLocation(), particleSequence.getAnnotation(), this.transformParticleList(particleSequence.getChildren()));
        }

        @Override
        public Particle visitRepeat(ParticleRepeat particleRepeat) {
            return particleRepeat.getChild().accept(this);
        }

        @Override
        public Particle visitElement(Element element) {
            return Transformer.this.visitElement(element);
        }
    }

    class AttributeTransformer
    extends AbstractAttributeUseVisitor<AttributeUse> {
        private final Set<Name> retainNames;
        private final Set<Name> requiredNames;
        private final boolean retainWildcard;

        public AttributeTransformer(Set<Name> set, Set<Name> set2, boolean bl) {
            this.retainNames = set;
            this.requiredNames = set2;
            this.retainWildcard = bl;
        }

        @Override
        public AttributeUse visitAttribute(Attribute attribute) {
            if (this.retainNames != null && !this.retainNames.contains(attribute.getName())) {
                return AttributeGroup.EMPTY;
            }
            if (this.requiredNames != null && !this.requiredNames.contains(attribute.getName())) {
                return new OptionalAttribute(attribute.getLocation(), null, attribute, null);
            }
            return attribute;
        }

        @Override
        public AttributeUse visitOptionalAttribute(OptionalAttribute optionalAttribute) {
            if (this.retainNames != null && !this.retainNames.contains(optionalAttribute.getName())) {
                return AttributeGroup.EMPTY;
            }
            return optionalAttribute;
        }

        @Override
        public AttributeUse visitWildcardAttribute(WildcardAttribute wildcardAttribute) {
            if (!this.retainWildcard) {
                return AttributeGroup.EMPTY;
            }
            return wildcardAttribute;
        }

        @Override
        public AttributeUse visitAttributeGroupRef(AttributeGroupRef attributeGroupRef) {
            AttributeUse attributeUse = Transformer.this.getTransformedAttributeGroup(attributeGroupRef.getName());
            if (this.isOk(Transformer.this.attributeMapper.getAttributeMap(attributeUse)) && (this.retainWildcard || Transformer.this.attributeMapper.getAttributeWildcard(attributeUse) == null)) {
                return attributeGroupRef;
            }
            return attributeUse.accept(this);
        }

        private boolean isOk(Map<Name, SingleAttributeUse> map) {
            for (Map.Entry<Name, SingleAttributeUse> entry : map.entrySet()) {
                Name name = entry.getKey();
                SingleAttributeUse singleAttributeUse = entry.getValue();
                if (this.retainNames != null && !this.retainNames.contains(name)) {
                    return false;
                }
                if (this.requiredNames == null || singleAttributeUse.isOptional() || this.requiredNames.contains(name)) continue;
                return false;
            }
            return true;
        }

        @Override
        public AttributeUse visitAttributeGroup(AttributeGroup attributeGroup) {
            List<AttributeUse> list = attributeGroup.getChildren();
            Vector<AttributeUse> vector = null;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                AttributeUse attributeUse = list.get(i).accept(this);
                if (vector != null) {
                    if (attributeUse.equals(AttributeGroup.EMPTY)) continue;
                    vector.add(attributeUse);
                    continue;
                }
                if (attributeUse == list.get(i)) continue;
                vector = new Vector<AttributeUse>();
                for (int j = 0; j < i; ++j) {
                    vector.add(list.get(j));
                }
                if (attributeUse.equals(AttributeGroup.EMPTY)) continue;
                vector.add(attributeUse);
            }
            if (vector == null) {
                return attributeGroup;
            }
            return new AttributeGroup(attributeGroup.getLocation(), attributeGroup.getAnnotation(), vector);
        }
    }

    static class AttributeInfo {
        final Map<Name, SingleAttributeUse> map;
        final Wildcard wildcard;
        static final Map<Name, SingleAttributeUse> EMPTY_MAP = Collections.emptyMap();

        AttributeInfo(Map<Name, SingleAttributeUse> map, Wildcard wildcard) {
            this.map = map;
            this.wildcard = wildcard;
        }
    }

    class SequenceDetector
    implements ParticleVisitor<Boolean> {
        SequenceDetector() {
        }

        @Override
        public Boolean visitElement(Element element) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitWildcardElement(WildcardElement wildcardElement) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitSequence(ParticleSequence particleSequence) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean visitGroupRef(GroupRef groupRef) {
            return Transformer.this.getSchema().getGroup(groupRef.getName()).getParticle().accept(this);
        }

        @Override
        public Boolean visitAll(ParticleAll particleAll) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitRepeat(ParticleRepeat particleRepeat) {
            return particleRepeat.getChild().accept(this);
        }

        @Override
        public Boolean visitChoice(ParticleChoice particleChoice) {
            for (Particle particle : particleChoice.getChildren()) {
                if (particle.accept(this) != Boolean.TRUE) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }
}

