/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xml;

import java.util.Vector;

public class ObjectPool {
    private final Class objectType;
    private final Vector freeStack;

    public ObjectPool(Class clazz) {
        this.objectType = clazz;
        this.freeStack = new Vector();
    }

    public ObjectPool(Class clazz, int n) {
        this.objectType = clazz;
        this.freeStack = new Vector(n);
    }

    public ObjectPool() {
        this.objectType = null;
        this.freeStack = new Vector();
    }

    public synchronized Object getInstanceIfFree() {
        if (!this.freeStack.isEmpty()) {
            Object e = this.freeStack.lastElement();
            this.freeStack.setSize(this.freeStack.size() - 1);
            return e;
        }
        return null;
    }

    public synchronized Object getInstance() {
        if (this.freeStack.isEmpty()) {
            try {
                return this.objectType.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            throw new RuntimeException("exception creating new instance for pool");
        }
        Object e = this.freeStack.lastElement();
        this.freeStack.setSize(this.freeStack.size() - 1);
        return e;
    }

    public synchronized void freeInstance(Object object) {
        if (this.objectType.isInstance(object)) {
            this.freeStack.addElement(object);
            return;
        }
        throw new IllegalArgumentException("argument type invalid for pool");
    }
}

