/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.bv;

import java.io.Serializable;
import java.util.Arrays;
import org.trie4j.bv.SuccinctBitVector;
import org.trie4j.util.IntArray;

public class LongsSuccinctBitVector
implements Serializable,
SuccinctBitVector {
    static final int BITS_IN_BLOCK = 64;
    static final int BITS_IN_COUNTCACHE0 = 64;
    static final int ZEROBITS_IN_EACH_INDEX = 64;
    private long[] longs;
    private int size;
    private int size0;
    private int node1pos = -1;
    private int node2pos = -1;
    private int node3pos = -1;
    private int[] countCache0;
    private IntArray indexCache0;
    private static final byte[] BITCOUNTS0 = new byte[]{8, 7, 7, 6, 7, 6, 6, 5, 7, 6, 6, 5, 6, 5, 5, 4, 7, 6, 6, 5, 6, 5, 5, 4, 6, 5, 5, 4, 5, 4, 4, 3, 7, 6, 6, 5, 6, 5, 5, 4, 6, 5, 5, 4, 5, 4, 4, 3, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 7, 6, 6, 5, 6, 5, 5, 4, 6, 5, 5, 4, 5, 4, 4, 3, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 5, 4, 4, 3, 4, 3, 3, 2, 4, 3, 3, 2, 3, 2, 2, 1, 7, 6, 6, 5, 6, 5, 5, 4, 6, 5, 5, 4, 5, 4, 4, 3, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 5, 4, 4, 3, 4, 3, 3, 2, 4, 3, 3, 2, 3, 2, 2, 1, 6, 5, 5, 4, 5, 4, 4, 3, 5, 4, 4, 3, 4, 3, 3, 2, 5, 4, 4, 3, 4, 3, 3, 2, 4, 3, 3, 2, 3, 2, 2, 1, 5, 4, 4, 3, 4, 3, 3, 2, 4, 3, 3, 2, 3, 2, 2, 1, 4, 3, 3, 2, 3, 2, 2, 1, 3, 2, 2, 1, 2, 1, 1, 0};
    private static final byte[][] BITPOS0 = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6}, {0, 1, 2, 3, 4, 5, 7}, {0, 1, 2, 3, 4, 5}, {0, 1, 2, 3, 4, 6, 7}, {0, 1, 2, 3, 4, 6}, {0, 1, 2, 3, 4, 7}, {0, 1, 2, 3, 4}, {0, 1, 2, 3, 5, 6, 7}, {0, 1, 2, 3, 5, 6}, {0, 1, 2, 3, 5, 7}, {0, 1, 2, 3, 5}, {0, 1, 2, 3, 6, 7}, {0, 1, 2, 3, 6}, {0, 1, 2, 3, 7}, {0, 1, 2, 3}, {0, 1, 2, 4, 5, 6, 7}, {0, 1, 2, 4, 5, 6}, {0, 1, 2, 4, 5, 7}, {0, 1, 2, 4, 5}, {0, 1, 2, 4, 6, 7}, {0, 1, 2, 4, 6}, {0, 1, 2, 4, 7}, {0, 1, 2, 4}, {0, 1, 2, 5, 6, 7}, {0, 1, 2, 5, 6}, {0, 1, 2, 5, 7}, {0, 1, 2, 5}, {0, 1, 2, 6, 7}, {0, 1, 2, 6}, {0, 1, 2, 7}, {0, 1, 2}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6}, {0, 1, 3, 4, 5, 7}, {0, 1, 3, 4, 5}, {0, 1, 3, 4, 6, 7}, {0, 1, 3, 4, 6}, {0, 1, 3, 4, 7}, {0, 1, 3, 4}, {0, 1, 3, 5, 6, 7}, {0, 1, 3, 5, 6}, {0, 1, 3, 5, 7}, {0, 1, 3, 5}, {0, 1, 3, 6, 7}, {0, 1, 3, 6}, {0, 1, 3, 7}, {0, 1, 3}, {0, 1, 4, 5, 6, 7}, {0, 1, 4, 5, 6}, {0, 1, 4, 5, 7}, {0, 1, 4, 5}, {0, 1, 4, 6, 7}, {0, 1, 4, 6}, {0, 1, 4, 7}, {0, 1, 4}, {0, 1, 5, 6, 7}, {0, 1, 5, 6}, {0, 1, 5, 7}, {0, 1, 5}, {0, 1, 6, 7}, {0, 1, 6}, {0, 1, 7}, {0, 1}, {0, 2, 3, 4, 5, 6, 7}, {0, 2, 3, 4, 5, 6}, {0, 2, 3, 4, 5, 7}, {0, 2, 3, 4, 5}, {0, 2, 3, 4, 6, 7}, {0, 2, 3, 4, 6}, {0, 2, 3, 4, 7}, {0, 2, 3, 4}, {0, 2, 3, 5, 6, 7}, {0, 2, 3, 5, 6}, {0, 2, 3, 5, 7}, {0, 2, 3, 5}, {0, 2, 3, 6, 7}, {0, 2, 3, 6}, {0, 2, 3, 7}, {0, 2, 3}, {0, 2, 4, 5, 6, 7}, {0, 2, 4, 5, 6}, {0, 2, 4, 5, 7}, {0, 2, 4, 5}, {0, 2, 4, 6, 7}, {0, 2, 4, 6}, {0, 2, 4, 7}, {0, 2, 4}, {0, 2, 5, 6, 7}, {0, 2, 5, 6}, {0, 2, 5, 7}, {0, 2, 5}, {0, 2, 6, 7}, {0, 2, 6}, {0, 2, 7}, {0, 2}, {0, 3, 4, 5, 6, 7}, {0, 3, 4, 5, 6}, {0, 3, 4, 5, 7}, {0, 3, 4, 5}, {0, 3, 4, 6, 7}, {0, 3, 4, 6}, {0, 3, 4, 7}, {0, 3, 4}, {0, 3, 5, 6, 7}, {0, 3, 5, 6}, {0, 3, 5, 7}, {0, 3, 5}, {0, 3, 6, 7}, {0, 3, 6}, {0, 3, 7}, {0, 3}, {0, 4, 5, 6, 7}, {0, 4, 5, 6}, {0, 4, 5, 7}, {0, 4, 5}, {0, 4, 6, 7}, {0, 4, 6}, {0, 4, 7}, {0, 4}, {0, 5, 6, 7}, {0, 5, 6}, {0, 5, 7}, {0, 5}, {0, 6, 7}, {0, 6}, {0, 7}, {0}, {1, 2, 3, 4, 5, 6, 7}, {1, 2, 3, 4, 5, 6}, {1, 2, 3, 4, 5, 7}, {1, 2, 3, 4, 5}, {1, 2, 3, 4, 6, 7}, {1, 2, 3, 4, 6}, {1, 2, 3, 4, 7}, {1, 2, 3, 4}, {1, 2, 3, 5, 6, 7}, {1, 2, 3, 5, 6}, {1, 2, 3, 5, 7}, {1, 2, 3, 5}, {1, 2, 3, 6, 7}, {1, 2, 3, 6}, {1, 2, 3, 7}, {1, 2, 3}, {1, 2, 4, 5, 6, 7}, {1, 2, 4, 5, 6}, {1, 2, 4, 5, 7}, {1, 2, 4, 5}, {1, 2, 4, 6, 7}, {1, 2, 4, 6}, {1, 2, 4, 7}, {1, 2, 4}, {1, 2, 5, 6, 7}, {1, 2, 5, 6}, {1, 2, 5, 7}, {1, 2, 5}, {1, 2, 6, 7}, {1, 2, 6}, {1, 2, 7}, {1, 2}, {1, 3, 4, 5, 6, 7}, {1, 3, 4, 5, 6}, {1, 3, 4, 5, 7}, {1, 3, 4, 5}, {1, 3, 4, 6, 7}, {1, 3, 4, 6}, {1, 3, 4, 7}, {1, 3, 4}, {1, 3, 5, 6, 7}, {1, 3, 5, 6}, {1, 3, 5, 7}, {1, 3, 5}, {1, 3, 6, 7}, {1, 3, 6}, {1, 3, 7}, {1, 3}, {1, 4, 5, 6, 7}, {1, 4, 5, 6}, {1, 4, 5, 7}, {1, 4, 5}, {1, 4, 6, 7}, {1, 4, 6}, {1, 4, 7}, {1, 4}, {1, 5, 6, 7}, {1, 5, 6}, {1, 5, 7}, {1, 5}, {1, 6, 7}, {1, 6}, {1, 7}, {1}, {2, 3, 4, 5, 6, 7}, {2, 3, 4, 5, 6}, {2, 3, 4, 5, 7}, {2, 3, 4, 5}, {2, 3, 4, 6, 7}, {2, 3, 4, 6}, {2, 3, 4, 7}, {2, 3, 4}, {2, 3, 5, 6, 7}, {2, 3, 5, 6}, {2, 3, 5, 7}, {2, 3, 5}, {2, 3, 6, 7}, {2, 3, 6}, {2, 3, 7}, {2, 3}, {2, 4, 5, 6, 7}, {2, 4, 5, 6}, {2, 4, 5, 7}, {2, 4, 5}, {2, 4, 6, 7}, {2, 4, 6}, {2, 4, 7}, {2, 4}, {2, 5, 6, 7}, {2, 5, 6}, {2, 5, 7}, {2, 5}, {2, 6, 7}, {2, 6}, {2, 7}, {2}, {3, 4, 5, 6, 7}, {3, 4, 5, 6}, {3, 4, 5, 7}, {3, 4, 5}, {3, 4, 6, 7}, {3, 4, 6}, {3, 4, 7}, {3, 4}, {3, 5, 6, 7}, {3, 5, 6}, {3, 5, 7}, {3, 5}, {3, 6, 7}, {3, 6}, {3, 7}, {3}, {4, 5, 6, 7}, {4, 5, 6}, {4, 5, 7}, {4, 5}, {4, 6, 7}, {4, 6}, {4, 7}, {4}, {5, 6, 7}, {5, 6}, {5, 7}, {5}, {6, 7}, {6}, {7}, new byte[0]};
    private static final long serialVersionUID = -7658605229245494623L;

    public LongsSuccinctBitVector() {
        this(16);
    }

    public LongsSuccinctBitVector(int initialCapacity) {
        this.longs = new long[LongsSuccinctBitVector.longsSize(initialCapacity)];
        this.countCache0 = new int[LongsSuccinctBitVector.countCache0Size(initialCapacity)];
        this.indexCache0 = new IntArray(LongsSuccinctBitVector.initialIndexCache0Size(initialCapacity));
    }

    public LongsSuccinctBitVector(byte[] bytes, int bitsSize) {
        this.size = bitsSize;
        this.longs = new long[LongsSuccinctBitVector.longsSize(bitsSize)];
        this.countCache0 = new int[LongsSuccinctBitVector.countCache0Size(bitsSize)];
        this.indexCache0 = new IntArray(LongsSuccinctBitVector.initialIndexCache0Size(bitsSize));
        int n = bytes.length;
        for (int i = 0; i < n; ++i) {
            int b = bytes[i] & 0xFF;
            int n2 = i / 8;
            this.longs[n2] = this.longs[n2] | (long)b << (7 - i % 8) * 8;
            byte[] zeroPosInB = BITPOS0[b];
            int rest = bitsSize - i * 8;
            if (rest < 8) {
                int nz = zeroPosInB.length;
                for (int j = 0; j < nz; ++j) {
                    if (zeroPosInB[j] < rest) continue;
                    zeroPosInB = Arrays.copyOf(zeroPosInB, j);
                    break;
                }
            }
            int zeroCount = zeroPosInB.length;
            if (this.size0 < 3 && zeroCount > 0) {
                if (this.size0 == 0) {
                    this.node1pos = zeroPosInB[0] + 8 * i;
                    if (zeroPosInB.length > 1) {
                        this.node2pos = zeroPosInB[1] + 8 * i;
                    }
                    if (zeroPosInB.length > 2) {
                        this.node3pos = zeroPosInB[2] + 8 * i;
                    }
                } else if (this.size0 == 1) {
                    this.node2pos = zeroPosInB[0] + 8 * i;
                    if (zeroPosInB.length > 1) {
                        this.node3pos = zeroPosInB[1] + 8 * i;
                    }
                } else {
                    this.node3pos = zeroPosInB[0] + 8 * i;
                }
            }
            int prevSize0 = this.size0;
            this.size0 += zeroCount;
            if ((i + 1) % 8 == 0) {
                this.countCache0[i / 8] = this.size0;
            }
            int indexOfIndexBlock = this.size0 / 64;
            if (zeroCount > 0 && indexOfIndexBlock != prevSize0 / 64) {
                this.indexCache0.set(indexOfIndexBlock, i * 8 + zeroPosInB[zeroPosInB.length - this.size0 % 64 - 1]);
            }
            if (rest < 8) break;
        }
        this.countCache0[(this.size - 1) / 64] = this.size0;
    }

    public LongsSuccinctBitVector(long[] longs, int size, int size0, int node1pos, int node2pos, int node3pos, int[] countCache0, IntArray indexCache0) {
        this.longs = longs;
        this.size = size;
        this.size0 = size0;
        this.node1pos = node1pos;
        this.node2pos = node2pos;
        this.node3pos = node3pos;
        this.countCache0 = countCache0;
        this.indexCache0 = indexCache0;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        int n = Math.min(this.size, 64);
        for (int i = 0; i < n; ++i) {
            long m = Long.MIN_VALUE >>> i % 64;
            long bi = this.longs[i / 64] & m;
            b.append(bi != 0L ? "1" : "0");
        }
        return b.toString();
    }

    public long[] getLongs() {
        return this.longs;
    }

    public int[] getCountCache0() {
        return this.countCache0;
    }

    public IntArray getIndexCache0() {
        return this.indexCache0;
    }

    @Override
    public boolean get(int pos) {
        return this.isOne(pos);
    }

    @Override
    public boolean isZero(int pos) {
        return (this.longs[pos / 64] & Long.MIN_VALUE >>> pos % 64) == 0L;
    }

    @Override
    public boolean isOne(int pos) {
        return (this.longs[pos / 64] & Long.MIN_VALUE >>> pos % 64) != 0L;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int getSize0() {
        return this.size0;
    }

    public int getNode1pos() {
        return this.node1pos;
    }

    public int getNode2pos() {
        return this.node2pos;
    }

    public int getNode3pos() {
        return this.node3pos;
    }

    @Override
    public void trimToSize() {
        this.longs = Arrays.copyOf(this.longs, LongsSuccinctBitVector.longsSize(this.size));
        this.countCache0 = Arrays.copyOf(this.countCache0, LongsSuccinctBitVector.countCache0Size(this.size));
        this.indexCache0.trimToSize();
    }

    @Override
    public void append0() {
        int longsi = this.size / 64;
        int countCachei = this.size / 64;
        if (longsi >= this.longs.length) {
            this.extendLongsAndCountCache0();
        }
        if (this.size % 64 == 0 && countCachei > 0) {
            this.countCache0[countCachei] = this.countCache0[countCachei - 1];
        }
        int n = countCachei;
        this.countCache0[n] = this.countCache0[n] + 1;
        ++this.size0;
        switch (this.size0) {
            case 1: {
                this.node1pos = this.size;
                break;
            }
            case 2: {
                this.node2pos = this.size;
                break;
            }
            case 3: {
                this.node3pos = this.size;
            }
        }
        if (this.size0 % 64 == 0) {
            this.indexCache0.set(this.size0 / 64, this.size);
        }
        ++this.size;
    }

    @Override
    public void append1() {
        int longsi = this.size / 64;
        int countCachei = this.size / 64;
        if (longsi >= this.longs.length) {
            this.extendLongsAndCountCache0();
        }
        if (this.size % 64 == 0 && countCachei > 0) {
            this.countCache0[countCachei] = this.countCache0[countCachei - 1];
        }
        int n = longsi;
        this.longs[n] = this.longs[n] | Long.MIN_VALUE >>> this.size % 64;
        ++this.size;
    }

    public void append(boolean bit) {
        if (bit) {
            this.append1();
        } else {
            this.append0();
        }
    }

    @Override
    public int rank1(int pos) {
        int cn = pos / 64;
        int ret = cn > 0 ? cn * 64 - this.countCache0[cn - 1] : 0;
        int n = pos / 64;
        for (int i = cn * 64 / 64; i < n; ++i) {
            ret += Long.bitCount(this.longs[i]);
        }
        return ret + Long.bitCount(this.longs[n] & Long.MIN_VALUE >> pos % 64);
    }

    @Override
    public int rank0(int pos) {
        int cn = pos / 64;
        if ((pos + 1) % 64 == 0) {
            return this.countCache0[cn];
        }
        int ret = cn > 0 ? this.countCache0[cn - 1] : 0;
        int n = pos / 64;
        for (int i = cn * 64 / 64; i < n; ++i) {
            ret += Long.bitCount(this.longs[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return ret + Long.bitCount((this.longs[n] ^ 0xFFFFFFFFFFFFFFFFL) & Long.MIN_VALUE >> pos % 64);
    }

    public int rank(int pos, boolean b) {
        if (b) {
            return this.rank1(pos);
        }
        return this.rank0(pos);
    }

    @Override
    public int select0(int count) {
        if (count > this.size0) {
            return -1;
        }
        if (count <= 3) {
            if (count == 1) {
                return this.node1pos;
            }
            if (count == 2) {
                return this.node2pos;
            }
            if (count == 3) {
                return this.node3pos;
            }
            return -1;
        }
        int idx = count / 64;
        int start = 0;
        int end = 0;
        if (idx < this.indexCache0.size()) {
            start = this.indexCache0.get(idx);
            if (count % 64 == 0) {
                return start;
            }
            start /= 64;
            end = idx + 1 < this.indexCache0.size() ? this.indexCache0.get(idx + 1) / 64 + 1 : LongsSuccinctBitVector.countCache0Size(this.size);
        } else if (idx > 0) {
            start = this.indexCache0.get(idx - 1) / 64;
            end = Math.min(start + 64, LongsSuccinctBitVector.countCache0Size(this.size));
        }
        int m = -1;
        int d = 0;
        if (start != end) {
            do {
                if ((d = count - this.countCache0[m = (start + end) / 2]) < 0) {
                    end = m;
                    continue;
                }
                if (d <= 0 || start == m) break;
                start = m;
            } while (start != end);
            if (d > 0) {
                count = d;
            } else {
                while (m >= 0 && count <= this.countCache0[m]) {
                    --m;
                }
                if (m >= 0) {
                    count -= this.countCache0[m];
                }
            }
        }
        int n = this.longs.length;
        for (int i = (m + 1) * 64 / 64; i < n; ++i) {
            long v = this.longs[i];
            int c = Long.bitCount(v ^ 0xFFFFFFFFFFFFFFFFL);
            int cd = count - c;
            if (cd <= 0) {
                int b = 0;
                byte bc = 0;
                if ((v & 0xFFFF000000000000L) != -281474976710656L) {
                    b = (int)(v >>> 56);
                    bc = BITCOUNTS0[b];
                    if ((count -= bc) <= 0) {
                        return i * 64 + BITPOS0[b][count + bc - 1];
                    }
                    b = (int)(v >>> 48 & 0xFFL);
                    bc = BITCOUNTS0[b];
                    if ((count -= bc) <= 0) {
                        return i * 64 + 8 + BITPOS0[b][count + bc - 1];
                    }
                }
                if ((v & 0xFFFF00000000L) != 0xFFFF00000000L) {
                    b = (int)(v >>> 40 & 0xFFL);
                    bc = BITCOUNTS0[b];
                    if ((count -= bc) <= 0) {
                        return i * 64 + 16 + BITPOS0[b][count + bc - 1];
                    }
                    b = (int)(v >>> 32 & 0xFFL);
                    bc = BITCOUNTS0[b];
                    if ((count -= bc) <= 0) {
                        return i * 64 + 24 + BITPOS0[b][count + bc - 1];
                    }
                }
                if ((v & 0xFFFF0000L) != 0xFFFF0000L) {
                    b = (int)(v >>> 24 & 0xFFL);
                    bc = BITCOUNTS0[b];
                    if ((count -= bc) <= 0) {
                        return i * 64 + 32 + BITPOS0[b][count + bc - 1];
                    }
                    b = (int)(v >>> 16 & 0xFFL);
                    bc = BITCOUNTS0[b];
                    if ((count -= bc) <= 0) {
                        return i * 64 + 40 + BITPOS0[b][count + bc - 1];
                    }
                }
                if ((count -= (bc = BITCOUNTS0[b = (int)(v >>> 8 & 0xFFL)])) <= 0) {
                    return i * 64 + 48 + BITPOS0[b][count + bc - 1];
                }
                b = (int)(v & 0xFFL);
                bc = BITCOUNTS0[b];
                if ((count -= bc) <= 0) {
                    return i * 64 + 56 + BITPOS0[b][count + bc - 1];
                }
                return -1;
            }
            count = cd;
        }
        return -1;
    }

    @Override
    public int select1(int count) {
        for (int i = 0; i < this.longs.length; ++i) {
            if (i * 64 >= this.size) {
                return -1;
            }
            long v = this.longs[i];
            int c = Long.bitCount(v);
            if (count <= c) {
                for (int j = 0; j < 64; ++j) {
                    if (i * 64 + j >= this.size) {
                        return -1;
                    }
                    if ((v & Long.MIN_VALUE) != 0L && --count == 0) {
                        return i * 64 + j;
                    }
                    v <<= 1;
                }
                return -1;
            }
            count -= c;
        }
        return -1;
    }

    public int select(int count, boolean b) {
        if (b) {
            return this.select1(count);
        }
        return this.select0(count);
    }

    @Override
    public int next0(int pos) {
        long v;
        if (pos >= this.size) {
            return -1;
        }
        if (pos <= this.node3pos) {
            if (pos <= this.node1pos) {
                return this.node1pos;
            }
            if (pos <= this.node2pos) {
                return this.node2pos;
            }
            return this.node3pos;
        }
        int longsi = pos / 64;
        int s = pos % 64;
        int n = this.longs.length - 1;
        if (longsi < n) {
            int i;
            v = this.longs[longsi] << s;
            for (i = s; i < 64; ++i) {
                if (v >= 0L) {
                    return longsi * 64 + i;
                }
                v <<= 1;
            }
            ++longsi;
            s = 0;
            while (longsi < n) {
                v = this.longs[longsi];
                if (Long.bitCount(v) != 64) {
                    for (i = 0; i < 64; ++i) {
                        if (v >= 0L) {
                            return longsi * 64 + i;
                        }
                        v <<= 1;
                    }
                }
                ++longsi;
            }
        }
        if (Long.bitCount(v = this.longs[longsi] << s) != 64 - s) {
            int in = this.size % 64;
            for (int i = s; i < in; ++i) {
                if (v >= 0L) {
                    return longsi * 64 + i;
                }
                v <<= 1;
            }
        }
        return -1;
    }

    private void extendLongsAndCountCache0() {
        int longsSize = (int)((double)this.longs.length * 1.2) + 1;
        this.longs = Arrays.copyOf(this.longs, longsSize);
        this.countCache0 = Arrays.copyOf(this.countCache0, LongsSuccinctBitVector.countCache0Size(longsSize * 64));
    }

    private static int longsSize(int bitSize) {
        if (bitSize == 0) {
            return 0;
        }
        return (bitSize - 1) / 64 + 1;
    }

    private static int countCache0Size(int bitSize) {
        if (bitSize == 0) {
            return 0;
        }
        return (bitSize - 1) / 64 + 1;
    }

    private static int initialIndexCache0Size(int bitSize) {
        if (bitSize == 0) {
            return 0;
        }
        return bitSize / 2 / 64;
    }
}

