/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.tail.index;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.trie4j.tail.index.DenseArrayTailIndex;
import org.trie4j.tail.index.TailIndex;
import org.trie4j.tail.index.TailIndexBuilder;
import org.trie4j.util.FastBitSet;

public class DenseArrayTailIndexBuilder
implements Externalizable,
TailIndexBuilder {
    private FastBitSet bs = new FastBitSet();
    private int[] tail = new int[0];
    private int current;
    private int currentIndex;

    public DenseArrayTailIndexBuilder(int initialCapacity) {
        this.tail = new int[initialCapacity];
    }

    public DenseArrayTailIndexBuilder() {
    }

    @Override
    public void add(int nodeId, int start, int end) {
        if (nodeId != this.current) {
            throw new IllegalArgumentException("nodeId must be a monoinc.");
        }
        this.ensureCapacity();
        this.tail[this.currentIndex++] = start;
        this.bs.set(this.current++);
    }

    @Override
    public void addEmpty(int nodeId) {
        if (nodeId != this.current) {
            throw new IllegalArgumentException("nodeId must be a monoinc.");
        }
        this.bs.unsetIfLE(this.current++);
    }

    @Override
    public void trimToSize() {
        this.tail = Arrays.copyOf(this.tail, this.currentIndex);
        this.bs.trimToSize();
    }

    @Override
    public TailIndex build() {
        this.trimToSize();
        return new DenseArrayTailIndex(this.tail, this.bs.getBytes(), this.bs.size());
    }

    private void ensureCapacity() {
        if (this.currentIndex == this.tail.length) {
            this.tail = Arrays.copyOf(this.tail, (int)((double)(this.current + 1) * 1.2));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        this.current = in.readInt();
        this.currentIndex = in.readInt();
        this.tail = (int[])in.readObject();
        this.bs = (FastBitSet)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.trimToSize();
        out.writeInt(this.current);
        out.writeInt(this.currentIndex);
        out.writeObject(this.tail);
        out.writeObject(this.bs);
    }
}

