/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.commons.lang.StringEscapeUtils;
import org.omegat.core.machinetranslators.AbstractMyMemoryTranslate;
import org.omegat.util.Language;
import org.omegat.util.OStrings;

public final class MyMemoryMachineTranslate
extends AbstractMyMemoryTranslate {
    @Override
    protected String getPreferenceName() {
        return "allow_mymemory_machine_translate";
    }

    @Override
    public String getName() {
        return OStrings.getString("MT_ENGINE_MYMEMORY_MACHINE");
    }

    @Override
    protected boolean includeMT() {
        return true;
    }

    @Override
    protected String translate(Language sLang, Language tLang, String text) throws Exception {
        String prev = this.getFromCache(sLang, tLang, text);
        if (prev != null) {
            return prev;
        }
        JsonNode jsonResponse = this.getMyMemoryResponse(sLang, tLang, text);
        double bestScore = 0.0;
        JsonNode bestEntry = null;
        JsonNode mtEntry = null;
        JsonNode entries = jsonResponse.get("matches");
        for (JsonNode entry : entries) {
            if ("MT!".equals(entry.get("created-by").asText())) {
                mtEntry = entry;
                continue;
            }
            if (!(entry.get("match").asDouble() > bestScore)) continue;
            bestEntry = entry;
            bestScore = entry.get("match").asDouble();
        }
        if (mtEntry != null) {
            bestEntry = mtEntry;
        }
        assert (bestEntry != null);
        String translation = StringEscapeUtils.unescapeHtml((String)bestEntry.get("translation").asText());
        this.putToCache(sLang, tLang, text, translation);
        return translation;
    }
}

