/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.xml;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.omegat.filters2.TranslationException;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.omegat.util.xml.DefaultEntityFilter;
import org.omegat.util.xml.XMLBlock;
import org.omegat.util.xml.XMLReader;

public class XMLStreamReader
implements Closeable {
    private DefaultEntityFilter entityFilter;
    private boolean cdataFlag = false;
    private boolean endCdataFlag = false;
    private static final int TYPE_TEXT = 1;
    private static final int TYPE_WS = 2;
    private static final int TYPE_APOS = 3;
    private static final int TYPE_QUOTE = 4;
    private static final int TYPE_LT = 5;
    private static final int TYPE_GT = 6;
    private static final int TYPE_AMP = 7;
    private static final int TYPE_EQUALS = 8;
    private static final int TYPE_QUES = 9;
    private static final int TYPE_OPBRAC = 10;
    private static final int TYPE_CLBRAC = 11;
    private static final int TYPE_SLASH = 12;
    private static final int TYPE_BACKSLASH = 13;
    private static final int TYPE_DASH = 14;
    private XMLReader mReader;
    private String mStringStream = "";
    private XMLBlock mHeadBlock = null;
    private int mPos = -1;
    private Stack<Integer> mCharStack = new Stack();
    private List<Integer> mCharCache = new ArrayList<Integer>();
    private boolean mKillEmptyBlocks = false;
    private boolean mIgnoreWhiteSpace = false;
    private boolean mBreakWhitespace = false;
    private boolean mCompressWhitespace = false;

    public final void setStream(File name) throws FileNotFoundException, UnsupportedEncodingException, IOException, TranslationException {
        this.setStream(name, "UTF-8");
    }

    public final void setStream(String name, String encoding) throws FileNotFoundException, UnsupportedEncodingException, IOException, TranslationException {
        this.setStream(new File(name), encoding);
    }

    private void setStream(File file, String encoding) throws FileNotFoundException, UnsupportedEncodingException, IOException, TranslationException {
        this.mReader = new XMLReader(file.getAbsolutePath(), encoding);
        this.setStreamImpl();
    }

    public void setStream(InputStream stream) throws IOException, TranslationException {
        this.setStream(stream, "UTF-8");
    }

    public void setStream(InputStream stream, String encoding) throws IOException, TranslationException {
        this.mReader = new XMLReader(stream, encoding);
        this.setStreamImpl();
    }

    private void setStreamImpl() throws IOException, TranslationException {
        this.mPos = -1;
        XMLBlock blk = this.getNextBlock();
        if (blk == null) {
            throw new IOException(OStrings.getString("XSR_ERROR_NONVALID_XML") + "\n" + OStrings.getString("XSR_ERROR_UNABLE_INIT_READ_XML"));
        }
        if (blk.getTagName().equals("xml")) {
            String ver = blk.getAttribute("version");
            if (ver != null && !ver.equals("") && !ver.equals("1.0")) {
                throw new IOException(OStrings.getString("XSR_ERROR_NONVALID_XML") + "\n" + StringUtil.format(OStrings.getString("XSR_ERROR_UNSUPPORTED_XML_VERSION"), ver));
            }
        } else {
            throw new IOException(OStrings.getString("XSR_ERROR_NONVALID_XML"));
        }
        this.mHeadBlock = blk;
    }

    public XMLBlock getNextBlock() throws TranslationException {
        int cp = this.getNextChar();
        if (cp == 0) {
            return null;
        }
        if (cp == 60) {
            cp = this.getNextChar();
            this.pushChar(cp);
            if (cp != 32) {
                XMLBlock b = this.getNextTag();
                return b;
            }
        } else if (cp == 93 && this.endCdataFlag) {
            XMLBlock b = this.getNextTagCDATAEnd();
            return b;
        }
        this.pushChar(cp);
        XMLBlock blk = this.getNextText();
        if (blk != null && this.mKillEmptyBlocks) {
            String str = blk.getText();
            if ((str = str.trim()).isEmpty()) {
                blk = this.getNextBlock();
            }
        }
        return blk;
    }

    public final void killEmptyBlocks() {
        this.mKillEmptyBlocks = true;
    }

    public final void breakOnWhitespace(boolean brk) {
        this.mBreakWhitespace = brk;
    }

    public final void compressWhitespace(boolean tof) {
        this.mCompressWhitespace = tof;
    }

    public final void setEntityFilter(DefaultEntityFilter filter) {
        this.entityFilter = filter;
    }

    private void pushChar(int cp) {
        this.mCharStack.push(cp);
    }

    private int getNextCharCache() {
        int c = this.getNextChar();
        this.mCharCache.add(c);
        return c;
    }

    private void clearCache() {
        this.mCharCache.clear();
    }

    private void revertToCached() {
        for (int i = this.mCharCache.size() - 1; i >= 0; --i) {
            this.mCharStack.push(this.mCharCache.get(i));
        }
    }

    private int getNextChar() {
        if (!this.mCharStack.empty()) {
            Integer ch = this.mCharStack.pop();
            return ch;
        }
        if (this.mPos >= 0) {
            if (this.mPos < this.mStringStream.length()) {
                int cp = this.mStringStream.codePointAt(this.mPos);
                this.mPos += Character.charCount(cp);
                if (cp == 13) {
                    cp = this.mStringStream.codePointAt(this.mPos);
                    if (cp == 10) {
                        this.mPos += Character.charCount(cp);
                    } else {
                        cp = 10;
                    }
                }
                return cp;
            }
            return 0;
        }
        char[] c = new char[2];
        try {
            char b;
            int res = this.mReader.read(c, 0, 1);
            if (res > 0) {
                b = c[0];
                if (b == '\r') {
                    res = this.mReader.read(c, 0, 1);
                    if (res > 0) {
                        b = c[0];
                        if (b != '\n' && b == '\r') {
                            this.pushChar(10);
                        }
                    } else {
                        b = '\u0000';
                    }
                }
            } else {
                return 0;
            }
            return b;
        }
        catch (IOException e) {
            Log.logErrorRB("XSR_ERROR_IOEXCEPTION", new Object[0]);
            Log.log(e);
            return 0;
        }
    }

    private XMLBlock getNextText() throws TranslationException {
        int cp;
        XMLBlock blk = new XMLBlock();
        StringBuilder strBuf = new StringBuilder();
        boolean wsCnt = false;
        boolean wsBreak = false;
        while ((cp = this.getNextChar()) != 60 && cp != 0) {
            if (cp == 38) {
                wsCnt = false;
                if (wsBreak) {
                    this.pushChar(cp);
                    break;
                }
                int cp2 = this.getEscChar();
                if (cp2 == 0) {
                    strBuf.append('&');
                    continue;
                }
                strBuf.appendCodePoint(cp2);
                continue;
            }
            if (cp == 32 || cp == 10 || cp == 13 || cp == 9) {
                if (this.mIgnoreWhiteSpace) continue;
                if (this.mCompressWhitespace) {
                    if (this.mBreakWhitespace) {
                        if (strBuf.length() > 0) {
                            if (wsBreak) continue;
                            this.pushChar(cp);
                            break;
                        }
                        wsCnt = true;
                        strBuf.setLength(0);
                        strBuf.append(" ");
                        wsBreak = true;
                        continue;
                    }
                    if (wsCnt) continue;
                    strBuf.append(' ');
                    wsCnt = true;
                    continue;
                }
                strBuf.appendCodePoint(cp);
                continue;
            }
            wsCnt = false;
            if (wsBreak) {
                this.pushChar(cp);
                break;
            }
            if (cp == 93 && this.cdataFlag) {
                int cp1 = this.getNextChar();
                int cp2 = this.getNextChar();
                this.pushChar(cp2);
                this.pushChar(cp1);
                if (cp1 == 93 && cp2 == 62) {
                    this.cdataFlag = false;
                    this.endCdataFlag = true;
                    this.pushChar(cp);
                    break;
                }
            }
            strBuf.appendCodePoint(cp);
        }
        if (cp == 60) {
            this.pushChar(cp);
        }
        blk.setText(strBuf.toString());
        return blk;
    }

    private XMLBlock getNextTagCDATAEnd() {
        this.endCdataFlag = false;
        XMLBlock blk = new XMLBlock();
        blk.setTypeChar('!');
        blk.setTagName("]]");
        this.getNextChar();
        this.getNextChar();
        return blk;
    }

    private XMLBlock getNextTagExclamation() throws TranslationException {
        int cp;
        boolean stateStart = true;
        int stateName = 2;
        int stateFinish = 3;
        int stateRecord = 4;
        int stateRecordSingle = 5;
        int stateRecordDouble = 6;
        int stateEscSingle = 7;
        int stateEscDouble = 8;
        int stateCdata = 9;
        int stateCommentStart = 10;
        int stateComment = 11;
        XMLBlock blk = new XMLBlock();
        blk.setTypeChar('!');
        StringBuilder name = new StringBuilder();
        StringBuilder data = new StringBuilder();
        int state = 1;
        boolean err = false;
        String msg = "";
        int dashCnt = 0;
        while ((cp = this.getNextChar()) != 0) {
            int type = this.getCharType(cp);
            block0 : switch (state) {
                case 1: {
                    switch (type) {
                        case 2: {
                            break block0;
                        }
                        case 1: {
                            state = 2;
                            name.appendCodePoint(cp);
                            break block0;
                        }
                        case 10: {
                            blk.setTagName("CDATA");
                            state = 9;
                            break block0;
                        }
                        case 14: {
                            state = 10;
                            blk.setComment();
                            break block0;
                        }
                    }
                    err = true;
                    msg = StringUtil.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), String.valueOf(Character.toChars(cp)), state);
                    break;
                }
                case 10: {
                    if (cp == 45) {
                        state = 11;
                        break;
                    }
                    err = true;
                    msg = OStrings.getString("XSR_ERROR_CONFUSED");
                    break;
                }
                case 11: {
                    switch (type) {
                        case 14: {
                            if (dashCnt >= 2) {
                                data.appendCodePoint(cp);
                                break block0;
                            }
                            ++dashCnt;
                            break block0;
                        }
                        case 6: {
                            if (dashCnt < 2) break block0;
                            blk.setText(data.toString());
                            state = 3;
                            break block0;
                        }
                    }
                    if (dashCnt > 0) {
                        while (dashCnt > 0) {
                            data.append('-');
                            --dashCnt;
                        }
                    }
                    data.appendCodePoint(cp);
                    break;
                }
                case 9: {
                    switch (type) {
                        case 10: {
                            state = 3;
                            this.cdataFlag = true;
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (type) {
                        case 1: {
                            name.appendCodePoint(cp);
                            break block0;
                        }
                        case 2: {
                            blk.setTagName(name.toString());
                            state = 4;
                            break block0;
                        }
                        case 6: {
                            state = 3;
                            break block0;
                        }
                    }
                    err = true;
                    msg = StringUtil.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), String.valueOf(Character.toChars(cp)), state);
                    break;
                }
                case 4: {
                    switch (type) {
                        case 3: {
                            state = 5;
                            data.appendCodePoint(cp);
                            break block0;
                        }
                        case 4: {
                            state = 6;
                            data.appendCodePoint(cp);
                            break block0;
                        }
                        case 6: {
                            state = 3;
                            blk.setAttribute(data.toString(), "");
                            break block0;
                        }
                    }
                    data.appendCodePoint(cp);
                    break;
                }
                case 5: {
                    switch (type) {
                        case 3: {
                            state = 4;
                            data.appendCodePoint(cp);
                            break block0;
                        }
                        case 13: {
                            state = 7;
                            data.appendCodePoint(cp);
                            break block0;
                        }
                    }
                    data.appendCodePoint(cp);
                    break;
                }
                case 7: {
                    data.appendCodePoint(cp);
                    state = 5;
                    break;
                }
                case 6: {
                    switch (type) {
                        case 4: {
                            state = 4;
                            data.appendCodePoint(cp);
                            break block0;
                        }
                        case 13: {
                            state = 8;
                            data.appendCodePoint(cp);
                            break block0;
                        }
                    }
                    data.appendCodePoint(cp);
                    break;
                }
                case 8: {
                    data.appendCodePoint(cp);
                    state = 6;
                    break;
                }
            }
            if (err) {
                String str = OStrings.getString("XSR_ERROR_TAG_NAME") + blk.getTagName() + " ";
                if (blk.isComment()) {
                    str = str + OStrings.getString("XSR_ERROR_COMMENT_TAG");
                }
                if (blk.numAttributes() > 0) {
                    str = str + blk.getAttribute((int)0).name;
                }
                throw new TranslationException(msg + str + "::" + data);
            }
            if (state != 3) continue;
            break;
        }
        return blk;
    }

    private void throwErrorInGetNextTag(XMLBlock blk, String msg) throws TranslationException {
        String data = OStrings.getString("XSR_ERROR_TAG_NAME") + blk.getTagName() + " ";
        if (blk.isStandalone()) {
            data = data + OStrings.getString("XSR_ERROR_EMPTY_TAG");
        } else if (blk.isClose()) {
            data = data + OStrings.getString("XSR_ERROR_CLOSE_TAG");
        }
        if (blk.numAttributes() > 0) {
            data = data + StringUtil.format(OStrings.getString("XSR_ERROR_LOADED"), String.valueOf(blk.numAttributes()));
        }
        throw new TranslationException(msg + data);
    }

    private XMLBlock getNextTag() throws TranslationException {
        int cp = this.getNextChar();
        if (cp == 0) {
            return null;
        }
        if (cp == 33) {
            return this.getNextTagExclamation();
        }
        boolean stateStart = true;
        int stateBuildName = 2;
        int stateSetCloseFlag = 3;
        int stateSetStandaloneFlag = 4;
        int stateAttrStandby = 5;
        int stateBuildAttr = 6;
        int stateTransitionFromAttr = 7;
        int stateBuildValue = 8;
        int stateCloseValueQuote = 9;
        int stateFinish = 10;
        int stateXmlDeclaration = 11;
        XMLBlock blk = new XMLBlock();
        if (cp == 63) {
            cp = this.getNextChar();
            blk.setTypeChar('?');
        }
        int state = 1;
        StringBuilder name = new StringBuilder();
        StringBuilder attr = new StringBuilder();
        StringBuilder val = new StringBuilder();
        int buildValueStartType = 0;
        while (cp != 0) {
            int type = this.getCharType(cp);
            block0 : switch (state) {
                case 1: {
                    switch (type) {
                        case 12: {
                            blk.setCloseFlag();
                            state = 3;
                            break block0;
                        }
                        case 1: {
                            name.appendCodePoint(cp);
                            state = 2;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StringUtil.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), String.valueOf(Character.toChars(cp)), state));
                    break;
                }
                case 2: {
                    switch (type) {
                        case 1: 
                        case 14: {
                            name.appendCodePoint(cp);
                            break block0;
                        }
                        case 2: {
                            state = 5;
                            blk.setTagName(name.toString());
                            break block0;
                        }
                        case 12: {
                            blk.setTagName(name.toString());
                            blk.setStandaloneFlag();
                            state = 4;
                            break block0;
                        }
                        case 6: {
                            blk.setTagName(name.toString());
                            state = 10;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StringUtil.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), String.valueOf(Character.toChars(cp)), state));
                    break;
                }
                case 3: {
                    switch (type) {
                        case 1: {
                            name.appendCodePoint(cp);
                            state = 2;
                            break block0;
                        }
                        case 2: {
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StringUtil.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), String.valueOf(Character.toChars(cp)), state));
                    break;
                }
                case 4: {
                    switch (type) {
                        case 2: {
                            break block0;
                        }
                        case 6: {
                            state = 10;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StringUtil.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), String.valueOf(Character.toChars(cp)), state));
                    break;
                }
                case 5: {
                    switch (type) {
                        case 1: {
                            attr.appendCodePoint(cp);
                            state = 6;
                            break block0;
                        }
                        case 9: {
                            state = 11;
                            break block0;
                        }
                        case 2: {
                            break block0;
                        }
                        case 12: {
                            blk.setStandaloneFlag();
                            state = 4;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StringUtil.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), String.valueOf(Character.toChars(cp)), state));
                    break;
                }
                case 11: {
                    if (cp != 62) {
                        this.throwErrorInGetNextTag(blk, OStrings.getString("XSR_ERROR_FLOATING_QUESTION_MARK"));
                        break;
                    }
                    state = 10;
                    break;
                }
                case 6: {
                    switch (type) {
                        case 1: 
                        case 14: {
                            attr.appendCodePoint(cp);
                            break block0;
                        }
                        case 8: {
                            state = 7;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StringUtil.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), String.valueOf(Character.toChars(cp)), state));
                    break;
                }
                case 7: {
                    switch (type) {
                        case 3: 
                        case 4: {
                            state = 8;
                            buildValueStartType = type;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StringUtil.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), String.valueOf(Character.toChars(cp)), state));
                    break;
                }
                case 8: {
                    switch (type) {
                        case 3: 
                        case 4: {
                            if (type == buildValueStartType) {
                                blk.setAttribute(attr.toString(), val.toString());
                                attr = new StringBuilder();
                                val = new StringBuilder();
                                state = 9;
                                break block0;
                            }
                            val.appendCodePoint(cp);
                            break block0;
                        }
                    }
                    val.appendCodePoint(cp);
                    break;
                }
                case 9: {
                    switch (type) {
                        case 1: {
                            attr.appendCodePoint(cp);
                            state = 6;
                            break block0;
                        }
                        case 2: {
                            break block0;
                        }
                        case 12: {
                            blk.setStandaloneFlag();
                            state = 4;
                            break block0;
                        }
                        case 6: {
                            state = 10;
                            break block0;
                        }
                        case 9: {
                            state = 11;
                            break block0;
                        }
                    }
                    this.throwErrorInGetNextTag(blk, StringUtil.format(OStrings.getString("XSR_ERROR_UNEXPECTED_CHAR"), String.valueOf(Character.toChars(cp)), state));
                    break;
                }
                default: {
                    Log.log("INTERNAL ERROR untrapped parse state " + state);
                }
            }
            if (state == 10) break;
            cp = this.getNextChar();
        }
        return blk;
    }

    private int getCharType(int cp) {
        int type = 1;
        switch (cp) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                type = 2;
                break;
            }
            case 34: {
                type = 4;
                break;
            }
            case 39: {
                type = 3;
                break;
            }
            case 38: {
                type = 7;
                break;
            }
            case 60: {
                type = 5;
                break;
            }
            case 62: {
                type = 6;
                break;
            }
            case 63: {
                type = 9;
                break;
            }
            case 47: {
                type = 12;
                break;
            }
            case 61: {
                type = 8;
                break;
            }
            case 91: {
                type = 10;
                break;
            }
            case 93: {
                type = 11;
                break;
            }
            case 45: {
                type = 14;
                break;
            }
            case 92: {
                type = 13;
                break;
            }
        }
        return type;
    }

    public String makeValidXML(int cp) {
        String res = StringUtil.escapeXMLChars(cp);
        if (res.codePointCount(0, res.length()) == 1 && this.entityFilter != null) {
            return this.entityFilter.convertToEntity(cp);
        }
        return res;
    }

    public String makeValidXML(String plaintext) {
        int cp;
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < plaintext.length(); i += Character.charCount(cp)) {
            cp = plaintext.codePointAt(i);
            out.append(this.makeValidXML(cp));
        }
        return out.toString();
    }

    public final List<XMLBlock> closeBlock(XMLBlock block) throws TranslationException {
        return this.closeBlock(block, false);
    }

    public List<XMLBlock> closeBlock(XMLBlock block, boolean includeTerminationBlock) throws TranslationException {
        ArrayList<XMLBlock> lst = new ArrayList<XMLBlock>();
        if (block == null) {
            return lst;
        }
        if (block.isStandalone()) {
            return lst;
        }
        int depth = 0;
        while (true) {
            XMLBlock blk;
            if ((blk = this.getNextBlock()) == null) {
                throw new TranslationException(OStrings.getString("XSR_ERROR_END_OF_STREAM"));
            }
            if (blk.isTag() && blk.getTagName().equals(block.getTagName())) {
                if (blk.isClose()) {
                    if (depth == 0) {
                        if (!includeTerminationBlock) break;
                        lst.add(blk);
                        break;
                    }
                    --depth;
                } else {
                    ++depth;
                }
                lst.add(blk);
                continue;
            }
            lst.add(blk);
        }
        return lst.isEmpty() ? null : lst;
    }

    public final XMLBlock advanceToTag(String tagname) throws TranslationException {
        XMLBlock blk;
        while (!((blk = this.getNextBlock()) == null || blk.isTag() && blk.getTagName().equals(tagname))) {
        }
        return blk;
    }

    private int getEscChar() throws TranslationException {
        this.clearCache();
        int cp = this.getNextCharCache();
        StringBuilder val = new StringBuilder();
        boolean hex = false;
        if (cp == 35) {
            cp = this.getNextCharCache();
            if (cp == 120 || cp == 88) {
                cp = this.getNextCharCache();
                hex = true;
            }
        } else if (cp == 32) {
            this.revertToCached();
            return 0;
        }
        int ctr = 0;
        while (cp != 59) {
            val.appendCodePoint(cp);
            if (cp == 0) {
                throw new TranslationException(OStrings.getString("XSR_ERROR_UNTERMINATED_ESCAPE_CHAR"));
            }
            cp = this.getNextCharCache();
            if (ctr++ <= 13) continue;
            this.revertToCached();
            return 0;
        }
        this.clearCache();
        String valString = val.toString();
        if (valString.equals("amp")) {
            return 38;
        }
        if (valString.equals("lt")) {
            return 60;
        }
        if (valString.equals("gt")) {
            return 62;
        }
        if (valString.equals("apos")) {
            return 39;
        }
        if (valString.equals("quot")) {
            return 34;
        }
        if (this.entityFilter != null) {
            return this.entityFilter.convertToSymbol(val.toString());
        }
        if (hex) {
            try {
                cp = Integer.valueOf(valString, 16);
            }
            catch (NumberFormatException ex) {
                throw new TranslationException(StringUtil.format(OStrings.getString("XSR_ERROR_BAD_BINARY_CHAR"), val), ex);
            }
            if (!StringUtil.isValidXMLChar(cp)) {
                throw new TranslationException(StringUtil.format(OStrings.getString("XSR_ERROR_BAD_BINARY_CHAR"), val));
            }
        } else {
            try {
                cp = Integer.valueOf(valString, 10);
            }
            catch (NumberFormatException ex) {
                throw new TranslationException(StringUtil.format(OStrings.getString("XSR_ERROR_BAD_DECIMAL_CHAR"), val), ex);
            }
            if (!StringUtil.isValidXMLChar(cp)) {
                throw new TranslationException(StringUtil.format(OStrings.getString("XSR_ERROR_BAD_DECIMAL_CHAR"), val));
            }
        }
        return cp;
    }

    public final XMLBlock getHeadBlock() {
        return this.mHeadBlock;
    }

    @Override
    public void close() throws IOException {
        if (this.mReader != null) {
            this.mReader.close();
        }
    }
}

