/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.JmxCollector;
import org.apache.cassandra.stress.util.Timing;
import org.apache.cassandra.stress.util.TimingInterval;
import org.apache.cassandra.stress.util.TimingIntervals;
import org.apache.cassandra.stress.util.Uncertainty;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class StressMetrics {
    private static final ThreadFactory tf = new NamedThreadFactory("StressMetrics");
    private final PrintStream output;
    private final Thread thread;
    private volatile boolean stop = false;
    private volatile boolean cancelled = false;
    private final Uncertainty rowRateUncertainty = new Uncertainty();
    private final CountDownLatch stopped = new CountDownLatch(1);
    private final Timing timing;
    private final Callable<JmxCollector.GcStats> gcStatsCollector;
    private volatile JmxCollector.GcStats totalGcStats;
    private final StressSettings settings;
    public static final String HEADFORMAT = "%-10s%10s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%8s,%7s,%9s,%7s,%7s,%8s,%8s,%8s,%8s";
    public static final String ROWFORMAT = "%-10s%10d,%8.0f,%8.0f,%8.0f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%8.1f,%7.1f,%9.5f,%7d,%7.0f,%8.0f,%8.0f,%8.0f,%8.0f";

    public StressMetrics(PrintStream output, final long logIntervalMillis, StressSettings settings) {
        Callable<JmxCollector.GcStats> gcStatsCollector;
        this.output = output;
        this.settings = settings;
        this.totalGcStats = new JmxCollector.GcStats(0.0);
        try {
            gcStatsCollector = new JmxCollector(settings.node.resolveAllPermitted(settings), settings.port.jmxPort);
        }
        catch (Throwable t) {
            switch (settings.log.level) {
                case VERBOSE: {
                    t.printStackTrace();
                }
            }
            System.err.println("Failed to connect over JMX; not collecting these stats");
            gcStatsCollector = new Callable<JmxCollector.GcStats>(){

                @Override
                public JmxCollector.GcStats call() throws Exception {
                    return StressMetrics.this.totalGcStats;
                }
            };
        }
        this.gcStatsCollector = gcStatsCollector;
        this.timing = new Timing(settings.samples.historyCount, settings.samples.reportCount);
        StressMetrics.printHeader("", output);
        this.thread = tf.newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StressMetrics.this.timing.start();
                try {
                    while (!StressMetrics.this.stop) {
                        try {
                            long sleepNanos = StressMetrics.this.timing.getHistory().endNanos() - System.nanoTime();
                            long sleep = sleepNanos / 1000000L + logIntervalMillis;
                            if (sleep < logIntervalMillis >>> 3) {
                                Thread.sleep(logIntervalMillis);
                            } else {
                                Thread.sleep(sleep);
                            }
                            StressMetrics.this.update();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    StressMetrics.this.update();
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    StressMetrics.this.cancel();
                    e.printStackTrace(StressMetrics.this.output);
                }
                finally {
                    StressMetrics.this.rowRateUncertainty.wakeAll();
                    StressMetrics.this.stopped.countDown();
                }
            }
        });
    }

    public void start() {
        this.thread.start();
    }

    public void waitUntilConverges(double targetUncertainty, int minMeasurements, int maxMeasurements) throws InterruptedException {
        this.rowRateUncertainty.await(targetUncertainty, minMeasurements, maxMeasurements);
    }

    public void cancel() {
        this.cancelled = true;
        this.stop = true;
        this.thread.interrupt();
        this.rowRateUncertainty.wakeAll();
    }

    public void stop() throws InterruptedException {
        this.stop = true;
        this.thread.interrupt();
        this.stopped.await();
    }

    private void update() throws InterruptedException {
        Timing.TimingResult<JmxCollector.GcStats> result = this.timing.snap(this.gcStatsCollector);
        this.totalGcStats = JmxCollector.GcStats.aggregate(Arrays.asList(this.totalGcStats, (JmxCollector.GcStats)result.extra));
        TimingInterval current = result.intervals.combine(this.settings.samples.reportCount);
        TimingInterval history = this.timing.getHistory().combine(this.settings.samples.historyCount);
        this.rowRateUncertainty.update(current.adjustedRowRate());
        if (current.partitionCount != 0L) {
            if (result.intervals.intervals().size() > 1) {
                for (Map.Entry<String, TimingInterval> type : result.intervals.intervals().entrySet()) {
                    StressMetrics.printRow("", type.getKey(), type.getValue(), this.timing.getHistory().get(type.getKey()), (JmxCollector.GcStats)result.extra, this.rowRateUncertainty, this.output);
                }
            }
            StressMetrics.printRow("", "total", current, history, (JmxCollector.GcStats)result.extra, this.rowRateUncertainty, this.output);
        }
        if (this.timing.done()) {
            this.stop = true;
        }
    }

    private static void printHeader(String prefix, PrintStream output) {
        output.println(prefix + String.format(HEADFORMAT, "type,", "total ops", "op/s", "pk/s", "row/s", "mean", "med", ".95", ".99", ".999", "max", "time", "stderr", "errors", "gc: #", "max ms", "sum ms", "sdv ms", "mb"));
    }

    private static void printRow(String prefix, String type, TimingInterval interval, TimingInterval total, JmxCollector.GcStats gcStats, Uncertainty opRateUncertainty, PrintStream output) {
        output.println(prefix + String.format(ROWFORMAT, type + ",", total.operationCount, interval.opRate(), interval.partitionRate(), interval.rowRate(), interval.meanLatency(), interval.medianLatency(), interval.rankLatency(0.95f), interval.rankLatency(0.99f), interval.rankLatency(0.999f), interval.maxLatency(), Float.valueOf((float)total.runTime() / 1000.0f), opRateUncertainty.getUncertainty(), interval.errorCount, gcStats.count, gcStats.maxms, gcStats.summs, gcStats.sdvms, gcStats.bytes / 1048576.0));
    }

    public void summarise() {
        this.output.println("\n");
        this.output.println("Results:");
        TimingIntervals opHistory = this.timing.getHistory();
        TimingInterval history = opHistory.combine(this.settings.samples.historyCount);
        this.output.println(String.format("op rate                   : %.0f %s", history.opRate(), opHistory.opRates()));
        this.output.println(String.format("partition rate            : %.0f %s", history.partitionRate(), opHistory.partitionRates()));
        this.output.println(String.format("row rate                  : %.0f %s", history.rowRate(), opHistory.rowRates()));
        this.output.println(String.format("latency mean              : %.1f %s", history.meanLatency(), opHistory.meanLatencies()));
        this.output.println(String.format("latency median            : %.1f %s", history.medianLatency(), opHistory.medianLatencies()));
        this.output.println(String.format("latency 95th percentile   : %.1f %s", history.rankLatency(0.95f), opHistory.rankLatencies(0.95f)));
        this.output.println(String.format("latency 99th percentile   : %.1f %s", history.rankLatency(0.99f), opHistory.rankLatencies(0.99f)));
        this.output.println(String.format("latency 99.9th percentile : %.1f %s", history.rankLatency(0.999f), opHistory.rankLatencies(0.999f)));
        this.output.println(String.format("latency max               : %.1f %s", history.maxLatency(), opHistory.maxLatencies()));
        this.output.println(String.format("Total partitions          : %d %s", history.partitionCount, opHistory.partitionCounts()));
        this.output.println(String.format("Total errors              : %d %s", history.errorCount, opHistory.errorCounts()));
        this.output.println(String.format("total gc count            : %.0f", this.totalGcStats.count));
        this.output.println(String.format("total gc mb               : %.0f", this.totalGcStats.bytes / 1048576.0));
        this.output.println(String.format("total gc time (s)         : %.0f", this.totalGcStats.summs / 1000.0));
        this.output.println(String.format("avg gc time(ms)           : %.0f", this.totalGcStats.summs / this.totalGcStats.count));
        this.output.println(String.format("stdev gc time(ms)         : %.0f", this.totalGcStats.sdvms));
        this.output.println("Total operation time      : " + DurationFormatUtils.formatDuration((long)history.runTime(), (String)"HH:mm:ss", (boolean)true));
    }

    public static void summarise(List<String> ids, List<StressMetrics> summarise, PrintStream out, int historySampleCount) {
        int idLen = 0;
        for (String id : ids) {
            idLen = Math.max(id.length(), idLen);
        }
        String formatstr = "%" + idLen + "s, ";
        StressMetrics.printHeader(String.format(formatstr, "id"), out);
        for (int i = 0; i < ids.size(); ++i) {
            for (Map.Entry<String, TimingInterval> type : summarise.get((int)i).timing.getHistory().intervals().entrySet()) {
                StressMetrics.printRow(String.format(formatstr, ids.get(i)), type.getKey(), type.getValue(), type.getValue(), summarise.get((int)i).totalGcStats, summarise.get((int)i).rowRateUncertainty, out);
            }
            TimingInterval hist = summarise.get((int)i).timing.getHistory().combine(historySampleCount);
            StressMetrics.printRow(String.format(formatstr, ids.get(i)), "total", hist, hist, summarise.get((int)i).totalGcStats, summarise.get((int)i).rowRateUncertainty, out);
        }
    }

    public Timing getTiming() {
        return this.timing;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }
}

