/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.Metadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RelMetadataQueryBase {
    public final Table<RelNode, List, Object> map = HashBasedTable.create();
    public final @Nullable JaninoRelMetadataProvider metadataProvider;
    public static final ThreadLocal<@Nullable JaninoRelMetadataProvider> THREAD_PROVIDERS = new ThreadLocal();

    protected RelMetadataQueryBase(@Nullable JaninoRelMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    protected static <H> H initialHandler(Class<H> handlerClass) {
        return handlerClass.cast(Proxy.newProxyInstance(RelMetadataQuery.class.getClassLoader(), new Class[]{handlerClass}, (proxy, method, args) -> {
            RelNode r = Objects.requireNonNull((RelNode)args[0], "(RelNode) args[0]");
            throw new JaninoRelMetadataProvider.NoHandler(r.getClass());
        }));
    }

    protected <M extends Metadata, H extends MetadataHandler<M>> H revise(Class<? extends RelNode> class_, MetadataDef<M> def) {
        Objects.requireNonNull(this.metadataProvider, "metadataProvider");
        return this.metadataProvider.revise(class_, def);
    }

    public boolean clearCache(RelNode rel) {
        Map row = this.map.row((Object)rel);
        if (row.isEmpty()) {
            return false;
        }
        row.clear();
        return true;
    }
}

