# Test that reproducible builds don't contain references to the build
# root in .debug files

from __future__ import print_function

from bracket import *

name = 'mkrepro'

def test_func(ts):
    status = run('zcat %s/release/%s/binary/sets/debug.* | (cd /tmp && tar xfv - ./usr/libdata/debug/bin/sh.debug)' % (test_dir(ts), config['arch']))
    if status != 0:
        raise RuntimeError("could not extract debug info")
    status = run('(cd /tmp && strings - ./usr/libdata/debug/bin/sh.debug | grep -m 1 %s/)' % config['build_root'])
    return status != 0

def op():
    return TestOp(test_func, [build_op], name = name)
