/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.common;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.intellij.plugins.markdown.extensions.MarkdownBrowserPreviewExtension;
import org.intellij.plugins.markdown.extensions.jcef.MarkdownJCEFPreviewExtension;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.settings.MarkdownCssSettings;
import org.intellij.plugins.markdown.settings.MarkdownFontUtil;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0012H\u0016R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/FontStylesExtension;", "Lorg/intellij/plugins/markdown/extensions/jcef/MarkdownJCEFPreviewExtension;", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "()V", "cssSettings", "Lorg/intellij/plugins/markdown/settings/MarkdownCssSettings;", "Lorg/jetbrains/annotations/NotNull;", "getCssSettings", "()Lorg/intellij/plugins/markdown/settings/MarkdownCssSettings;", "priority", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Priority;", "getPriority", "()Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Priority;", "resourceProvider", "getResourceProvider", "()Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "styles", "", "", "getStyles", "()Ljava/util/List;", "canProvide", "", "resourceName", "loadResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "intellij.markdown"})
public final class FontStylesExtension
implements MarkdownJCEFPreviewExtension,
ResourceProvider {
    @NotNull
    private final List<String> styles = CollectionsKt.listOf((Object)"font/font-settings.css");
    @NotNull
    private final ResourceProvider resourceProvider = this;

    @NotNull
    public final MarkdownCssSettings getCssSettings() {
        MarkdownApplicationSettings markdownApplicationSettings = MarkdownApplicationSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)markdownApplicationSettings, (String)"MarkdownApplicationSettings.getInstance()");
        MarkdownCssSettings markdownCssSettings = markdownApplicationSettings.getMarkdownCssSettings();
        Intrinsics.checkNotNullExpressionValue((Object)markdownCssSettings, (String)"MarkdownApplicationSetti\u2026nce().markdownCssSettings");
        return markdownCssSettings;
    }

    @Override
    @NotNull
    public MarkdownBrowserPreviewExtension.Priority getPriority() {
        return MarkdownBrowserPreviewExtension.Priority.AFTER_ALL;
    }

    @Override
    @NotNull
    public List<String> getStyles() {
        return this.styles;
    }

    @Override
    @NotNull
    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    @Override
    public boolean canProvide(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        return this.getStyles().contains(resourceName);
    }

    @Override
    @NotNull
    public ResourceProvider.Resource loadResource(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        Integer n = this.getCssSettings().getFontSize();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"cssSettings.fontSize");
        int n2 = n;
        String string = this.getCssSettings().getFontFamily();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cssSettings.fontFamily");
        String string2 = MarkdownFontUtil.INSTANCE.getFontSizeCss(n2, string);
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return new ResourceProvider.Resource(byArray, null, 2, null);
    }

    @Override
    @NotNull
    public Map<String, Function1<String, Unit>> getEvents() {
        return MarkdownJCEFPreviewExtension.DefaultImpls.getEvents(this);
    }

    @Override
    @NotNull
    public List<String> getScripts() {
        return MarkdownJCEFPreviewExtension.DefaultImpls.getScripts(this);
    }

    @Override
    public int compareTo(@NotNull MarkdownBrowserPreviewExtension other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return MarkdownJCEFPreviewExtension.DefaultImpls.compareTo(this, other);
    }
}

