/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.google.authorization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.collaboration.auth.services.OAuthServiceBase;
import com.intellij.collaboration.auth.services.OAuthServiceWithRefresh;
import com.intellij.openapi.components.Service;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.DigestUtil;
import java.io.IOException;
import java.net.http.HttpHeaders;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.commons.lang.time.DateUtils;
import org.intellij.plugins.markdown.google.authorization.GoogleCredentials;
import org.intellij.plugins.markdown.google.utils.GoogleCredentialUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

@Service
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0003)*+B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0006H\u0014J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0018\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d2\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0012H\u0002J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0012H\u0014J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0012H\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020(2\u0006\u0010!\u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\b\u00a8\u0006,"}, d2={"Lorg/intellij/plugins/markdown/google/authorization/GoogleOAuthService;", "Lcom/intellij/collaboration/auth/services/OAuthServiceBase;", "Lorg/intellij/plugins/markdown/google/authorization/GoogleCredentials;", "Lcom/intellij/collaboration/auth/services/OAuthServiceWithRefresh;", "()V", "authorizationCodeUrl", "Lcom/intellij/util/Url;", "getAuthorizationCodeUrl", "()Lcom/intellij/util/Url;", "errorRedirectUrl", "getErrorRedirectUrl", "googleAppCred", "Lorg/intellij/plugins/markdown/google/utils/GoogleCredentialUtils$GoogleAppCredentials;", "getGoogleAppCred", "()Lorg/intellij/plugins/markdown/google/utils/GoogleCredentialUtils$GoogleAppCredentials;", "setGoogleAppCred", "(Lorg/intellij/plugins/markdown/google/utils/GoogleCredentialUtils$GoogleAppCredentials;)V", "name", "", "getName", "()Ljava/lang/String;", "successRedirectUrl", "getSuccessRedirectUrl", "getAuthUrlWithParameters", "getCredentials", "responseBody", "responseHeaders", "Ljava/net/http/HttpHeaders;", "getLocalDateTime", "Ljava/util/Date;", "kotlin.jvm.PlatformType", "responseDate", "getRefreshTokenUrlWithParameters", "refreshToken", "getTokenUrlWithParameters", "code", "revokeToken", "", "token", "updateAccessToken", "Ljava/util/concurrent/CompletableFuture;", "AuthorizationResponseData", "Companion", "RefreshResponseData", "intellij.markdown"})
public final class GoogleOAuthService
extends OAuthServiceBase<GoogleCredentials>
implements OAuthServiceWithRefresh<GoogleCredentials> {
    @Nullable
    private GoogleCredentialUtils.GoogleAppCredentials googleAppCred;
    private static final String authGrantType = "authorization_code";
    private static final String refreshGrantType = "refresh_token";
    private static final String responseType = "code";
    private static final String codeChallengeMethod = "S256";
    private static final String codeVerifier;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final GoogleCredentialUtils.GoogleAppCredentials getGoogleAppCred() {
        return this.googleAppCred;
    }

    public final void setGoogleAppCred(@Nullable GoogleCredentialUtils.GoogleAppCredentials googleAppCredentials) {
        this.googleAppCred = googleAppCredentials;
    }

    @NotNull
    public String getName() {
        return "google/oauth";
    }

    @NotNull
    public Url getAuthorizationCodeUrl() {
        return Urls.newFromEncoded((String)("http://localhost:" + GoogleOAuthService.Companion.getPort() + "/api/" + this.getName() + "/authorization_code"));
    }

    @NotNull
    public Url getSuccessRedirectUrl() {
        return Urls.newFromEncoded((String)("http://localhost:" + GoogleOAuthService.Companion.getPort() + "/success"));
    }

    @NotNull
    public Url getErrorRedirectUrl() {
        return Urls.newFromEncoded((String)("http://localhost:" + GoogleOAuthService.Companion.getPort() + "/error"));
    }

    @NotNull
    public CompletableFuture<GoogleCredentials> updateAccessToken(@NotNull String refreshToken) {
        Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
        if (!this.getCurrentRequest().compareAndSet(null, new CompletableFuture())) {
            Object v = this.getCurrentRequest().get();
            Intrinsics.checkNotNull(v);
            return (CompletableFuture)v;
        }
        Object v = this.getCurrentRequest().get();
        Intrinsics.checkNotNull(v);
        CompletableFuture request = (CompletableFuture)v;
        request.whenComplete(new BiConsumer(this){
            final /* synthetic */ GoogleOAuthService this$0;

            public final void accept(GoogleCredentials $noName_0, Throwable $noName_1) {
                GoogleOAuthService.access$getCurrentRequest$p(this.this$0).set(null);
            }
            {
                this.this$0 = googleOAuthService;
            }
        });
        try {
            String string = this.getRefreshTokenUrlWithParameters(refreshToken).toExternalForm();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRefreshTokenUrlWithPa\u2026shToken).toExternalForm()");
            String refreshTokenUrl = string;
            HttpResponse response = this.postHttpResponse(refreshTokenUrl);
            String string2 = response.headers().firstValue("date").get();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"response.headers().firstValue(\"date\").get()");
            Date responseDateTime = this.getLocalDateTime(string2);
            if (response.statusCode() == 200) {
                ObjectMapper objectMapper = GoogleOAuthService.Companion.getJacksonMapper();
                boolean bl = false;
                boolean bl2 = false;
                ObjectMapper $this$with = objectMapper;
                boolean bl3 = false;
                $this$with.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategies.SnakeCaseStrategy());
                RefreshResponseData responseData = (RefreshResponseData)$this$with.readValue((String)response.body(), RefreshResponseData.class);
                String string3 = responseData.getAccessToken();
                long l = responseData.getExpiresIn();
                String string4 = responseData.getTokenType();
                String string5 = responseData.getScope();
                Date date = DateUtils.addSeconds((Date)responseDateTime, (int)((int)responseData.getExpiresIn()));
                Intrinsics.checkNotNullExpressionValue((Object)date, (String)"DateUtils.addSeconds(res\u2026seData.expiresIn.toInt())");
                GoogleCredentials result = new GoogleCredentials(string3, refreshToken, l, string4, string5, date);
                request.complete(result);
            } else {
                CharSequence charSequence;
                CompletableFuture completableFuture = request;
                CharSequence charSequence2 = (CharSequence)response.body();
                boolean bl = false;
                CharSequence charSequence3 = charSequence2;
                boolean bl4 = false;
                if (charSequence3.length() == 0) {
                    CompletableFuture completableFuture2 = completableFuture;
                    boolean bl5 = false;
                    String string6 = "No token provided";
                    completableFuture = completableFuture2;
                    charSequence = string6;
                } else {
                    charSequence = charSequence2;
                }
                String string7 = (String)charSequence;
                completableFuture.completeExceptionally(new Exception(string7));
            }
        }
        catch (IOException e) {
            request.completeExceptionally(e);
        }
        return request;
    }

    public void revokeToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    protected GoogleCredentials getCredentials(@NotNull String responseBody, @NotNull HttpHeaders responseHeaders) {
        Intrinsics.checkNotNullParameter((Object)responseBody, (String)"responseBody");
        Intrinsics.checkNotNullParameter((Object)responseHeaders, (String)"responseHeaders");
        String string = responseHeaders.firstValue("date").get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"responseHeaders.firstValue(\"date\").get()");
        Date responseDateTime = this.getLocalDateTime(string);
        ObjectMapper objectMapper = GoogleOAuthService.Companion.getJacksonMapper();
        boolean bl = false;
        boolean bl2 = false;
        ObjectMapper $this$with = objectMapper;
        boolean bl3 = false;
        $this$with.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategies.SnakeCaseStrategy());
        AuthorizationResponseData responseData = (AuthorizationResponseData)$this$with.readValue(responseBody, AuthorizationResponseData.class);
        String string2 = responseData.getAccessToken();
        String string3 = responseData.getRefreshToken();
        long l = responseData.getExpiresIn();
        String string4 = responseData.getTokenType();
        String string5 = responseData.getScope();
        Date date = DateUtils.addSeconds((Date)responseDateTime, (int)((int)responseData.getExpiresIn()));
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"DateUtils.addSeconds(res\u2026seData.expiresIn.toInt())");
        return new GoogleCredentials(string2, string3, l, string4, string5, date);
    }

    @NotNull
    protected Url getAuthUrlWithParameters() {
        Pair[] pairArray = new Pair[7];
        pairArray[0] = TuplesKt.to((Object)"scope", (Object)GoogleOAuthService.Companion.getScope());
        pairArray[1] = TuplesKt.to((Object)"response_type", (Object)responseType);
        pairArray[2] = TuplesKt.to((Object)"code_challenge", (Object)GoogleOAuthService.Companion.getCodeChallenge());
        pairArray[3] = TuplesKt.to((Object)"code_challenge_method", (Object)codeChallengeMethod);
        pairArray[4] = TuplesKt.to((Object)"state", (Object)GoogleOAuthService.Companion.getState());
        GoogleCredentialUtils.GoogleAppCredentials googleAppCredentials = this.googleAppCred;
        pairArray[5] = TuplesKt.to((Object)"client_id", (Object)(googleAppCredentials != null ? googleAppCredentials.getClientId() : null));
        pairArray[6] = TuplesKt.to((Object)"redirect_uri", (Object)this.getAuthorizationCodeUrl().toExternalForm());
        Url url = GoogleOAuthService.Companion.getAUTHORIZE_URI().addParameters(MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"AUTHORIZE_URI.addParamet\u2026Url.toExternalForm()\n  ))");
        return url;
    }

    @NotNull
    protected Url getTokenUrlWithParameters(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)responseType);
        Pair[] pairArray = new Pair[6];
        GoogleCredentialUtils.GoogleAppCredentials googleAppCredentials = this.googleAppCred;
        pairArray[0] = TuplesKt.to((Object)"client_id", (Object)(googleAppCredentials != null ? googleAppCredentials.getClientId() : null));
        GoogleCredentialUtils.GoogleAppCredentials googleAppCredentials2 = this.googleAppCred;
        pairArray[1] = TuplesKt.to((Object)"client_secret", (Object)(googleAppCredentials2 != null ? googleAppCredentials2.getClientSecret() : null));
        pairArray[2] = TuplesKt.to((Object)"redirect_uri", (Object)this.getAuthorizationCodeUrl().toExternalForm());
        pairArray[3] = TuplesKt.to((Object)responseType, (Object)code);
        pairArray[4] = TuplesKt.to((Object)"code_verifier", (Object)codeVerifier);
        pairArray[5] = TuplesKt.to((Object)"grant_type", (Object)authGrantType);
        Url url = GoogleOAuthService.Companion.getTOKEN_URI().addParameters(MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"TOKEN_URI.addParameters(\u2026pe\" to authGrantType\n  ))");
        return url;
    }

    private final Url getRefreshTokenUrlWithParameters(String refreshToken) {
        Pair[] pairArray = new Pair[4];
        GoogleCredentialUtils.GoogleAppCredentials googleAppCredentials = this.googleAppCred;
        pairArray[0] = TuplesKt.to((Object)"client_id", (Object)(googleAppCredentials != null ? googleAppCredentials.getClientId() : null));
        GoogleCredentialUtils.GoogleAppCredentials googleAppCredentials2 = this.googleAppCred;
        pairArray[1] = TuplesKt.to((Object)"client_secret", (Object)(googleAppCredentials2 != null ? googleAppCredentials2.getClientSecret() : null));
        pairArray[2] = TuplesKt.to((Object)refreshGrantType, (Object)refreshToken);
        pairArray[3] = TuplesKt.to((Object)"grant_type", (Object)refreshGrantType);
        Url url = GoogleOAuthService.Companion.getTOKEN_URI().addParameters(MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"TOKEN_URI.addParameters(\u2026 to refreshGrantType\n  ))");
        return url;
    }

    private final Date getLocalDateTime(String responseDate) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        boolean bl = false;
        boolean bl2 = false;
        SimpleDateFormat $this$apply = simpleDateFormat;
        boolean bl3 = false;
        $this$apply.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.parse(responseDate);
    }

    static {
        Companion = new Companion(null);
        codeVerifier = DigestUtil.randomToken();
    }

    public static final /* synthetic */ AtomicReference access$getCurrentRequest$p(GoogleOAuthService $this) {
        return $this.getCurrentRequest();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006 "}, d2={"Lorg/intellij/plugins/markdown/google/authorization/GoogleOAuthService$AuthorizationResponseData;", "", "accessToken", "", "refreshToken", "expiresIn", "", "tokenType", "scope", "idToken", "(Ljava/lang/String;Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAccessToken", "()Ljava/lang/String;", "getExpiresIn", "()J", "getIdToken", "getRefreshToken", "getScope", "getTokenType", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.markdown"})
    private static final class AuthorizationResponseData {
        @NotNull
        private final String accessToken;
        @NotNull
        private final String refreshToken;
        private final long expiresIn;
        @NotNull
        private final String tokenType;
        @NotNull
        private final String scope;
        @NotNull
        private final String idToken;

        @NotNull
        public final String getAccessToken() {
            return this.accessToken;
        }

        @NotNull
        public final String getRefreshToken() {
            return this.refreshToken;
        }

        public final long getExpiresIn() {
            return this.expiresIn;
        }

        @NotNull
        public final String getTokenType() {
            return this.tokenType;
        }

        @NotNull
        public final String getScope() {
            return this.scope;
        }

        @NotNull
        public final String getIdToken() {
            return this.idToken;
        }

        public AuthorizationResponseData(@NotNull String accessToken, @NotNull String refreshToken, long expiresIn, @NotNull String tokenType, @NotNull String scope, @NotNull String idToken) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
            Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)idToken, (String)"idToken");
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
            this.expiresIn = expiresIn;
            this.tokenType = tokenType;
            this.scope = scope;
            this.idToken = idToken;
        }

        @NotNull
        public final String component1() {
            return this.accessToken;
        }

        @NotNull
        public final String component2() {
            return this.refreshToken;
        }

        public final long component3() {
            return this.expiresIn;
        }

        @NotNull
        public final String component4() {
            return this.tokenType;
        }

        @NotNull
        public final String component5() {
            return this.scope;
        }

        @NotNull
        public final String component6() {
            return this.idToken;
        }

        @NotNull
        public final AuthorizationResponseData copy(@NotNull String accessToken, @NotNull String refreshToken, long expiresIn, @NotNull String tokenType, @NotNull String scope, @NotNull String idToken) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
            Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)idToken, (String)"idToken");
            return new AuthorizationResponseData(accessToken, refreshToken, expiresIn, tokenType, scope, idToken);
        }

        public static /* synthetic */ AuthorizationResponseData copy$default(AuthorizationResponseData authorizationResponseData, String string, String string2, long l, String string3, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                string = authorizationResponseData.accessToken;
            }
            if ((n & 2) != 0) {
                string2 = authorizationResponseData.refreshToken;
            }
            if ((n & 4) != 0) {
                l = authorizationResponseData.expiresIn;
            }
            if ((n & 8) != 0) {
                string3 = authorizationResponseData.tokenType;
            }
            if ((n & 0x10) != 0) {
                string4 = authorizationResponseData.scope;
            }
            if ((n & 0x20) != 0) {
                string5 = authorizationResponseData.idToken;
            }
            return authorizationResponseData.copy(string, string2, l, string3, string4, string5);
        }

        @NotNull
        public String toString() {
            return "AuthorizationResponseData(accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + ", expiresIn=" + this.expiresIn + ", tokenType=" + this.tokenType + ", scope=" + this.scope + ", idToken=" + this.idToken + ")";
        }

        public int hashCode() {
            String string = this.accessToken;
            String string2 = this.refreshToken;
            String string3 = this.tokenType;
            String string4 = this.scope;
            String string5 = this.idToken;
            return (((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + Long.hashCode(this.expiresIn)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof AuthorizationResponseData)) break block3;
                    AuthorizationResponseData authorizationResponseData = (AuthorizationResponseData)object;
                    if (!Intrinsics.areEqual((Object)this.accessToken, (Object)authorizationResponseData.accessToken) || !Intrinsics.areEqual((Object)this.refreshToken, (Object)authorizationResponseData.refreshToken) || this.expiresIn != authorizationResponseData.expiresIn || !Intrinsics.areEqual((Object)this.tokenType, (Object)authorizationResponseData.tokenType) || !Intrinsics.areEqual((Object)this.scope, (Object)authorizationResponseData.scope) || !Intrinsics.areEqual((Object)this.idToken, (Object)authorizationResponseData.idToken)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lorg/intellij/plugins/markdown/google/authorization/GoogleOAuthService$RefreshResponseData;", "", "accessToken", "", "expiresIn", "", "scope", "tokenType", "idToken", "(Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAccessToken", "()Ljava/lang/String;", "getExpiresIn", "()J", "getIdToken", "getScope", "getTokenType", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.markdown"})
    private static final class RefreshResponseData {
        @NotNull
        private final String accessToken;
        private final long expiresIn;
        @NotNull
        private final String scope;
        @NotNull
        private final String tokenType;
        @NotNull
        private final String idToken;

        @NotNull
        public final String getAccessToken() {
            return this.accessToken;
        }

        public final long getExpiresIn() {
            return this.expiresIn;
        }

        @NotNull
        public final String getScope() {
            return this.scope;
        }

        @NotNull
        public final String getTokenType() {
            return this.tokenType;
        }

        @NotNull
        public final String getIdToken() {
            return this.idToken;
        }

        public RefreshResponseData(@NotNull String accessToken, long expiresIn, @NotNull String scope, @NotNull String tokenType, @NotNull String idToken) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
            Intrinsics.checkNotNullParameter((Object)idToken, (String)"idToken");
            this.accessToken = accessToken;
            this.expiresIn = expiresIn;
            this.scope = scope;
            this.tokenType = tokenType;
            this.idToken = idToken;
        }

        @NotNull
        public final String component1() {
            return this.accessToken;
        }

        public final long component2() {
            return this.expiresIn;
        }

        @NotNull
        public final String component3() {
            return this.scope;
        }

        @NotNull
        public final String component4() {
            return this.tokenType;
        }

        @NotNull
        public final String component5() {
            return this.idToken;
        }

        @NotNull
        public final RefreshResponseData copy(@NotNull String accessToken, long expiresIn, @NotNull String scope, @NotNull String tokenType, @NotNull String idToken) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
            Intrinsics.checkNotNullParameter((Object)idToken, (String)"idToken");
            return new RefreshResponseData(accessToken, expiresIn, scope, tokenType, idToken);
        }

        public static /* synthetic */ RefreshResponseData copy$default(RefreshResponseData refreshResponseData, String string, long l, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = refreshResponseData.accessToken;
            }
            if ((n & 2) != 0) {
                l = refreshResponseData.expiresIn;
            }
            if ((n & 4) != 0) {
                string2 = refreshResponseData.scope;
            }
            if ((n & 8) != 0) {
                string3 = refreshResponseData.tokenType;
            }
            if ((n & 0x10) != 0) {
                string4 = refreshResponseData.idToken;
            }
            return refreshResponseData.copy(string, l, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "RefreshResponseData(accessToken=" + this.accessToken + ", expiresIn=" + this.expiresIn + ", scope=" + this.scope + ", tokenType=" + this.tokenType + ", idToken=" + this.idToken + ")";
        }

        public int hashCode() {
            String string = this.accessToken;
            String string2 = this.scope;
            String string3 = this.tokenType;
            String string4 = this.idToken;
            return ((((string != null ? string.hashCode() : 0) * 31 + Long.hashCode(this.expiresIn)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RefreshResponseData)) break block3;
                    RefreshResponseData refreshResponseData = (RefreshResponseData)object;
                    if (!Intrinsics.areEqual((Object)this.accessToken, (Object)refreshResponseData.accessToken) || this.expiresIn != refreshResponseData.expiresIn || !Intrinsics.areEqual((Object)this.scope, (Object)refreshResponseData.scope) || !Intrinsics.areEqual((Object)this.tokenType, (Object)refreshResponseData.tokenType) || !Intrinsics.areEqual((Object)this.idToken, (Object)refreshResponseData.idToken)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\rR\u0014\u0010\u001c\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\r\u00a8\u0006\u001e"}, d2={"Lorg/intellij/plugins/markdown/google/authorization/GoogleOAuthService$Companion;", "", "()V", "AUTHORIZE_URI", "Lcom/intellij/util/Url;", "getAUTHORIZE_URI", "()Lcom/intellij/util/Url;", "TOKEN_URI", "getTOKEN_URI", "authGrantType", "", "codeChallenge", "getCodeChallenge", "()Ljava/lang/String;", "codeChallengeMethod", "codeVerifier", "jacksonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getJacksonMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "port", "", "getPort", "()I", "refreshGrantType", "responseType", "scope", "getScope", "state", "getState", "intellij.markdown"})
    public static final class Companion {
        private final String getScope() {
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])new String[]{"https://www.googleapis.com/auth/drive.readonly", "https://www.googleapis.com/auth/userinfo.profile"}), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }

        private final int getPort() {
            return BuiltInServerManager.Companion.getInstance().getPort();
        }

        private final String getState() {
            return DigestUtil.randomToken();
        }

        private final String getCodeChallenge() {
            Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
            MessageDigest messageDigest = DigestUtil.sha256();
            String string = codeVerifier;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            String string3 = encoder.encodeToString(messageDigest.digest(byArray));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Base64.getUrlEncoder().w\u2026eVerifier.toByteArray()))");
            return string3;
        }

        private final Url getAUTHORIZE_URI() {
            return Urls.newFromEncoded((String)"https://accounts.google.com/o/oauth2/v2/auth");
        }

        private final Url getTOKEN_URI() {
            return Urls.newFromEncoded((String)"https://oauth2.googleapis.com/token");
        }

        private final ObjectMapper getJacksonMapper() {
            return ExtensionsKt.jacksonObjectMapper();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

