/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.ui.preview.PreviewStaticServer;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/PreviewStaticServer;", "Lorg/jetbrains/ide/HttpRequestHandler;", "()V", "resourceProvider", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "getResourceProvider", "()Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "setResourceProvider", "(Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;)V", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "Companion", "intellij.markdown"})
public final class PreviewStaticServer
extends HttpRequestHandler {
    @NotNull
    private ResourceProvider resourceProvider = ResourceProvider.Companion.getDefault();
    private static final String PREFIX = "/4f800f8a-bbed-4dd8-b03c-00449c9f6698/";
    private static final String[] typesForExplicitUtfCharset;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public final void setResourceProvider(@NotNull ResourceProvider resourceProvider) {
        Intrinsics.checkNotNullParameter((Object)resourceProvider, (String)"<set-?>");
        this.resourceProvider = resourceProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!super.isSupported(request)) return false;
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.uri()");
        if (!StringsKt.startsWith$default((String)string, (String)PREFIX, (boolean)false, (int)2, null)) return false;
        return true;
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        String path;
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = path = urlDecoder.path();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
        boolean bl = StringsKt.startsWith$default((String)string, (String)PREFIX, (boolean)false, (int)2, null);
        boolean bl2 = false;
        int n = 0;
        if (!bl) {
            boolean bl3 = false;
            String string2 = "prefix should have been checked by #isSupported";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String string3 = path;
        n = PREFIX.length();
        boolean bl4 = false;
        String string4 = string3.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        String resourceName = string4;
        if (this.resourceProvider.canProvide(resourceName)) {
            HttpRequest httpRequest = (HttpRequest)request;
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"context.channel()");
            PreviewStaticServer.Companion.sendResource(httpRequest, channel, this.resourceProvider.loadResource(resourceName), resourceName);
            return true;
        }
        return false;
    }

    static {
        Companion = new Companion(null);
        typesForExplicitUtfCharset = new String[]{"application/javascript", "text/html", "text/css", "image/svg+xml"};
    }

    @NotNull
    public static final PreviewStaticServer getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @NotNull
    public static final String createCSP(@NotNull List<String> scripts, @NotNull List<String> styles) {
        return Companion.createCSP(scripts, styles);
    }

    @JvmStatic
    @NotNull
    public static final String getStaticUrl(@NotNull String staticPath) {
        return Companion.getStaticUrl(staticPath);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\r\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0007J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0007J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J*\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0014\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u00068FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u001d"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/PreviewStaticServer$Companion;", "", "()V", "PREFIX", "", "instance", "Lorg/intellij/plugins/markdown/ui/preview/PreviewStaticServer;", "getInstance$annotations", "getInstance", "()Lorg/intellij/plugins/markdown/ui/preview/PreviewStaticServer;", "typesForExplicitUtfCharset", "", "[Ljava/lang/String;", "createCSP", "scripts", "", "styles", "getStaticUrl", "staticPath", "guessContentType", "resourceName", "sendResource", "", "request", "Lio/netty/handler/codec/http/HttpRequest;", "channel", "Lio/netty/channel/Channel;", "resource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "intellij.markdown"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @NotNull
        public final PreviewStaticServer getInstance() {
            PreviewStaticServer previewStaticServer = (PreviewStaticServer)((Object)HttpRequestHandler.Companion.getEP_NAME().findExtension(PreviewStaticServer.class));
            if (previewStaticServer == null) {
                String string = "Could not get server instance!";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return previewStaticServer;
        }

        @JvmStatic
        @NotNull
        public final String createCSP(@NotNull List<String> scripts, @NotNull List<String> styles) {
            String string;
            String p1;
            Collection<String> collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter(scripts, (String)"scripts");
            Intrinsics.checkNotNullParameter(styles, (String)"styles");
            createCSP.1 $fun$stripQueryParameters$1 = createCSP.1.INSTANCE;
            Iterable iterable = scripts;
            StringBuilder stringBuilder = new StringBuilder().append("\n        default-src 'none';\n        script-src ");
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                string = createCSP.1.INSTANCE.invoke(p1);
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = styles;
            stringBuilder = stringBuilder.append(StringUtil.join((Collection)collection, (String)" ")).append(";\n        style-src https: ");
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                p1 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                string = createCSP.1.INSTANCE.invoke(p1);
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            return stringBuilder.append(StringUtil.join(collection, (String)" ")).append(" 'unsafe-inline';\n        img-src file: *; connect-src 'none'; font-src * data: *;\n        object-src 'none'; media-src 'none'; child-src 'none';\n      ").toString();
        }

        @JvmStatic
        @NotNull
        public final String getStaticUrl(@NotNull String staticPath) {
            Intrinsics.checkNotNullParameter((Object)staticPath, (String)"staticPath");
            Url url = Urls.parseEncoded((String)("http://localhost:" + BuiltInServerManager.Companion.getInstance().getPort() + PreviewStaticServer.PREFIX + staticPath));
            boolean bl = false;
            boolean bl2 = false;
            if (url == null) {
                boolean bl3 = false;
                String string = "Could not parse url!";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            String string = BuiltInServerManager.Companion.getInstance().addAuthToken(url).toExternalForm();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInstance().addAuthToken(url).toExternalForm()");
            return string;
        }

        private final String guessContentType(String resourceName) {
            String type = FileResponses.INSTANCE.getContentType(resourceName);
            return ArraysKt.contains((Object[])typesForExplicitUtfCharset, (Object)type) ? type + "; charset=utf-8" : type;
        }

        private final void sendResource(HttpRequest request, Channel channel, ResourceProvider.Resource resource, String resourceName) {
            ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
            Calendar calendar = applicationInfo.getBuildDate();
            Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"ApplicationInfo.getInstance().buildDate");
            long lastModified = calendar.getTimeInMillis();
            if (FileResponses.checkCache$default((FileResponses)FileResponses.INSTANCE, (HttpRequest)request, (Channel)channel, (long)lastModified, null, (int)8, null)) {
                return;
            }
            if (resource == null) {
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"HttpResponseStatus.NOT_FOUND");
                Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)request, null, null, (int)12, null);
                return;
            }
            FullHttpResponse response = (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])resource.getContent()));
            boolean bl = false;
            boolean bl2 = false;
            FullHttpResponse $this$with = response;
            boolean bl3 = false;
            if (resource.getType() != null) {
                $this$with.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)resource.getType());
            } else {
                $this$with.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)Companion.guessContentType(resourceName));
            }
            $this$with.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"private, must-revalidate");
            $this$with.headers().set((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)new Date(lastModified));
            Responses.send$default((HttpResponse)((HttpResponse)$this$with), (Channel)channel, (HttpRequest)request, null, (int)4, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

