/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.inspection.grammar.quickfix;

import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.ide.fus.GrazieFUSCounter;
import com.intellij.grazie.ide.ui.components.dsl.SwingKTKt;
import com.intellij.grazie.ide.ui.grammar.GrazieConfigurable;
import com.intellij.grazie.text.Rule;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/quickfix/GrazieRuleSettingsAction;", "Lcom/intellij/codeInspection/IntentionAndQuickFixAction;", "Lcom/intellij/openapi/util/Iconable;", "ruleName", "", "rule", "Lcom/intellij/grazie/text/Rule;", "(Ljava/lang/String;Lcom/intellij/grazie/text/Rule;)V", "analyzeStateChange", "state1", "Lcom/intellij/grazie/GrazieConfig$State;", "state2", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getFamilyName", "getIcon", "Ljavax/swing/Icon;", "flags", "", "getName", "startInWriteAction", "", "intellij.grazie.core"})
public final class GrazieRuleSettingsAction
extends IntentionAndQuickFixAction
implements Iconable {
    private final String ruleName;
    private final Rule rule;

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = AllIcons.Actions.Edit;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.Actions.Edit");
        return icon;
    }

    @NotNull
    public String getName() {
        return SwingKTKt.msg("grazie.grammar.quickfix.open.rule.text", this.ruleName);
    }

    @NotNull
    public String getFamilyName() {
        return SwingKTKt.msg("grazie.grammar.quickfix.open.rule.family", new String[0]);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @Nullable PsiFile file2, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GrazieConfig.State state1 = GrazieConfig.Companion.get();
        GrazieConfigurable configurable = new GrazieConfigurable();
        String string = this.rule.getGlobalId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rule.globalId");
        configurable.selectRule$intellij_grazie_core(string);
        boolean ok = ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable);
        String result2 = !ok ? "canceled" : this.analyzeStateChange(state1, GrazieConfig.Companion.get());
        GrazieFUSCounter.INSTANCE.quickFixInvoked(this.rule, project, "rule.settings:" + result2);
    }

    private final String analyzeStateChange(GrazieConfig.State state1, GrazieConfig.State state2) {
        if (Intrinsics.areEqual((Object)state1, (Object)state2)) {
            return "unmodified";
        }
        boolean bl = false;
        ArrayList<String> changes = new ArrayList<String>();
        if (state1.getCheckingContext().languagesDiffer(state2.getCheckingContext())) {
            changes.add("languages");
        }
        if (state1.getCheckingContext().domainsDiffer(state2.getCheckingContext())) {
            changes.add("domains");
        }
        if (Intrinsics.areEqual(state1.getUserDisabledRules(), state2.getUserDisabledRules()) ^ true || Intrinsics.areEqual(state1.getUserEnabledRules(), state2.getUserEnabledRules()) ^ true) {
            changes.add("rules");
        }
        if (changes.isEmpty()) {
            changes.add("unclassified");
        }
        return "changes:" + CollectionsKt.joinToString$default((Iterable)changes, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    public GrazieRuleSettingsAction(@NotNull String ruleName, @NotNull Rule rule) {
        Intrinsics.checkNotNullParameter((Object)ruleName, (String)"ruleName");
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        this.ruleName = ruleName;
        this.rule = rule;
    }
}

