/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion.perf;

import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.profiler.MisConfiguredException;
import com.intellij.profiler.api.AttachFailedException;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.api.XLocalAttachProfiler;
import com.intellij.profiler.clion.CPPProfilerBundleKt;
import com.intellij.profiler.clion.NativeTargetProcess;
import com.intellij.profiler.clion.perf.PerfUtils;
import com.intellij.profiler.linux.KernelVariablesChangeRequiredException;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileUtil;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\r\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f0\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/clion/perf/PerfAttachProfiler;", "Lcom/intellij/profiler/api/XLocalAttachProfiler;", "processInfo", "Lcom/intellij/execution/process/ProcessInfo;", "(Lcom/intellij/execution/process/ProcessInfo;)V", "profilerDisplayName", "", "getProfilerDisplayName", "()Ljava/lang/String;", "targetProcess", "Lcom/intellij/profiler/clion/NativeTargetProcess;", "getTargetProcess", "()Lcom/intellij/profiler/clion/NativeTargetProcess;", "attachProfiler", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/profiler/api/ProfilerProcess;", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.profiler.clion"})
public final class PerfAttachProfiler
implements XLocalAttachProfiler {
    @NotNull
    private final String profilerDisplayName;
    @NotNull
    private final NativeTargetProcess targetProcess;

    @NotNull
    public String getProfilerDisplayName() {
        return this.profilerDisplayName;
    }

    @NotNull
    public NativeTargetProcess getTargetProcess() {
        return this.targetProcess;
    }

    @NotNull
    public Promise<? extends ProfilerProcess<? extends AttachableTargetProcess>> attachProfiler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!SystemInfo.isLinux) {
            return Promises.rejectedPromise((Throwable)((Throwable)new AttachFailedException(CPPProfilerBundleKt.profilerMessage("profiler.exception.not.supported.so", new Object[0]))));
        }
        CidrToolEnvironment cidrToolEnvironment = MemoryProfileUtil.getEnvironment(project);
        if (cidrToolEnvironment == null) {
            cidrToolEnvironment = new CidrToolEnvironment();
        }
        Intrinsics.checkNotNullExpressionValue((Object)cidrToolEnvironment, (String)"MemoryProfileUtil.getEnv\u2026 ?: CidrToolEnvironment()");
        CidrToolEnvironment environment2 = cidrToolEnvironment;
        MisConfiguredException misConfiguredException = PerfUtils.Companion.validatePerfSettings(environment2, project);
        if (misConfiguredException != null) {
            MisConfiguredException misConfiguredException2 = misConfiguredException;
            boolean bl = false;
            boolean bl2 = false;
            MisConfiguredException it = misConfiguredException2;
            boolean bl3 = false;
            return Promises.rejectedPromise((Throwable)((Throwable)it));
        }
        KernelVariablesChangeRequiredException kernelVariablesChangeRequiredException = PerfUtils.Companion.validateKernelVariables(environment2, project);
        if (kernelVariablesChangeRequiredException != null) {
            KernelVariablesChangeRequiredException kernelVariablesChangeRequiredException2 = kernelVariablesChangeRequiredException;
            boolean bl = false;
            boolean bl4 = false;
            KernelVariablesChangeRequiredException it = kernelVariablesChangeRequiredException2;
            boolean bl5 = false;
            return Promises.rejectedPromise((Throwable)((Throwable)it));
        }
        AttachableTargetProcess attachableTargetProcess = this.getTargetProcess();
        PerformInBackgroundOption performInBackgroundOption = PerformInBackgroundOption.DEAF;
        Intrinsics.checkNotNullExpressionValue((Object)performInBackgroundOption, (String)"PerformInBackgroundOption.DEAF");
        return PerfUtils.Companion.attachPerfProfiler(attachableTargetProcess, performInBackgroundOption, environment2, project);
    }

    public PerfAttachProfiler(@NotNull ProcessInfo processInfo) {
        Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
        this.profilerDisplayName = "Perf profiler";
        this.targetProcess = new NativeTargetProcess(processInfo);
    }
}

