/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion.perf;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Version;
import com.intellij.profiler.clion.CPPProfilerBundleKt;
import com.intellij.profiler.clion.perf.PerfProfilerSettings;
import com.intellij.profiler.clion.perf.PerfSample;
import com.intellij.profiler.clion.perf.PerfScriptParser;
import com.intellij.profiler.clion.perf.PerfUtils;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/profiler/clion/perf/PerfScriptProcess;", "", "()V", "Companion", "intellij.profiler.clion"})
public final class PerfScriptProcess {
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PerfScriptProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JW\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2!\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00070\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0012\u0010\u001b\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/profiler/clion/perf/PerfScriptProcess$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "execute", "", "perfDataPath", "Ljava/nio/file/Path;", "withNavigationData", "", "onSampleParsed", "Lkotlin/Function1;", "Lcom/intellij/profiler/clion/perf/PerfSample;", "Lkotlin/ParameterName;", "name", "sample", "onFinish", "Lkotlin/Function0;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "isNavigationSupported", "version", "Lcom/intellij/openapi/util/Version;", "isNoInlineSupported", "intellij.profiler.clion"})
    public static final class Companion {
        public final void execute(@NotNull Path perfDataPath, boolean withNavigationData, @NotNull Function1<? super PerfSample, Unit> onSampleParsed, @NotNull Function0<Unit> onFinish, @NotNull CidrToolEnvironment environment2, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)perfDataPath, (String)"perfDataPath");
            Intrinsics.checkNotNullParameter(onSampleParsed, (String)"onSampleParsed");
            Intrinsics.checkNotNullParameter(onFinish, (String)"onFinish");
            Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            if (!Files.exists(perfDataPath, new LinkOption[0])) {
                LOG.warn("Cannot execute perf script: perf data is not found");
                onFinish.invoke();
                return;
            }
            Version perfVersion = PerfUtils.Companion.getPerfVersion(environment2, indicator);
            GeneralCommandLine cl = new GeneralCommandLine();
            String string = environment2.toEnvPath(PerfProfilerSettings.Companion.getInstance().getState().getExecutablePath());
            if (string == null) {
                throw (Throwable)new ExecutionException(CPPProfilerBundleKt.profilerMessage("profiler.exception.perf.empty.path", new Object[0]));
            }
            cl.setExePath(string);
            if (withNavigationData) {
                if (!this.isNavigationSupported(perfVersion)) {
                    Version version = perfVersion;
                    LOG.info("Navigation is not supported for perf version: " + (version != null ? version.toCompactString() : null));
                    onFinish.invoke();
                    return;
                }
                cl.addParameters(new String[]{"script", "--fields", "comm,tid,ip,sym,dso,srcline", "--full-source-path"});
            } else {
                cl.addParameters(new String[]{"script", "--fields", "comm,tid,ip,sym,dso"});
            }
            if (this.isNoInlineSupported(perfVersion)) {
                cl.addParameter("--no-inline");
            }
            cl.addParameters(new String[]{"-i", environment2.toEnvPath(((Object)perfDataPath).toString())});
            PerfScriptParser parser = new PerfScriptParser(environment2, onSampleParsed);
            BaseProcessHandler<?> processHandler = PerfUtils.Companion.createProcessHandler(cl, environment2, parser);
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(parser, onFinish){
                final /* synthetic */ PerfScriptParser $parser;
                final /* synthetic */ Function0 $onFinish;

                public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.$parser.finish();
                    this.$onFinish.invoke();
                }
                {
                    this.$parser = $captured_local_variable$0;
                    this.$onFinish = $captured_local_variable$1;
                }
            });
            CidrToolsUtil.runProcess(processHandler, (ProgressIndicator)indicator, (int)-1);
        }

        private final boolean isNavigationSupported(Version version) {
            return version != null && version.major >= 4;
        }

        private final boolean isNoInlineSupported(Version version) {
            return version != null && version.major >= 5;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

