/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakeCodeBlocks {
    @NotNull
    private final Map<String, String> myFilePathsWithFolders;
    @NotNull
    private final Map<String, String> myTargetTypes;

    private CMakeCodeBlocks(@NotNull Element root) {
        if (root == null) {
            CMakeCodeBlocks.$$$reportNull$$$0(0);
        }
        Element project = root.getChild("Project");
        HashMap<String, String> filePaths = new HashMap<String, String>();
        HashMap<String, String> targetTypes = new HashMap<String, String>();
        if (project != null) {
            for (Element eachUnit : project.getChildren("Unit")) {
                String path = eachUnit.getAttributeValue("filename");
                if (path == null) continue;
                Element option = eachUnit.getChild("Option");
                String group = StringUtil.notNullize(option == null ? null : option.getAttributeValue("virtualFolder"));
                filePaths.put(path, group);
            }
            Element build = project.getChild("Build");
            if (build != null) {
                block1: for (Element eachTarget : build.getChildren("Target")) {
                    String targetName = eachTarget.getAttributeValue("title");
                    if (targetName == null) continue;
                    for (Element eachOption : eachTarget.getChildren("Option")) {
                        String type = eachOption.getAttributeValue("type");
                        if (type == null) continue;
                        targetTypes.put(targetName, type);
                        continue block1;
                    }
                }
            }
        }
        this.myFilePathsWithFolders = Collections.unmodifiableMap(filePaths);
        this.myTargetTypes = Collections.unmodifiableMap(targetTypes);
    }

    @Nullable
    public static CMakeCodeBlocks load(@NotNull File codeBlocksFile) throws JDOMException, IOException {
        if (codeBlocksFile == null) {
            CMakeCodeBlocks.$$$reportNull$$$0(1);
        }
        return codeBlocksFile.exists() ? new CMakeCodeBlocks(JDOMUtil.load((File)codeBlocksFile)) : null;
    }

    @NotNull
    public Map<String, String> getFilePathsWithFolders() {
        Map<String, String> map2 = this.myFilePathsWithFolders;
        if (map2 == null) {
            CMakeCodeBlocks.$$$reportNull$$$0(2);
        }
        return map2;
    }

    @NotNull
    public Map<String, String> getTargetTypes() {
        Map<String, String> map2 = this.myTargetTypes;
        if (map2 == null) {
            CMakeCodeBlocks.$$$reportNull$$$0(3);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlocksFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeCodeBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeCodeBlocks";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePathsWithFolders";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

