/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.CMakeRunner;
import com.jetbrains.cidr.cpp.cmake.CMakeRunnerStep;
import com.jetbrains.cidr.cpp.cmake.model.CMakeApiProfileGenerationResult;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCacheFile;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeFileProfileGenerationResult;
import com.jetbrains.cidr.cpp.cmake.model.CMakeFileSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorType;
import com.jetbrains.cidr.cpp.cmake.model.CMakeListener;
import com.jetbrains.cidr.cpp.cmake.model.CMakeMessage;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModel;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModelConfigurationData;
import com.jetbrains.cidr.cpp.cmake.model.CMakeProfileGenerationResult;
import com.jetbrains.cidr.cpp.cmake.model.CMakeProfileTargetInfo;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTargetInfoComparator;
import com.jetbrains.cidr.cpp.cmake.presets.ParseKt;
import com.jetbrains.cidr.cpp.toolchains.CMakeExecutableTool;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class CMakeGenerator {
    private static boolean ourForceApi;
    public static final String CMAKE_FILES_FOLDER = "CMakeFiles";
    public static final Map<@NlsSafe String, OCLanguageKind> PREDEFINED_EXTENSION_TO_LANGUAGE_MAP;
    public static final Version API_MIN_CMAKE_VERSION;
    @NlsSafe
    private static final String GENERATOR_FLAG = "-G";
    @NlsSafe
    private static final String ALL_TARGET_MULTI_CONF = "ALL_BUILD";
    private static List<String> ourEmulateCMakeExecutionErrorInProfiles;
    @Nullable
    private static List<Pair<String, String>> ourEmulateProductNotFoundForTargetAndProfile;
    private static final AtomicLong ourTotalGenerationTime;
    @NotNull
    final Project myProject;
    @NotNull
    private final File myProjectDir;
    @NotNull
    private final List<Parameters> myParameters;
    @Nullable
    private final String myPreferredEncoding;
    @NotNull
    private final Charset myDefaultCharset;

    public boolean shouldEmulateProductNotFoundForTargetAndProfile(Pair<String, String> pair) {
        return ourEmulateProductNotFoundForTargetAndProfile != null && ourEmulateProductNotFoundForTargetAndProfile.contains(pair);
    }

    public static void setForceAPI(boolean forceAPI) {
        ourForceApi = forceAPI;
    }

    public static boolean isAPIForced() {
        return ourForceApi;
    }

    private static CMakeProfileGenerationResult createProfileGenerationResult(@NotNull CMakeGenerator generator2, @NotNull Parameters parameters, @Nullable CMakeModel previousModel) {
        NullableLazyValue<ToolVersion> lazyCMakeVersion;
        if (generator2 == null) {
            CMakeGenerator.$$$reportNull$$$0(0);
        }
        if (parameters == null) {
            CMakeGenerator.$$$reportNull$$$0(1);
        }
        return CMakeGenerator.shouldUseAPI(parameters, lazyCMakeVersion = CMakeGenerator.createLazyCMakeVersion(parameters)) ? new CMakeApiProfileGenerationResult(generator2, parameters, previousModel) : new CMakeFileProfileGenerationResult(generator2, parameters, previousModel, (ToolVersion)lazyCMakeVersion.getValue());
    }

    @NotNull
    private static NullableLazyValue<ToolVersion> createLazyCMakeVersion(@NotNull Parameters parameters) {
        if (parameters == null) {
            CMakeGenerator.$$$reportNull$$$0(2);
        }
        NullableLazyValue nullableLazyValue = NullableLazyValue.createValue(() -> CMakeExecutableTool.readCMakeToolVersion((CPPToolchains.Toolchain)parameters.environment.getToolchain()));
        if (nullableLazyValue == null) {
            CMakeGenerator.$$$reportNull$$$0(3);
        }
        return nullableLazyValue;
    }

    public static boolean shouldUseAPI(@NotNull Parameters finalParams) {
        if (finalParams == null) {
            CMakeGenerator.$$$reportNull$$$0(4);
        }
        return CMakeGenerator.shouldUseAPI(finalParams, CMakeGenerator.createLazyCMakeVersion(finalParams));
    }

    public static boolean shouldUseAPI(@NotNull Parameters finalParams, @NotNull NullableLazyValue<? extends ToolVersion> lazyCMakeVersion) {
        if (finalParams == null) {
            CMakeGenerator.$$$reportNull$$$0(5);
        }
        if (lazyCMakeVersion == null) {
            CMakeGenerator.$$$reportNull$$$0(6);
        }
        return (CMakeGenerator.isAPIForced() || CMakeGenerator.getUserSpecifiedGenerator(finalParams.additionalOptions) != null) && CMakeGenerator.checkAPICompatibleCMake((ToolVersion)lazyCMakeVersion.getValue()) == APICompatibilityResult.OK;
    }

    public static boolean isSingleConfigurationGenerator(@Nullable String generator2) {
        return generator2 == null || generator2.contains("Ninja") && !generator2.contains("Multi-Config") || generator2.contains("Make");
    }

    public static boolean isParallelBuildByDefault(@NotNull String generator2) {
        if (generator2 == null) {
            CMakeGenerator.$$$reportNull$$$0(7);
        }
        return CMakeGenerator.hasParallelBuildSupport(generator2) && (!generator2.contains("Make") || generator2.contains(" JOM"));
    }

    public static boolean hasParallelBuildSupport(@NotNull String generator2) {
        if (generator2 == null) {
            CMakeGenerator.$$$reportNull$$$0(8);
        }
        return !generator2.contains("Watcom") && !generator2.contains("Borland") && (!generator2.contains("NMake") || generator2.contains(" JOM"));
    }

    public static boolean hasUnixLikeMakefileGenerator(@NotNull List<String> generationOptions2) {
        String generator2;
        if (generationOptions2 == null) {
            CMakeGenerator.$$$reportNull$$$0(9);
        }
        return (generator2 = CMakeGenerator.getUserSpecifiedGenerator(generationOptions2)) == null || generator2.contains("Unix") || generator2.contains("MinGW") || generator2.contains("MSYS");
    }

    @NotNull
    public static String getAllTargetName(@NotNull String generator2) {
        if (generator2 == null) {
            CMakeGenerator.$$$reportNull$$$0(10);
        }
        return CMakeGenerator.isSingleConfigurationGenerator(generator2) || generator2.contains("Ninja") ? "all" : ALL_TARGET_MULTI_CONF;
    }

    @Nullable
    public static String getUserSpecifiedGenerator(@NotNull List<String> options) {
        if (options == null) {
            CMakeGenerator.$$$reportNull$$$0(11);
        }
        String generator2 = null;
        int genFlagIdx = CMakeGenerator.getGeneratorFlagIndex(options);
        if (genFlagIdx >= 0) {
            String flag = options.get(genFlagIdx);
            if (flag.length() > GENERATOR_FLAG.length()) {
                generator2 = flag.substring(GENERATOR_FLAG.length());
            } else if (genFlagIdx + 1 < options.size()) {
                generator2 = options.get(genFlagIdx + 1);
            }
        }
        return generator2;
    }

    public static boolean hasUserSpecifiedGenerator(@NotNull List<String> options) {
        if (options == null) {
            CMakeGenerator.$$$reportNull$$$0(12);
        }
        return CMakeGenerator.getGeneratorFlagIndex(options) >= 0;
    }

    private static int getGeneratorFlagIndex(@NotNull List<String> options) {
        if (options == null) {
            CMakeGenerator.$$$reportNull$$$0(13);
        }
        return ContainerUtil.lastIndexOf(options, o -> o.startsWith(GENERATOR_FLAG));
    }

    @NotNull
    public static APICompatibilityResult checkAPICompatibleCMake(@Nullable CPPToolchains.Toolchain toolchain) {
        ToolVersion cMakeVersion = CMakeExecutableTool.readCMakeToolVersion((CPPToolchains.Toolchain)toolchain);
        return CMakeGenerator.checkAPICompatibleCMake(cMakeVersion);
    }

    @NotNull
    public static APICompatibilityResult checkAPICompatibleCMake(@Nullable ToolVersion cMakeVersion) {
        if (cMakeVersion == null) {
            APICompatibilityResult aPICompatibilityResult = APICompatibilityResult.NOT_DETERMINED;
            if (aPICompatibilityResult == null) {
                CMakeGenerator.$$$reportNull$$$0(14);
            }
            return aPICompatibilityResult;
        }
        if (CPPToolchainsUtil.compareVersions((Version)API_MIN_CMAKE_VERSION, (Version)cMakeVersion.versionNumber) < 0) {
            APICompatibilityResult aPICompatibilityResult = APICompatibilityResult.UNSUPPORTED;
            if (aPICompatibilityResult == null) {
                CMakeGenerator.$$$reportNull$$$0(15);
            }
            return aPICompatibilityResult;
        }
        APICompatibilityResult aPICompatibilityResult = APICompatibilityResult.OK;
        if (aPICompatibilityResult == null) {
            CMakeGenerator.$$$reportNull$$$0(16);
        }
        return aPICompatibilityResult;
    }

    @TestOnly
    public static void setEmulateCMakeExecutionErrorInTests(String ... emulateInProfiles) {
        ourEmulateCMakeExecutionErrorInProfiles = emulateInProfiles == null || emulateInProfiles.length == 0 ? null : Arrays.asList(emulateInProfiles);
    }

    @SafeVarargs
    @TestOnly
    public static void setEmulateProductNotFoundInTests(Pair<String, String> ... targetAndProfiles) {
        ourEmulateProductNotFoundForTargetAndProfile = targetAndProfiles == null || targetAndProfiles.length == 0 ? null : Arrays.asList(targetAndProfiles);
    }

    public CMakeGenerator(@NotNull Project project, @NotNull File projectDir, @NotNull List<Parameters> parameters, @Nullable String preferredEncoding, @NotNull Charset defaultCharset) {
        if (project == null) {
            CMakeGenerator.$$$reportNull$$$0(17);
        }
        if (projectDir == null) {
            CMakeGenerator.$$$reportNull$$$0(18);
        }
        if (parameters == null) {
            CMakeGenerator.$$$reportNull$$$0(19);
        }
        if (defaultCharset == null) {
            CMakeGenerator.$$$reportNull$$$0(20);
        }
        this.myProject = project;
        this.myProjectDir = new File(FileUtil.toCanonicalPath((String)projectDir.getPath()));
        this.myParameters = parameters;
        this.myPreferredEncoding = preferredEncoding;
        this.myDefaultCharset = defaultCharset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CMakeModel generate(@Nullable CMakeModel previousModel, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CMakeGenerator.$$$reportNull$$$0(21);
        }
        long before = System.currentTimeMillis();
        CMakeModel cMakeModel = this.doGenerate(previousModel, indicator);
        CMakeModel cMakeModel2 = cMakeModel;
        if (cMakeModel2 == null) {
            CMakeGenerator.$$$reportNull$$$0(22);
        }
        return cMakeModel2;
        finally {
            long after = System.currentTimeMillis();
            long time = after - before;
            ourTotalGenerationTime.addAndGet(time);
            CPPLog.LOG.info("CMake generation took " + StringUtil.formatDuration((long)time) + "; total time during this session: " + StringUtil.formatDuration((long)ourTotalGenerationTime.get()));
        }
    }

    private CMakeModel doGenerate(@Nullable CMakeModel previousModel, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CMakeGenerator.$$$reportNull$$$0(23);
        }
        ProgressManager.checkCanceled();
        CommonInfo commonInfo = new CommonInfo();
        commonInfo.addDependencyFile(CMakeGenerator.getCMakeListsFile(this.myProjectDir));
        commonInfo.addDependencyFile(ParseKt.getProjectPresetsFile(this.myProjectDir.toPath()).toFile());
        commonInfo.addDependencyFile(ParseKt.getProjectUserPresetsFile(this.myProjectDir.toPath()).toFile());
        int maxThreads = Registry.get((String)"cmake.parallel.generation").asInteger();
        if (maxThreads < 1) {
            maxThreads = Runtime.getRuntime().availableProcessors();
        }
        ExecutorService executor = maxThreads > 1 ? AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"CMakeGenerator Pool", (int)(maxThreads - 1)) : ConcurrencyUtil.newSameThreadExecutorService();
        ExecutorCompletionService<CMakeProfileGenerationResult> completionService = new ExecutorCompletionService<CMakeProfileGenerationResult>(executor);
        Condition isInSourceGeneration = each -> FileUtil.filesEqual((File)this.myProjectDir, (File)each.generationDir);
        boolean hasInSourceCache = new File(this.myProjectDir, "CMakeCache.txt").exists();
        boolean hasInSourceGenerationParameters = ContainerUtil.find(this.myParameters, (Condition)isInSourceGeneration) != null;
        Map alreadyUsedGenerationDirs = FileCollectionFactory.createCanonicalFileMap();
        ArrayList<Object> submitted = new ArrayList<Object>(this.myParameters.size());
        for (int i = 0; i < this.myParameters.size(); ++i) {
            Object dirIsAlreadyUsedBy;
            boolean isLast;
            Parameters each2 = this.myParameters.get(i);
            boolean bl = isLast = i == this.myParameters.size() - 1;
            if ((hasInSourceGenerationParameters || hasInSourceCache) && !isInSourceGeneration.value((Object)each2)) {
                if (hasInSourceGenerationParameters) {
                    @NlsContexts.DetailedDescription String reason = hasInSourceCache ? CLionCMakeBundle.message("text.cmakecache.txt.found.in.project.dir.only.in.source.generation.will.be.performed", new Object[0]) : CLionCMakeBundle.message("cmake.text.only.in.source.generation.will.be.performed", new Object[0]);
                    each2.listener.message(CMakeMessage.fatalError(CLionCMakeBundle.message("cmake.text.cannot.generate.into", each2.profileName, each2.generationDir, reason), CMakeGenerator.getCMakeListsFile(this.myProjectDir)));
                    continue;
                }
                hasInSourceGenerationParameters = true;
                each2 = new Parameters(each2.profileId, each2.profileName, each2.buildType, this.myProjectDir, each2.additionalOptions, each2.passSystemEnvironment, each2.additionalEnvironment, each2.listener, each2.environment);
            }
            if ((dirIsAlreadyUsedBy = (String)alreadyUsedGenerationDirs.get(each2.generationDir)) == null) {
                alreadyUsedGenerationDirs.put(each2.generationDir, each2.profileName);
            }
            try {
                this.prepareGenerationDirectory(each2.environment, each2.generationDir, each2.additionalOptions, (String)dirIsAlreadyUsedBy);
            }
            catch (CMakeException e) {
                each2.listener.message(CMakeMessage.fromException(e, CMakeGenerator.getCMakeListsFile(this.myProjectDir)));
                continue;
            }
            Parameters finalParams = each2;
            Callable<CMakeProfileGenerationResult> callable = () -> {
                CMakeProfileGenerationResult result = CMakeGenerator.createProfileGenerationResult(this, finalParams, previousModel);
                ProgressManager.getInstance().runProcess(() -> result.doGenerate(commonInfo), (ProgressIndicator)new SensitiveProgressWrapper(indicator));
                return result;
            };
            if (isLast) {
                FutureResult result = new FutureResult();
                try {
                    result.set((Object)callable.call());
                }
                catch (Throwable e) {
                    result.setException(e);
                }
                submitted.add(result);
                continue;
            }
            submitted.add(completionService.submit(callable));
        }
        ArrayList<CMakeProfileGenerationResult> profileGenerationResults = new ArrayList<CMakeProfileGenerationResult>();
        String projectName = null;
        ProgressManager.checkCanceled();
        ProcessCanceledException pce = null;
        for (Object each3 : submitted) {
            CMakeProfileGenerationResult result = null;
            try {
                result = (CMakeProfileGenerationResult)each3.get();
            }
            catch (InterruptedException e) {
                pce = new ProcessCanceledException((Throwable)e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof ProcessCanceledException) {
                    pce = (ProcessCanceledException)e.getCause();
                }
                CPPLog.LOG.error((Throwable)e);
            }
            if (result == null) continue;
            profileGenerationResults.add(result);
            projectName = result.getProjectName();
        }
        if (pce != null) {
            throw pce;
        }
        ProgressManager.checkCanceled();
        projectName = StringUtil.notNullize(projectName, (String)"Project");
        List<CMakeTarget> targets = this.convertToTargets(projectName, profileGenerationResults);
        commonInfo.adjustDependencyByResources();
        for (CMakeTarget eachTarget : targets) {
            for (CMakeConfiguration eachConfig : eachTarget.getBuildConfigurations()) {
                commonInfo.removeResources(eachConfig.getSources());
            }
        }
        PREDEFINED_EXTENSION_TO_LANGUAGE_MAP.forEach((ext, kind) -> commonInfo.addExtension((String)ext, (OCLanguageKind)kind));
        List configurationData = ContainerUtil.map(profileGenerationResults, it -> new CMakeModelConfigurationData(it.parameters.profileId, it.parameters.profileName, it.parameters.generationDir, it.cacheIOFile, it.cacheIOFileEncoding, it.getRegisteredBuildTypes()));
        commonInfo.compact();
        return new CMakeModel(projectName, commonInfo.getCmakeDependencyFiles(), commonInfo.getHeaderAndResourceFiles(), targets, commonInfo.getExtensions(), configurationData);
    }

    @NotNull
    private List<CMakeTarget> convertToTargets(@NotNull String projectName, @NotNull List<CMakeProfileGenerationResult> generationResults) {
        if (projectName == null) {
            CMakeGenerator.$$$reportNull$$$0(24);
        }
        if (generationResults == null) {
            CMakeGenerator.$$$reportNull$$$0(25);
        }
        Map targetsWithConfigs = CMakeGenerator.createOrderedTargetKeysMap();
        for (CMakeProfileGenerationResult eachGenerationResult : generationResults) {
            Collection<? extends CMakeProfileTargetInfo> infos = eachGenerationResult.getTargetInfos();
            ArrayList<? extends CMakeProfileTargetInfo> sortedInfos = new ArrayList<CMakeProfileTargetInfo>(infos);
            sortedInfos.sort(new CMakeTargetInfoComparator(this.getCMakeListsFile()));
            for (CMakeProfileTargetInfo cMakeProfileTargetInfo : sortedInfos) {
                Pair targetInfoAndConfigs = targetsWithConfigs.computeIfAbsent(cMakeProfileTargetInfo.targetName, k -> new Pair((Object)eachTarget, new ArrayList(generationResults.size())));
                CMakeConfiguration.MacroContext macroContext = new CMakeConfiguration.MacroContext(CMakeGenerator.toEnvFile(cMakeProfileTargetInfo.environment, cMakeProfileTargetInfo.productFile), CMakeGenerator.toEnvFile(cMakeProfileTargetInfo.environment, cMakeProfileTargetInfo.buildWorkingDir), CMakeGenerator.toEnvFile(cMakeProfileTargetInfo.environment, cMakeProfileTargetInfo.generatedDir));
                ((List)targetInfoAndConfigs.second).add(new CMakeConfiguration(eachGenerationResult.parameters.profileId, eachGenerationResult.parameters.profileName, cMakeProfileTargetInfo.buildType, cMakeProfileTargetInfo.generatedDir, cMakeProfileTargetInfo.targetDir, cMakeProfileTargetInfo.perLanguageSettings, ContainerUtil.notNullize(cMakeProfileTargetInfo.linkerFlags), cMakeProfileTargetInfo.sources, cMakeProfileTargetInfo.productFile, cMakeProfileTargetInfo.buildWorkingDir, cMakeProfileTargetInfo.targetType, cMakeProfileTargetInfo.generator, macroContext));
            }
        }
        ArrayList sortedTargetsWithConfigs = new ArrayList(targetsWithConfigs.values());
        sortedTargetsWithConfigs.sort(new Comparator<Pair<CMakeProfileTargetInfo, List<CMakeConfiguration>>>(){
            final CMakeTargetInfoComparator myBaseComparator;
            {
                this.myBaseComparator = new CMakeTargetInfoComparator(CMakeGenerator.this.getCMakeListsFile());
            }

            @Override
            public int compare(Pair<CMakeProfileTargetInfo, List<CMakeConfiguration>> o1, Pair<CMakeProfileTargetInfo, List<CMakeConfiguration>> o2) {
                return this.myBaseComparator.compare((CMakeProfileTargetInfo)o1.first, (CMakeProfileTargetInfo)o2.first);
            }
        });
        ArrayList<CMakeTarget> result = new ArrayList<CMakeTarget>(sortedTargetsWithConfigs.size());
        for (Pair eachTargetWithConfigs : sortedTargetsWithConfigs) {
            CMakeTarget target = new CMakeTarget(projectName, ((CMakeProfileTargetInfo)eachTargetWithConfigs.first).targetName, (List)eachTargetWithConfigs.second);
            for (CMakeConfiguration eachConfiguration : (List)eachTargetWithConfigs.second) {
                eachConfiguration.initTarget(target);
            }
            result.add(target);
        }
        ArrayList<CMakeTarget> arrayList = result;
        if (arrayList == null) {
            CMakeGenerator.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    private void prepareGenerationDirectory(@NotNull CPPEnvironment environment2, @NotNull File generationDirFile, @NotNull List<String> options, @Nullable String dirIsAlreadyUsed) throws CMakeException {
        Path cacheFilePath;
        if (environment2 == null) {
            CMakeGenerator.$$$reportNull$$$0(27);
        }
        if (generationDirFile == null) {
            CMakeGenerator.$$$reportNull$$$0(28);
        }
        if (options == null) {
            CMakeGenerator.$$$reportNull$$$0(29);
        }
        Function<@Nls String, @Nls String> formatMessage = text -> CLionCMakeBundle.message("cmake.cannot.generate.into.0.1.please.either.delete.it.manually.or.select.another.generation.directory", generationDirFile, text);
        HostMachine host = environment2.getHostMachine();
        Path generationDir2 = host.getPath(generationDirFile.getPath(), new String[0]);
        if (dirIsAlreadyUsed != null) {
            throw new CMakeException(formatMessage.apply(CLionCMakeBundle.message("cmake.this.directory.is.already.used.for.0.profile", dirIsAlreadyUsed)));
        }
        try {
            CMakeGenerator.ensurePathExists(generationDir2, true);
        }
        catch (IOException e) {
            throw new CMakeException(e.getMessage());
        }
        boolean cleanGeneratedFiles = false;
        boolean errorOnIncompatibleGeneratedFiles = true;
        Path envFile = CMakeGenerator.getCMakeFilesIDEFile(generationDir2, "environment.txt");
        @NonNls String currentToolchainAndOptions = environment2.calcToolchainHash() + "\nOptions:" + StringUtil.join(options, (String)"\u0000");
        try {
            String prev = PathKt.readText((Path)envFile);
            if (currentToolchainAndOptions.equals(prev)) {
                errorOnIncompatibleGeneratedFiles = false;
            } else {
                cleanGeneratedFiles = true;
                CPPLog.LOG.info("CMake will be regenerated due to environment change.\nNew environment: " + currentToolchainAndOptions + "\nOld environment: " + prev);
            }
        }
        catch (IOException prev) {
            // empty catch block
        }
        if (!cleanGeneratedFiles && Files.exists(cacheFilePath = generationDir2.resolve("CMakeCache.txt"), new LinkOption[0])) {
            File cacheFile;
            try {
                cacheFile = host.resolvePath(cacheFilePath);
            }
            catch (IOException e) {
                throw new CMakeException(CLionCMakeBundle.message("cannot.resolve.path", cacheFilePath), e);
            }
            try {
                File previousProjectDir;
                CMakeCacheFile cache2;
                try {
                    cache2 = new CMakeCacheFile(cacheFile, this.encodingForFile(cacheFile));
                }
                catch (CMakeException e) {
                    throw new CMakeException(formatMessage.apply(CLionCMakeBundle.message("cannot.read.file", cacheFile.getName())), e);
                }
                String previousProjectDirValue = cache2.getVariableValue("CMAKE_HOME_DIRECTORY");
                File file = previousProjectDir = previousProjectDirValue == null ? null : CMakeGenerator.toLocalFile(environment2, previousProjectDirValue);
                if (previousProjectDir == null) {
                    throw new CMakeException(formatMessage.apply(CLionCMakeBundle.message("it.is.already.used.for.unknown.project", new Object[0])));
                }
                if (!FileUtil.filesEqual((File)this.myProjectDir, (File)previousProjectDir)) {
                    throw new CMakeException(formatMessage.apply(CLionCMakeBundle.message("it.is.already.used.for.project", previousProjectDir)));
                }
                @NlsSafe String previousGenerator = cache2.getVariableValue("CMAKE_GENERATOR");
                if (previousGenerator == null) {
                    throw new CMakeException(formatMessage.apply(CLionCMakeBundle.message("it.was.created.with.unknown.generator", new Object[0])));
                }
                String generator2 = CMakeGenerator.getUserSpecifiedGenerator(options);
                if (generator2 == null) {
                    generator2 = CMakeGenerator.getGeneratorSpec(environment2);
                }
                if (!CMakeGenerator.isCompatibleGenerator(previousGenerator, generator2)) {
                    throw new CMakeException(formatMessage.apply(CLionCMakeBundle.message("it.was.created.with.incompatible.generator", previousGenerator)));
                }
            }
            catch (CMakeException e) {
                if (errorOnIncompatibleGeneratedFiles) {
                    throw e;
                }
                cleanGeneratedFiles = true;
                CPPLog.LOG.info("CMake will be regenerated due to incompatible generated files: " + e.getMessage());
            }
        }
        if (cleanGeneratedFiles) {
            CMakeGenerator.cleanGeneratedCMakeFiles(generationDir2);
        }
        try {
            PathKt.write((Path)envFile, (CharSequence)currentToolchainAndOptions);
        }
        catch (Exception e) {
            String message = CLionCMakeBundle.message("cannot.save.file", envFile);
            throw new CMakeException(SystemUtil.patchMessage((String)message, (Path)envFile, (String)e.getMessage()), e);
        }
    }

    public static boolean isCompatibleGenerator(@NotNull String mainGenerator, @NotNull String generatorSpec) {
        String[] parts;
        if (mainGenerator == null) {
            CMakeGenerator.$$$reportNull$$$0(30);
        }
        if (generatorSpec == null) {
            CMakeGenerator.$$$reportNull$$$0(31);
        }
        String mainGeneratorPart = ((parts = generatorSpec.split(" - ")).length > 1 ? parts[1] : parts[0]).trim();
        return mainGenerator.equals(mainGeneratorPart);
    }

    public static void ensurePathExists(Path path, boolean isDirectory) throws IOException {
        boolean exists;
        BasicFileAttributes attributes = PathKt.basicAttributesIfExists((Path)path);
        boolean bl = exists = attributes != null;
        if (exists && attributes.isDirectory() != isDirectory) {
            throw new IOException("Specified path is " + (isDirectory ? "not " : "") + "a directory");
        }
        if (exists) {
            return;
        }
        try {
            if (isDirectory) {
                PathKt.createDirectories((Path)path);
            } else {
                PathKt.createFile((Path)path);
            }
        }
        catch (Exception e) {
            String message = "Cannot create " + (isDirectory ? "directory " : "file ") + path;
            throw new IOException(SystemUtil.patchMessage((String)message, (Path)path, (String)e.getMessage()), e);
        }
    }

    public static void cleanGeneratedCMakeFiles(@NotNull Path generationDir2) {
        if (generationDir2 == null) {
            CMakeGenerator.$$$reportNull$$$0(32);
        }
        PathKt.delete((Path)generationDir2.resolve(CMAKE_FILES_FOLDER));
        PathKt.delete((Path)generationDir2.resolve("CMakeCache.txt"));
    }

    @NotNull
    public static File getCMakeFilesIDEFile(@NotNull File generationDir2, @NotNull String fileName) {
        if (generationDir2 == null) {
            CMakeGenerator.$$$reportNull$$$0(33);
        }
        if (fileName == null) {
            CMakeGenerator.$$$reportNull$$$0(34);
        }
        File file = CMakeGenerator.getCMakeFilesIDEFile(generationDir2.toPath(), fileName).toFile();
        if (file == null) {
            CMakeGenerator.$$$reportNull$$$0(35);
        }
        return file;
    }

    @NotNull
    private static Path getCMakeFilesIDEFile(@NotNull Path generationDir2, @NotNull String fileName) {
        if (generationDir2 == null) {
            CMakeGenerator.$$$reportNull$$$0(36);
        }
        if (fileName == null) {
            CMakeGenerator.$$$reportNull$$$0(37);
        }
        String productName = FileUtil.sanitizeFileName((String)StringUtil.toLowerCase((String)ApplicationNamesInfo.getInstance().getProductName()));
        Path path = generationDir2.resolve("CMakeFiles/" + productName + "-" + fileName);
        if (path == null) {
            CMakeGenerator.$$$reportNull$$$0(38);
        }
        return path;
    }

    @NotNull
    File getCMakeListsFile() {
        return CMakeGenerator.getCMakeListsFile(this.myProjectDir);
    }

    @NotNull
    static File getCMakeListsFile(@NotNull File dir) {
        if (dir == null) {
            CMakeGenerator.$$$reportNull$$$0(39);
        }
        return new File(FileUtil.toCanonicalPath((String)new File(dir, "CMakeLists.txt").getPath()));
    }

    @NotNull
    static File toLocalFile(@NotNull CPPEnvironment environment2, @NlsSafe @NotNull String absolutePath) {
        if (environment2 == null) {
            CMakeGenerator.$$$reportNull$$$0(40);
        }
        if (absolutePath == null) {
            CMakeGenerator.$$$reportNull$$$0(41);
        }
        return CMakeGenerator.toLocalFile(environment2, null, absolutePath);
    }

    @NotNull
    static File toLocalFile(@NotNull CPPEnvironment environment2, @Nullable File basedir, @NotNull String absoluteOrRelativePath) {
        if (environment2 == null) {
            CMakeGenerator.$$$reportNull$$$0(42);
        }
        if (absoluteOrRelativePath == null) {
            CMakeGenerator.$$$reportNull$$$0(43);
        }
        return new File(environment2.toLocalPath(basedir, absoluteOrRelativePath));
    }

    @Nullable
    static String toEnvFile(@NotNull CPPEnvironment environment2, @Nullable File localFile) {
        if (environment2 == null) {
            CMakeGenerator.$$$reportNull$$$0(44);
        }
        if (localFile == null) {
            return null;
        }
        return environment2.toEnvPath(localFile.getPath());
    }

    static <T> Map<String, T> createOrderedTargetKeysMap() {
        return new LinkedHashMap();
    }

    @NotNull CMakeRunner.CMakeOutput runCMakeGenerator(@NotNull Parameters parameters, @Nullable String generatorSpec, @NotNull List<String> extraOptions) throws CMakeException {
        String buildType2;
        if (parameters == null) {
            CMakeGenerator.$$$reportNull$$$0(45);
        }
        if (extraOptions == null) {
            CMakeGenerator.$$$reportNull$$$0(46);
        }
        if (ourEmulateCMakeExecutionErrorInProfiles != null && ourEmulateCMakeExecutionErrorInProfiles.contains(parameters.profileName)) {
            throw new EmulatedCMakeException("Emulated CMake error in " + parameters.profileName);
        }
        ArrayList<String> commandLineOptions = new ArrayList<String>();
        List<String> additionalOptions = parameters.additionalOptions;
        String userGenerator = CMakeGenerator.getUserSpecifiedGenerator(additionalOptions);
        if ((generatorSpec != null || CMakeGenerator.isSingleConfigurationGenerator(userGenerator)) && !(buildType2 = CMakeGenerator.getBuildTypeOption(parameters.buildType)).isEmpty()) {
            commandLineOptions.add(buildType2);
        }
        commandLineOptions.addAll(additionalOptions);
        commandLineOptions.addAll(extraOptions);
        return CMakeGenerator.runCMakeGenerator(parameters.environment, this.myProjectDir.toPath(), parameters.generationDir.toPath(), generatorSpec, commandLineOptions, parameters.passSystemEnvironment, parameters.additionalEnvironment, handler2 -> parameters.listener.attachTo(handler2), true, this.myProject);
    }

    @NotNull
    public static String getBuildTypeOption(@NotNull String buildType2) {
        if (buildType2 == null) {
            CMakeGenerator.$$$reportNull$$$0(47);
        }
        Object object = buildType2.equals("Default") ? "" : "-DCMAKE_BUILD_TYPE=" + buildType2;
        if (object == null) {
            CMakeGenerator.$$$reportNull$$$0(48);
        }
        return object;
    }

    @Deprecated
    @NotNull
    public static CMakeRunner.CMakeOutput runCMakeGenerator(@NotNull CPPEnvironment environment2, @NotNull File projectDir, @NotNull File outputDir, @NotNull List<String> commandLineOptions) throws CMakeException {
        if (environment2 == null) {
            CMakeGenerator.$$$reportNull$$$0(49);
        }
        if (projectDir == null) {
            CMakeGenerator.$$$reportNull$$$0(50);
        }
        if (outputDir == null) {
            CMakeGenerator.$$$reportNull$$$0(51);
        }
        if (commandLineOptions == null) {
            CMakeGenerator.$$$reportNull$$$0(52);
        }
        return CMakeGenerator.runCMakeGenerator(environment2, projectDir.toPath(), outputDir.toPath(), commandLineOptions, Collections.emptyMap(), handler2 -> {});
    }

    @NotNull
    public static CMakeRunner.CMakeOutput runCMakeGenerator(@NotNull CPPEnvironment environment2, @NotNull Path projectDir, @NotNull Path outputDir, @NotNull List<String> commandLineOptions) throws CMakeException {
        if (environment2 == null) {
            CMakeGenerator.$$$reportNull$$$0(53);
        }
        if (projectDir == null) {
            CMakeGenerator.$$$reportNull$$$0(54);
        }
        if (outputDir == null) {
            CMakeGenerator.$$$reportNull$$$0(55);
        }
        if (commandLineOptions == null) {
            CMakeGenerator.$$$reportNull$$$0(56);
        }
        return CMakeGenerator.runCMakeGenerator(environment2, projectDir, outputDir, commandLineOptions, Collections.emptyMap(), handler2 -> {});
    }

    @NotNull
    public static CMakeRunner.CMakeOutput runCMakeGenerator(@NotNull CPPEnvironment environment2, @NotNull Path projectDir, @NotNull Path outputDir, @NotNull List<String> commandLineOptions, @NotNull Map<String, String> additionalEnvironment2) throws CMakeException {
        if (environment2 == null) {
            CMakeGenerator.$$$reportNull$$$0(57);
        }
        if (projectDir == null) {
            CMakeGenerator.$$$reportNull$$$0(58);
        }
        if (outputDir == null) {
            CMakeGenerator.$$$reportNull$$$0(59);
        }
        if (commandLineOptions == null) {
            CMakeGenerator.$$$reportNull$$$0(60);
        }
        if (additionalEnvironment2 == null) {
            CMakeGenerator.$$$reportNull$$$0(61);
        }
        return CMakeGenerator.runCMakeGenerator(environment2, projectDir, outputDir, commandLineOptions, additionalEnvironment2, handler2 -> {});
    }

    @NotNull
    public static CMakeRunner.CMakeOutput runCMakeGenerator(@NotNull CPPEnvironment environment2, @NotNull Path projectDir, @NotNull Path outputDir, @NotNull List<String> commandLineOptions, @Nullable String generator2) throws CMakeException {
        if (environment2 == null) {
            CMakeGenerator.$$$reportNull$$$0(62);
        }
        if (projectDir == null) {
            CMakeGenerator.$$$reportNull$$$0(63);
        }
        if (outputDir == null) {
            CMakeGenerator.$$$reportNull$$$0(64);
        }
        if (commandLineOptions == null) {
            CMakeGenerator.$$$reportNull$$$0(65);
        }
        return CMakeGenerator.runCMakeGenerator(environment2, projectDir, outputDir, generator2, commandLineOptions, true, Collections.emptyMap(), handler2 -> {}, false, null);
    }

    @NotNull
    private static CMakeRunner.CMakeOutput runCMakeGenerator(@NotNull CPPEnvironment environment2, @NotNull Path projectDir, @NotNull Path outputDir, List<String> commandLineOptions, @NotNull Map<String, String> additionalEnvironment2, @NotNull CMakeRunner.Listener listener) throws CMakeException {
        if (environment2 == null) {
            CMakeGenerator.$$$reportNull$$$0(66);
        }
        if (projectDir == null) {
            CMakeGenerator.$$$reportNull$$$0(67);
        }
        if (outputDir == null) {
            CMakeGenerator.$$$reportNull$$$0(68);
        }
        if (additionalEnvironment2 == null) {
            CMakeGenerator.$$$reportNull$$$0(69);
        }
        if (listener == null) {
            CMakeGenerator.$$$reportNull$$$0(70);
        }
        String generator2 = CMakeGenerator.getGeneratorSpec(environment2);
        return CMakeGenerator.runCMakeGenerator(environment2, projectDir, outputDir, generator2, commandLineOptions, true, additionalEnvironment2, listener, false, null);
    }

    @NotNull
    private static CMakeRunner.CMakeOutput runCMakeGenerator(@NotNull CPPEnvironment environment2, @NotNull Path projectDir, @NotNull Path outputDir, @Nullable String generatorSpec, @NotNull List<String> commandLineOptions, boolean passSystemEnvironment, @NotNull Map<String, String> additionalEnvironment2, @NotNull CMakeRunner.Listener listener, boolean runCustomSteps, @Nullable Project projectForCustomStepsOrNull) throws CMakeException {
        if (environment2 == null) {
            CMakeGenerator.$$$reportNull$$$0(71);
        }
        if (projectDir == null) {
            CMakeGenerator.$$$reportNull$$$0(72);
        }
        if (outputDir == null) {
            CMakeGenerator.$$$reportNull$$$0(73);
        }
        if (commandLineOptions == null) {
            CMakeGenerator.$$$reportNull$$$0(74);
        }
        if (additionalEnvironment2 == null) {
            CMakeGenerator.$$$reportNull$$$0(75);
        }
        if (listener == null) {
            CMakeGenerator.$$$reportNull$$$0(76);
        }
        ArrayList<String> allParams = new ArrayList<String>(commandLineOptions);
        if (generatorSpec != null) {
            allParams.add(GENERATOR_FLAG);
            allParams.add(generatorSpec);
        }
        CMakeRunnerStep.Parameters parameters = new CMakeRunnerStep.Parameters(environment2, projectDir, outputDir, allParams, passSystemEnvironment, additionalEnvironment2, listener);
        if (runCustomSteps) {
            if (projectForCustomStepsOrNull == null) {
                CPPLog.LOG.error("project must be specified");
            } else {
                for (CMakeRunnerStep eachStep : CMakeRunnerStep.EP_NAME.getExtensionList()) {
                    parameters = eachStep.modifyParameters(projectForCustomStepsOrNull, parameters);
                }
                for (CMakeRunnerStep eachStep : CMakeRunnerStep.EP_NAME.getExtensionList()) {
                    try {
                        eachStep.beforeGeneration(projectForCustomStepsOrNull, parameters);
                    }
                    catch (CMakeException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        CPPLog.LOG.warn("Extension thrown exception: " + eachStep, e);
                    }
                }
            }
        }
        CMakeRunner.CMakeOutput cMakeOutput = CMakeRunner.runCMake(parameters);
        if (cMakeOutput == null) {
            CMakeGenerator.$$$reportNull$$$0(77);
        }
        return cMakeOutput;
    }

    @NotNull
    private static String getGeneratorSpec(@NotNull CPPEnvironment environment2) {
        if (environment2 == null) {
            CMakeGenerator.$$$reportNull$$$0(78);
        }
        return CMakeGenerator.getGeneratorSpec(environment2.getToolSet(), false);
    }

    @NotNull
    public static String getGeneratorSpec(@NotNull CPPToolSet toolSet, boolean generateCodeBlocksProject) {
        if (toolSet == null) {
            CMakeGenerator.$$$reportNull$$$0(79);
        }
        CMakeGeneratorType generator2 = toolSet.isMinGW() ? CMakeGeneratorType.MINGW : (toolSet.isCygwin() || toolSet.isWSL() || toolSet.isRemote() ? CMakeGeneratorType.UNIX : (toolSet.isMSVC() ? CMakeGeneratorType.NMAKE : CMakeGeneratorType.UNIX));
        String string = (generateCodeBlocksProject ? "CodeBlocks - " : "") + generator2.getValue();
        if (string == null) {
            CMakeGenerator.$$$reportNull$$$0(80);
        }
        return string;
    }

    @NotNull
    String encodingForFile(@NotNull File file) {
        String string;
        if (file == null) {
            CMakeGenerator.$$$reportNull$$$0(81);
        }
        if (this.myPreferredEncoding != null) {
            String string2 = this.myPreferredEncoding;
            if (string2 == null) {
                CMakeGenerator.$$$reportNull$$$0(82);
            }
            return string2;
        }
        if ((int)file.length() == 0) {
            String string3 = this.myDefaultCharset.name();
            if (string3 == null) {
                CMakeGenerator.$$$reportNull$$$0(83);
            }
            return string3;
        }
        try {
            Charset guessedCharset = CharsetToolkit.guessEncoding((File)file, (int)((int)file.length()), (Charset)this.myDefaultCharset);
            string = (guessedCharset == null ? this.myDefaultCharset : guessedCharset).name();
        }
        catch (IOException e) {
            String string4 = this.myDefaultCharset.name();
            if (string4 == null) {
                CMakeGenerator.$$$reportNull$$$0(85);
            }
            return string4;
        }
        if (string == null) {
            CMakeGenerator.$$$reportNull$$$0(84);
        }
        return string;
    }

    static {
        PREDEFINED_EXTENSION_TO_LANGUAGE_MAP = new HashMap<String, OCLanguageKind>();
        API_MIN_CMAKE_VERSION = new Version(3, 15, -1);
        PREDEFINED_EXTENSION_TO_LANGUAGE_MAP.put("m", (OCLanguageKind)CLanguageKind.OBJ_C);
        PREDEFINED_EXTENSION_TO_LANGUAGE_MAP.put("M", (OCLanguageKind)CLanguageKind.OBJ_CPP);
        PREDEFINED_EXTENSION_TO_LANGUAGE_MAP.put("mm", (OCLanguageKind)CLanguageKind.OBJ_CPP);
        ourEmulateCMakeExecutionErrorInProfiles = null;
        ourEmulateProductNotFoundForTargetAndProfile = null;
        ourTotalGenerationTime = new AtomicLong(0L);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 26: 
            case 35: 
            case 38: 
            case 48: 
            case 77: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 26: 
            case 35: 
            case 38: 
            case 48: 
            case 77: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 1: 
            case 2: 
            case 19: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 26: 
            case 35: 
            case 38: 
            case 48: 
            case 77: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeGenerator";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finalParams";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazyCMakeVersion";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationOptions";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: 
            case 50: 
            case 54: 
            case 58: 
            case 63: 
            case 67: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultCharset";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationResults";
                break;
            }
            case 27: 
            case 40: 
            case 42: 
            case 44: 
            case 49: 
            case 53: 
            case 57: 
            case 62: 
            case 66: 
            case 71: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationDirFile";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainGenerator";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatorSpec";
                break;
            }
            case 32: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationDir";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolutePath";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absoluteOrRelativePath";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraOptions";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildType";
                break;
            }
            case 51: 
            case 55: 
            case 59: 
            case 64: 
            case 68: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 52: 
            case 56: 
            case 60: 
            case 65: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineOptions";
                break;
            }
            case 61: 
            case 69: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalEnvironment";
                break;
            }
            case 70: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolSet";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeGenerator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createLazyCMakeVersion";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAPICompatibleCMake";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToTargets";
                break;
            }
            case 35: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeFilesIDEFile";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTypeOption";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "runCMakeGenerator";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratorSpec";
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "encodingForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createProfileGenerationResult";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLazyCMakeVersion";
                break;
            }
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 26: 
            case 35: 
            case 38: 
            case 48: 
            case 77: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseAPI";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isParallelBuildByDefault";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasParallelBuildSupport";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasUnixLikeMakefileGenerator";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAllTargetName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUserSpecifiedGenerator";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasUserSpecifiedGenerator";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getGeneratorFlagIndex";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doGenerate";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "convertToTargets";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "prepareGenerationDirectory";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibleGenerator";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "cleanGeneratedCMakeFiles";
                break;
            }
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeFilesIDEFile";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeListsFile";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "toLocalFile";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "toEnvFile";
                break;
            }
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "runCMakeGenerator";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getBuildTypeOption";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getGeneratorSpec";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "encodingForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 26: 
            case 35: 
            case 38: 
            case 48: 
            case 77: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class EmulatedCMakeException
    extends CMakeException {
        EmulatedCMakeException(String message) {
            super(message);
        }
    }

    static final class CudaTargetInfo {
        @Nullable
        private final File compilerPath;
        @NotNull
        private final Map<File, CMakeFileSettings> sources;

        CudaTargetInfo(@Nullable File compilerPath, @NotNull Map<File, CMakeFileSettings> sources) {
            if (sources == null) {
                CudaTargetInfo.$$$reportNull$$$0(0);
            }
            this.compilerPath = compilerPath;
            this.sources = sources;
        }

        @Nullable
        File getCompilerPath() {
            return this.compilerPath;
        }

        @NotNull
        Map<File, CMakeFileSettings> getSources() {
            Map<File, CMakeFileSettings> map2 = this.sources;
            if (map2 == null) {
                CudaTargetInfo.$$$reportNull$$$0(1);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sources";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeGenerator$CudaTargetInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeGenerator$CudaTargetInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class CommonInfo {
        @NotNull
        private final Set<File> cmakeDependencyFiles = FileCollectionFactory.createCanonicalFileSet();
        @NotNull
        private final Set<File> headerAndResourceFiles = FileCollectionFactory.createCanonicalFileSet();
        @NotNull
        private final Map<String, OCLanguageKind> extensions = new HashMap<String, OCLanguageKind>();

        public synchronized void addDependencyFile(@NotNull File file) {
            if (file == null) {
                CommonInfo.$$$reportNull$$$0(0);
            }
            this.cmakeDependencyFiles.add(file);
        }

        public synchronized void adjustDependencyByResources() {
            this.removeResources(this.cmakeDependencyFiles);
        }

        public synchronized void removeResources(@NotNull Collection<File> sources) {
            if (sources == null) {
                CommonInfo.$$$reportNull$$$0(1);
            }
            this.headerAndResourceFiles.removeAll(sources);
        }

        public synchronized void compact() {
            CollectionFactory.trimSet(this.headerAndResourceFiles);
            CollectionFactory.trimSet(this.cmakeDependencyFiles);
            CollectionFactory.trimMap(this.extensions);
        }

        public synchronized void addExtension(@NotNull String extension, @NotNull OCLanguageKind kind) {
            if (extension == null) {
                CommonInfo.$$$reportNull$$$0(2);
            }
            if (kind == null) {
                CommonInfo.$$$reportNull$$$0(3);
            }
            this.extensions.put(extension, kind);
        }

        public synchronized void addSourceFile(@NotNull File headerOrResource) {
            if (headerOrResource == null) {
                CommonInfo.$$$reportNull$$$0(4);
            }
            this.headerAndResourceFiles.add(headerOrResource);
        }

        @NotNull
        public Set<File> getCmakeDependencyFiles() {
            Set<File> set = this.cmakeDependencyFiles;
            if (set == null) {
                CommonInfo.$$$reportNull$$$0(5);
            }
            return set;
        }

        @NotNull
        public Set<File> getHeaderAndResourceFiles() {
            Set<File> set = this.headerAndResourceFiles;
            if (set == null) {
                CommonInfo.$$$reportNull$$$0(6);
            }
            return set;
        }

        @NotNull
        public Map<String, OCLanguageKind> getExtensions() {
            Map<String, OCLanguageKind> map2 = this.extensions;
            if (map2 == null) {
                CommonInfo.$$$reportNull$$$0(7);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sources";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "headerOrResource";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeGenerator$CommonInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeGenerator$CommonInfo";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCmakeDependencyFiles";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHeaderAndResourceFiles";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExtensions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addDependencyFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "removeResources";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addExtension";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addSourceFile";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Parameters {
        public final int profileId;
        @NotNull
        public final String profileName;
        @NotNull
        public final String buildType;
        @NotNull
        public final File generationDir;
        @NotNull
        public final List<String> additionalOptions;
        public final boolean passSystemEnvironment;
        @NotNull
        public final Map<String, String> additionalEnvironment;
        @NotNull
        public final CMakeListener listener;
        @NotNull
        public final CPPEnvironment environment;

        public Parameters(int profileId, @NotNull String profileName, @NotNull String buildType2, @NotNull File outputDir, @NotNull List<String> additionalOptions, boolean passSystemEnvironment, Map<String, String> additionalEnvironment2, @NotNull CMakeListener listener, @NotNull CPPEnvironment environment2) {
            if (profileName == null) {
                Parameters.$$$reportNull$$$0(0);
            }
            if (buildType2 == null) {
                Parameters.$$$reportNull$$$0(1);
            }
            if (outputDir == null) {
                Parameters.$$$reportNull$$$0(2);
            }
            if (additionalOptions == null) {
                Parameters.$$$reportNull$$$0(3);
            }
            if (listener == null) {
                Parameters.$$$reportNull$$$0(4);
            }
            if (environment2 == null) {
                Parameters.$$$reportNull$$$0(5);
            }
            this.profileId = profileId;
            this.profileName = profileName;
            this.buildType = buildType2;
            this.generationDir = new File(FileUtil.toCanonicalPath((String)outputDir.getPath()));
            this.additionalOptions = Collections.unmodifiableList(additionalOptions);
            this.passSystemEnvironment = passSystemEnvironment;
            if (!additionalEnvironment2.isEmpty()) {
                additionalEnvironment2 = new HashMap<String, String>(additionalEnvironment2);
                EnvironmentUtil.inlineParentOccurrences(additionalEnvironment2);
            }
            this.additionalEnvironment = Collections.unmodifiableMap(additionalEnvironment2);
            this.listener = listener;
            this.environment = environment2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "profileName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "buildType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputDir";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "additionalOptions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "listener";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "environment";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeGenerator$Parameters";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum APICompatibilityResult {
        OK,
        NOT_DETERMINED,
        UNSUPPORTED;

    }
}

