/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.projectWizard;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.projectWizard.generators.settings.CMakeProjectSettings;
import com.jetbrains.cidr.cpp.toolchains.CMakeExecutableTool;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.lang.formatting.CidrProjectWizardFilesFormatter;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CLionProjectWizardUtils {
    private static final Logger LOG = Logger.getInstance(CLionProjectWizardUtils.class);

    public static void reformatProjectFiles(@NotNull Project project, @Nullable VirtualFile cmakeFile, VirtualFile ... cppFiles) {
        if (project == null) {
            CLionProjectWizardUtils.$$$reportNull$$$0(0);
        }
        WriteAction.run(() -> {
            if (project.isDisposed()) {
                return;
            }
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> WriteCommandAction.runWriteCommandAction((Project)project, (String)CLionCMakeBundle.message("cmake.project.wizard.format.source.files", new Object[0]), null, () -> {
                List formatters;
                if (cmakeFile != null) {
                    CLionProjectWizardUtils.reformatCmakeFile(project, cmakeFile);
                }
                LOG.assertTrue((formatters = CidrProjectWizardFilesFormatter.EP_NAME.getExtensionList()).size() <= 1);
                if (!formatters.isEmpty()) {
                    ((CidrProjectWizardFilesFormatter)formatters.get(0)).reformatProjectFiles(project, cppFiles);
                }
            }, (PsiFile[])new PsiFile[0])));
        });
    }

    private static void reformatCmakeFile(@NotNull Project project, @NotNull VirtualFile cmakeFile) {
        if (project == null) {
            CLionProjectWizardUtils.$$$reportNull$$$0(1);
        }
        if (cmakeFile == null) {
            CLionProjectWizardUtils.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(ApplicationManager.getApplication().isWriteAccessAllowed());
        PsiFile cmakePsiFile = PsiManager.getInstance((Project)project).findFile(cmakeFile);
        if (cmakePsiFile != null) {
            CodeStyleManager.getInstance((Project)project).reformatText(cmakePsiFile, 0, cmakePsiFile.getTextLength());
        }
    }

    public static void refreshProjectDir(VirtualFile projectDir) {
        CLionProjectWizardUtils.refreshProjectDir(projectDir, false);
    }

    public static void refreshProjectDir(VirtualFile projectDir, boolean recursive) {
        CPPLog.LOG.assertTrue(projectDir != null);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)recursive, (boolean)true, (VirtualFile[])new VirtualFile[]{projectDir});
    }

    @NotNull
    @NonNls
    public static String getCMakeMinimumRequiredLine(String versionString) {
        Object cmake_minimum_required;
        Version version;
        Version version2 = version = versionString == null ? null : Version.parseVersion((String)versionString);
        if (version != null) {
            String versionToSet = version.lessThan(Integer.valueOf(3)) ? "2.8.4" : version.major + "." + version.minor;
            cmake_minimum_required = "cmake_minimum_required(VERSION " + versionToSet + ")\n";
        } else {
            cmake_minimum_required = "# cmake_minimum_required(VERSION <specify CMake version here>)\n";
        }
        String string = cmake_minimum_required;
        if (string == null) {
            CLionProjectWizardUtils.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @NonNls
    public static String getCMakeFileHeader(@NotNull String projectName, @Nullable CMakeProjectSettings settings) {
        if (projectName == null) {
            CLionProjectWizardUtils.$$$reportNull$$$0(4);
        }
        CPPToolchains.Toolchain toolchain = CPPToolchains.getInstance().getDefaultToolchain();
        String languageVersionLineForCMake = "";
        if (settings != null) {
            languageVersionLineForCMake = settings.getLanguageVersionLineForCMake();
        }
        String enabledLanguages = settings == null ? "" : settings.getEnabledProjectLanguages();
        String version = CLionProjectWizardUtils.getCMakeVersionUnderProgress(toolchain);
        String string = CLionProjectWizardUtils.getCMakeMinimumRequiredLine(version) + "project(" + projectName + (String)(StringUtil.isEmptyOrSpaces((String)enabledLanguages) ? "" : " " + enabledLanguages) + ")\n\n" + languageVersionLineForCMake;
        if (string == null) {
            CLionProjectWizardUtils.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public static String getCMakeVersionUnderProgress(@Nullable CPPToolchains.Toolchain toolchain) {
        return (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> CMakeExecutableTool.readCMakeVersion((CPPToolchains.Toolchain)toolchain), CLionCMakeBundle.message("cmake.checking.version", new Object[0]), true, null);
    }

    @Nullable
    public static Version getCMakeVersionForDefaultToolchain() {
        String versionString = (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> CMakeExecutableTool.readCMakeVersion((CPPToolchains.Toolchain)CPPToolchains.getInstance().getDefaultToolchain()), CLionCMakeBundle.message("cmake.checking.version", new Object[0]), false, null);
        return versionString == null ? null : Version.parseVersion((String)versionString);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmakeFile";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/projectWizard/CLionProjectWizardUtils";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/projectWizard/CLionProjectWizardUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeMinimumRequiredLine";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeFileHeader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reformatProjectFiles";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reformatCmakeFile";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeFileHeader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

