/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.projectWizard;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.projectWizard.CLionProjectWizardUtils;
import com.jetbrains.cidr.cpp.cmake.projectWizard.CMakeCreateListsStepAdapter;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class CMakeCreateListsWizard
extends AbstractWizard<CMakeCreateListsStepAdapter> {
    @NotNull
    private final VirtualFile myImportDir;
    @NotNull
    private final String myHelpId;
    @NotNull
    private final CMakeCreateListsStepAdapter myStep;
    @NotNull
    private final Project myProject;

    public CMakeCreateListsWizard(@NotNull VirtualFile importDir, @NotNull Project project) {
        if (importDir == null) {
            CMakeCreateListsWizard.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CMakeCreateListsWizard.$$$reportNull$$$0(1);
        }
        super(CLionCMakeBundle.message("cmake.create.lists", new Object[0]), project);
        this.myHelpId = "CMakeCreateLists";
        this.myImportDir = importDir;
        this.myProject = project;
        this.myStep = new CMakeCreateListsStepAdapter(this.getDisposable(), () -> ((CMakeCreateListsWizard)this).updateButtons());
        this.addStep((Step)this.myStep);
        this.init();
    }

    private boolean tryFinish() {
        try {
            this.myStep.createProject();
            return true;
        }
        catch (IOException e) {
            CPPLog.LOG.warn((Throwable)e);
            this.setErrorText(CLionCMakeBundle.message("cmake.lists.creation.fail", new Object[0]));
            this.getNextButton().setEnabled(false);
            return false;
        }
    }

    @NotNull
    protected String getHelpID() {
        String string = this.myHelpId;
        if (string == null) {
            CMakeCreateListsWizard.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected boolean canFinish() {
        return this.myStep.validate();
    }

    protected void doOKAction() {
        if (this.tryFinish()) {
            super.doOKAction();
        }
    }

    public void runWizard() {
        this.myStep.prepareDirectories(this.myImportDir);
        this.show();
        if (this.getExitCode() == 0) {
            this.doRunWizard();
        }
    }

    private void doRunWizard() {
        CLionProjectWizardUtils.refreshProjectDir(this.myImportDir);
        VirtualFile makeFile = this.myImportDir.findChild("CMakeLists.txt");
        CPPLog.LOG.assertTrue(makeFile != null);
        CMakeWorkspace.getInstance(this.myProject).selectProjectDir(VfsUtilCore.virtualToIoFile((VirtualFile)this.myImportDir));
        CLionProjectWizardUtils.reformatProjectFiles(this.myProject, makeFile, new VirtualFile[0]);
        PsiNavigationSupport.getInstance().createNavigatable(this.myProject, makeFile, -1).navigate(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/projectWizard/CMakeCreateListsWizard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/projectWizard/CMakeCreateListsWizard";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

