/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.workspace;

import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.cidr.FilesModificationsListener;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeStatisticsCollector;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceListener;
import com.jetbrains.cidr.cpp.cmake.workspace.FileStamp;
import com.jetbrains.cidr.cpp.cmake.workspace.FutureProvider;
import com.jetbrains.cidr.cpp.cmake.workspace.ReloadFlag;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class CMakeWorkspaceWatcher {
    public static final Key<Boolean> NEEDS_RELOAD = Key.create((String)"NEEDS_RELOAD");
    public static final Key<Boolean> SHOULD_CHECK_DOCUMENT_TEXT = Key.create((String)"SHOULD_CHECK_DOCUMENT_TEXT");
    private static final int DOCUMENT_CHECK_DELAY = 1000;
    @NotNull
    private static final Logger LOG = Logger.getInstance(CMakeWorkspaceWatcher.class);
    @NotNull
    private final AtomicBoolean myInitialized;
    @NotNull
    private final Disposable myShutdownDisposable;
    @NotNull
    private final Project myProject;
    @NotNull
    private final CMakeWorkspace myWorkspace;
    @NotNull
    private final BackgroundTaskQueue myReloadsQueue;
    @NotNull
    private final MergingUpdateQueue myChangedDocumentsQueue;
    @NotNull
    private final QueueProcessor<Runnable> mySchedulingQueueProcessor;
    @NotNull
    private final ReadWriteLock myReloadsLock;
    @NotNull
    private final AtomicInteger myWaitingReloadsCount;
    @Nullable
    private volatile ProgressIndicator myRunningReloadTaskIndicator;
    private static final ExtensionPointName<FutureProvider<ReloadFlag>> EP_NAME = ExtensionPointName.create((String)"com.intellij.cmake.loadOnStartupDependency");
    private volatile boolean myReloadInBackgroundInTestsMode;

    public CMakeWorkspaceWatcher(@NotNull Project project, @NotNull CMakeWorkspace workspace) {
        if (project == null) {
            CMakeWorkspaceWatcher.$$$reportNull$$$0(0);
        }
        if (workspace == null) {
            CMakeWorkspaceWatcher.$$$reportNull$$$0(1);
        }
        this.myInitialized = new AtomicBoolean(false);
        this.myShutdownDisposable = Disposer.newDisposable();
        this.mySchedulingQueueProcessor = QueueProcessor.createRunnableQueueProcessor();
        this.myReloadsLock = new ReentrantReadWriteLock(true);
        this.myWaitingReloadsCount = new AtomicInteger();
        this.myProject = project;
        this.myWorkspace = workspace;
        this.myReloadsQueue = new BackgroundTaskQueue(project, CMakeWorkspaceWatcher.getReadingCmakeProject());
        this.myChangedDocumentsQueue = new MergingUpdateQueue(this.getClass() + ": Document changes queue", 1000, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.myProject, null, false).usePassThroughInUnitTestMode();
    }

    public void listenForChanges() {
        if (this.myInitialized.getAndSet(true)) {
            return;
        }
        Disposer.register((Disposable)this.myProject, (Disposable)this.myShutdownDisposable);
        final AtomicBoolean isGenerationRunning = new AtomicBoolean(false);
        final AtomicLong lastGenerationTimestamp = new AtomicLong(0L);
        this.myProject.getMessageBus().connect(this.myShutdownDisposable).subscribe(CMakeWorkspaceListener.TOPIC, (Object)new CMakeWorkspaceListener(){

            @Override
            public void generationStarted() {
                isGenerationRunning.set(true);
                lastGenerationTimestamp.set(System.currentTimeMillis());
            }

            @Override
            public void generationFinished() {
                isGenerationRunning.set(false);
                lastGenerationTimestamp.set(System.currentTimeMillis());
            }
        });
        final Function getWatchedFileForDocument = doc -> {
            VirtualFile vFile = FileDocumentManager.getInstance().getFile(doc);
            if (vFile == null) {
                return null;
            }
            File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)vFile);
            if (!this.myWorkspace.getCMakeDependencyFiles().contains(ioFile)) {
                return null;
            }
            return Pair.create((Object)ioFile, (Object)vFile);
        };
        EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
        multicaster.addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (getWatchedFileForDocument.fun((Object)e.getEditor().getDocument()) != null) {
                    CMakeWorkspaceWatcher.this.myChangedDocumentsQueue.restartTimer();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$2", "caretPositionChanged"));
            }
        }, this.myShutdownDisposable);
        multicaster.addDocumentListener(new DocumentListener(){
            @NotNull
            final Map<File, Document> myChangedDocuments = FileCollectionFactory.createCanonicalFileMap();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void documentChanged(@NotNull DocumentEvent event) {
                Document doc;
                Pair files;
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((files = (Pair)getWatchedFileForDocument.fun((Object)(doc = event.getDocument()))) == null) {
                    return;
                }
                if (((VirtualFile)files.second).getModificationStamp() >= doc.getModificationStamp() && !UndoManager.getInstance((Project)CMakeWorkspaceWatcher.this.myProject).isUndoOrRedoInProgress()) {
                    return;
                }
                doc.putUserData(SHOULD_CHECK_DOCUMENT_TEXT, (Object)true);
                Map<File, Document> map2 = this.myChangedDocuments;
                synchronized (map2) {
                    this.myChangedDocuments.put((File)files.first, doc);
                }
                CMakeWorkspaceWatcher.this.runWhenReady(this::scheduleDocsUpdate);
            }

            private void scheduleDocsUpdate() {
                CMakeWorkspaceWatcher.this.myChangedDocumentsQueue.restartTimer();
                CMakeWorkspaceWatcher.this.myChangedDocumentsQueue.queue(new Update(CMakeWorkspaceWatcher.this){

                    public void run() {
                        ApplicationManager.getApplication().runReadAction(() -> {
                            boolean changed;
                            Map fileStampFunctionMap;
                            if (CMakeWorkspaceWatcher.this.myProject.isDisposed()) {
                                return;
                            }
                            LookupEx lookup = LookupManager.getInstance((Project)CMakeWorkspaceWatcher.this.myProject).getActiveLookup();
                            if (lookup != null && (lookup.getComponent().isShowing() || ApplicationManager.getApplication().isUnitTestMode())) {
                                this.rescheduleWithDelay();
                                return;
                            }
                            Map<File, Document> map2 = myChangedDocuments;
                            synchronized (map2) {
                                fileStampFunctionMap = FileCollectionFactory.createCanonicalFileMap((int)myChangedDocuments.size());
                                for (Map.Entry<File, Document> eachEntry : myChangedDocuments.entrySet()) {
                                    File changedFile = eachEntry.getKey();
                                    final Document changedDocument = eachEntry.getValue();
                                    fileStampFunctionMap.put(changedFile, new FileStampFunctionAdapter(false){
                                        PsiFile myCachedPsiFile;

                                        @Override
                                        @NotNull
                                        public PsiFile getCMakeFile(@NotNull Project project) {
                                            if (project == null) {
                                                1.$$$reportNull$$$0(0);
                                            }
                                            if (this.myCachedPsiFile != null) {
                                                PsiFile psiFile = this.myCachedPsiFile;
                                                if (psiFile == null) {
                                                    1.$$$reportNull$$$0(1);
                                                }
                                                return psiFile;
                                            }
                                            PsiFile psiFile = FileStamp.createOrGetCMakeFile(project, changedDocument);
                                            if (psiFile == null) {
                                                1.$$$reportNull$$$0(2);
                                            }
                                            return psiFile;
                                        }

                                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                            RuntimeException runtimeException;
                                            Object[] objectArray;
                                            Object[] objectArray2;
                                            int n2;
                                            String string;
                                            switch (n) {
                                                default: {
                                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                                    break;
                                                }
                                                case 1: 
                                                case 2: {
                                                    string = "@NotNull method %s.%s must not return null";
                                                    break;
                                                }
                                            }
                                            switch (n) {
                                                default: {
                                                    n2 = 3;
                                                    break;
                                                }
                                                case 1: 
                                                case 2: {
                                                    n2 = 2;
                                                    break;
                                                }
                                            }
                                            Object[] objectArray3 = new Object[n2];
                                            switch (n) {
                                                default: {
                                                    objectArray2 = objectArray3;
                                                    objectArray3[0] = "project";
                                                    break;
                                                }
                                                case 1: 
                                                case 2: {
                                                    objectArray2 = objectArray3;
                                                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$3$1$1";
                                                    break;
                                                }
                                            }
                                            switch (n) {
                                                default: {
                                                    objectArray = objectArray2;
                                                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$3$1$1";
                                                    break;
                                                }
                                                case 1: 
                                                case 2: {
                                                    objectArray = objectArray2;
                                                    objectArray2[1] = "getCMakeFile";
                                                    break;
                                                }
                                            }
                                            switch (n) {
                                                default: {
                                                    objectArray = objectArray;
                                                    objectArray[2] = "getCMakeFile";
                                                    break;
                                                }
                                                case 1: 
                                                case 2: {
                                                    break;
                                                }
                                            }
                                            String string2 = String.format(string, objectArray);
                                            switch (n) {
                                                default: {
                                                    runtimeException = new IllegalArgumentException(string2);
                                                    break;
                                                }
                                                case 1: 
                                                case 2: {
                                                    runtimeException = new IllegalStateException(string2);
                                                    break;
                                                }
                                            }
                                            throw runtimeException;
                                        }
                                    });
                                }
                                myChangedDocuments.clear();
                            }
                            boolean filesHaveChanges = CMakeWorkspaceWatcher.this.cmakeFilesHaveChanges(fileStampFunctionMap.keySet(), (NotNullFunction<File, FileStampFunctionAdapter>)((NotNullFunction)file -> (FileStampFunctionAdapter)fileStampFunctionMap.get(file)));
                            boolean hasValidSyntax = this.haveValidSyntax(fileStampFunctionMap.keySet(), (NotNullFunction<File, FileStampFunctionAdapter>)((NotNullFunction)file -> (FileStampFunctionAdapter)fileStampFunctionMap.get(file)));
                            boolean bl = changed = filesHaveChanges && hasValidSyntax;
                            if (changed) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("CMake needs to be reloaded because documents changed:\n" + StringUtil.join(Collections.singletonList(fileStampFunctionMap.keySet()), (String)"\n"));
                                }
                                if (CMakeWorkspaceWatcher.this.isAutoReloadEnabled()) {
                                    CMakeWorkspaceWatcher.this.myWorkspace.scheduleReload(false);
                                } else {
                                    CMakeWorkspaceWatcher.this.setNeedsReload(true);
                                }
                            } else {
                                CMakeWorkspaceWatcher.this.setNeedsReload(false);
                            }
                        });
                    }

                    private void rescheduleWithDelay() {
                        ((CMakeWorkspaceListener)CMakeWorkspaceWatcher.this.myProject.getMessageBus().syncPublisher(CMakeWorkspaceListener.TOPIC)).reloadingRescheduled();
                        CMakeWorkspaceWatcher.this.myChangedDocumentsQueue.restartTimer();
                        CMakeWorkspaceWatcher.this.myChangedDocumentsQueue.queue((Update)this);
                    }

                    private boolean haveValidSyntax(@NotNull Collection<File> changedDocuments, @NotNull NotNullFunction<File, FileStampFunctionAdapter> getFileDocumentStampFunction) {
                        if (changedDocuments == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (getFileDocumentStampFunction == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return !ContainerUtil.exists(changedDocuments, each -> {
                            PsiFile file = ((FileStampFunctionAdapter)getFileDocumentStampFunction.fun(each)).getCMakeFile(CMakeWorkspaceWatcher.this.myProject);
                            return file != null && PsiTreeUtil.hasErrorElements((PsiElement)file);
                        });
                    }

                    public boolean canEat(Update update2) {
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "changedDocuments";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "getFileDocumentStampFunction";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$3$1";
                        objectArray[2] = "haveValidSyntax";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$3", "documentChanged"));
            }
        }, this.myShutdownDisposable);
        new FilesModificationsListener(){

            @NotNull
            protected Set<File> getWatchedFiles() {
                Set<File> set = CMakeWorkspaceWatcher.this.myWorkspace.getCMakeDependencyFiles();
                if (set == null) {
                    4.$$$reportNull$$$0(0);
                }
                return set;
            }

            protected void watchedFilesChanged(@NotNull Set<File> structurallyChangedFiles, @NotNull Set<VirtualFile> filesWithContentChanges, boolean externalChange, boolean fromSave) {
                if (structurallyChangedFiles == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (filesWithContentChanges == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (externalChange) {
                    if (isGenerationRunning.get()) {
                        return;
                    }
                    if (CollectionsKt.none(structurallyChangedFiles, file -> file.lastModified() > lastGenerationTimestamp.get() || file.lastModified() == 0L) && CollectionsKt.none(filesWithContentChanges, file -> file.getTimeStamp() > lastGenerationTimestamp.get())) {
                        return;
                    }
                }
                if (!structurallyChangedFiles.isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("CMake needs to be reloaded because files changed structurally" + (externalChange ? "(external)" : "") + ":\n" + StringUtil.join(structurallyChangedFiles, (String)"\n"));
                    }
                } else {
                    if (fromSave) {
                        return;
                    }
                    final Map map2 = ContainerUtil.map2MapNotNull(filesWithContentChanges, file -> Pair.create((Object)VfsUtilCore.virtualToIoFile((VirtualFile)file), (Object)file));
                    boolean filesHaveChanged = CMakeWorkspaceWatcher.this.cmakeFilesHaveChanges(map2.keySet(), (NotNullFunction<File, FileStampFunctionAdapter>)((NotNullFunction)file -> new FileStampFunctionAdapter(true, (File)file){
                        final /* synthetic */ File val$file;
                        {
                            this.val$file = file;
                            super(useAlreadyCalculatedStamp);
                        }

                        @Override
                        @Nullable
                        public PsiFile getCMakeFile(@NotNull Project project) {
                            if (project == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return FileStamp.createOrGetCMakeFile(project, (VirtualFile)map2.get(this.val$file));
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$4$1", "getCMakeFile"));
                        }
                    }));
                    if (!filesHaveChanged) {
                        return;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("CMake needs to be reloaded because file contents changed" + (externalChange ? "(external)" : "") + ":\n" + StringUtil.join(filesWithContentChanges, (String)"\n"));
                    }
                }
                if (externalChange && !CMakeWorkspaceWatcher.this.isAutoReloadEnabled() && AdvancedSettings.getBoolean((String)"cmake.disable.auto.reload.external.changes")) {
                    LOG.debug("External changes were ignored");
                    CMakeWorkspaceWatcher.this.setNeedsReload(true);
                    return;
                }
                CMakeWorkspaceWatcher.this.myWorkspace.scheduleReload(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$4";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "structurallyChangedFiles";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "filesWithContentChanges";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getWatchedFiles";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "watchedFilesChanged";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }.install(this.myShutdownDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.myInitialized.getAndSet(false)) {
            return;
        }
        Disposer.dispose((Disposable)this.myShutdownDisposable);
        this.myChangedDocumentsQueue.cancelAllUpdates();
        this.myReloadsQueue.clear();
        this.mySchedulingQueueProcessor.clear();
        this.myWaitingReloadsCount.set(0);
        AtomicInteger atomicInteger = this.myWaitingReloadsCount;
        synchronized (atomicInteger) {
            this.myWaitingReloadsCount.notifyAll();
        }
        ProgressIndicator currentIndicator = this.myRunningReloadTaskIndicator;
        if (currentIndicator != null) {
            currentIndicator.cancel();
        }
    }

    private void runWhenReady(@NotNull DumbAwareRunnable runnable2) {
        if (runnable2 == null) {
            CMakeWorkspaceWatcher.$$$reportNull$$$0(2);
        }
        DumbAwareRunnable dumbAware = () -> {
            if (!this.myInitialized.get()) {
                return;
            }
            runnable2.run();
        };
        if (StartupManagerEx.getInstanceEx((Project)this.myProject).startupActivityPassed()) {
            dumbAware.run();
        } else {
            StartupManager.getInstance((Project)this.myProject).runAfterOpened((Runnable)dumbAware);
        }
    }

    public <T> Future<T> lockModelDuring(@NotNull Callable<? extends T> callable) {
        if (callable == null) {
            CMakeWorkspaceWatcher.$$$reportNull$$$0(3);
        }
        FutureResult result = new FutureResult();
        this.runWhenReady(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Lock lock = this.myReloadsLock.readLock();
            lock.lock();
            try {
                result.set(callable.call());
            }
            catch (Throwable e) {
                result.setException(e);
            }
            finally {
                lock.unlock();
            }
        }));
        return result;
    }

    @TestOnly
    public void setReloadInBackgroundInTests(boolean value, @NotNull Disposable disposable) {
        if (disposable == null) {
            CMakeWorkspaceWatcher.$$$reportNull$$$0(4);
        }
        WriteAction.runAndWait(() -> {
            this.myReloadInBackgroundInTestsMode = value;
            this.myChangedDocumentsQueue.setPassThrough(!value);
            this.myReloadsQueue.setForceAsyncInTests(value, disposable);
        });
    }

    @TestOnly
    public void stopReloadsOnDocumentChange() {
        this.myChangedDocumentsQueue.suspend();
    }

    @TestOnly
    public void resumeReloadsOnDocumentChange() {
        this.myChangedDocumentsQueue.resume();
    }

    @TestOnly
    public void waitForReloadsToFinish(int millis) throws TimeoutException {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            throw new AssertionError((Object)"Must not wait for CMake reload on AWT, a deadlock will happen.\nRewrite the test with runInDispatchThread=false");
        }
        @NonNls String[] debugState = new String[]{"Initial"};
        AtomicBoolean finished = new AtomicBoolean();
        Thread thread = new Thread(() -> {
            debugState[0] = "Flushing myChangedDocumentsQueue";
            this.myChangedDocumentsQueue.flush();
            while (this.myChangedDocumentsQueue.isFlushing()) {
                TimeoutUtil.sleep((long)100L);
            }
            AtomicInteger atomicInteger = this.myWaitingReloadsCount;
            synchronized (atomicInteger) {
                while (this.myWaitingReloadsCount.get() > 0) {
                    debugState[0] = "Waiting for myWaitingReloadsCount: " + this.myWaitingReloadsCount.get();
                    try {
                        this.myWaitingReloadsCount.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            debugState[0] = "Waiting for mySchedulingQueueProcessor";
            this.mySchedulingQueueProcessor.waitFor();
            debugState[0] = "Waiting for myReloadsQueue";
            this.myReloadsQueue.waitForTasksToFinish();
            debugState[0] = "Waiting for myReloadsLock";
            this.myReloadsLock.writeLock().lock();
            this.myReloadsLock.writeLock().unlock();
            debugState[0] = "Waiting for RefreshQueue";
            RefreshQueue.getInstance().refresh(false, false, null, Collections.emptyList());
            finished.set(true);
        }, "wait for reload");
        thread.start();
        try {
            thread.join(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!finished.get()) {
            ProgressIndicator indicator = this.myRunningReloadTaskIndicator;
            if (indicator != null) {
                indicator.cancel();
            }
            throw new TimeoutException(debugState[0]);
        }
    }

    void scheduleReload(@NotNull Consumer<ProgressIndicator> reloadRunnable, @NotNull ReloadFlag flag) {
        if (reloadRunnable == null) {
            CMakeWorkspaceWatcher.$$$reportNull$$$0(5);
        }
        if (flag == null) {
            CMakeWorkspaceWatcher.$$$reportNull$$$0(6);
        }
        this.setNeedsReload(false);
        this.myChangedDocumentsQueue.cancelAllUpdates();
        this.myWaitingReloadsCount.incrementAndGet();
        Throwable originalStackTrace = new Throwable().fillInStackTrace();
        this.runWhenReady(() -> this.doScheduleReload(reloadRunnable, flag, originalStackTrace));
    }

    void cancelActiveReload() {
        ProgressIndicator indicator = this.myRunningReloadTaskIndicator;
        if (indicator != null) {
            indicator.cancel();
        }
    }

    private void doScheduleReload(final @NotNull Consumer<ProgressIndicator> reloadRunnable, @NotNull ReloadFlag flag, final @NotNull Throwable originalStackTrace) {
        ProgressIndicator indicator;
        if (reloadRunnable == null) {
            CMakeWorkspaceWatcher.$$$reportNull$$$0(7);
        }
        if (flag == null) {
            CMakeWorkspaceWatcher.$$$reportNull$$$0(8);
        }
        if (originalStackTrace == null) {
            CMakeWorkspaceWatcher.$$$reportNull$$$0(9);
        }
        if ((indicator = this.myRunningReloadTaskIndicator) != null) {
            indicator.cancel();
        }
        final Throwable localOriginalStackTrace = new Throwable().fillInStackTrace();
        Runnable action = () -> {
            block10: {
                if (!this.myInitialized.get()) {
                    return;
                }
                Lock writeLock = this.myReloadsLock.writeLock();
                writeLock.lock();
                try {
                    int count = this.myWaitingReloadsCount.decrementAndGet();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("doScheduleReload: waiting reloads: " + count);
                    }
                    if (count != 0) break block10;
                    AtomicInteger atomicInteger = this.myWaitingReloadsCount;
                    synchronized (atomicInteger) {
                        this.myWaitingReloadsCount.notifyAll();
                    }
                    List futures = EP_NAME.extensions().map(ext -> ext.getFuture(this.myProject)).collect(Collectors.toList());
                    ReloadFlag effectiveFlag = flag;
                    if (this.shouldReloadInBackground() && !futures.stream().map(CompletableFuture::isDone).allMatch(done -> done.equals(true))) {
                        LOG.info("Waiting for startup futures to complete");
                        effectiveFlag = futures.stream().map(CompletableFuture::join).sorted().findFirst().orElse(flag);
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("doScheduleReload: effectiveFlag: " + effectiveFlag);
                    }
                    final ReloadFlag finalEffectiveFlag = effectiveFlag;
                    this.myReloadsQueue.run(new Task.Backgroundable(this.myProject, CMakeWorkspaceWatcher.getReadingCmakeProject(), true){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                5.$$$reportNull$$$0(0);
                            }
                            LOG.trace("Task.Backgroundable#run");
                            if (!CMakeWorkspaceWatcher.this.myInitialized.get()) {
                                return;
                            }
                            StructuredIdeActivity activity = CMakeStatisticsCollector.RELOAD_ACTIVITY.started(this.myProject);
                            CMakeWorkspaceWatcher.this.myRunningReloadTaskIndicator = indicator;
                            try {
                                boolean requireReload = CMakeWorkspaceWatcher.this.cmakeFilesOrDocumentsHaveChangesOrSettingsChanged(indicator, finalEffectiveFlag == ReloadFlag.RELOAD_ONLY_WHEN_CHANGED_PLUS_FULL_CHECK_ENVIRONMENT);
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace("requireReload: " + requireReload);
                                }
                                if (finalEffectiveFlag == ReloadFlag.FORCE_RELOAD || requireReload) {
                                    reloadRunnable.accept(indicator);
                                }
                            }
                            catch (RuntimeException e) {
                                localOriginalStackTrace.addSuppressed(originalStackTrace);
                                e.addSuppressed(localOriginalStackTrace);
                                ExceptionUtil.rethrow((Throwable)e);
                            }
                            finally {
                                CMakeWorkspaceWatcher.this.myRunningReloadTaskIndicator = null;
                                activity.finished();
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$5", "run"));
                        }
                    });
                    this.myReloadsQueue.waitForTasksToFinish();
                }
                finally {
                    writeLock.unlock();
                }
            }
        };
        if (this.shouldReloadInBackground()) {
            LOG.trace("doScheduleReload: shouldReloadInBackground");
            this.mySchedulingQueueProcessor.add((Object)action);
        } else {
            LOG.trace("doScheduleReload: run in the current thread");
            action.run();
        }
    }

    private boolean shouldReloadInBackground() {
        return !ApplicationManager.getApplication().isUnitTestMode() || this.myReloadInBackgroundInTestsMode;
    }

    private boolean isAutoReloadEnabled() {
        return this.myWorkspace.getSettings().isAutoReloadEnabled();
    }

    public void schedulePendingAutoReloads() {
        if (this.myProject.getUserData(NEEDS_RELOAD) != null && this.isAutoReloadEnabled()) {
            this.myWorkspace.scheduleReload(false);
        }
    }

    private void setNeedsReload(boolean value) {
        this.myProject.putUserData(NEEDS_RELOAD, (Object)(value ? Boolean.valueOf(true) : null));
        EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
    }

    private boolean cmakeFilesOrDocumentsHaveChangesOrSettingsChanged(final @NotNull ProgressIndicator indicator, boolean alsoCheckEnvironment) {
        if (indicator == null) {
            CMakeWorkspaceWatcher.$$$reportNull$$$0(10);
        }
        indicator.checkCanceled();
        if (this.myWorkspace.isModelSettingsHashChanged(alsoCheckEnvironment)) {
            return true;
        }
        NotNullFunction<File, FileStampFunctionAdapter> getFileStampFunction = new NotNullFunction<File, FileStampFunctionAdapter>(){
            FileDocumentManager myDocumentManager;

            @NotNull
            public FileStampFunctionAdapter fun(File file) {
                Document document;
                boolean checkDocumentText;
                indicator.checkCanceled();
                final VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
                if (vFile == null) {
                    return new FileStampFunctionAdapter(true){

                        @Override
                        @Nullable
                        public PsiFile getCMakeFile(@NotNull Project project) {
                            if (project == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return null;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$6$1", "getCMakeFile"));
                        }
                    };
                }
                if (this.myDocumentManager == null) {
                    this.myDocumentManager = FileDocumentManager.getInstance();
                }
                boolean bl = checkDocumentText = (document = this.myDocumentManager.getCachedDocument(vFile)) != null && document.getUserData(SHOULD_CHECK_DOCUMENT_TEXT) == Boolean.TRUE;
                if (document != null) {
                    document.putUserData(SHOULD_CHECK_DOCUMENT_TEXT, null);
                }
                return new FileStampFunctionAdapter(!checkDocumentText){

                    @Override
                    @Nullable
                    public PsiFile getCMakeFile(@NotNull Project project) {
                        if (project == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (checkDocumentText) {
                            return FileStamp.createOrGetCMakeFile(project, document);
                        }
                        return FileStamp.createOrGetCMakeFile(project, vFile);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$6$2", "getCMakeFile"));
                    }
                };
            }
        };
        return this.cmakeFilesHaveChanges(null, getFileStampFunction);
    }

    private boolean cmakeFilesHaveChanges(@Nullable Collection<File> toCheckOrNullForAll, final @NotNull NotNullFunction<File, FileStampFunctionAdapter> getFileDocumentStampFunction) {
        Map oldStamps;
        if (getFileDocumentStampFunction == null) {
            CMakeWorkspaceWatcher.$$$reportNull$$$0(11);
        }
        if ((oldStamps = (Map)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return null;
            }
            return this.myWorkspace.getCMakeDependencyFilesWithStamps();
        })) == null) {
            return false;
        }
        Collection<File> newFiles = toCheckOrNullForAll != null ? toCheckOrNullForAll : oldStamps.keySet();
        for (final File newFile : newFiles) {
            FileStamp oldStamp;
            FileStamp.FileStampFunction fileStampFunction;
            FileStamp newStamp = (FileStamp)ReadAction.compute(() -> this.lambda$cmakeFilesHaveChanges$11(newFile, fileStampFunction = new FileStamp.FileStampFunction(oldStamp = (FileStamp)oldStamps.get(newFile)){
                final FileStampFunctionAdapter delegate;
                final /* synthetic */ FileStamp val$oldStamp;
                {
                    this.val$oldStamp = fileStamp;
                    this.delegate = (FileStampFunctionAdapter)getFileDocumentStampFunction.fun((Object)newFile);
                }

                @Override
                public FileStamp getAlreadyCalculatedStamp() {
                    return this.delegate.useAlreadyCalculatedStamp ? this.val$oldStamp : null;
                }

                @Override
                @Nullable
                public PsiFile getCMakeFile(@NotNull Project project) {
                    if (project == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    return this.delegate.getCMakeFile(project);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher$7", "getCMakeFile"));
                }
            }));
            if (newStamp == null) {
                return false;
            }
            if (oldStamp == null || oldStamp.timestamp != newStamp.timestamp && (oldStamp.timestamp == 0L || newStamp.timestamp == 0L)) {
                return true;
            }
            if (oldStamp.contentCrc != newStamp.contentCrc) {
                return true;
            }
            if (oldStamp.contentCrc != -1L || oldStamp.timestamp == newStamp.timestamp && oldStamp.size == newStamp.size) continue;
            return true;
        }
        return false;
    }

    @NlsContexts.ProgressTitle
    private static String getReadingCmakeProject() {
        return CLionCMakeBundle.message("cmake.loadingProgress", new Object[0]);
    }

    private /* synthetic */ FileStamp lambda$cmakeFilesHaveChanges$11(File newFile, FileStamp.FileStampFunction fileStampFunction) throws RuntimeException {
        if (this.myProject.isDisposed()) {
            return null;
        }
        return FileStamp.calcFileStamp(this.myProject, newFile, fileStampFunction);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reloadRunnable";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flag";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalStackTrace";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getFileDocumentStampFunction";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceWatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "runWhenReady";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lockModelDuring";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setReloadInBackgroundInTests";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleReload";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "doScheduleReload";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "cmakeFilesOrDocumentsHaveChangesOrSettingsChanged";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "cmakeFilesHaveChanges";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class FileStampFunctionAdapter {
        final boolean useAlreadyCalculatedStamp;

        FileStampFunctionAdapter(boolean useAlreadyCalculatedStamp) {
            this.useAlreadyCalculatedStamp = useAlreadyCalculatedStamp;
        }

        @Nullable
        public abstract PsiFile getCMakeFile(@NotNull Project var1);
    }
}

