/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.build;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ContentsUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.execution.build.CLionBuildConsoleBuilder;
import com.jetbrains.cidr.cpp.execution.build.CLionBuildConsoleView;
import com.jetbrains.cidr.cpp.execution.build.CLionBuildUtil;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.execution.build.CidrBuild;
import com.jetbrains.cidr.execution.build.CidrBuildListener;
import java.io.File;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001aD\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"ACTION_PLACE", "", "createBuildConsole", "Lcom/intellij/execution/ui/ConsoleView;", "project", "Lcom/intellij/openapi/project/Project;", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "baseDir", "Ljava/io/File;", "taskName", "preBuildMessage", "buildSessionId", "", "context", "Lcom/jetbrains/cidr/execution/build/CidrBuild$BuildContext;", "getDefaultBuildProcesses", "", "cpuCount", "intellij.clion.execution"})
public final class ClionBuildUtilKt {
    @NotNull
    public static final String ACTION_PLACE = "CLionBuildConsole";

    public static final int getDefaultBuildProcesses() {
        return ClionBuildUtilKt.getDefaultBuildProcesses(Runtime.getRuntime().availableProcessors());
    }

    public static final int getDefaultBuildProcesses(int cpuCount) {
        int n = 1;
        double d = (double)cpuCount * 0.8;
        boolean bl = false;
        int n2 = (int)Math.floor(d);
        boolean bl2 = false;
        return Math.max(n, n2);
    }

    @NotNull
    public static final ConsoleView createBuildConsole(@NotNull Project project, @NotNull CPPEnvironment environment2, @Nullable File baseDir, @NotNull String taskName, @Nullable String preBuildMessage, @Nullable Object buildSessionId, @NotNull CidrBuild.BuildContext context) {
        Content content;
        ContentManager contentManager;
        block6: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            CPPLog.LOG.assertTrue(application.isDispatchThread(), (Object)"Should be called from EDT");
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Messages");
            Intrinsics.checkNotNull((Object)toolWindow);
            ToolWindow toolWindow2 = toolWindow;
            ContentManager contentManager2 = toolWindow2.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"toolWindow.contentManager");
            contentManager = contentManager2;
            Content[] contentArray = contentManager.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"contentManager.contents");
            Content[] contentArray2 = contentArray;
            boolean bl = false;
            Content[] contentArray3 = contentArray2;
            boolean bl2 = false;
            Content[] contentArray4 = contentArray3;
            int n = contentArray4.length;
            for (int i = 0; i < n; ++i) {
                Content content2;
                Content it = content2 = contentArray4[i];
                boolean bl3 = false;
                Content content3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"it");
                if (!Intrinsics.areEqual((Object)content3.getDisplayName(), (Object)CidrExecutionBundle.message((String)"build.logToolWindowName", (Object[])new Object[0]))) continue;
                content = content2;
                break block6;
            }
            content = null;
        }
        Content usedContent = content;
        ConsoleViewImpl consoleView = null;
        if (usedContent == null || !(usedContent.getComponent() instanceof CLionBuildConsoleView) || buildSessionId == null || Intrinsics.areEqual((Object)buildSessionId, (Object)CLionBuildUtil.getBuildSessionId(usedContent)) ^ true) {
            ConsoleView consoleView2 = new CLionBuildConsoleBuilder(project, environment2, baseDir).getConsole();
            if (consoleView2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.execution.impl.ConsoleViewImpl");
            }
            consoleView = (ConsoleViewImpl)consoleView2;
            Content content4 = ContentFactory.SERVICE.getInstance().createContent(consoleView.getComponent(), CidrExecutionBundle.message((String)"build.logToolWindowName", (Object[])new Object[0]), true);
            Intrinsics.checkNotNullExpressionValue((Object)content4, (String)"ContentFactory.SERVICE.g\u2026                    true)");
            Content content5 = content4;
            ContentsUtil.addOrReplaceContent((ContentManager)contentManager, (Content)content5, (boolean)true);
            if (buildSessionId != null) {
                content5.putUserData(ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY, buildSessionId);
            }
            Disposer.register((Disposable)((Disposable)content5), (Disposable)((Disposable)consoleView));
            contentManager.addContentManagerListener((ContentManagerListener)new CidrBuild.BuildContentRemoveListener(project, contentManager, content5, context));
        } else {
            JComponent jComponent = usedContent.getComponent();
            if (jComponent == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.cidr.cpp.execution.build.CLionBuildConsoleView");
            }
            consoleView = (CLionBuildConsoleView)((Object)jComponent);
            consoleView.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        consoleView.putClientProperty(CidrBuild.BuildContext.class, (Object)context);
        consoleView.attachToProcess(context.processHandler);
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect()");
        MessageBusConnection buildConnection = messageBusConnection;
        CidrBuildListener cidrBuildListener = CLionBuildUtil.notificationListener(buildConnection, context.id, context.processHandler, taskName, preBuildMessage);
        Intrinsics.checkNotNullExpressionValue((Object)cidrBuildListener, (String)"CLionBuildUtil.notificat\u2026askName, preBuildMessage)");
        CidrBuildListener buildListener = cidrBuildListener;
        buildConnection.subscribe(CidrBuildListener.TOPIC, (Object)buildListener);
        return (ConsoleView)consoleView;
    }
}

