/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.build.runners;

import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Computable;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.impl.ProjectModelBuildTaskImpl;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeExplicitTargetConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeRunConfigurationType;
import com.jetbrains.cidr.cpp.execution.build.CLionBuildUtil;
import com.jetbrains.cidr.cpp.execution.build.CMakeBuild;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.build.CidrBuildResult;
import com.jetbrains.cidr.execution.build.runners.CidrTaskRunner;
import com.jetbrains.cidr.execution.build.tasks.CidrCleanTaskImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\u0006\u0010\u0007\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\u0006\u0010\u0007\u001a\u00020\u0010H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\bH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001aH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/cpp/execution/build/runners/CMakeBuildTaskRunner;", "Lcom/jetbrains/cidr/execution/build/runners/CidrTaskRunner;", "()V", "build", "", "project", "Lcom/intellij/openapi/project/Project;", "task", "Lcom/intellij/task/ProjectModelBuildTask;", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lcom/intellij/task/ProjectTaskRunner$Result;", "sessionId", "", "executeTask", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/task/ProjectTask;", "context", "Lcom/intellij/task/ProjectTaskContext;", "expandBuildTask", "", "expandModule", "Lcom/intellij/task/ModuleBuildTask;", "expandTask", "getConfiguration", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeConfiguration;", "Lcom/intellij/openapi/roots/ProjectModelBuildableElement;", "getExplicitTargetName", "", "buildableElement", "intellij.clion.cmake"})
public final class CMakeBuildTaskRunner
implements CidrTaskRunner {
    @NotNull
    public static final CMakeBuildTaskRunner INSTANCE;

    private final CMakeConfiguration getConfiguration(ProjectModelBuildTask<? extends ProjectModelBuildableElement> task2) {
        CMakeConfiguration cMakeConfiguration;
        if (task2.getBuildableElement() instanceof CMakeConfiguration) {
            ProjectModelBuildableElement projectModelBuildableElement = task2.getBuildableElement();
            if (projectModelBuildableElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration");
            }
            cMakeConfiguration = (CMakeConfiguration)projectModelBuildableElement;
        } else {
            CPPLog.LOG.assertTrue(task2.getBuildableElement() instanceof CMakeExplicitTargetConfiguration);
            ProjectModelBuildableElement projectModelBuildableElement = task2.getBuildableElement();
            if (projectModelBuildableElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.cidr.cpp.execution.CMakeExplicitTargetConfiguration");
            }
            cMakeConfiguration = ((CMakeExplicitTargetConfiguration)projectModelBuildableElement).getCmakeConfiguration();
        }
        return cMakeConfiguration;
    }

    private final String getExplicitTargetName(ProjectModelBuildableElement buildableElement) {
        return buildableElement instanceof CMakeExplicitTargetConfiguration ? ((CMakeExplicitTargetConfiguration)buildableElement).getExplicitBuildTargetName() : null;
    }

    @NotNull
    public List<ProjectTask> expandTask(@NotNull ProjectTask task2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        ProjectTask projectTask = task2;
        if (projectTask instanceof ProjectModelBuildTask) {
            list = this.expandBuildTask((ProjectModelBuildTask)task2);
        } else if (projectTask instanceof ModuleBuildTask) {
            list = this.expandModule((ModuleBuildTask)task2);
        } else {
            CPPLog.LOG.error("Invalid project task: " + task2.getPresentableName());
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public Promise<ProjectTaskRunner.Result> executeTask(@NotNull Project project, @NotNull ProjectTask task2, @NotNull Object sessionId, @NotNull ProjectTaskContext context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CPPLog.LOG.assertTrue(task2 instanceof ProjectModelBuildTask);
        AsyncPromise promise = new AsyncPromise();
        this.build(project, (ProjectModelBuildTask)task2, (AsyncPromise<ProjectTaskRunner.Result>)promise, sessionId);
        return (Promise)promise;
    }

    public final void build(@NotNull Project project, @NotNull ProjectModelBuildTask<?> task2, @NotNull AsyncPromise<ProjectTaskRunner.Result> promise, @NotNull Object sessionId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        CMakeConfiguration cMakeConfiguration = this.getConfiguration(task2);
        ProjectModelBuildableElement projectModelBuildableElement = task2.getBuildableElement();
        Intrinsics.checkNotNullExpressionValue((Object)projectModelBuildableElement, (String)"task.buildableElement");
        CMakeAppRunConfiguration.BuildAndRunConfigurations configurations = new CMakeAppRunConfiguration.BuildAndRunConfigurations(cMakeConfiguration, null, null, this.getExplicitTargetName(projectModelBuildableElement));
        configurations.putUserData(ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY, sessionId);
        ExecutionResult<CidrBuildResult> result = CMakeBuild.build(project, configurations);
        CLionBuildUtil.handleProjectTaskResults(result, promise);
    }

    private final List<ProjectTask> expandBuildTask(ProjectModelBuildTask<?> task2) {
        return task2.isIncrementalBuild() ? CollectionsKt.listOf(task2) : CollectionsKt.listOf((Object[])new ProjectTask[]{(ProjectTask)new CidrCleanTaskImpl((CidrBuildConfiguration)this.getConfiguration(task2)), (ProjectTask)task2});
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProjectTask> expandModule(ModuleBuildTask task2) {
        List list;
        Module module = task2.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"task.module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"task.module.project");
        Project project2 = project;
        boolean $i$f$runReadAction = false;
        Object object = ApplicationManager.getApplication().runReadAction(new Computable(project2){
            final /* synthetic */ Project $project$inlined;
            {
                this.$project$inlined = project;
            }

            public final T compute() {
                boolean bl = false;
                return (T)CMakeRunConfigurationType.getHelper(this.$project$inlined).findAllProfileConfigurations();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction { CMakeRun\u2026ProfileConfigurations() }");
        List configurations = (List)object;
        if (configurations.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(project2){
                final /* synthetic */ Project $project;

                public final void run() {
                    CMakeBuild.showBuildNotification(this.$project, MessageType.ERROR, CLionCMakeBundle.message("cmake.build.project.noProfileError.message", new Object[0]));
                }
                {
                    this.$project = project;
                }
            });
            list = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            CidrCleanTaskImpl cidrCleanTaskImpl;
            Iterable iterable;
            Iterable destination$iv$iv;
            List list2;
            if (task2.isIncrementalBuild()) {
                list2 = CollectionsKt.emptyList();
            } else {
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv = configurations;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    CMakeConfiguration cMakeConfiguration = (CMakeConfiguration)item$iv$iv;
                    iterable = destination$iv$iv;
                    boolean bl = false;
                    void v5 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"it");
                    cidrCleanTaskImpl = new CidrCleanTaskImpl((CidrBuildConfiguration)v5);
                    iterable.add(cidrCleanTaskImpl);
                }
                list2 = (List)destination$iv$iv;
            }
            List cleanTasks = list2;
            Iterable $this$map$iv = configurations;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void configuration;
                CMakeConfiguration bl = (CMakeConfiguration)item$iv$iv;
                iterable = destination$iv$iv2;
                boolean bl2 = false;
                void v6 = configuration;
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"configuration");
                cidrCleanTaskImpl = new ProjectModelBuildTaskImpl((ProjectModelBuildableElement)new CMakeExplicitTargetConfiguration((CMakeConfiguration)v6, "all"), true);
                iterable.add(cidrCleanTaskImpl);
            }
            List buildTasks = (List)destination$iv$iv2;
            list = CollectionsKt.plus((Collection)cleanTasks, (Iterable)buildTasks);
        }
        return list;
    }

    private CMakeBuildTaskRunner() {
    }

    static {
        CMakeBuildTaskRunner cMakeBuildTaskRunner;
        INSTANCE = cMakeBuildTaskRunner = new CMakeBuildTaskRunner();
    }
}

