/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.coredump;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.coredump.CidrCoreDumpDebugParameters;
import com.jetbrains.cidr.cpp.execution.coredump.CidrCoreDumpRunConfigurationEditor;
import com.jetbrains.cidr.cpp.execution.coredump.CidrCoreDumpRunConfigurationType;
import com.jetbrains.cidr.cpp.execution.coredump.CoreDumpLauncher;
import com.jetbrains.cidr.cpp.execution.remote.DebuggerData;
import com.jetbrains.cidr.cpp.execution.remote.DebuggerSourceKind;
import com.jetbrains.cidr.cpp.execution.remote.PathMappingsComponentKt;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrLauncher;
import com.jetbrains.cidr.execution.CidrRunProfile;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00022\u00020\u0003B!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00000\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0007H\u0016J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0016R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006&"}, d2={"Lcom/jetbrains/cidr/cpp/execution/coredump/CidrCoreDumpRunConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lcom/intellij/execution/runners/RunConfigurationWithSuppressedDefaultRunAction;", "Lcom/jetbrains/cidr/execution/CidrRunProfile;", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "debuggerData", "Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerData;", "getDebuggerData", "()Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerData;", "setDebuggerData", "(Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerData;)V", "params", "Lcom/jetbrains/cidr/cpp/execution/coredump/CidrCoreDumpDebugParameters;", "getParams", "()Lcom/jetbrains/cidr/cpp/execution/coredump/CidrCoreDumpDebugParameters;", "setParams", "(Lcom/jetbrains/cidr/cpp/execution/coredump/CidrCoreDumpDebugParameters;)V", "checkConfiguration", "", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "getState", "Lcom/intellij/execution/configurations/CommandLineState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "readExternal", "element", "Lorg/jdom/Element;", "suggestedName", "writeExternal", "intellij.clion.execution"})
public final class CidrCoreDumpRunConfiguration
extends LocatableConfigurationBase<CidrCoreDumpRunConfiguration>
implements RunConfigurationWithSuppressedDefaultRunAction,
CidrRunProfile {
    @NotNull
    private DebuggerData debuggerData;
    @NotNull
    private CidrCoreDumpDebugParameters params;

    @NotNull
    public final DebuggerData getDebuggerData() {
        return this.debuggerData;
    }

    public final void setDebuggerData(@NotNull DebuggerData debuggerData) {
        Intrinsics.checkNotNullParameter((Object)debuggerData, (String)"<set-?>");
        this.debuggerData = debuggerData;
    }

    @NotNull
    public final CidrCoreDumpDebugParameters getParams() {
        return this.params;
    }

    public final void setParams(@NotNull CidrCoreDumpDebugParameters cidrCoreDumpDebugParameters) {
        Intrinsics.checkNotNullParameter((Object)cidrCoreDumpDebugParameters, (String)"<set-?>");
        this.params = cidrCoreDumpDebugParameters;
    }

    @NotNull
    public SettingsEditor<CidrCoreDumpRunConfiguration> getConfigurationEditor() {
        return new CidrCoreDumpRunConfigurationEditor();
    }

    public void checkConfiguration() {
        DebuggerSourceKind kind = this.debuggerData.getKind();
        if (kind instanceof DebuggerSourceKind.External && StringsKt.isBlank((CharSequence)((DebuggerSourceKind.External)kind).getPath())) {
            throw (Throwable)new RuntimeConfigurationError(CLionExecutionBundle.message("gdbRemote.debuggerNotSpecified", new Object[0]));
        }
        String coreDump = this.params.getCoreDump();
        if (StringsKt.isBlank((CharSequence)coreDump)) {
            throw (Throwable)new RuntimeConfigurationError(CLionExecutionBundle.message("coredump.coredump.missing", new Object[0]));
        }
        if (!new File(coreDump).exists()) {
            throw (Throwable)new RuntimeConfigurationError(CLionExecutionBundle.message("coredump.coredump.invalid", coreDump));
        }
        String symbolFile = this.params.getCoreDump();
        if (this.debuggerData.isGDB() && StringsKt.isBlank((CharSequence)symbolFile)) {
            throw (Throwable)new RuntimeConfigurationError(CLionExecutionBundle.message("coredump.symbolFile.missing", new Object[0]));
        }
        if (this.debuggerData.isGDB() && !new File(symbolFile).exists()) {
            throw (Throwable)new RuntimeConfigurationWarning(CLionExecutionBundle.message("coredump.symbolFile.invalid", symbolFile));
        }
    }

    @NotNull
    public CommandLineState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment2) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        CPPToolchains.Toolchain debuggerToolchain = this.debuggerData.getOrCreateDebuggerToolchain();
        Project project = environment2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"environment.project");
        CoreDumpLauncher launcher = new CoreDumpLauncher(project, this.params, debuggerToolchain);
        return (CommandLineState)new CidrCommandLineState(environment2, (CidrLauncher)launcher);
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        this.debuggerData.writeExternal(element);
        element.setAttribute("coreDump", FileUtil.toSystemIndependentName((String)this.params.getCoreDump()));
        element.setAttribute("symbolFile", FileUtil.toSystemIndependentName((String)this.params.getSymbolFile()));
        element.setAttribute("sysroot", FileUtil.toSystemIndependentName((String)this.params.getSysroot()));
        PathMappingsComponentKt.save(element, this.params.getPathMappings());
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        this.debuggerData.readExternal(element);
        String string = element.getAttributeValue("coreDump");
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        string = element.getAttributeValue("symbolFile");
        bl = false;
        String string3 = string;
        if (string3 == null) {
            string3 = "";
        }
        string = element.getAttributeValue("sysroot");
        bl = false;
        String string4 = string;
        if (string4 == null) {
            string4 = "";
        }
        this.params = new CidrCoreDumpDebugParameters(string2, string3, string4, PathMappingsComponentKt.load(element));
    }

    @NotNull
    public String suggestedName() {
        String string = FileUtil.toSystemIndependentName((String)this.params.getCoreDump());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.toSystemIndependentName(params.coreDump)");
        String coreDumpFileName = StringsKt.substringAfterLast$default((String)string, (char)'/', null, (int)2, null);
        return coreDumpFileName.length() < 30 ? coreDumpFileName : StringsKt.take((String)coreDumpFileName, (int)30) + "...";
    }

    public CidrCoreDumpRunConfiguration(@NotNull Project project, @Nullable String name2, @NotNull ConfigurationFactory factory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        super(project, factory, name2);
        this.debuggerData = new DebuggerData(SystemInfo.isWindows ? (DebuggerSourceKind.Bundle)DebuggerSourceKind.Bundle.LLDB.INSTANCE : DebuggerSourceKind.Bundle.Companion.defaultForOS$default(DebuggerSourceKind.Bundle.Companion, null, 1, null));
        this.params = new CidrCoreDumpDebugParameters(null, null, null, null, 15, null);
    }

    public /* synthetic */ CidrCoreDumpRunConfiguration(Project project, String string, ConfigurationFactory configurationFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            boolean $i$f$runConfigurationType = false;
            configurationFactory = (ConfigurationFactory)ConfigurationTypeUtil.findConfigurationType(CidrCoreDumpRunConfigurationType.class);
        }
        this(project, string, configurationFactory);
    }
}

