/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.external.build.runners;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.TaskRunnerResults;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolsBundle;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.execution.external.build.CLionExternalConfiguration;
import com.jetbrains.cidr.cpp.execution.external.build.CLionExternalToolConfiguration;
import com.jetbrains.cidr.cpp.execution.external.build.runners.CLionAbstractExternalConfigurationRunner;
import com.jetbrains.cidr.cpp.execution.external.build.runners.CLionExternalProjectTaskContext;
import com.jetbrains.cidr.cpp.execution.external.build.runners.CLionExternalToolConfigurationRunner;
import com.jetbrains.cidr.cpp.execution.external.build.runners.CLionExternalToolConfigurationRunnerKt;
import com.jetbrains.cidr.execution.build.CidrBuildEvent;
import com.jetbrains.cidr.execution.build.CidrBuildListener;
import com.jetbrains.cidr.execution.build.CidrBuildResult;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JX\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0010H\u0002J6\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 "}, d2={"Lcom/jetbrains/cidr/cpp/execution/external/build/runners/CLionExternalToolConfigurationRunner;", "Lcom/jetbrains/cidr/cpp/execution/external/build/runners/CLionAbstractExternalConfigurationRunner;", "()V", "type", "Lcom/jetbrains/cidr/cpp/execution/external/build/CLionExternalConfiguration$Type;", "getType", "()Lcom/jetbrains/cidr/cpp/execution/external/build/CLionExternalConfiguration$Type;", "reportExecutionResult", "", "project", "Lcom/intellij/openapi/project/Project;", "configuration", "Lcom/jetbrains/cidr/cpp/execution/external/build/CLionExternalConfiguration;", "buildEvent", "Lcom/jetbrains/cidr/execution/build/CidrBuildEvent;", "success", "", "canceled", "started", "", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lcom/intellij/task/ProjectTaskRunner$Result;", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "notify", "run", "Lorg/jetbrains/concurrency/Promise;", "sessionId", "", "context", "Lcom/intellij/task/ProjectTaskContext;", "intellij.clion.execution"})
public final class CLionExternalToolConfigurationRunner
extends CLionAbstractExternalConfigurationRunner {
    @NotNull
    private final CLionExternalConfiguration.Type type = CLionExternalConfiguration.Type.Tool.INSTANCE;

    @Override
    @NotNull
    protected CLionExternalConfiguration.Type getType() {
        return this.type;
    }

    @Override
    @NotNull
    public Promise<ProjectTaskRunner.Result> run(@NotNull Project project, @NotNull CLionExternalConfiguration configuration, @NotNull Object sessionId, @NotNull CidrBuildEvent buildEvent, @NotNull ProjectTaskContext context) {
        long l;
        DataContext dataContext;
        Tool tool;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)buildEvent, (String)"buildEvent");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CPPLog.LOG.assertTrue(Intrinsics.areEqual((Object)configuration.getType(), (Object)this.getType()) && configuration instanceof CLionExternalToolConfiguration);
        Logger logger = CPPLog.LOG;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"CPPLog.LOG");
        if (logger.isDebugEnabled()) {
            CPPLog.LOG.debug("Running external tool configuration: " + configuration.getName());
        }
        if ((tool = ((CLionExternalToolConfiguration)configuration).getTool()) == null) {
            MessageType messageType = MessageType.ERROR;
            Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.ERROR");
            String string = ToolsBundle.message((String)"tools.unknown.external.tool", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ToolsBundle.message(\"tools.unknown.external.tool\")");
            CLionAbstractExternalConfigurationRunner.Companion.showBuildNotification$default(CLionAbstractExternalConfigurationRunner.Companion, project, messageType, string, null, 8, null);
            CPPLog.LOG.debug("External tool configuration - unknown external tool");
            return Promises.resolvedPromise((Object)TaskRunnerResults.ABORTED);
        }
        AsyncPromise promise = new AsyncPromise();
        ProjectTaskContext projectTaskContext = context;
        if (!(projectTaskContext instanceof CLionExternalProjectTaskContext)) {
            projectTaskContext = null;
        }
        CLionExternalProjectTaskContext cLionExternalProjectTaskContext = (CLionExternalProjectTaskContext)projectTaskContext;
        Object object = dataContext = cLionExternalProjectTaskContext != null ? cLionExternalProjectTaskContext.getData() : null;
        if (dataContext == null) {
            CPPLog.LOG.error("External tool configuration " + configuration.getName() + " - data context not found");
            return Promises.resolvedPromise((Object)TaskRunnerResults.ABORTED);
        }
        Object object2 = sessionId;
        if (object2 instanceof UUID) {
            l = ((UUID)sessionId).getLeastSignificantBits();
        } else if (object2 instanceof Long) {
            l = ((Number)sessionId).longValue();
        } else {
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"UUID.randomUUID()");
            l = uUID.getLeastSignificantBits();
        }
        long executionId = l;
        long started = System.currentTimeMillis();
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect()");
        MessageBusConnection connection = messageBusConnection;
        connection.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(this, executionId, project, configuration, buildEvent, started, promise, connection){
            final /* synthetic */ CLionExternalToolConfigurationRunner this$0;
            final /* synthetic */ long $executionId;
            final /* synthetic */ Project $project;
            final /* synthetic */ CLionExternalConfiguration $configuration;
            final /* synthetic */ CidrBuildEvent $buildEvent;
            final /* synthetic */ long $started;
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ MessageBusConnection $connection;

            public void processNotStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env) {
                Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
                Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                if (env.getExecutionId() != 0L && env.getExecutionId() == this.$executionId) {
                    CLionExternalToolConfigurationRunner.access$reportExecutionResult(this.this$0, this.$project, this.$configuration, this.$buildEvent, false, true, this.$started, this.$promise, this.$connection, false);
                }
            }
            {
                this.this$0 = this$0;
                this.$executionId = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                this.$configuration = $captured_local_variable$3;
                this.$buildEvent = $captured_local_variable$4;
                this.$started = $captured_local_variable$5;
                this.$promise = $captured_local_variable$6;
                this.$connection = $captured_local_variable$7;
            }
        });
        ProcessAdapter processListener2 = new ProcessAdapter(this, project, configuration, buildEvent, started, promise, connection){
            final /* synthetic */ CLionExternalToolConfigurationRunner this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ CLionExternalConfiguration $configuration;
            final /* synthetic */ CidrBuildEvent $buildEvent;
            final /* synthetic */ long $started;
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ MessageBusConnection $connection;

            public void processTerminated(@NotNull ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                boolean success = event.getExitCode() == 0;
                CLionExternalToolConfigurationRunner.reportExecutionResult$default(this.this$0, this.$project, this.$configuration, this.$buildEvent, success, false, this.$started, this.$promise, this.$connection, false, 256, null);
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
                this.$configuration = $captured_local_variable$2;
                this.$buildEvent = $captured_local_variable$3;
                this.$started = $captured_local_variable$4;
                this.$promise = $captured_local_variable$5;
                this.$connection = $captured_local_variable$6;
            }
        };
        ((CidrBuildListener)project.getMessageBus().syncPublisher(CidrBuildListener.TOPIC)).beforeStarted(buildEvent);
        try {
            boolean toolExecutionInitiated2 = (Boolean)ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.NON_MODAL, (Function0)((Function0)new Function0<Boolean>(tool, dataContext, executionId, processListener2){
                final /* synthetic */ Tool $tool;
                final /* synthetic */ DataContext $dataContext;
                final /* synthetic */ long $executionId;
                final /* synthetic */ run.processListener.1 $processListener;

                public final boolean invoke() {
                    return CLionExternalToolConfigurationRunnerKt.access$executeWithCustomConsole(this.$tool, null, this.$dataContext, this.$executionId, (ProcessListener)this.$processListener);
                }
                {
                    this.$tool = tool;
                    this.$dataContext = dataContext;
                    this.$executionId = l;
                    this.$processListener = var5_4;
                    super(0);
                }
            }));
            if (!toolExecutionInitiated2) {
                CLionExternalToolConfigurationRunner.reportExecutionResult$default(this, project, configuration, buildEvent, false, true, started, promise, connection, false, 256, null);
            }
        }
        catch (Exception ex) {
            connection.disconnect();
            CPPLog.LOG.error((Throwable)ex);
            return Promises.resolvedPromise((Object)TaskRunnerResults.ABORTED);
        }
        catch (Throwable ex) {
            connection.disconnect();
            CPPLog.LOG.error(ex);
            throw ex;
        }
        return (Promise)promise;
    }

    private final void reportExecutionResult(Project project, CLionExternalConfiguration configuration, CidrBuildEvent buildEvent, boolean success, boolean canceled2, long started, AsyncPromise<ProjectTaskRunner.Result> promise, MessageBusConnection connection, boolean notify) {
        String string;
        connection.disconnect();
        long duration = System.currentTimeMillis() - started;
        if (!canceled2) {
            if (duration > 0L) {
                String string2 = NlsMessages.formatDuration((long)duration);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"NlsMessages.formatDuration(duration)");
                String formatDuration = string2;
                string = CidrExecutionBundle.message((String)(success ? "build.finished.duration" : "build.failed.duration"), (Object[])new Object[]{configuration.getName(), formatDuration});
            } else {
                string = CidrExecutionBundle.message((String)(success ? "build.finished" : "build.failed"), (Object[])new Object[]{configuration.getName()});
            }
        } else {
            string = CLionExecutionBundle.message("external.tool.cannot.execute", configuration.getName(), configuration.getName());
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (!canceled) {\n      i\u2026configuration.name)\n    }");
        String message = string;
        ((CidrBuildListener)project.getMessageBus().syncPublisher(CidrBuildListener.TOPIC)).afterFinished(buildEvent, new CidrBuildResult(success, canceled2, started, duration, success || canceled2 ? 0 : 1, 0, message));
        if (canceled2) {
            promise.setResult((Object)TaskRunnerResults.ABORTED);
        } else if (success) {
            promise.setResult((Object)TaskRunnerResults.SUCCESS);
        } else {
            promise.setResult((Object)TaskRunnerResults.FAILURE);
        }
        CPPLog.LOG.debug(message);
        if (notify) {
            ApplicationManager.getApplication().invokeLater(new Runnable(project, success, message){
                final /* synthetic */ Project $project;
                final /* synthetic */ boolean $success;
                final /* synthetic */ String $message;

                public final void run() {
                    MessageType messageType = this.$success ? MessageType.INFO : MessageType.ERROR;
                    Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"if (success) MessageType\u2026FO else MessageType.ERROR");
                    CLionAbstractExternalConfigurationRunner.Companion.showBuildNotification(this.$project, messageType, this.$message, "Run");
                }
                {
                    this.$project = project;
                    this.$success = bl;
                    this.$message = string;
                }
            });
        }
    }

    static /* synthetic */ void reportExecutionResult$default(CLionExternalToolConfigurationRunner cLionExternalToolConfigurationRunner, Project project, CLionExternalConfiguration cLionExternalConfiguration, CidrBuildEvent cidrBuildEvent, boolean bl, boolean bl2, long l, AsyncPromise asyncPromise, MessageBusConnection messageBusConnection, boolean bl3, int n, Object object) {
        if ((n & 0x100) != 0) {
            bl3 = true;
        }
        cLionExternalToolConfigurationRunner.reportExecutionResult(project, cLionExternalConfiguration, cidrBuildEvent, bl, bl2, l, (AsyncPromise<ProjectTaskRunner.Result>)asyncPromise, messageBusConnection, bl3);
    }

    public static final /* synthetic */ void access$reportExecutionResult(CLionExternalToolConfigurationRunner $this, Project project, CLionExternalConfiguration configuration, CidrBuildEvent buildEvent, boolean success, boolean canceled2, long started, AsyncPromise promise, MessageBusConnection connection, boolean notify) {
        $this.reportExecutionResult(project, configuration, buildEvent, success, canceled2, started, (AsyncPromise<ProjectTaskRunner.Result>)promise, connection, notify);
    }
}

