/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.gdbserver.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.gdbserver.GdbServerLauncher;
import com.jetbrains.cidr.cpp.execution.gdbserver.GdbServerRunConfiguration;
import com.jetbrains.cidr.cpp.execution.gdbserver.remote.RemoteGdbServerRunConfiguration;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.system.RemoteDeploymentHelper;
import com.jetbrains.cidr.system.RemoteUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteGdbServerLauncher
extends GdbServerLauncher {
    public RemoteGdbServerLauncher(@NotNull ExecutionEnvironment executionEnvironment, @NotNull RemoteGdbServerRunConfiguration configuration, @NotNull CPPToolchains.Toolchain debuggerToolchain) {
        if (executionEnvironment == null) {
            RemoteGdbServerLauncher.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            RemoteGdbServerLauncher.$$$reportNull$$$0(1);
        }
        if (debuggerToolchain == null) {
            RemoteGdbServerLauncher.$$$reportNull$$$0(2);
        }
        super(executionEnvironment, configuration, debuggerToolchain);
    }

    @Override
    @Nullable
    protected String getGdbServerParameters(@NotNull GdbServerRunConfiguration configuration) {
        String programParameters;
        if (configuration == null) {
            RemoteGdbServerLauncher.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)(programParameters = configuration.getProgramParameters())) && configuration instanceof RemoteGdbServerRunConfiguration) {
            return ((RemoteGdbServerRunConfiguration)configuration).getDefaultGdbServerArgs();
        }
        return programParameters;
    }

    @Override
    protected void prepareSymbolFile(@NotNull String filePath, @NotNull GdbServerRunConfiguration configuration) throws ExecutionException {
        RemoteGdbServerRunConfiguration remoteConfiguration;
        if (filePath == null) {
            RemoteGdbServerLauncher.$$$reportNull$$$0(4);
        }
        if (configuration == null) {
            RemoteGdbServerLauncher.$$$reportNull$$$0(5);
        }
        if (!this.haveToBeDownloaded((remoteConfiguration = (RemoteGdbServerRunConfiguration)configuration).getDownloadType(), new File(filePath))) {
            return;
        }
        String hostId = remoteConfiguration.getHostId();
        String sshConfigName = remoteConfiguration.getSshConfigName();
        if (hostId == null || sshConfigName == null) {
            throw new ExecutionException(CLionExecutionBundle.message("dialog.message.credentials.are.not.valid", new Object[0]));
        }
        String uploadFilePath = remoteConfiguration.getUploadFile();
        assert (uploadFilePath != null);
        if (!uploadFilePath.contains("/")) {
            throw new ExecutionException(CLionExecutionBundle.message("dialog.message.upload.path.empty", new Object[0]));
        }
        SshConfig sshConfig = SshConfigManager.getInstance((Project)this.getProject()).findConfigByName(sshConfigName);
        RemoteCredentials credentials = RemoteUtil.toCredentials((SshConfig)sshConfig);
        if (credentials == null || !RemoteUtil.checkConnection((RemoteCredentials)credentials)) {
            throw new ExecutionException(CLionExecutionBundle.message("dialog.message.cannot.connect.to.remote.host", new Object[0]));
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            try {
                RemoteDeploymentHelper.upload((String)hostId, (Project)this.getProject(), (String)filePath, (String)uploadFilePath, (ProgressIndicator)indicator);
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
            RemoteUtil.setExecutable((RemoteCredentials)credentials, (String)uploadFilePath, (ProgressIndicator)indicator);
            return null;
        }, CLionExecutionBundle.message("remote.gdbserver.upload.executable.dialog.text", new Object[0]), true, this.getProject());
    }

    @Override
    protected BaseProcessHandler<?> createGdbServerProcess(@NotNull GeneralCommandLine gdbServerCommandLine) throws ExecutionException {
        if (gdbServerCommandLine == null) {
            RemoteGdbServerLauncher.$$$reportNull$$$0(6);
        }
        RemoteGdbServerRunConfiguration configuration = (RemoteGdbServerRunConfiguration)this.getConfiguration();
        String sshConfigName = configuration.getSshConfigName();
        assert (sshConfigName != null);
        SshConfig sshConfig = SshConfigManager.getInstance((Project)this.getProject()).findConfigByName(sshConfigName);
        RemoteCredentials credentials = RemoteUtil.toCredentials((SshConfig)sshConfig);
        assert (credentials != null);
        if (StringUtil.isEmpty((String)gdbServerCommandLine.getExePath())) {
            gdbServerCommandLine.setExePath("/usr/bin/gdbserver");
        }
        return RemoteUtil.createRemoteProcess((RemoteCredentials)credentials).withPty(true).withElevated(this.getConfiguration().isElevated()).build(gdbServerCommandLine);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionEnvironment";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerToolchain";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gdbServerCommandLine";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/execution/gdbserver/remote/RemoteGdbServerLauncher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getGdbServerParameters";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareSymbolFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createGdbServerProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

