/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.testing;

import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.execution.CMakeBuildConfigurationHelper;
import com.jetbrains.cidr.cpp.execution.CMakeRunConfigurationType;
import com.jetbrains.cidr.cpp.execution.CMakeTargetToConfigProvider;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkDetector;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeTestTargetToConfigProvider
implements CMakeTargetToConfigProvider {
    @Override
    @Nullable
    public ConfigurationTypeBase getConfigTypeByTargetType(@NotNull CMakeTarget target, @NotNull CMakeBuildConfigurationHelper helper) {
        CMakeConfiguration config;
        if (target == null) {
            CMakeTestTargetToConfigProvider.$$$reportNull$$$0(0);
        }
        if (helper == null) {
            CMakeTestTargetToConfigProvider.$$$reportNull$$$0(1);
        }
        List fwDetection = ContainerUtil.map((Collection)CidrTestFrameworkDetector.EP_NAME.getExtensionList(), detector -> new Triple((Object)detector.getTestHeaderName(), (Object)detector.getTestMacros(), (Object)detector.getTestConfigurationType()));
        ProgressManager.checkCanceled();
        for (CidrTestFrameworkDetector each : CidrTestFrameworkDetector.EP_NAME.getExtensionList()) {
            ConfigurationTypeBase type;
            if (!each.hasTestConfiguration((CidrBuildTarget)target, (CidrBuildConfigurationHelper)helper) || !((type = each.getTestConfigurationType()) instanceof CMakeRunConfigurationType)) continue;
            return type;
        }
        if (CidrBuildConfigurationHelper.isTargetDetectionEnabled() && target.isExecutable() && (config = (CMakeConfiguration)helper.getDefaultConfiguration(target)) != null) {
            Collection<File> sources = config.getSources();
            LocalFileSystem fs = LocalFileSystem.getInstance();
            int maxFilesInTargetToCheck = Registry.get((String)"cmake.test.files.in.target.check").asInteger();
            int maxHeaderFileContextLengthToCheck = Registry.get((String)"cmake.test.header.context.length.check").asInteger();
            for (File file : sources) {
                if (--maxFilesInTargetToCheck < 0) break;
                VirtualFile vf = fs.findFileByIoFile(file);
                if (vf == null) continue;
                try {
                    String fullContext = VfsUtilCore.loadText((VirtualFile)vf);
                    String content = fullContext.substring(0, Math.min(fullContext.length(), maxHeaderFileContextLengthToCheck));
                    for (Triple fwd : fwDetection) {
                        if (!content.contains((String)fwd.getFirst() + "\"") && !content.contains((String)fwd.getFirst() + ">")) continue;
                        for (String catchMacroName : (Collection)fwd.getSecond()) {
                            if (!content.contains(catchMacroName)) continue;
                            return (ConfigurationTypeBase)fwd.getThird();
                        }
                    }
                }
                catch (IOException iOException) {
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "helper";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/cpp/execution/testing/CMakeTestTargetToConfigProvider";
        objectArray[2] = "getConfigTypeByTargetType";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

