/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.profiling.actions;

import com.intellij.execution.Executor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.cpp.CLionProfilingBundle;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileTreeDataModel;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileUtil;
import com.jetbrains.cidr.cpp.profiling.ui.MemoryProfileOutputPanel;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class MemoryProfileImportAction
extends AnAction {
    protected static final Logger LOG = Logger.getInstance(MemoryProfileImportAction.class);

    public MemoryProfileImportAction() {
        super(AllIcons.ToolbarDecorator.Import);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MemoryProfileImportAction.$$$reportNull$$$0(0);
        }
    }

    public void actionPerformed(final @NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            MemoryProfileImportAction.$$$reportNull$$$0(1);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            LOG.warn(MemoryProfileImportAction.getLogMessage("project is null"));
            return;
        }
        FileChooserDescriptor fileDescriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((String)"xml");
        FileChooser.chooseFile((FileChooserDescriptor)fileDescriptor, (Project)project, null, file -> {
            final CidrToolEnvironment environment2 = MemoryProfileUtil.getEnvironment(project);
            if (environment2 == null) {
                return;
            }
            final String filePath = file.getPath();
            if (!FileUtil.exists((String)filePath)) {
                LOG.warn(MemoryProfileImportAction.getLogMessage("filePath doesn't exist"));
                return;
            }
            Task.Backgroundable task2 = new Task.Backgroundable(project, CLionProfilingBundle.message("memory.profile.import.title", this.getProfilerName())){

                public void run(@NotNull ProgressIndicator indicator) {
                    MemoryProfileTreeDataModel dataModel;
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!MemoryProfileImportAction.this.tryParse(e, environment2, filePath, indicator, dataModel = new MemoryProfileTreeDataModel(MemoryProfileImportAction.this.getProfilerName(), project))) {
                        if (!indicator.isCanceled()) {
                            LOG.warn(MemoryProfileImportAction.getLogMessage("file content is invalid"));
                        }
                        return;
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        MemoryProfileOutputPanel panel2 = new MemoryProfileOutputPanel(dataModel, MemoryProfileImportAction.this.getEditSettingsActionId(), MemoryProfileImportAction.this.getTreePopupId(), project);
                        RunContentDescriptor contentDescriptor = new RunContentDescriptor(null, null, (JComponent)panel2, MemoryProfileImportAction.this.getProfilerName());
                        RunContentManager.getInstance((Project)project).showRunContent(MemoryProfileImportAction.this.getExecutor(), contentDescriptor);
                    }, value -> indicator.isCanceled());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/cpp/profiling/actions/MemoryProfileImportAction$1", "run"));
                }
            };
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new BackgroundableProcessIndicator(task2));
        });
    }

    @Nls
    protected abstract String getProfilerName();

    protected abstract String getEditSettingsActionId();

    protected abstract String getTreePopupId();

    protected abstract Executor getExecutor();

    protected abstract boolean tryParse(@NotNull AnActionEvent var1, @NotNull CidrToolEnvironment var2, @NotNull String var3, @NotNull ProgressIndicator var4, @NotNull MemoryProfileTreeDataModel var5);

    @NonNls
    protected static String getLogMessage(@NonNls @NotNull String reason) {
        if (reason == null) {
            MemoryProfileImportAction.$$$reportNull$$$0(2);
        }
        return "Failed to perform Import action, because " + reason;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/profiling/actions/MemoryProfileImportAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLogMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

